//
//  SCLinear.h
//  SCTVOSSDK
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class SCClosedCaptionDescription, SCMediaFileResource;

///Linear Ads are the video or audio formatted ads that play linearly within the streaming content.
@interface SCLinear : NSObject
///Subtitle files for the current creative in different languages
@property (nonatomic, strong) SCClosedCaptionDescription *captions;
///Overview of all trackers that could be triggered.
@property (nonatomic, strong) NSDictionary *creativeTrackers;
///The ad icon details for the <Icon> element.
@property (nonatomic, strong) NSDictionary *icons;
///From the parsed VAST response with various sub-information like bitrate, mimType, URL etc.
@property (nonatomic, strong) NSArray *mediaFiles;
///Is the selected media file and its information
@property (nonatomic, strong) SCMediaFileResource *selectedMediaFile;
@end

NS_ASSUME_NONNULL_END
