//
//  SCAdSessionStateListener.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//


#ifndef SCAdSessionStateListener_h
#define SCAdSessionStateListener_h

/**
 * Use this protocol to be notified when the sdk is ready to be used
 */
@protocol SCAdSessionStateListener <NSObject>

/// SCAdSessionState: Overall state of the sdk
typedef enum SCAdSessionState {
    /// Sdk is still initializing
    SessionStateInitializing,
    /// Sdk is ready to be used
    SessionStateReady
} SCAdSessionState;


@required
/// Get informed of session state changes
- (void)sessionStateChangedWith:(SCAdSessionState)newState;
@end

#endif /* SCAdSessionStateListener_h */
