//
//  SCAdInfo.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SCUniversalAdId;

/**
 * This class holds the advertisement information
 */
@interface SCAdInfo : NSObject
/// id of the ad
@property (nonatomic, copy)     NSString           *adId;

/// title of the ad
@property (nonatomic, copy)     NSString           *title;

/// variant string
@property (nonatomic, copy)     NSString           *variant;

/**
 *     The default value for this property is false. When the ad reaches a point where it can
 *     be skipped, the ad unit updates this property to true and sends the
 *     ON_AD_SKIPPABLE_STATE_CHANGE event. The video player can check this property at any time,
 *     but should always check it when the ON_AD_SKIPPABLE_STATE_CHANGE event is received.
 */
@property (nonatomic)           BOOL                skippable;

/// duration of the current commercial
@property (nonatomic)           NSTimeInterval      duration;

/// current time regarding the the current commercials duration
@property (nonatomic)           NSTimeInterval      currentTime;

/// an array of wrapper tags
@property (nonatomic, strong)   NSArray            *wrapperTags;

/// if an error occurs, the error code, describing the error type
@property (nonatomic)           NSInteger           errorCode;

/// universal ad id
@property (nonatomic, strong)   SCUniversalAdId    *universalAdId;
/**
 * Get the original JSON formatted description as NSDictionary
 */
- (NSDictionary*)adInfoDescription;
@end
