//
//  SCPlayerEventListener.h
//  SCTVOSSDK
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SCTVOSSDK/SCAdPlayerEvent.h>

NS_ASSUME_NONNULL_BEGIN
@class SCPublicAdSlot, SCAdError, SCAdInfo;

/// Completionblock that delivers an SCPublicAdSlot object
typedef void (^SCPublicAdSlotCompletionBlock)(SCPublicAdSlot* _Nullable adInfo);
/// Completionblock that delivers an AdError object as result
typedef void (^SCAdErrorCompletionBlock)(SCAdError* _Nullable adError);
/// Completionblock that delivers an SCAdInfo object
typedef void (^SCAdInfoCompletionBlock)(SCAdInfo* _Nullable adInfo);


/// Use this protocol to inform the adSlotController about player related events
@protocol SCPlayerEventListener <NSObject>
///Inform adSlotController about the player state
- (void)playerEventCallbackWith:(SCAdPlayerEventType)playerEventType;
///Inform the adSlotController about a successfull ad video load
- (void)loadAdSuccess;
///Inform the adSlotController about an unsuccessfull ad video load
- (void)loadAdFailure;
///Request stopping the current ad slot (if you leave your viewController during ad playback for example)
- (void)stopAdSlot;
///Call when presentationSize of the player changes
- (void)resize;
@optional
///Call when contentVideo has finished
- (void)contentVideoFinished;
///Call when contentVideo has an error
- (void)contentVideoError:(NSError*)error;
@end

NS_ASSUME_NONNULL_END
