//
//  SCAdSlotController.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//
#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <SCTVOSSDK/SCAdPlayerEvent.h>
#import <SCTVOSSDK/SCPlayerEventListener.h>
#import <SCTVOSSDK/SCAdListener.h>

@class SCAdInfo, SCAdConfiguration, SCAdEvent, SCPublicAdSlot, SCAdError, SCElementSize, SCPublicAd;
@protocol SCOmidEventLoggingDelegate;

/// Completionblock that delivers a SCAdInfo object
typedef void (^SCAdInfoCompletionBlock)(SCAdInfo* _Nullable adInfo);
/// Completionblock that delivers a SCPublicAdSlot object
typedef void (^SCPublicAdSlotCompletionBlock)(SCPublicAdSlot* _Nullable publicAdSlot);
/// Completionblock that delivers a SCPublicAd object
typedef void (^SCPublicAdCompletionBlock)(SCPublicAd* _Nullable publicAd);
/// Completionblock that delivers a SCAdError object
typedef void (^SCAdErrorCompletionBlock)(SCAdError* _Nullable adError);
/// Completionblock that delivers a String as result
typedef void (^SCStringResultCompletionBlock)(NSString* _Nullable result);

/// Completionblock without giving back a value
typedef void (^SCEmptyCompletionBlock)(void);

/**
* The SCAdSlotController initializes and controls a single AdSlot.
* A valid AdSlot must be inialized from the SCAdSessionController.
*/
@interface SCAdSlotController: NSObject <SCPlayerEventListener>

///Register your SCAdListener here as the delegate of the SCAdSlotController
@property (nonatomic, weak) id<SCAdListener> _Nullable delegate;

/**
* You start the playback of an ad slot with this function
* - Parameter configutation: An instance of SCAdConfiguration
*/
- (void)startAdSlotWith:(nonnull SCAdConfiguration*)configuration;

/**
 * You start the playback of VMAP playlist with this function
 * - Parameter configutation: An instance of SCAdConfiguration
 */
- (void)startVMAPWith:(nonnull SCAdConfiguration*)configuration;

///Call this function if you leave your view controller while video (or advertisement) playback is still active
- (void)stopAdSlot;

///Call this function to stop a VMAP playlist
- (void)stopAdPlaylist;

///Call this function when the user has pushed the skip button
- (void)skipAd;

///Cleanup after usage!
- (void)cleanup;

///Callback function for the video player that must be called for certain player events
- (void)playerEventCallbackWith:(SCAdPlayerEventType)playerEventType;

///Call this function for a more detailed adInfo
- (void)getAdInfo:(nonnull SCAdInfoCompletionBlock)completion;

///Call this function for a publicAdSlot object
- (void)getPublicAdSlot:(nonnull SCPublicAdSlotCompletionBlock)completion;

///Call this function for a publicAd object
- (void)getPublicAd:(nonnull SCPublicAdCompletionBlock)completion;

///Call this function if you want to pause playback
- (void)pausePlayback;

///Call this function if you want to start playback
- (void)startPlayback;

///Call this function if you want to resume playback
- (void)resumePlayback;

///Call this function for a more detailed error description
- (void)getAdError:(nonnull SCAdErrorCompletionBlock)completion;

///Call this function if the loading of the adTag succeeded
- (void)loadAdSuccess;

///Call this function if the loading of the adTag failed
- (void)loadAdFailure;

///Call this function to unmute the adPlayer
- (void)unmutePlayer;

///Call this function to mute the adPlayer
- (void)mutePlayer;

///Call this function to check if the player currently is muted
- (BOOL)isMuted;

/// Can be used to set a receiver for omid specific event logging
- (void)setOmidEventLoggingDelegate:(_Nullable id<SCOmidEventLoggingDelegate>)omidEventLogger;

/// set the player view that holds the (AV)player
- (void)addVisibilityCheckerForView:(UIView* _Nullable)adView;

/// add every view to the friendly views array that covers the adView
- (void)registerFriendlyViews:(NSMutableArray* _Nullable)friendlyViews;
@end
