//
//  SCAdMacros.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/**
 * This class is used to specify VAST MAKROS
 */
@interface SCAdMacros : NSObject

/// enum values for ConnectionType macro
typedef enum SCConnectionType {
    /// Connection type is undefined
    SCConnectionTypeUnknown = 0,

    /// Connection over ethernet
    SCConnectionTypeEthernet,

    /// Connection over wifi
    SCConnectionTypeWIFI,

    /// Connection over a cellular network of unknown generation
    SCConnectionTypeCellularUnknownGen,

    /// Connection over a cellular network 2. generation
    SCConnectionTypeCellular2G,

    /// Connection over a cellular network 3. generation
    SCConnectionTypeCellular3G,

    /// Connection over a cellular network 4. generation
    SCConnectionTypeCellular4G
} SCConnectionType;

/// enum values for BreakPosition macro
typedef enum SCBreakPosition {
    /// Breakposition undefined
    SCBreakPositionOther = 0,

    /// Preroll break
    SCBreakPositionPreRoll,

    /// Midroll break
    SCBreakPositionMidRoll,

    /// Postroll break
    SCBreakPositionPostRoll,

    /// Standalone break
    SCBreakPositionStandAlone
} SCBreakPosition;

/// enum values for PlacementType macro
typedef enum SCPlacementType {
    /// In-stream. Played before, during or after the streaming video content that the consumer has requested (e.g., Pre-roll, Mid-roll, Post-roll).
    SCPlacementTypeInStream = 1,

    /// In-article. Loads and plays dynamically between paragraphs of editorial content; existing as a standalone branded message.
    /// (outstream)
    SCPlacementTypeInArticle = 3,

    /// Interstitial/Slider/Floating. Covers the entire or a portion of screen area, but is always on screen while displayed (i.e. cannot be scrolled out of view).
    SCPlacementTypeInterstitial = 5
} SCPlacementType;

/// Macro: ADCATEGORIES
@property (nonatomic, strong)   NSMutableArray     *adCategories;

/// Macro: APPBUNDLE
@property (nonatomic, copy)     NSString           *appBundle;

/// Macro: APIFRAMEWORKS
@property (nonatomic, strong)   NSMutableArray     *apiFrameworks;

/// Macro: BLOCKEDADCATEGORIES
@property (nonatomic, strong)   NSMutableArray     *blockedAdCategories;

/// Macro: BREAKPOSITION
@property (nonatomic)           SCBreakPosition     breakPosition;

/// Macro: CONTENTID
@property (nonatomic, copy)     NSString           *contentId;

/// Macro: CONTENTPLAYHEAD Current time offset “HH:MM:SS.mmm” of the video content.
@property (nonatomic, copy)     NSString           *contentPlayhead DEPRECATED_ATTRIBUTE;

/// Macro: CONTENTURI
/// The URI of the main media content asset into which the ad is being loaded or inserted. Only applicable to in-stream ads.
@property (nonatomic, copy)     NSString           *contentUri;

/// Macro: DOMAIN
@property (nonatomic, copy)     NSString           *domain;

/// Macro: EXTENSION
@property (nonatomic, strong)   NSMutableArray     *extensions;

/// Macro: GDPRCONSENT
@property (nonatomic, copy)     NSString           *gdprConsent;

/// Macro: IFA
@property (nonatomic, copy)     NSString           *ifa;

/// Macro: IFATYPE
@property (nonatomic, copy)     NSString           *ifaType;

/// Macro: INVENTORYSTATE
@property (nonatomic, strong)   NSMutableArray     *inventoryState;

/// Macro: LATLONG
@property (nonatomic, copy)     NSString           *latLong;

/// Macro: LIMITADTRACKING
@property (nonatomic)           BOOL                limitAdTracking;

/// Macro: MEDIAMIME
@property (nonatomic, strong)   NSString            *mediaMime;

/// Macro: MEDIAPLAYHEAD
@property (nonatomic, copy)     NSString           *mediaPlayhead;

/// Macro: PLACEMENTTYPE
@property (nonatomic)           enum SCPlacementType placementType;

/// Macro: PLAYERCAPABILITIES
@property (nonatomic, strong)   NSMutableArray     *playerCapabilities;

/// Macro: REGULATIONS
@property (nonatomic, strong)   NSMutableArray     *regulations;

/// Macro: VERIFICATIONVENDORS
@property (nonatomic, strong)   NSMutableArray     *verificationVendors;

/// Connection type
@property (nonatomic)           SCConnectionType    connectionType;

/// Unique identifier
@property (nonatomic, strong)   NSString           *uniqueIdentifier;
@end
NS_ASSUME_NONNULL_END
