//
//  SCAdListener.h
//  SCTVOSSDK
//
//  Copyright © 2022 smartclip. All rights reserved.
//

#ifndef SCAdListener_h
#define SCAdListener_h

@class SCAdEvent, SCElementSize, SCAdEnvironment;

/// Protocol that the SCAdSlotController uses to inform the listener about certain events.
@protocol SCAdListener <NSObject>
@optional
/**
* Called when the content video has finished
*/
- (void)contentVideoFinished;

/**
 * Called when the content video fails for any reason
 */
- (void)contentVideoError:(nonnull NSError*)error;

/// Return your environmentVars object (only needed for VMAP implementations)
- (nullable SCAdEnvironment *)getEnvironmentVarsWith:(NSString* _Nonnull)adBreakType;
@required
/**
* Called on for every ScAdInfo type change
* - Parameter adInfo: current ScAdInfo
*/
- (void)onEventCallback:(SCAdEvent *_Nonnull )event;

/**
* Returns the rect of the avplayer layer and if it is displayed fullscreen or not
*/
- (nullable SCElementSize*)getPlayerSize;

/**
* Returns the rect of the viewport and if the player is displayed fullscreen or not
*/
- (nullable SCElementSize*)getViewportSize;
@end

#endif /* SCAdListener_h */
