var PLAYER_FACTORY_VERSION = '3.2';
// defines empty functions that get filled with the load-Promise callbacks
var loadRequestPromiseResolve = function() {};
var loadRequestPromiseReject = function() {};
function FacadeBase(playerReference) {

    this.player = playerReference;

    this.handshakeVersion = function _(apiFacadeVersion) {
        return PLAYER_FACTORY_VERSION;
    };

    /**
     * @param {string} url Media file URI
     * @param {Boolean} disableSeeking Wether the requested source can be seeked back and forth
     * @returns {Promise} Either resolves if the player accepted the play request or not
     */
    this.load = function _(url, disableSeeking = false) {
        console.log("load called in FacadeBase.js!");
        return new Promise(function(resolve, reject, playerRef = this.player) {
           loadRequestPromiseResolve = resolve;
           loadRequestPromiseReject = reject;
           loadAdGlobaly(url, disableSeeking);
           // the native code should then respond by calling either
           //  callJSFunction("loadRequestPromiseResolve")
           //  callJSFunction("loadRequestPromiseReject")
           // depending on whether the MediaFile could be loaded (resolve) or not (reject).
        });
    };

    this.addEventListener = function _(event, callback) {
        console.log("adding event listener for event: " + event);
        let eventDispatcher = getEventDispatcher();
        eventDispatcher.addEventListener(event, callback);
    };

    this.removeEventListener = function _(event, callback) {
        let eventDispatcher = getEventDispatcher();
        eventDispatcher.removeEventListener(event, callback);
    };

    this.callEventListener = function _(event) {
        let eventDispatcher = getEventDispatcher();
        console.log("facadeBase - dispatching event: " + event);
        eventDispatcher.dispatchEvent(event);
    };

    this.onEventCallback = function _(event) {
        console.log("OnEventCallback for event: " + event);
        this.player.onEventCallback(event);
    }

    /**
     * @returns {SourceObject} Current content source and playhead progress
     */
    this.getCurrentContentSource = function _() {
        console.log("getCurrentContentSource called in FacadeBase.js!");
        return this.player.getCurrentContentSource();
    };

    /**
     * Resets the latest known content source and playhead progress
     * @returns {Promise} Either resolves if the player accepted the play request or not
     */
    this.releaseContent = function _() {
        console.log("releaseContent called in FacadeBase.js!");
        let accept = this.player.releaseContent();
        return Promise.resolve(accept);
    };

    /**
     * Saves the current playback state, most likely before starting a new ad-break
     * @returns {SourceObject} Current content source and playhead progress
     */
    this.lockContent = function _() {
        this.player.lockContent();
        return Promise.resolve(true);
    };

    /**
     * Requests details about the most recent error that has occurred on the video player.
     * @returns {MediaError} Description object of the most recent error or `null`.
     */
    this.getError = function _() {
        return this.player.getError();
    };

    /**
    * Requests the current playhead position from the video player.
    * @returns {Number} Current time in seconds.
    */
    this.getCurrentTime = function _() {
        return this.player.getCurrentTime();
    };

    /**
    * Requests the content-duration from the video player.
    * @returns {Number} Total time in seconds.
    */
    this.getDuration = function _() {
        return this.player.getDuration();
    };

    /**
     * Requests the latest status of the video player, site, and other external factors.
     * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
     * @returns {EnvironmentVars} Description object of the most recent error or `null`.
     */
    this.getEnvironmentVars = function _(adBreakType) {
        let environmentVars = this.player.getEnvironmentVars(adBreakType);
        return JSON.parse(environmentVars);
    };

     /**
      * Requests the current size and viewMode from the video player.
      * @returns {ElementSize} Current player dimension specs
      */
    this.getPlayerSize = function _() {
        return JSON.parse(this.player.getPlayerSize());
    };

     /**
      * Requests the current size and viewMode from the viewport that surrounds the video player.
      * @returns {ElementSize} The dimension specs of the element
      */
     this.getViewportSize = function _() {
         return JSON.parse(this.player.getViewportSize());
    };

    /**
     * Requests the video player element
     * @returns {Element} The video element
     * @deprecated
     */
    this.getVideoElement = function _() {};

    /**
     * Requests the player element
     * @returns {Element} The video or audio element
     */
    this.getPlayerElement = function _() {};

    /**
    * Requests the current volume level from the video player.
    * @returns {Number} The current volume level between 0-1
    */
    this.getVolume = function _() {
        return this.player.getVolume();
    };

    /**
        * Requests the video player to change the volume.
        * @param {Number} volume - Requested volume level between 0-1
        * @returns {Promise} Resolves if the video player accepted the volume change request
        */
    this.setVolume = function _(volume) {
        this.player.setVolume(volume);
    };

    /**
    * Requests the current muted state from the video player.
    * @returns {Boolean} Muted state
    */
    this.isMuted = function _() {
        return this.player.isMuted();
    };

    /**
    * Requests the video player to mute playback.
    * @returns {Promise} Resolves if the video player has been muted
    */
    this.mute = function _() {
        this.player.mute();
    };

    /**
    * Requests the video player to unmute playback.
    * @returns {Promise} Resolves if the video player has been unmuted
    */
    this.unmute = function _() {
        this.player.unmute();
    };

    /**
    * Requests the current play state from the video player.
    * @returns {Boolean} Playback state
    */
    this.isPaused = function _() {
        return this.player.isPaused();
    };

    /**
    * Requests the video player to pause playback.
    * @returns {Promise} Resolves if the video player has been paused
    */
    this.pause = function _() {
        this.player.pausePlayback();
    };

    /**
    * Requests the video player to start (resume) playback.
    * @returns {Promise} Resolves if the video player has been resumed
    */
    this.play = function _() {
        this.player.startPlayback();
    };

    /**
    * Requests the video player to change the playhead position to the specified time.
    * @param {Number} offset - Requested playhead position
    * @returns {Promise} Resolves if the video player has finished seeking to the specified position
    */
    this.seek = function _(offset) {
        this.player.seek(offset);
    };
}
