var TVOSURLHandler = function() {};

function stringToXML(responseText) {
    //is already a XML
    if ((typeof responseText === 'string') === false) {
        return responseText;
    }

    // no valid XML, could be a gif tracking pixel
    if ((responseText || '').indexOf('<') !== 0) {
        return '';
    }

    var responseXML = null;

    if (DOMParser) {
        var parser = new window.linkedom.DOMParser();
        responseXML = parser.parseFromString(responseText.replaceAll("vmap:", ''), 'text/xml');
    }

    return responseXML;
}

TVOSURLHandler.prototype.xhr = function() {
    return new window.XMLHttpRequest;
};

TVOSURLHandler.supported = function() {
    return !!(new TVOSURLHandler).xhr();
};

TVOSURLHandler.prototype.get = function(url, options, cb) {

    try {
        var xhr = this.xhr();
        xhr.open("GET", url);
        xhr.timeout = options.timeout || 0;

		if (xhr.overrideMimeType && options.issuer && options.issuer !== TVOSURLHandler.ISSUER.TRACKING) {
            xhr.overrideMimeType("application/xml");
        }
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
					if (options.issuer && options.issuer === TVOSURLHandler.ISSUER.TRACKING) {
						return cb(null, null);
					}
					

                    var responseXML = null;

                    if (xhr.responseText) {
                        responseXML = stringToXML(xhr.responseText);
                    }

                    if (!responseXML) {
                        xhr.statusText = "Response contains neither 'responseXML' nor 'responseText'";
                        cb(new Error("XHRURLHandler: " + xhr.statusText));
                        return;
                    }
                    cb(null, responseXML);
                } else {
                    cb(new Error("XHRURLHandler: " + xhr.statusText));
                }
            }
        };
        xhr.send();
    } catch (e) {
        cb(e);
    }
};

TVOSURLHandler.ISSUER = {};
TVOSURLHandler.ISSUER.TRACKING = 'TrackingURLHandler';
TVOSURLHandler.ISSUER.TAG = 'TVOSURLHandler';

TVOSURLHandler.DEFAULT_TIMEOUT = 4;
