var adPlaylistAPI = null;

function stopAdPlaylist() {
    adPlaylistAPI.stopAdPlaylist();
}

function getPlaylistError() {
    return JSON.stringify(adPlaylistAPI.error);
}

function getRawVMAP() {
    return adPlaylistAPI.rawVMAP;
}

function playVMAPWithPlaylistSetup(adPlaylistDescription, vastMacros, skipOffset, adVerificationConfigJSON, enableDebugOutput, globalAdConfigDescription) {
    if (enableDebugOutput) {
        console.log("playVMAPWithPlaylistSetup(" + adPlaylistDescription + ", " + vastMacros + ", " + skipOffset + ", " + adVerificationConfigJSON + ", " + enableDebugOutput + ")");
    }

    var skipOffsetInt = parseInt(skipOffset);
    if (skipOffsetInt > 0) {
        globalAdConfig.skipOffset = skipOffsetInt;
    }

    var adVerificationConfig = JSON.parse(adVerificationConfigJSON)
    var globalConfig = JSON.parse(globalAdConfigDescription)
    globalAdConfig.adVerification.vendorWhitelist = adVerificationConfig['vendorWhitelist'];
    globalAdConfig.adVerification.disabled = adVerificationConfig['disabled'];
    globalAdConfig.adVerification.sessionCleanupDelay = adVerificationConfig['sessionCleanupDelay'];
    globalAdConfig.adVerification.playerHandles = true;
    globalAdConfig.playerHandlesNonLinear = true;

    globalAdConfig.trackImpressionOnStart = globalConfig['trackImpressionOnStart'];
    globalAdConfig.trackSkippedQuartiles = globalConfig['trackSkippedQuartiles'];
    globalAdConfig.maxWrapperDepth = globalConfig['maxWrapperDepth'];
    globalAdConfig.viewability = globalConfig['viewability'];
    
    globalAdConfig.debug = enableDebugOutput;

    var connectResult = smartclientcore.vmap.connect(playerProxy);
    if (connectResult) {
        connectResult.setup(globalAdConfig).then(function ([playlistAPI, api]) {
                                                 adPlaylistAPI = playlistAPI;
                                                 adSlotAPI = api;
                                                 console.log('Ready to request and play out video ads.');
                                                 /**
                                                  * You are ready to request your first ads
                                                  * this is also a good point to subscribe to ad events
                                                  */
                                                 smartclientcore.EVENTS.forEach(eventType => {
                                                     adSlotAPI.addEventListener(eventType, (event) => {
                                                         playerProxy.onEventCallback(JSON.stringify(event));
                                                                                                          });
                                                                                });
                                                smartclientcore.vmap.EVENTS.forEach(eventType => {
                                                        adPlaylistAPI.addEventListener(eventType, (event) => {
                                                            playerProxy.onEventCallback(JSON.stringify(event));
                                                                                                            });
                                                                                });

                                                 adPlaylistAPI.initAdPlaylist(JSON.parse(adPlaylistDescription), JSON.parse(vastMacros)).then(function(adLoaded) {
                                                                                                                   console.log('### Loading AdManifest success.');
                                                     console.log(smartclientcore.EVENT);

                                                    adPlaylistAPI.startAdPlaylist();
                                                                                                                   }, function(failedLoading) {
                                                                                                                   console.warn('### Loading AdManifest failed ' + failedLoading);
                                                                                                                   });

                                                 }, failure => {
                                                     console.log('setup failure: ' + failure);
                                                 });
    } else {
        console.log('Error: connection error. connect returned null');
    }
}
