//
//  SCPublicAdSlot.h
//  SCTVOSSDK
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * This class holds public progress information about the adSlot
 */
@interface SCPublicAdSlot : NSObject
///number    Index of the current ad, regardless of its variant.
@property (nonatomic) NSInteger currentClip;
///number    Total number of ads within the current ad break, regardless of variants.
@property (nonatomic) NSInteger totalClips;
///number    Index of the current ad of variant COMMERCIAL. Defaulting to -1
@property (nonatomic) NSInteger currentCommercial;
///number    Total number of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSInteger totalCommercials;
///number    Total duration of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSTimeInterval totalCommercialsDuration;
/// number    Current time of all ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSTimeInterval totalCommercialsCurrentTime;
/**
 * Initalizer, takes a JSON formatted description string
 * - Parameter description: adInfo as JSON formatted string
 */
- (id)initWithDescription:(NSString*)description;

/**
 * Get the original JSON formatted description as NSDictionary
 */
- (NSDictionary*)publicAdSlotDescription;
@end

NS_ASSUME_NONNULL_END
