//
//  SCAdVariants.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * This class holds an opener, closer and/or bumper for any video.
 */
@interface SCAdVariants : NSObject
/// url string of the opener
@property (nonatomic, copy)  NSString * _Nullable opener;
/// url string of the closer
@property (nonatomic, copy)  NSString * _Nullable closer;
/// url string of the bumper
@property (nonatomic, copy)  NSString * _Nullable bumper;
/// force opener playback
@property (nonatomic) BOOL forceOpener;
/// force closer playback
@property (nonatomic) BOOL forceCloser;
/// force bumper playback
@property (nonatomic) BOOL forceBumper;
/**
* Initialize a Variant object
*
* - Parameter opener: url of video played before the advertisement
* - Parameter closer: url of video played after the advertisement
* - Parameter bumper: url of bumper video
*/
- (id)initWithOpener:(nullable NSString*)opener closer:(nullable NSString*)closer bumper:(nullable NSString*)bumper;
@end

NS_ASSUME_NONNULL_END
