//
//  SCAdLog.h
//  SCTVOSSDK
//
//  Copyright © 2018 smartclip Holding AG. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * Use this class to enable loggings helping you with troubleshooting
 * any kind of errorous behavior of SCTVOSSDK
 */
@interface SCAdLog : NSObject

/**
 * The different levels of logging.
 */
typedef enum LogLevel {
    /// Print every single log message.
    LogVerbose,
    /// Useful for debugging
    LogDebug,
    /// Only print error log messages.
    LogError,
} LogLevel;

/// Check if logging is enabled
@property (nonatomic, class) BOOL loggingEnabled;

/// Pass desired log level here.
+ (void)setLogLevel:(LogLevel)level;
@end
