//
//  SCNonlinearAd.h
//  SmartclipSDKiOS
//
//  Copyright © 2022 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UIImage+URL.h"

NS_ASSUME_NONNULL_BEGIN

@class SCNonlinearAdBackgroundView;

@interface SCNonlinearAd : NSObject
/// A string that identifies an API that is needed to execute the creative.
@property (nonatomic, copy) NSString * _Nullable  apiFramework;
/// Pass information from the VAST response into the VPAID object
@property (nonatomic, strong) NSDictionary * _Nullable adParameters;
/// URIs for clickThrough
@property (nonatomic, copy) NSString * _Nullable clickThroughURL;
/// URIs for clickTracker
@property (nonatomic, strong) NSArray * _Nullable clickTracker;
/// URIs for creativeTracker
@property (nonatomic, strong) NSObject * _Nullable creativeTrackers;
/// Width of the ad in pixels, as given from AdTag
@property (nonatomic) NSInteger width;
/// Height of the ad in pixels, as given from AdTag
@property (nonatomic) NSInteger height;
/// The maximum pixel height of the creative in its expanded state.
@property (nonatomic) NSInteger expandedHeight;
/// The maximum pixel width of the creative in its expanded state.
@property (nonatomic) NSInteger expandedWidth;
/// Maintain the original canvas aspect ratio (width/height) when resizing.
@property (nonatomic) BOOL maintainAspectRatio;
/// Specified by advertiser.
@property (nonatomic, copy) NSString * _Nullable minSuggestedDuration;
/// Array of resources with their attributes and contents parsed into properties.
@property (nonatomic, strong) NSMutableArray * _Nullable resources;
/// Value that indicates whether the media file is meant to scale to larger dimensions.
@property (nonatomic) BOOL scalable;
/// An optional identifier for the creative
@property (nonatomic, copy) NSString * _Nullable identifier;
/// Duration for this ad in seconds
@property (nonatomic) NSInteger displayDuration;

- (instancetype)initWith:(NSDictionary*)dictionary;
- (void)addResourcesTo:(SCNonlinearAdBackgroundView*)backgroundView;
@end

NS_ASSUME_NONNULL_END

