#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>

NS_ASSUME_NONNULL_BEGIN

/// Ad-verification vendors that rely on the Open Measurement (OM) Interface Definition
/// API are enabled by default. The following properties may be adjusted to enable
/// selected verification vendors only and to limit the measurement session
/// execution time.
@interface SCAdVerificationConfig : NSObject
@property (nonatomic) BOOL disabled;
@property (nonatomic) NSInteger sessionCleanupDelay;
- (void)setOMIDVerificationVendors:(NSArray*)vendors;
- (NSString*)getVerificationConfigDescription;
- (NSArray*)vendorWhitelist;
@end

NS_ASSUME_NONNULL_END
