//
//  SCAdConfiguration_internal.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//
#import <SmartclipSDKiOS/SCAdConfiguration.h>

#ifndef SCAdConfiguration_internal_h
#define SCAdConfiguration_internal_h

@class SCAdVariants, SCAdEnvironment, SCAdVerificationConfig;
/// :nodoc:
@interface SCAdConfiguration (internal)

- (NSString*)environmentDescription;

- (NSString*)adVerificationDescription;

- (NSString*)macroDescription;

- (NSString*)globalConfigDescription;

- (SCAdVerificationConfig*)getAdVerificationConfig;

/**
 Initializes a SCAdConfiguration object that defines the advertisement behaviour

 - Parameter adURL: the request url for you advertisement content
 */
- (id)initWithAdURLs:(NSArray*)adUrls variants:(SCAdVariants*)variants;

/**
 Initializes a SCAdConfiguration struct that defines the advertisement behaviour

 - Parameter adURL: the request url for you advertisement content
 - Parameter environment: values about the environment the ad is running in
 */
- (id)initWithAdURLs:(NSArray*)adUrls
            variants:(SCAdVariants*)variants
        environment:(SCAdEnvironment*)environment;
@end

#endif /* SCAdConfiguration_internal_h */
