let eventDispatcher = new EventDispatcher();
let myPlayerFacade = new FacadeBase();
var console=(function(oldCons){
    return {
        log: function(){
            oldCons.log(Array.prototype.slice.call(arguments).join(' '));
        },
        info: function () {
            oldCons.log(Array.prototype.slice.call(arguments).join(' '));
        },
        warn: function () {
            oldCons.log(Array.prototype.slice.call(arguments).join(' '));
        },
        error: function () {
            oldCons.log(Array.prototype.slice.call(arguments).join(' '));
        }
    };
}(window.console));

window.console = console;

let globalAdConfig = smartclientcore.SCHEMA.create(smartclientcore.SCHEMA.GLOBAL_CONFIG);
globalAdConfig.debug = false; // disable debug output to the browser console per default
globalAdConfig.adVerification.playerHandles = true;

function getEventDispatcher() {
    return eventDispatcher;
}

function callbackForPlayerEvent(event) {
    let eventDispatcher = getEventDispatcher();
    eventDispatcher.dispatchEvent(event);
}

function postPlayerFacadeMessage(message) {
    try {
        webkit.messageHandlers.SCPlayerFacade.postMessage(message);
    } catch(err) {
        console.warn('postPlayerFacadeMessage did not succeed for message: ' + message + ', error: ' + err);
    }
}

function callNativeFunction(functionName, argument) {
    try {
        var type = "SCPlayerFacade";
        var data = {'argument':argument};
        var payload = {'type': type, 'functionName': functionName, 'data': data};

        var res = prompt(JSON.stringify (payload));
        return res;
    } catch(err) {
        console.log('The native context does not exist yet');
    }
}

function getCoreVersion() {
    return smartclientcore.version;
}
