// Monkey-patch fetch() and XMLHttpRequest to log network requests
// through the existing WKScriptMessageHandler bridge (logInfo/logError).

(function() {
    var originalFetch = window.fetch;

    window.fetch = function(input, init) {
        var method = (init && init.method) ? init.method.toUpperCase() : "GET";
        var url = (typeof input === "string") ? input : (input.url || String(input));
        var startTime = Date.now();

        window.webkit.messageHandlers.logInfo.postMessage(
            "\uD83C\uDF10 JS net: \u27A1\uFE0F " + method + " " + url
        );

        return originalFetch.apply(this, arguments).then(function(response) {
            var duration = Date.now() - startTime;
            window.webkit.messageHandlers.logInfo.postMessage(
                "\uD83C\uDF10 JS net: \u2705 " + response.status + " " + method + " " + url + " (" + duration + "ms)"
            );
            return response;
        }).catch(function(error) {
            var duration = Date.now() - startTime;
            window.webkit.messageHandlers.logError.postMessage(
                "\uD83C\uDF10 JS net: \u274C FAIL " + method + " " + url + " (" + (error.message || error) + ", " + duration + "ms)"
            );
            throw error;
        });
    };

    var originalXHROpen = XMLHttpRequest.prototype.open;
    var originalXHRSend = XMLHttpRequest.prototype.send;

    XMLHttpRequest.prototype.open = function(method, url) {
        this._scMethod = (method || "GET").toUpperCase();
        this._scUrl = url;
        return originalXHROpen.apply(this, arguments);
    };

    XMLHttpRequest.prototype.send = function() {
        var xhr = this;
        var method = xhr._scMethod || "GET";
        var url = xhr._scUrl || "";
        var startTime = Date.now();

        window.webkit.messageHandlers.logInfo.postMessage(
            "\uD83C\uDF10 JS net: \u27A1\uFE0F " + method + " " + url
        );

        xhr.addEventListener("load", function() {
            var duration = Date.now() - startTime;
            window.webkit.messageHandlers.logInfo.postMessage(
                "\uD83C\uDF10 JS net: \u2705 " + xhr.status + " " + method + " " + url + " (" + duration + "ms)"
            );
        });

        xhr.addEventListener("error", function() {
            var duration = Date.now() - startTime;
            window.webkit.messageHandlers.logError.postMessage(
                "\uD83C\uDF10 JS net: \u274C FAIL " + method + " " + url + " (network error, " + duration + "ms)"
            );
        });

        xhr.addEventListener("timeout", function() {
            var duration = Date.now() - startTime;
            window.webkit.messageHandlers.logError.postMessage(
                "\uD83C\uDF10 JS net: \u274C TIMEOUT " + method + " " + url + " (" + duration + "ms)"
            );
        });

        return originalXHRSend.apply(this, arguments);
    };
})();
