function logLog(emoji, type, args) {
window.webkit.messageHandlers.logLog.postMessage(`${emoji} JS ${type}: ${Object.values(args)
   .map(v => typeof(v) === "undefined" ? "undefined" : typeof(v) === "object" ? JSON.stringify(v) : v.toString())
   .map(v => v.substring(0, 3000)) // Limit msg to 3000 chars
   .join(", ")}`)
} 

function logWarn(emoji, type, args) {
window.webkit.messageHandlers.logWarn.postMessage(`${emoji} JS ${type}: ${Object.values(args)
   .map(v => typeof(v) === "undefined" ? "undefined" : typeof(v) === "object" ? JSON.stringify(v) : v.toString())
   .map(v => v.substring(0, 3000)) // Limit msg to 3000 chars
   .join(", ")}`)
}

function logError(emoji, type, args) {
window.webkit.messageHandlers.logError.postMessage(`${emoji} JS ${type}: ${Object.values(args)
   .map(v => typeof(v) === "undefined" ? "undefined" : typeof(v) === "object" ? JSON.stringify(v) : v.toString())
   .map(v => v.substring(0, 3000)) // Limit msg to 3000 chars
   .join(", ")}`)
} 

function logInfo(emoji, type, args) {
window.webkit.messageHandlers.logInfo.postMessage(`${emoji} JS ${type}: ${Object.values(args)
   .map(v => typeof(v) === "undefined" ? "undefined" : typeof(v) === "object" ? JSON.stringify(v) : v.toString())
   .map(v => v.substring(0, 3000)) // Limit msg to 3000 chars
   .join(", ")}`)
} 

let originalLog = console.log
let originalWarn = console.warn
let originalError = console.error
let originalInfo = console.info

window.console.log = function() { logLog("📗", "log", arguments); originalLog.apply(null, arguments) }
window.console.warn = function() { logWarn("📙", "warning", arguments); originalWarn.apply(null, arguments) }
window.console.error = function() { logError("📕", "error", arguments); originalError.apply(null, arguments) }
window.console.info = function() { logInfo("📘", "info", arguments); originalInfo.apply(null, arguments) }

window.addEventListener("error", function(e) { 
logError("💥", "Uncaught", [`${e.message} at ${e.filename}:${e.lineno}:${e.colno}`])
})
