//
//  SCViewability.h
//  SmartclipSDKiOS
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/// The Media Ratings Council (MRC) has published the following as recommendations for
/// video viewability. How a video ad is counted when 50% of the ad's pixels are visible
/// for at least two seconds. Publishers should disclose their process for tracking
/// viewable video impressions.
@interface SCViewability : NSObject
/// The percentage of how many pixels of an ad must be in the visible area for the
/// visibility time measurement to begin. Default is 50 pixel.
@property (nonatomic) NSInteger area;
/// The number of seconds a single ad must be visible before a viewable tracker can be
/// triggered. Default is 2 seconds.
@property (nonatomic) NSInteger time;
@end

NS_ASSUME_NONNULL_END
