//
//  SCPublicAdSlot.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


///This class holds public progress information about the adSlot
@interface SCPublicAdSlot : NSObject
///Index of the current ad, regardless of its variant.
@property (nonatomic) NSInteger currentClip;
///Total number of ads within the current ad break, regardless of variants.
@property (nonatomic) NSInteger totalClips;
///Index of the current ad of variant COMMERCIAL. Defaulting to -1
@property (nonatomic) NSInteger currentCommercial;
///Total number of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSInteger totalCommercials;
///Total duration of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSTimeInterval totalCommercialsDuration;
///Current time of all ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSTimeInterval totalCommercialsCurrentTime;
///Total number of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSInteger totalPlayableCommercials;
///Total number of playable ads within the current ad break, regardless of variants.
@property (nonatomic) NSInteger totalPlayableClips;
/**
 * Initalizer, takes a JSON formatted description string
 * - Parameter description: adInfo as JSON formatted string
 */
- (id)initWithDescription:(NSString*)description;

/**
 * Get the original JSON formatted description as NSDictionary
 */
- (NSDictionary*)publicAdSlotDescription;
@end

NS_ASSUME_NONNULL_END
