//
//  SCIcon.h
//  SmartclipSDKiOS
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class SCResource;

/// Class that handles Industry Icons
@interface SCIcon : NSObject
/// AltText for Icon
@property (nonatomic, copy) NSString * _Nullable altText;
/// HoverText for icon
@property (nonatomic, copy) NSString * _Nullable hoverText;
/// Identifier or name of icon
@property (nonatomic, copy) NSString * _Nullable program;
/// ApiFramework
@property (nonatomic, copy) NSString * _Nullable apiFramework;
/// ClickThrough url of icon
@property (nonatomic, copy) NSString * _Nullable clickThroughURL;
/// Static resource of icon (image url)
@property (nonatomic, copy) NSString * _Nullable staticResource;
/// Display duration
@property (nonatomic) CGFloat duration;
/// Boolean value that shows if this icon has a creative
@property (nonatomic) BOOL hasCreative;
/// With of the icon
@property (nonatomic) CGFloat width;
/// Height of the icon
@property (nonatomic) CGFloat height;
/// XPosition of the icon
@property (nonatomic) NSString * _Nullable xPosition;
/// YPosition of the icon
@property (nonatomic) NSString * _Nullable yPosition;
/// Icon offset
@property (nonatomic) CGFloat offset;
/// Px ratio of the icon
@property (nonatomic) CGFloat pxRatio;
/// Resource definitions
@property (nonatomic, strong) NSMutableArray<SCResource*> * _Nullable resources;
@end

NS_ASSUME_NONNULL_END
