//
//  SCAdSessionStateListener.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//


#ifndef SCAdSessionStateListener_h
#define SCAdSessionStateListener_h


/// Protocol to inform you about the overall state of the sdk
@protocol SCAdSessionStateListener <NSObject>

/// Overall state of the session
typedef enum SCAdSessionState {
    ///SDK is still initializing
    SessionStateInitializing,
    ///SDK is ready to use
    SessionStateReady
} SCAdSessionState;


@required
/// Implement this function to be informed about the session state
- (void)onSDKReady;
@end

#endif /* SCAdSessionStateListener_h */
