//
//  SCAdPlayerEvent.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// Wrapper class for player events, that need to be sent to SmartclipSDKiOS
@interface SCAdPlayerEvent : NSObject
/// Definition of Player events
typedef enum SCAdPlayerEventType {
    /// Send when playback data is loaded
    EventTypeLoadedData,
    /// Send when player is switching to the play state
    EventTypePlay,
    /// Send when player is switching to the pause state
    EventTypePause,
    /// Send regular time updates while the player is playing
    EventTypeTimeupdate,
    /// Send when the volume has changed
    EventTypeVolumeChanged,
    /// Send when the playback has finished
    EventTypeEnded,
    /// Send when the player has detected an error
    EventTypeError
} SCAdPlayerEventType;


/// Initializer
- (instancetype)initWithPlayerEventType:(SCAdPlayerEventType)eventType;
/// Get the event as string
- (NSString*)eventTypeString;
@end

NS_ASSUME_NONNULL_END
