//
//  SCAdLog.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip Holding AG. All rights reserved.
//

#import <Foundation/Foundation.h>

/// Implement this protocol and set your receiver as SCAdLog logDelegate, if you want to receive log messages in your app (not only in xcode console)
@protocol SCAdLogDelegate <NSObject>
- (void)logString:(nullable NSString*)logString;
@end

///Use this class to enable logging, helping you with troubleshooting any kind of errorous behavior of SmartclipSDKiOS
@interface SCAdLog : NSObject

/**
 * The different levels of logging.
 */
typedef enum LogLevel {
    /// Print every single log message.
    LogVerbose,
    /// Print Debug, Warning and Error messages
    LogDebug,
    /// Print Warning and Error messages
    LogWarning,
    /// Print only Error messages
    LogError,
} LogLevel;

/// Check if logging is enabled, or enable/disable it
@property (nonatomic, class) BOOL loggingEnabled;
/// Set a log delegate to receive log messages as strings
@property (nonatomic, weak, class) id<SCAdLogDelegate> _Nullable logDelegate;

/// Pass desired log level here.
+ (void)setLogLevel:(LogLevel)level;
/// Get current log level
+ (LogLevel)getLogLevel;
@end
