//
//  SCAdListener.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//
#ifndef SCAdListener_h
#define SCAdListener_h

@class SCAdEvent, SCElementSize, SCAdEnvironment;

/// Protocol that the video player uses to inform the listener about certain events.
@protocol SCAdListener <NSObject>
@optional

/// Called when the content video has finished
- (void)contentVideoFinished;

/// Called when the content video fails for any reason
- (void)contentVideoError:(NSError* _Nonnull )error;

/// if you use customizableClickThroughAlert, add this function
- (void)displayClickThroughAlert;

/// The player detected a change of the presentationSize of the current AVPlayerItem
- (void)presentationSizeChangedTo:(CGSize)newSize;

/// Return your environmentVars object (only needed for VMAP implementations)
- (nullable SCAdEnvironment *)getEnvironmentVarsWith:(NSString* _Nonnull)adBreakType;
@required

/// Called on for every SCAdEvent type change
/// - Parameter event: SCAdEvent
- (void)onEventCallback:(SCAdEvent *_Nonnull )event;

/// Click through happened, pass it on to the view controller
- (void)displayClickThroughAlert:(UIAlertController* _Nonnull )alert;

/// Visibility of the adView changed, so pause or resume the player
- (void)visibilityChanged:(BOOL)visible;

/// Give back the current player frame and viewMode (normal or fullscreen)
- (nullable SCElementSize*)getPlayerSize;

/// Give back the frame of the viewPort and the viewMode (normal or fullscreen)
- (nullable SCElementSize*)getViewportSize;
@end

#endif /* SCAdListener_h */
