//
//  SCAdInfo.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SCUniversalAdId;

///Collection of data that describes the current video ad.
@interface SCAdInfo : NSObject

///Value of the id attribute from the VAST > Ad node
@property (nonatomic, copy)     NSString           *adId;

///Value of the VAST > Ad > AdTitle node
@property (nonatomic, copy)     NSString           *title;

///Ad variant, depending on the current schedule and VAST manifest.
@property (nonatomic, copy)     NSString           *variant;

///The default value for this property is false. When the ad reaches a point where it can be skipped, the ad unit updates this property to true and sends the ON_AD_SKIPPABLE_STATE_CHANGE event. The video player can check this property at any time, but should always check it when the ON_AD_SKIPPABLE_STATE_CHANGE event is received.
@property (nonatomic)           BOOL                skippable;

///Total time of the current ad
@property (nonatomic)           NSTimeInterval           duration;

///Current time of the current ad
@property (nonatomic)           NSTimeInterval           currentTime;

///Total number of ads with variant COMMERCIAL within the current ad break
@property (nonatomic) NSInteger totalPlayableCommercials;

///Total number of playable ads within the current ad break, regardless of variants.
@property (nonatomic) NSInteger totalPlayableClips;

///A unique creative identifier that is maintained across different ad systems.
@property (nonatomic, strong)   SCUniversalAdId    *universalAdId;

///A list of multiple creative identifiers that are maintained across different ad systems.
@property (nonatomic, strong)   NSArray            *universalAdIds;

/**
 * Get the original JSON formatted description as NSDictionary
 */
- (NSDictionary*)adInfoDescription;
@end
