//
//  NSString+MediaTime.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// Extension for NSString concerning mediaTime string formatting
@interface NSString(MediaTime)
/// Gives back a formatted time sting like "00:00:00:00" (hours:minutes:seconds:milliseconds)
+ (NSString*)getMediaplaybackStringWithTime:(NSTimeInterval)time;

/// Gives back a duration in seconds as a NSTimeInterval for a String like "00:00:00"
/// (hours:minutes:seconds)
+ (NSTimeInterval)durationFromString:(NSString*)durationString;
@end

NS_ASSUME_NONNULL_END
