//
//  SCOmidController.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <SmartclipSDKiOS/SCAdMacros.h>

NS_ASSUME_NONNULL_BEGIN

@class SCAdEvent;
@protocol SCAdSlotDelegate, SCOmidEventLoggingDelegate;

typedef void (^VerifyOMIDCompletionHandler)(NSError * _Nullable error);

@interface SCOmidController : NSObject
@property (nonatomic, assign) id<SCOmidEventLoggingDelegate> eventLoggingDelegate;

- (instancetype)initWithPartnerName:(NSString*)partnerName versionString:(NSString*)versionString eventLoggingDelegate:(id<SCOmidEventLoggingDelegate>)eventLoggingDelegate;
- (void)verifiyWith:(id<SCAdSlotDelegate>)adSlotDelegate whiteList:(NSArray*)whitelist completion:(VerifyOMIDCompletionHandler)completion;
- (void)registerAdView:(UIView*)adView;
- (void)registerFriendlyObstructions:(NSArray*)views;
- (void)removeAllViews;
- (void)startSession;
- (void)completeSession;
- (void)onNewEvent:(SCAdEvent*)event;
- (void)onVolumeChanged:(CGFloat)volume;
- (void)onAdSkipped;
- (void)onBufferingStateChanged:(BOOL)isBuffering;
- (void)onPlayerCollapsed;
- (void)onStartTrackingWithDuration:(CGFloat)duration andVolume:(CGFloat)volume;
- (void)onClicked;
- (void)adLoadedWithBreakPosition:(SCBreakPosition)breakPosition;
+ (NSString*)omidPartnerName;
@end

NS_ASSUME_NONNULL_END
