//
//  SCAdSlotDelegate.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <SmartclipSDKiOS/SCAdConfiguration.h>
#import <SmartclipSDKiOS/SCElementSize.h>

#ifndef SCAdSlotDelegate_h
#define SCAdSlotDelegate_h

@class SCAdPlayerEvent, SCAdVerification, SCClosedCaptionDescription;

typedef void (^SCJavaScriptBridgeStringResultCompletionBlock)(NSString* _Nullable result);
typedef void (^SCJavaScriptBridgeStringAndErrorResultCompletionBlock)(NSString* _Nullable result, NSError* _Nullable error);
typedef void (^SCJavaScriptBridgeArrayResultCompletionBlock)(NSError * _Nullable error, NSArray * _Nullable array);
typedef void (^SCJavaScriptBridgeBoolResultCompletionBlock)(NSNumber * _Nullable result);
typedef void (^SCJavaScriptBridgeClosedCaptionsResultCompletionBlock)(NSError * _Nullable error, SCClosedCaptionDescription* _Nullable closedCaption);

@protocol SCAdSlotDelegate <NSObject>
- (void)playAdWithURL:(nonnull NSArray*)urls opener:(nullable NSString*)opener closer:(nullable NSString*)closer bumper:(nullable NSString*)bumper;
- (void)playAdWithConfiguration:(SCAdConfiguration*_Nonnull)configuration;
- (void)playVMAPWithConfiguration:(SCAdConfiguration*_Nonnull)configuration;
- (void)stopAdSlot;
- (void)stopAdPlaylist;
- (void)skipAd;
- (void)eventPlayerCallbackWith:(SCAdPlayerEvent*_Nonnull)playerEvent;
- (void)getAdInfo:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getPublicAdSlot:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getPublicAd:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getAdVerifications:(SCJavaScriptBridgeArrayResultCompletionBlock _Nonnull )completion;
- (void)getClosedCaptions:(SCJavaScriptBridgeClosedCaptionsResultCompletionBlock _Nonnull )completion;
- (void)clickThroughURL:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getAdError:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)hasClickThrough:(SCJavaScriptBridgeBoolResultCompletionBlock _Nonnull )completion;
- (void)iconClickThrough:(NSString *_Nonnull)iconName completion:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)iconView:(NSString * _Nonnull)iconName;
- (void)loadRequestPromiseResolve:(SCJavaScriptBridgeBoolResultCompletionBlock _Nullable)completion;
- (void)loadRequestPromiseReject:(SCJavaScriptBridgeBoolResultCompletionBlock _Nullable)completion;
- (void)replayAdSlot;
- (void)resizeWith:(SCElementSize* _Nonnull)boundingRect;
- (void)getCoreVersion:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getAdType:(SCJavaScriptBridgeStringResultCompletionBlock _Nonnull )completion;
- (void)getGenericJSProperty:(NSString* _Nonnull)property completion:(SCJavaScriptBridgeStringAndErrorResultCompletionBlock _Nonnull)completion;
- (void)getNonLinear:(SCJavaScriptBridgeArrayResultCompletionBlock _Nonnull)completion;
@end

#endif /* SCAdSlotDelegate_h */
