//
//  SCAdSlotController_internal.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <SmartclipSDKiOS/SCAdSlotController.h>
#import <SmartclipSDKiOS/SCAdPlayerFacade.h>
#import <SmartclipSDKiOS/SCNonlinearAdBackgroundView.h>

#ifndef SCAdSlotController_internal_h
#define SCAdSlotController_internal_h
@protocol SCAdSlotDelegate, SCAdFacadeDelegate;

@interface SCAdSlotController(internal) <SCAdPlayerFacade, SCNonlinearAdViewDelegate>
- (instancetype)initWithAdSlotDelegate:(id<SCAdSlotDelegate>)adSlotDelegate
                        facadeDelegate:(id<SCAdFacadeDelegate>)facadeDelegate;
- (BOOL)isVisible;
- (BOOL)isPaused;
- (void)stopVisibilityTimer;
- (void)removeFriendViews;
- (void)onPlayerCollapsed;
- (NSMutableArray*)getFriendlyViews;
+ (BOOL)isTesting;
@end

#endif /* SCAdSlotController_internal_h */
