//
//  SCAdSessionController_internal.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//
#import <SmartclipSDKiOS/SCAdSessionController.h>
#import <SmartclipSDKiOS/SCAdSessionStateListener.h>
#import <SmartclipSDKiOS/SCAdSlotDelegate.h>
#import <SmartclipSDKiOS/SCAdInfo.h>

#ifndef SCAdSessionController_internal_h
#define SCAdSessionController_internal_h

typedef void (^JSEvaluationCompletionHandler)(_Nullable id, NSError * _Nullable error);
/// Smartclip error domain specific error codes
typedef enum {
    SCNoFunctionAllowed
} SmartclipErrorCode;

@interface SCAdSessionController(internal) <SCAdSlotDelegate>
@property (nonatomic, readonly) SCAdSessionState sessionState;

///Get the shared instance of this controller
- (void)callJSFunctionWith:(NSString* _Nonnull )functionString completion:(JSEvaluationCompletionHandler _Nullable )completionHandler;
@end

#endif /* SCAdSessionController_internal_h */
