//
//  SCAdPlayerFacade.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>

#ifndef SCAdPlayerFacade_h
#define SCAdPlayerFacade_h

@class SCElementSize, SCAdEnvironment, SCContentSource;

@protocol SCAdPlayerFacade <NSObject>
@required
- (BOOL)loadAdWithUrlString:(NSString*)urlString disableSeeking:(BOOL)disableSeeking;
- (void)startPlayback;
- (void)pausePlayback;
- (BOOL)isPaused;
- (void)mutePlayer;
- (void)unmutePlayer;
- (BOOL)isMuted;
- (void)seek:(NSInteger)offset;
- (double)getCurrentTime;
- (double)getDuration;
- (void)setVolume:(CGFloat)volume;
- (CGFloat)getVolume;
- (void)lockContent;
- (SCContentSource *)getCurrentContentSource;
- (BOOL)releaseContent;
- (NSString*)getError;
- (void)onEventCallback:(NSString *)eventString;
- (SCElementSize*)getPlayerSize;
- (SCElementSize*)getViewportSize;
- (SCAdEnvironment*)getEnvironmentVars:(NSString*)adBreakType;
@end

#endif /* SCAdPlayerFacade_h */
