var adSlotAPI = null;

function stopCurrentAdSlot() {
    if(adSlotAPI){
        adSlotAPI.stopAdSlot();
    }
}

function skipCurrentAd() {
    if(adSlotAPI){
        adSlotAPI.skipAd();
    }
}

function clickThroughURL() {
    if(adSlotAPI){
        return adSlotAPI.clickThrough(true);
    }

    return "";
}

function iconClickThrough(icon) {
    if(adSlotAPI){
        return adSlotAPI.iconClickThrough(icon, true);
    }

    return "";
}

function iconView(icon) {
    if(adSlotAPI){
        adSlotAPI.iconView(icon);
    }
}

function hasClickThrough() {
    return adSlotAPI && adSlotAPI.ad.hasClickThrough;
}

function getAdVerifications() {
    return adSlotAPI.ad.verifications;
}

function getAdInfo() {
    return JSON.stringify(adSlotAPI.ad.info);
}

function getAdType() {
    return adSlotAPI.ad.type;
}

function getAdError() {
    return JSON.stringify(adSlotAPI.ad.error);
}

function getError() {
    return JSON.stringify(adSlotAPI.error);
}

function getPublicAdSlot() {
    return JSON.stringify(adSlotAPI.adSlot);
}

function getPublicAd() {
	console.log(JSON.stringify(adSlotAPI.ad));
    return JSON.stringify(adSlotAPI.ad);
}

function getClosedCaptions() {
    return adSlotAPI.ad.closedCaptions;
}

function replayAd() {
    adSlotAPI.startAdSlot();
}

function resizePlayer(boundingRectangle, viewMode) {
    adSlotAPI.resize(JSON.parse(boundingRectangle), viewMode);
}

function getNonLinear() {
    return adSlotAPI.ad.nonLinear;
}

function playAdWithURL(adURL, openerURL, forceOpener, closerURL, forceCloser, bumperURL, forceBumper, environmentVarsJSON, skipOffset, adVerificationConfigJSON, enableDebugOutput, globalAdConfigDescription, adType) {
    if (enableDebugOutput) {
        console.log("playAdWithURL(" + adURL + ", " + openerURL + ", " + forceOpener + ", " + closerURL + ", " + forceCloser + ", " + bumperURL + ", " + forceBumper + ", " + environmentVarsJSON + ", "+ skipOffset + ", " + adVerificationConfigJSON + ", " + enableDebugOutput + ", " + globalAdConfigDescription + ", " + adType + ")");
    }

    var skipOffsetInt = parseInt(skipOffset);
    if (skipOffsetInt > 0) {
        globalAdConfig.skipOffset = skipOffsetInt;
    }
    globalAdConfig.debug = enableDebugOutput;

    var adVerificationConfig = JSON.parse(adVerificationConfigJSON)
    var globalConfig = JSON.parse(globalAdConfigDescription)
    globalAdConfig.adVerification.vendorWhitelist = adVerificationConfig['vendorWhitelist'];
    globalAdConfig.adVerification.disabled = adVerificationConfig['disabled'];
    globalAdConfig.adVerification.sessionCleanupDelay = adVerificationConfig['sessionCleanupDelay'];
    globalAdConfig.adVerification.playerHandles = true;
    globalAdConfig.playerHandlesNonLinear = true;

    globalAdConfig.trackImpressionOnStart = globalConfig['trackImpressionOnStart'];
    globalAdConfig.trackSkippedQuartiles = globalConfig['trackSkippedQuartiles'];
    globalAdConfig.maxWrapperDepth = globalConfig['maxWrapperDepth'];
    globalAdConfig.viewability = globalConfig['viewability'];

    var connectResult = smartclientcore.vmap.connect(myPlayerFacade);
    if (connectResult) {
        connectResult.setup(globalAdConfig).then(function ([playlistAPI, api]) {
                                                 adPlaylistAPI = playlistAPI;
                                                 adSlotAPI = api;
                                                 console.log('Ready to request and play out video ads.');
                                                 /**
                                                  * You are ready to request your first ads
                                                  * this is also a good point to subscribe to ad events
                                                  */
                                                 smartclientcore.EVENTS.forEach(eventType => {
                                                                                adSlotAPI.addEventListener(eventType, (event) => {
                                                                                                          myPlayerFacade.onEventCallback(JSON.stringify(event));
                                                                                                          });
                                                                                });

                                                 var config = {
                                                 tag: adURL,
                                                 type: adType
                                                 };
                                                 if (openerURL != "null") {
                                                 config.opener = {
                                                 progressive: openerURL,
                                                 forcePlay: forceOpener
                                                 }
                                                 };
                                                 if (closerURL != "null") {
                                                 config.closer = {
                                                 progressive: closerURL,
                                                 forcePlay: forceCloser
                                                 }
                                                 };
                                                 if (bumperURL != "null") {
                                                 config.bumper = {
                                                 progressive: bumperURL,
                                                 forcePlay: forceBumper
                                                 }
                                                 };
                                                 adSlotAPI.initAdSlot(config, JSON.parse(environmentVarsJSON)).then(function(adLoaded) {
                                                                                                                   console.log('### Loading AdManifest success.');
                                                     console.log(smartclientcore.EVENT);
                                                                                                                   adSlotAPI.startAdSlot();
                                                                                                                   }, function(failedLoading) {
                                                                                                                   console.warn('### Loading AdManifest failed ' + failedLoading);
                                                                                                                   });

                                                 }, failure => {
                                                     console.log('setup failure: ' + failure);
                                                 });
    } else {
        console.log('Error: connection error. connect returned null');
    }
}
