function EventDispatcher() {

    this.addEventListener = function _(type, listener) {

        if (!this._listeners) {
            this._listeners = {};
        }

        let listeners = this._listeners;

        if (!listeners[type]) {
            listeners[type] = [];
        }

        if (listeners[type].indexOf(listener) === -1) {
            listeners[type].push(listener);
        }

        return () => {
            this.removeEventListener(type, listener);
        };
    };

    this.hasEventListener = function _(type, listener) {

        if (!this._listeners) {
            return false;
        }

        let listeners = this._listeners;

        if (listeners[type] && listeners[type].indexOf(listener) !== -1) {
            return true;
        }

        return false;
    };

    this.removeEventListener = function _(type, listener) {

        if (!this._listeners) {
            return;
        }

        let listeners = this._listeners;
        let listenerArray = listeners[type];

        if (listenerArray) {

            let index = listenerArray.indexOf(listener);

            if (index !== -1) {
                listenerArray.splice(index, 1);
            }
        }
    };

    this.dispatchEvent = function _(type) {

        if (!this._listeners) {
            return;
        }

        let listeners = this._listeners;
        let listenerArray = listeners[type];

        /* istanbul ignore else */
        if (listenerArray) {
            const length = listenerArray.length;
            
            if (length > 0) {
                /** @type {AdEvent} */
                const adEvent = {
                type:      type,
                timestamp: new Date().getTime(),
                issuer:    'smartclip'
                };

                for (var x = 0; x < length; x++) {
                    listenerArray[x].call(this, adEvent);
                }
            }
        }
    };
}

