//
//  SCPublicAd.h
//  SmartclipSDKiOS
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class SCAdInfo, SCAdError, SCClosedCaptionDescription, SCAdVerification, SCLinear, SCIcon;

///Collection of data for the current running ad
@interface SCPublicAd : NSObject
///Indicates if the ad is currently in a expanded state
@property (nonatomic) BOOL isExpanded;
///Returns whether the current ad is interactive (most likely by using VPAID) or * not.
@property (nonatomic) BOOL isInteractive;
///Indicates whether the ads current mode of operation is linear or non-linear.
@property (nonatomic) BOOL isLinear;
///If true, the ad can be skipped, based on AdTag skip delay and configurable skip offset. Changes of the state can be monitored by listening on ON_AD_SKIPPABLE_STATE_CHANGE
@property (nonatomic) BOOL isSkippable;
///Time in seconds when ad will become skippable based on playback progress. Will return -1 if ad won't become skippable.
@property (nonatomic) NSInteger skipOffset;
///Returns whether the current ad has a ClickThrough target (URL) or not.
@property (nonatomic) BOOL hasClickThrough;
///Width of the ad in pixels, as given from AdTag
@property (nonatomic) NSInteger width;
///Height of the ad in pixels, as given from AdTag
@property (nonatomic) NSInteger height;
///Current time of ad in seconds
@property (nonatomic) NSTimeInterval currentTime;
///Remaining time of ad in seconds
@property (nonatomic) NSTimeInterval remainingTime;
///Duration of current ad, given in seconds
@property (nonatomic) NSTimeInterval duration;
///get volume of the current running ad
@property (nonatomic) double volume;
///Collection of data that describes the current video ad.
@property (nonatomic, strong) SCAdInfo *info;
///Description object of the most recent ad error.
@property (nonatomic, strong) SCAdError *error;
///The value of this property is an Array of caption details for the <ClosedCaption> element.
@property (nonatomic, strong) SCClosedCaptionDescription *closedCaptions;
///The value of this property is an Array that provides details for each <Verification> element.
@property (nonatomic, strong) NSArray *verifications;
///The value of this property is an Array that provides linear creative details for each <Linear> element.
@property (nonatomic, strong) SCLinear *linear;
///The value of this property is an Array that provides ad extension details for the <Extensions> element.
@property (nonatomic, strong) NSArray *extensions;
///The value of this property is an Object that provides ad icon details for the <Icon> element. The video player should request this value whenever it receives the ON_ICONS_DETECTED add-on event.
@property (nonatomic, strong) NSArray *icons;

@property (nonatomic, strong) NSArray<NSString *> *ids;
@property (nonatomic, strong) NSArray<NSString *> *adIds;
@property (nonatomic, strong) NSArray<NSString *> *adId;

/**
 * Get the original JSON formatted description as NSDictionary
 */
- (NSDictionary*)publicAdDescription;
@end

NS_ASSUME_NONNULL_END
