//
//  SCPlayerEventListener.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@class SCPublicAdSlot, SCAdError, SCAdInfo, SCPublicAd;

/// Completionblock that delivers an SCPublicAdSlot object
typedef void (^SCPublicAdSlotCompletionBlock)(SCPublicAdSlot* _Nullable adSlot);
/// Completionblock that delivers an AdError object as result
typedef void (^SCAdErrorCompletionBlock)(SCAdError* _Nullable adError);
/// Completionblock that delivers an SCAdInfo object
typedef void (^SCAdInfoCompletionBlock)(SCAdInfo* _Nullable adInfo);
/// Completionblock that delivers an SCPublicAd object
typedef void (^SCPublicAdCompletionBlock)(SCPublicAd* _Nullable ad);


/// Use this protocol to inform the adSlotController about player related events
@protocol SCPlayerEventListener <NSObject>
///Inform adSlotController about the player state
- (void)playerEventCallbackWith:(SCAdPlayerEventType)playerEventType;
///DEPRECATED: This function must no longer be implemented by the listener
- (void)getAdInfo:(SCAdInfoCompletionBlock _Nonnull )completion __deprecated_msg("This function must no longer be implemented by the listener");
///DEPRECATED: This function must no longer be implemented by the listener
- (void)getAdError:(SCAdErrorCompletionBlock _Nonnull )completion __deprecated_msg("This function must no longer be implemented by the listener");
///DEPRECATED: This function must no longer be implemented by the listener
- (void)getPublicAdSlot:(SCPublicAdSlotCompletionBlock _Nonnull )completion __deprecated_msg("This function must no longer be implemented by the listener");
///DEPRECATED: This function must no longer be implemented by the listener
- (void)onClickThrough __deprecated_msg("This function must no longer be implemented by the listener");
///Inform the adSlotController about an empty player buffer (needed for OMID)
- (void)onBufferEmpty;
///Inform the adSlotController about a refilled player buffer (needed for OMID)
- (void)onBufferRefilled;
///Inform the adSlotController about a successfull ad video load
- (void)loadAdSuccess;
///Inform the adSlotController about an unsuccessfull ad video load
- (void)loadAdFailure;
///DEPRECATED: This function must no longer be implemented by the listener
- (void)stopAdSlot __deprecated_msg("This function must no longer be implemented by the listener");
///Call when presentationSize of the player changes
- (void)resize;

@optional
///Call when contentVideo has finished
- (void)contentVideoFinished;
///Call when contentVideo has an error
- (void)contentVideoError:(NSError*)error;
@end

NS_ASSUME_NONNULL_END
