//
//  SCNonlinearAdBackgroundView.h
//  SmartclipSDKiOS
//
//  Copyright © 2022 smartclip. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <WebKit/WKWebView.h>

NS_ASSUME_NONNULL_BEGIN
@protocol SCNonlinearAdViewDelegate <NSObject>
- (void)onNonlinearClickThrough;
@end

@interface SCNonlinearAdBackgroundView : UIView
@property (nonatomic, strong, nullable) NSLayoutConstraint *widthConstraint;
@property (nonatomic, strong, nullable) NSLayoutConstraint *heightConstraint;
@property (nonatomic, weak) id<SCNonlinearAdViewDelegate> delegate;

- (UIImageView*)getImageView;
- (WKWebView*)getWebView;
@end

NS_ASSUME_NONNULL_END
