//
//  SCMediaFileResource.h
//  SmartclipSDKiOS
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
///Contains all relevant data for the mediaFile
@interface SCMediaFileResource : NSObject
///Identifies the API needed to execute an interactive media file.
@property (nonatomic, copy) NSString *apiFramework;
///Value specifies the average bitrate for the media file.
@property (nonatomic) NSInteger bitrate;
///The native height of the video file, in pixels. (0 for audio ads)
@property (nonatomic) NSInteger height;
///The native width of the video file, in pixels. (0 for audio ads).
@property (nonatomic) NSInteger width;
///Type of linearity (linear/nonlinear)
@property (nonatomic, copy) NSString *linearity;
///Type of media file.
@property (nonatomic, copy) NSString *mimeType;
///Identifies whether the ad always drops when the duration is reached, or if it can potentially extend the duration by pausing the underlying video or delaying the adStopped call after adVideoComplete.
@property (nonatomic) BOOL variableDuration;
@end

NS_ASSUME_NONNULL_END
