//
//  SCMediaError.h
//  SmartclipSDKiOS
//
//  Copyright © 2019 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

///Use this class to inform SmartclipSDKiOS about a media error (error that occured during content video playback)
@interface SCMediaError : NSObject
///Media error codes
typedef enum MediaErrorCode {
    MEDIA_ERR_ABORTED = 1,
    MEDIA_ERR_NETWORK,
    MEDIA_ERR_DECODE,
    MEDIA_ERR_SRC_NOT_SUPPORTED
} MediaErrorCode;

/// Default initializer
- (instancetype)initWithError:(NSError*)error;
/// Get the error description
- (NSString*)description;
@end

NS_ASSUME_NONNULL_END
