//
//  SCContentSource.h
//  SmartclipSDKiOS
//
//  Copyright © 2021 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// Description of the contentVideo and its current playback offset
@interface SCContentSource : NSObject
/// URL of the contentVideo
@property (nonatomic, copy) NSString *url;
/// Current playback offset
@property (nonatomic)       double offset;

/// Initializer
- (instancetype)initWithSource:(NSString*)source andOffset:(double)offset;
/// Description as JSON parsable String
- (NSString*)getDescription;
@end

NS_ASSUME_NONNULL_END
