//
//  SCAdSessionController.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <WebKit/WebKit.h>
#import <SmartclipSDKiOS/SCAdFacadeDelegate.h>
#import <SmartclipSDKiOS/SCAdSessionStateListener.h>

NS_ASSUME_NONNULL_BEGIN

@class SCAdSlotController;

///Initial component that establishes the basic connection to the Ad server and creates the SCAdSlotController instances.
@interface SCAdSessionController : NSObject <WKScriptMessageHandler, WKUIDelegate, WKNavigationDelegate>
///The sessionStateListener informs the app, when the SmartclipSDKiOS is ready to be used
@property (nonatomic, weak) id<SCAdSessionStateListener> sessionStateListener;

/// CompletionBlock that delivers a set
typedef void (^SCSetCompletionBlock)(NSSet* _Nullable set);
/// CompletionBlock that delivers a String
typedef void (^SCStringCompletionBlock)(NSString* _Nullable string);

/// Use this function to get your SCAdSlotController, the object that handles an adSlot
- (SCAdSlotController*)createAdSlotWithFacadeDelegate:(id<SCAdFacadeDelegate>)listener;

/// Stop an adSlot
- (void)stopAdSlot;

/// Skip an ad
- (void)skipAd;

/// Cleanup after usage!
- (void)cleanup;

/// Delete all cookies
- (void)deleteCookies;

/// Get a list of saved cookies
- (void)getSavedCookiesWithCompletion:(SCSetCompletionBlock)completion;

/// Get version string of core
- (void)getCoreVersion:(SCStringCompletionBlock _Nonnull )completion;

/// Set user tracking allowed or not allowed (from ATTrackingManager required since iOS14). Used for blocking cookies
+ (void)setUserTracking:(Boolean)allowed;

/// Set desired referrer string used as baseURL for the WKWebView. This becomes the Referer header on all requests.
+ (void)setDesiredReferrer:(NSString*)referrer;
@end

NS_ASSUME_NONNULL_END
