//
//  SCAdFacadeDelegate.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//
#import <AVKit/AVKit.h>
#import <SmartclipSDKiOS/SCAdSlotController.h>
#import <SmartclipSDKiOS/SCPlayerEventListener.h>

#ifndef SCAdFacadeDelegate_h
#define SCAdFacadeDelegate_h

@class SCAdEvent, SCElementSize, SCAdEnvironment, SCContentSource;

 /// The SCAdFacadeDelegate protocol needs to be implemented by the video player implementation it receives its commands and delivers information through this protocol
@protocol SCAdFacadeDelegate <NSObject>
@optional
/// if you want to support subtitles (captions), implement this optional function in addition to the normal loadAdWithUrlString function (see below)
- (BOOL)loadAdWithCaptions:(NSDictionary* _Nonnull)loadDict disableSeeking:(BOOL)disableSeeking completion:(nullable SCEmptyCompletionBlock)completion;

@required
/// The player should load the ad from this url and is told to disable/enable seeking
- (BOOL)loadAdWithUrlString:(NSString* _Nonnull)urlString disableSeeking:(BOOL)disableSeeking completion:(nullable SCEmptyCompletionBlock)completion;
/// The player should start its playback
- (void)start;
/// The player should pause its playback
- (void)pause;
/// The player should resume its playback
- (void)resume;
/// The player is being asked if it is paused
- (BOOL)isPaused;
/// The player should mute sound
- (void)mutePlayer;
/// The player should unmute sound
- (void)unmutePlayer;
/// The player is being asked if it is muted
- (BOOL)isMuted;
/// The player should seek from its current position to a time offset
- (void)seek:(NSInteger)offset;
/// The player must give back its current playback position
- (double)getCurrentTime;
/// The player must give back the duration of its current video
- (double)getDuration;
/// The player should set its volume to the desired value (unused at the moment)
- (void)setVolume:(CGFloat)volume;
/// The player should give back the current volume (currently unused)
- (CGFloat)getVolume;
/// The player should lock the current content source
- (void)lockContent;
/// The player should give back its current content source
- (SCContentSource *_Nullable)getCurrentContentSource;
/// The player should release its source to the content source (after an adSlot is finished)
- (BOOL)releaseContent;
/// Give back an error, if a playback error occured
- (nullable NSString*)getError;
@end

#endif /* SCAdFacadeDelegate_h */
