//
//  SCAdConfiguration.h
//  SmartclipSDKiOS
//
//  Copyright © 2018 smartclip. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <CoreGraphics/CoreGraphics.h>

NS_ASSUME_NONNULL_BEGIN

@class SCAdEnvironment, SCAdVariants, SCAdPlaylistSetup, UIColor, SCNonlinearAdBackgroundView, SCViewability;

/// enum that defines different ways a clickThrough can be implemented
/// currently ClickableOnFullArea and ClickableOnAssociatedButtonOrLink are handled in the same way,
/// by directly opening the landingpage, whereas
/// ClickableWithConfirmationDialog opens a dialog, which can be configured when
/// "customizableClickThroughAlert" is set to true
typedef enum SCClickType {
    NotClickable,
    ClickableOnFullArea,
    ClickableOnAssociatedButtonOrLink,
    ClickableWithConfirmationDialog
} SCClickType;

typedef  enum SCAdType {
    AdTypeLinear,
    AdTypeNonlinear
} SCAdType;


/// This class is used to configure the advertisement behavior
@interface SCAdConfiguration : NSObject
/// Set this property to "true", if you want to enable debug output of
/// the Java Script Core (defaults to "false")
@property (nonatomic) BOOL enableCoreDebugLogging;
/// The request url for you advertisement content
@property (nonatomic, copy) NSString* _Nullable adURL;
/// BundleId of the app
@property (nonatomic, copy) NSString* _Nullable bundleId;
/// Use this to enable bitrate calculation, or set desiredBitrate
@property (nonatomic, strong) SCAdEnvironment* _Nullable environment;
/// If you use opener, closer or bumper, SCAdVariants is the place to define them
@property (nonatomic, strong) SCAdVariants* _Nullable  variants;
/// DEPRECATED: Setting this property no longer has any effect!
@property (nonatomic, copy) NSString* _Nullable customTitle __deprecated_msg("Setting this property no longer has any effect!");
/// DEPRECATED: Setting this property no longer has any effect!
@property (nonatomic, strong) UIColor* _Nullable customTitleColor __deprecated_msg("Setting this property no longer has any effect!");
/// DEPRECATED: Setting this property no longer has any effect!
@property (nonatomic, strong) UIColor* _Nullable customProgressBarColor __deprecated_msg("Setting this property no longer has any effect!");
/// You can prevent ad skipping with this boolean value, defaults to true
@property (nonatomic)         BOOL     allowAdSkipping;
/// You can define an offset value, when you want to allow ad skipping (defaults to -1, meaning never)
@property (nonatomic)         NSInteger skipOffset;
/// DEPRECATED: Setting this property no longer has any effect!
@property (nonatomic)         BOOL      initialMuted __deprecated_msg("Setting this property no longer has any effect!");
/// message to be displayed on the clickThrough dialog (default: "Open in Browser?")
@property (nonatomic, copy) NSString* _Nonnull clickThroughDialogMessage;
/// string to be displayed on the clickThrough dialog`s positive answer button (default: "YES")
@property (nonatomic, copy) NSString* _Nonnull clickThroughPositiveAnswer;
/// string to be displayed on the clickThrough dialog`s negative answer button (default: "NO")
@property (nonatomic, copy) NSString* _Nonnull clickThroughNegativeAnswer;
/// clickType for clickThrough handling (default: ClickableWithConfirmationDialog)
@property (nonatomic) enum SCClickType  clickType;
/// if you want to have control over the UIAlertController during clickThrough set this to "YES" (and leave clickType on default)
@property (nonatomic) BOOL customizableClickThroughAlert;
/// DEPRECATED: Setting this property no longer has any effect!
@property (nonatomic, copy) NSString* _Nullable replayButtonImageName __deprecated_msg("DEPRECATED: Setting this property no longer has any effect!");
/// adType (linear or nonlinear) (default: AdTypeLinear)
@property (nonatomic) enum SCAdType adType;
/// BackgroundView for nonlinear ads
@property (nonatomic, weak) SCNonlinearAdBackgroundView* _Nullable nonlinearAdContainer;

/// to start VMAP playlists, please use the SCAdPlaylistSetup, it enables you to set
/// different separation clips (opener, closer, bumper) for preroll, midroll and postroll ad breaks.
@property (nonatomic, strong) SCAdPlaylistSetup *vmapPlaylistSetup;
/// In general, wrappers should be limited to ten before resulting in an inline response. Default limit is 10 wrappers
@property (nonatomic) NSInteger maxWrapperDepth;
/// Defines whether the trackers impression and creativeView are requested at the time a
/// video ad is loaded or when the video player actually starts playing (start, 0%).
/// The difference is most noticeable with video players or browsers that prevent autoplay
/// without user interaction. The impression and creative view trackers are requested immediately,
/// while the start tracker is requested after a delay, depending on when playback starts.
/// Defaulting to false if omitted.
@property (nonatomic) BOOL trackImpressionOnStart;
/// Defines whether to track all VAST progress trackers (start, firstQuartile, midpoint,
/// thirdQuartile and complete), regardless of whether some of them were somehow skipped or
/// to just request VAST progress trackers that were actually triggered by a matching playhead update.
/// Possible "skip" use cases are the user seeks over one or multiple progress points, or the
/// timeupdate interval from the video player is too long. Defaulting to false if omitted.
@property (nonatomic) BOOL trackSkippedQuartiles;
/// The Media Ratings Council (MRC) has published the following as recommendations for
/// video viewability. How a video ad is counted when 50% of the ad's pixels are visible
/// for at least two seconds. Publishers should disclose their process for tracking viewable
/// video impressions.
@property (nonatomic, strong) SCViewability *viewability;
/// List of accepted AdVerification vendors (whitelist). Each specified String has to
/// represent an unique identifier that can be found within the verification
/// code resource URI, most likely the domain name. If omitted, the smartclientcore tries
/// to load verification code from each vendor.
- (void)setOMIDVerificationVendorWhitelist:(NSArray*)vendors;
/// Ad verification is enabled by default. Disable carefully.
/// Disabling OM should be limited to two situations: If the OM integration
/// is interfering with your site (app),
/// or if there is a bug in the integration that generates bad OM data.
- (void)disableVerification:(BOOL)disable;
/// Time value in seconds that specifies a delay for closing the current
/// measurement session after the ad has finished playback. Default is 3 seconds.
- (void)setVerificationSessionCleanupDelay:(NSInteger)delay;

/// Default configuration initialized with the given SCAdEnvironment values
+ (SCAdConfiguration*)defaultConfigurationWith:(NSString*)requestURL variants:(SCAdVariants*)variants environment:(SCAdEnvironment*)environment;
/// defaultInstreamConfiguration for use with sequencer
+ (SCAdConfiguration*)defaultInstreamConfigurationWith:(SCAdEnvironment*)environment;
/// Use for nonlinear ads
+ (SCAdConfiguration*)defaultNonLinearConfigurationWith:(SCAdEnvironment*)environment adContainer:(SCNonlinearAdBackgroundView*)adContainer;
/// default VMAP configuration, using a vmapPlaylistSetup
+ (SCAdConfiguration*)defaultVMAPConfigurationWith:(SCAdEnvironment*)environment playlistSetup:(SCAdPlaylistSetup*)playlistSetup;
/// framework bundle version
+ (NSString*)frameworkBundleVersion;
///SmartclipSDK version string (bundleVersion/buildNumber)
+ (NSString*)sdkVersionString;
///OMIDSDK version string
+ (NSString*)omidSDKVersionString;
@end

NS_ASSUME_NONNULL_END
