Object.entries || (Object.entries = function(e) {
  var i = [];
  for (k in e)
    typeof k == "string" && e.propertyIsEnumerable(k) && i.push([k, e[k]]);
  return i;
});
(function() {
  if (typeof navigator != "undefined" && navigator.userAgent) {
    var c = function(r, s) {
      s = s || {
        bubbles: !1,
        cancelable: !1,
        detail: void 0
      };
      var l = document.createEvent("CustomEvent");
      return l.initCustomEvent(r, s.bubbles, s.cancelable, s.detail), l;
    }, e = navigator.userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    /trident|msie/i.test(e[1]) && (c.prototype = window.Event.prototype, window.CustomEvent = c, window.Event = c);
  }
})();
(function(c) {
  c && c.prototype && c.prototype.firstElementChild === void 0 && Object.defineProperty(c.prototype, "firstElementChild", {
    get: function() {
      for (var i, r = this.childNodes, s = 0; i = r[s++]; )
        if (i.nodeType === 1)
          return i;
      return null;
    }
  });
})(typeof window != "undefined" ? window.Node || window.Element : null);
var pt = /* @__PURE__ */ ((c) => (c[c.SILENT = 0] = "SILENT", c[c.ERROR = 1] = "ERROR", c[c.NORMAL = 2] = "NORMAL", c[c.VERBOSE = 3] = "VERBOSE", c))(pt || {}), Me = /* @__PURE__ */ ((c) => (c[c.CRITICAL = 0] = "CRITICAL", c[c.ERROR = 1] = "ERROR", c[c.INFO = 2] = "INFO", c[c.TABLE = 3] = "TABLE", c[c.WARN = 4] = "WARN", c))(Me || {});
let bt = pt.SILENT;
const Fi = "[OIS_DEBUG]", vo = {
  [pt.ERROR]: [Me.CRITICAL, Me.ERROR],
  [pt.NORMAL]: [Me.INFO, Me.TABLE, Me.WARN],
  [pt.SILENT]: [],
  [pt.VERBOSE]: [Me.CRITICAL, Me.ERROR, Me.INFO, Me.TABLE, Me.WARN]
};
function ui() {
}
class f {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    bt = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return bt;
  }
  static shouldLog(e, i) {
    return i !== pt.SILENT && vo[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(Me.CRITICAL, bt) ? console.error : ui).bind(console, Fi),
      info: (this.shouldLog(Me.INFO, bt) ? console.info : ui).bind(console, Fi),
      error: (this.shouldLog(Me.ERROR, bt) ? console.error : ui).bind(console, Fi),
      table: (this.shouldLog(Me.TABLE, bt) ? console.table : ui).bind(console),
      warn: (this.shouldLog(Me.WARN, bt) ? console.warn : ui).bind(console, Fi)
    };
  }
}
const So = "4.0";
class yo {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return So;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var ce = /* @__PURE__ */ ((c) => (c.LINEAR = "linear", c.NON_LINEAR = "nonlinear", c))(ce || {});
function qn(c, e = "") {
  return (Array.isArray(c) ? c : [c]).map((r) => e ? `${r} ${e}` : r).join(",");
}
class Zt {
  static cTSTS(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  static gMNE(e, i) {
    let r = -1, s = null;
    for (const l of te(e, i)) {
      let h = 0, E = l;
      for (; E.parentNode !== e; )
        h++, E = E.parentNode;
      h > r && (r = h, s = l);
    }
    return s;
  }
  static gU(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, h) => !r.includes(l[i], h + 1));
  }
  static t(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
  static f(e, i, r = "") {
    return e.querySelector(qn(i, r));
  }
  static fA(e, i, r = "") {
    return e.querySelectorAll(qn(i, r));
  }
}
const Nt = Zt.cTSTS, X = Zt.f, te = Zt.fA, Io = Zt.gU, At = Zt.gMNE, Se = Zt.t;
class To {
  constructor(e) {
    this.adSourceXML = e, this.adSource = X(this.adSourceXML, "AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? Se(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : Se(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const wt = class wt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return ce.NON_LINEAR;
      default:
        return ce.LINEAR;
    }
  }
  queryElements(e) {
    return te(this.adBreakXML, e);
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = X(this.adBreakXML, ":scope > AdSource");
    return e ? new To(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[wt.POSITION[this.breakPosition]] && this.publisherSpecs[wt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[wt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = Nt(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  getBreakPosition() {
    return this.type === ce.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || Nt(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  getExtensions() {
    const e = this.queryElements(":scope > Extensions > Extension"), i = [];
    for (const r of e)
      i.push({
        extensionXML: r,
        type: r.getAttribute("type") || ""
      });
    return i;
  }
  getTrackers() {
    const e = this.queryElements(":scope > TrackingEvents > Tracking");
    let i = {};
    for (const r of e) {
      const s = r.getAttribute("event"), l = r.textContent.trim();
      l && (i[s] = i[s] || [], i[s].push({ url: l }));
    }
    return i;
  }
  getSeparationClips() {
    return this.publisherSpecs[wt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = X(this.adBreakXML, "ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
wt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let Ai = wt;
class Oo {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let r = e.documentElement || e, s = te(r, ":scope > *");
    const l = [];
    for (const K of s)
      l.push(new Ai(K, i));
    this.adSlotList = l;
    let h = {}, E = [];
    const v = "Ad", I = "AdTagURI", M = "adtaguri", re = "allowMultipleAds", ee = "sequence", Te = "type", z = "VAST";
    for (let K = 0; K < s.length; K++) {
      let y = l[K];
      y.breakPosition === 2 && y.timeOffset !== null && (h[y.timeOffset] = (h[y.timeOffset] || 0) + 1, h[y.timeOffset] > 1 && (y.multiMidroll = !0, E.length === 0 && (this.adSlotList[K - 1].multiMidroll = !0, this.adSlotList[K - 1].adBreakXML.setAttribute(
        Te,
        this.adSlotList[K - 1].adSource.type
      ), this.adSlotList[K - 1].adBreakXML.setAttributeNS(
        null,
        re,
        this.adSlotList[K].adSource.allowMultipleAds.toString()
      ), E.push(this.adSlotList[K - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[K].multiMidroll = !0, y.adBreakXML.setAttribute(Te, this.adSlotList[K].adSource.type), y.adBreakXML.setAttributeNS(
        null,
        re,
        this.adSlotList[K].adSource.allowMultipleAds.toString()
      ), E.push(y.adBreakXML.cloneNode(!0))));
    }
    if (this.midrollHasSameTimeOffset) {
      let K = [];
      for (let R = 0; R < E.length; R++)
        if (E[R].getAttribute(Te).includes(M)) {
          let V = document.createElementNS(null, v);
          V.setAttribute(ee, (R + 1).toString());
          let q = document.createElementNS(null, "Wrapper");
          q.setAttributeNS(
            null,
            "fallbackOnNoAd",
            E[R].getAttribute(re)
          );
          let B = document.createElementNS(null, z + I);
          B.textContent = X(E[R], I).textContent.trim(), q.appendChild(B), V.appendChild(q), K.push(V);
        } else
          X(E[R], v).setAttribute(ee, (R + 1).toString()), K.push(X(E[R], v));
      let y = null;
      for (let R = 0; R < this.adSlotList.length; R++) {
        if (!this.adSlotList[R].multiMidroll)
          continue;
        if (this.adSlotList[R].adBreakXML.hasAttribute(Te) && this.adSlotList[R].adBreakXML.getAttribute(Te).includes(M) && (y = document.createElementNS(null, z + "AdData")), X(this.adSlotList[R].adBreakXML, "Ad") || y) {
          if (y) {
            X(this.adSlotList[R].adBreakXML, "AdTagURI").remove();
            let q = X(this.adSlotList[R].adBreakXML, "AdSource");
            const B = document.createElementNS(null, "VAST");
            for (const J of K)
              B.appendChild(J);
            y.appendChild(B), q.appendChild(y);
          } else {
            X(this.adSlotList[R].adBreakXML, "Ad").remove();
            const q = X(this.adSlotList[R].adBreakXML, "VAST");
            for (const B of K)
              q.appendChild(B);
          }
          this.adSlotList[R].multiMidroll = !1, this.adSlotList[R] = new Ai(this.adSlotList[R].adBreakXML, this.adSlotList[R].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((R) => {
        if (!R.multiMidroll)
          return R;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class Ct {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const w = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let Or = null, Rr = null, Gt = 0, Yn = null, Nr = null;
const Ke = class Ke {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (Yn = e), this.enrichment.set("BLOCKED", Gt, "blocked");
  }
  get isActive() {
    return Gt === 1;
  }
  get vendorAPI() {
    return Nr;
  }
  setVendorAPI(e) {
    !Nr && e && (Nr = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    Rr = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    Or = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (f.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !Yn.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      f.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = w.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!Rr) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    Rr(r, s).then(() => {
      Gt !== Ke.STATUS.IS_BLOCKED ? Or ? Or(r).then((l) => {
        f.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          Ke.STATUS.IS_BLOCKED,
          "blocked"
        ), Gt = Ke.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        f.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (f.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        Ke.STATUS.IS_BLOCKED,
        "blocked"
      ), Gt = Ke.STATUS.IS_BLOCKED, e()) : (f.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    Gt = 0, this.enrichment.set("BLOCKED", Ke.STATUS.IS_OPEN, "blocked");
  }
};
Ke.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, Ke.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, Ke.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, Ke.EventDispatcher = new Ct();
let pe = Ke;
class $e {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: $e.screenHeight(),
      width: $e.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return $e.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !$e.isIF() || $e.isFIF();
  }
}
function Ro() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function ji(c) {
  return encodeURIComponent(c).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function No() {
  const c = /* @__PURE__ */ new Date(), e = c.toISOString();
  let i = c.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function Co(c, e, i) {
  if (c.indexOf(e) === -1)
    return c;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(c) ? parseInt(c.match(/\|(\d+)]/)[1], 10) : 0;
    return c.replace(
      r,
      s === 0 ? ji(i) : ji(i).substring(0, s)
    );
  }
}
function Bi(c) {
  let e = !Number.isFinite(c) || c < 0 ? 0 : c;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function os() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
    let e = Math.random() * 16 | 0;
    return (c === "x" ? e : e & 3 | 8).toString(16);
  });
}
class Rt {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], $e.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], Ro), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Bi), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", $e.userAgent(), "deviceua"), this.set("DOMAIN", $e.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", $e.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Bi), this.set("OS", $e.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.6.2", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      $e.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", $e.screenHeight(), "screenheight"), this.set("SCREENWIDTH", $e.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", No), this.set("TRANSACTIONID", os(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  getMacros(e = !1) {
    let i = {};
    if (e)
      for (const [r] of this.macroMap)
        i[`[${r}]`] = this.get(r, !0);
    else
      for (const [r] of this.macroMap)
        i[r] = this.get(r, !0);
    return i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, h = r || l.macroList;
    return l.value = i, h ? Array.isArray(h) ? l.macroList = h : l.macroList = [h] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => ji(String(l))).join(",") : ji(String(s)) : s;
  }
  setFromObject(e) {
    if (e)
      for (const i in e) {
        if (!Object.prototype.hasOwnProperty.call(e, i))
          continue;
        const r = e[i], s = typeof r == "string" && r.length === 0 || Array.isArray(r) && r.length === 0 ? "-1" : r;
        this.set(i.toUpperCase(), s, "");
      }
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    let i = e === null ? "" : String(e);
    for (const [r, s] of this.macroMap) {
      const l = String(this.get(r, !0));
      for (const h of s.macroList)
        i = this.replaceMacroWithValue(i, h, l);
    }
    return i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return Co(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class Hi {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new Hi().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class _o {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, h = setTimeout(() => {
      s = !0;
      let M = new Error("ImageURLHandler: Tracking request timeout.");
      M.code = w.WARNING.TRACKER_TIMEOUT.code, M.description = w.WARNING.TRACKER_TIMEOUT.message, M.type = "AdWarning", r(M);
    }, l);
    let E = new Image();
    E.src = "";
    const v = () => {
      clearTimeout(h), !s && r(null);
    }, I = (M) => {
      v();
    };
    return E.onerror = I, E.onload = v, E.src = e, E;
  }
}
function Xr(c) {
  if (typeof c != "string")
    return c;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(c, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(c), e = i;
  }
  return e;
}
const Cr = " Response contains neither 'responseXML' nor 'responseText'", Le = class Le {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Le().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, E = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        f.debug.info(Le.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let v = new Error(Le.NAME + ": Request timeout");
      v.code = w.WRAPPER.TIMEOUT.code;
      let I = r.timeouts ? r.timeouts.errorMessage : null;
      v.message = I || w.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? pe.REASON.WRAPPER_CHAIN_TIMEOUT : pe.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: v
      }), i(v, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(E), s.status === 200) {
            let v = s.responseXML;
            if (!v && s.responseText && (v = Xr(s.responseText)), !v) {
              f.debug.info(Le.NAME + Cr);
              let I = new Error(Le.NAME + Cr);
              I.code = r.isWrapper ? w.WRAPPER.NO_RESPONSE.code : w.XML.INVALID_XML.code, I.message = "XHR Response Error:" + Cr, r.adReinsertion.setReinsertionReason({
                reason: pe.REASON.XHR_ERROR,
                xhr: s,
                xhrError: I
              }), i(I, null);
              return;
            }
            i(null, v);
          } else {
            s.onreadystatechange = s.onerror = () => {
              f.debug.info(Le.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let v = new Error(Le.NAME + s.statusText);
            v.code = r.isWrapper ? w.WRAPPER.TIMEOUT.code : w.XML.INVALID_XML.code, v.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: pe.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: v
            }), i(v, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(E), f.debug.info(Le.NAME + ": XHR Error.", s.readyState, s.status, e);
        let v = new Error(Le.NAME + s.statusText);
        v.code = w.WRAPPER.TIMEOUT.code, v.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: pe.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: v
        }), i(v, null);
      };
    } catch (v) {
      clearTimeout(E);
      let I = new Error(`${Le.NAME}: Request error.`);
      I.code = w.WRAPPER.TIMEOUT.code, I.message = `XHR Request Error: ${v}`, r.adReinsertion.setReinsertionReason({
        reason: pe.REASON.XHR_ERROR,
        xhr: null,
        xhrError: I
      }), i(I, null);
    }
  }
  get(e, i, r) {
    f.debug.info(`${Le.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Le.ISSUER.TRACKING ? _o.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Le.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Le.NAME = "XHRURLHandler";
let Et = Le;
Et.DEFAULT_TIMEOUT = 4;
function Wi(c, e) {
  if (c.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + c;
  }
  return c.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + c : c;
}
const Ei = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class qr {
  constructor() {
    this.issuer = Et.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = Ei, s.enrichment = new Rt()), s.issuer = this.issuer, s.enrichment = s.enrichment || new Rt(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = Wi(l, ""));
    let h = s.urlhandler;
    if (s.response) {
      let E = s.response;
      i(null, Xr(E));
    } else return h && h.supported() ? new h().get(l, i, s) : Et.supported() ? new Et().get(l, i, s) : Hi.supported() ? new Hi().get(l, i, s) : i();
    return null;
  }
}
const pi = class pi extends qr {
  constructor() {
    super(), this.issuer = Et.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : f.debug.info(pi.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    for (const s of e)
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && f.debug.warn(pi.NAME + "onResponse failed:", i.name, i, e);
  }
};
pi.NAME = "TrackingUrlHandler::";
let Xi = pi;
const m = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup",
  // HOMAD
  ON_HOMAD_PENALTY: "HOMADPenalty"
}, Kt = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, xt = class xt {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, xt.ERROR_CODE_MAP[w.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, xt.ERROR_CODE_MAP[w.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, f.debug.info(
      Ne.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new Rt(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new pe(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, h) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        f.debug.info(
          Ne.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((E) => {
        f.debug.warn(Ne.NAME + "initAdSlot - Could not init ad slot", E), h(E);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    f.debug.info(
      Ne.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(m.ON_AD_SLOT_START, () => {
        this.trackEvent(Kt.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(m.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(Kt.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(m.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(m.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          xt.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(Kt.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(m.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(Kt.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), f.debug.info(
      Ne.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    f.debug.info(
      Ne.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      f.debug.info(
        Ne.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new Xi().track(e, (r, s) => {
      s && f.debug.warn(Ne.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
xt.ERROR_CODE_MAP = {}, xt.NAME = "AdBreakCtrl::";
let Mr = xt;
const Xe = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, _r = "Content - Scan for AdBreaks to play", me = class me extends Ct {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(m.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(m.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(m.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, f.debug.info(
      me.NAME + "before" + _r + "."
    ), super.dispatchEvent(m.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      f.debug.info(
        me.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(m.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), f.debug.info(
      me.NAME + "start" + _r + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, f.debug.info(
      me.NAME + "after" + _r + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset) {
      this.isSeeking = !1, this.postroll = null;
      for (const s of this.adPlaylist)
        s.timeOffset !== "end" && (s.requested = !0);
      this.requestAdBreak(e);
    }
    if (this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    for (const s of i)
      s.requested = !0;
    return r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new Mr(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((h) => {
        f.debug.info(
          me.NAME + "requestAdBreak - Initialized AdBreak",
          h.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(h), s();
      }).catch((h) => {
        f.debug.warn(
          me.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          h
        ), l(h);
      })) : l(
        me.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      me.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), f.debug.info(me.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = me.PROCESS.REQUEST) {
    function s(h, E) {
      var I;
      const v = h - E;
      return (I = e.publisherSpecs) != null && I.strictOffsets ? v >= 0 && v <= me.STRICT_OFFSET_THRESHOLD : v >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const h = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, h);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === me.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === me.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = Nt(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", Bi(r)), this.adPlaylist.push(new Ai(s, e.publisherSpecs)), f.debug.info(
      me.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener(Xe.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, h = (Date.now() - e) / 1e3;
      l > h + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= me.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        me.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(Xe.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), f.debug.info(
      me.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    f.debug.info(
      me.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
me.NAME = "AdPlaylistCtrl::", me.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, me.STRICT_OFFSET_THRESHOLD = 2, me.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let Ne = me;
const Do = "HomadXHRUrlHandler", Gn = ": Response contains neither 'responseXML' nor 'responseText'", zt = class zt {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new zt().xhrRequest();
  }
  getAsXHR(e, i, r) {
    function s(v) {
      i(v, null);
    }
    function l(v) {
      if (r.issuer && r.issuer === Et.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let I = v.responseXML;
      if (!I && v.responseText && (I = Xr(v.responseText)), !I) {
        let M = new Error(Do + Gn);
        M.code = w.XML.INVALID_XML.code, M.description = "HOMAD Response Error" + Gn, i(M, null);
        return;
      }
      i(null, I);
    }
    if (!r.adReinsertion) {
      let v = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      v.code = w.WRAPPER.TIMEOUT.code, v.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(v);
      return;
    }
    const h = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let E = r.adReinsertion.vendorAPI.getUrlRequest(h);
    E.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), f.debug.info(
      zt.NAME + "getAsXHR - Provide VAST Macro List" + E.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(E, (v) => {
      l(v);
    }, (v) => {
      let I, M = "HOMADUtils XHR";
      v.timedOut ? (I = new Error("HomadUtilsURLHandler: Request timeout."), I.code = w.WRAPPER.TIMEOUT.code, I.description = `${M} Timeout Error ${r.timeouts.errorMessage || w.WRAPPER.TIMEOUT.message}`) : (I = new Error("HomadUtilsURLHandler: " + v.statusText), I.code = w.XML.INVALID_XML.code, I.description = `${M} Status Error (${v.status}): ${v.statusText}`), s(I);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = Ei.timeouts), f.debug.info(`${zt.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
zt.NAME = "HomadUrlHandler::";
let qi = zt;
function as(c) {
  return window.location.protocol === "https:" && !c.startsWith("http://") || window.location.protocol !== "https:";
}
function ze(c, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), c.appendChild(i);
}
const fi = class fi {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (f.debug.info(fi.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return ze(r, w.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    te(e, "VMAP").length > 0 && te(e, "AdBreak").length === 0 && (ze(r, w.VMAP.NO_ADBREAKS), i = r), te(e, "VMAP").length === 0 && te(e, "ParserError").length === 0 && (ze(r, w.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new qr().get(e, (r, s) => {
        if (!r && s && X(s, "parsererror")) {
          let l = document.createDocumentFragment();
          ze(l, w.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          f.debug.warn(fi.NAME + "loadURL - XHR Request Error", r), ze(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  isInsecureURL(e) {
    return this.blockInsecureURL && !as(e);
  }
};
fi.NAME = "VMAPReqService::";
let br = fi;
function ls(c) {
  if (!c || typeof c != "object")
    return !1;
  try {
    return c.self === c;
  } catch (e) {
    return !0;
  }
}
function Qt(c, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (ls(i[r]) ? c[r] = i[r] : typeof c[r] == "object" && typeof i[r] == "object" ? c[r] = Qt(c[r], i[r]) : c[r] = i[r]);
  return c;
}
function ds() {
  return this.error || null;
}
function ht(c) {
  this.error = {
    code: c.code,
    message: c.message,
    timestamp: Date.now()
  };
}
let Kn = null;
const Kr = class Kr extends Ct {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, f.debug.info(Ne.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), f.debug.info(Ne.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = Qt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    Kn = new pe(this.config.adReinsertion, s);
    const l = {
      adReinsertion: Kn,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: Qt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((h, E) => {
      r = this.addEventListener(m.ON_AD_PLAYLIST_LOAD_ERROR, () => E(this.errorAPI)), this.addEventListener(m.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new Ne(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), h("ok")));
      let v = new br(
        l
      );
      e.tag ? v.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : v.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new Oo(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    f.debug.info(Ne.NAME + "onXMLLoadDone and vmap parsed.", i), f.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = X(i, "ParserError"), h = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = w.VMAP.NO_ADBREAKS;
        ht.call(this, h), super.dispatchEvent(m.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(m.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      f.debug.info(
        Ne.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), f.debug.info(
            Ne.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = qi, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          f.debug.info(Ne.NAME + "enable - AdReinsertion remains disabled.", l), ht.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    super.dispatchEvent(m.ON_AD_PLAYLIST_START);
    for (const e of Object.values(m))
      this.adPlaylistController.addEventListener(e, (i) => {
        super.dispatchEvent(i.type);
      });
    return new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return ds.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
Kr.NAME = "AdPlaylAPI::";
let Pr = Kr;
var Ee = /* @__PURE__ */ ((c) => (c.CLOSER = "closer", c.DIVIDER = "divider", c.OPENER = "opener", c.COMMERCIAL = "commercial", c.SPONSORED = "sponsored", c))(Ee || {});
class Lo {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== Ee.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const ue = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, ut = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, ct = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, Ge = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, mi = class mi extends f {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.resolutionListeners = {}, this.eventsThatRequireResponse = [
      ue.CLICK_THRU,
      ue.GET_MEDIA_STATE,
      ue.READY,
      ue.REPORT_TRACKING,
      ue.REQUEST_CHANGE_AD_DURATION,
      ue.REQUEST_FULL_SCREEN,
      ue.REQUEST_PAUSE,
      ue.REQUEST_PLAY,
      ue.REQUEST_RESIZE,
      ue.REQUEST_SKIP,
      ue.REQUEST_STOP,
      ue.REQUEST_VIDEO_LOCATION,
      ue.REQUEST_VOLUME,
      ct.AD_SKIPPED,
      ct.AD_STOPPED,
      ct.FATAL_ERROR,
      ct.INIT,
      ct.START_CREATIVE,
      Ge.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === Ge.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((h, E) => {
      this.addResolveRejectListener(r, h, E), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((h) => {
      this.target.postMessage(JSON.stringify(l), "*"), h();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  isResolve(e) {
    return e.type === Ge.RESOLVE;
  }
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      this.isResolve(l) ? i(l.args.value) : r(l.args.value);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  parseData(e) {
    try {
      return JSON.parse(e);
    } catch (i) {
      return null;
    }
  }
  callListeners(e, i) {
    const r = this.listeners[e];
    if (r)
      for (let s = 0; s < r.length; s++)
        r[s](i);
  }
  // eslint-disable-next-line complexity
  isValidSession(e) {
    const i = e.sessionId, r = e.type, s = this.sessionId === "" && r === Ge.CREATE_SESSION, l = this.sessionId === i;
    if (!(!(s || l) || r === null)) {
      if (Object.values(Ge).includes(r))
        this.handleProtocolMessage(e);
      else if (r.startsWith("SIMID:")) {
        const E = r.substring(6);
        this.callListeners(E, e);
      }
    }
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i = this.parseData(e.data);
    i && this.isValidSession(i);
  }
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case Ge.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {}), this.callListeners(i, e);
        break;
      case Ge.RESOLVE:
      // intentional fallthrough
      case Ge.REJECT:
        const s = e.args.messageId, l = this.resolutionListeners[s];
        l && (l(e), delete this.resolutionListeners[s]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ge.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ge.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      f.debug.info(mi.NAME + "createSession resolve");
    }, i = () => {
      f.debug.info(mi.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(Ge.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
mi.NAME = "SIMIDPtl::";
let wr = mi;
function Ot(c, e) {
  let i = document.createElement(c);
  if (e)
    for (const r in e)
      Object.prototype.hasOwnProperty.call(e, r) && i.setAttribute(r, e[r]);
  return i;
}
const $i = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, zn = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Pt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, hi = 0, Dr = -2, Mo = !0, Fe = class Fe {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new wr(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = hi, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = hi, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      f.debug.info(
        Fe.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = Ot("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    if (f.debug.info(Fe.NAME + "createSimidIframe with", this.creativeAsset), e.style.display = "none", this.container.appendChild(e), this.creativeAsset.resource) {
      const i = new Blob([this.creativeAsset.resource], { type: "text/html" });
      e.src = URL.createObjectURL(i);
    } else
      e.src = this.creativeAsset.fileURL;
    return this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  addListeners() {
    this.simidProtocol.addListener(Ge.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(ue.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(ue.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(ue.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(ue.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(ue.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(ue.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(ue.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      ue.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(ue.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(ue.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(ue.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(ue.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(ue.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = e.y + e.height <= i.height, s = e.x + e.width <= i.width;
    return r && s;
  }
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      f.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  setIFrameDimensions(e) {
    f.debug.info(Fe.NAME + "resize", e), this.IFrame.style.height = e.height.toString(), this.IFrame.style.width = e.width.toString(), this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(m.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: $i.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), f.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), f.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), f.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: $i.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), f.debug.error(Fe.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: $i.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), f.debug.error(Fe.NAME + i, r.message);
    }
  }
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(ct.INIT, l).then(() => {
      this.resolveInitializationPromise(), f.debug.info(Fe.NAME + "session created");
    }).catch((E) => {
      this.rejectInitializationPromise(E);
    });
  }
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(m.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), f.debug.info(Fe.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(ct.START_CREATIVE);
  }
  onAdInitializedFailed(e) {
    this.setError(w.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(m.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), f.debug.error(Fe.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  setCreativeControlsState(e) {
    let i = te(document, ".ad_request");
    if (i)
      for (let r of i)
        r.disabled = e;
  }
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        ut.ERROR,
        {
          error: w.SIMID.GENERAL_ERROR.code,
          message: w.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = w.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(ut.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(ut.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(ut.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(ut.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(ut.SEEKING);
    }), this.videoTrackingEvents.set(Xe.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        ut.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        ut.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Pt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        ut.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Pt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(ct.AD_STOPPED).then(() => {
      f.debug.info(Fe.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(ct.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(m.ON_AD_SKIPPED), this.loadedSource = null;
  }
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(Mo), this.adSlotController.dispatchEvent(m.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    f.debug.info(Fe.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.requestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: zn.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: $i.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Pt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Pt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    f.debug.info(Fe.NAME + "onReportTracking -  Creative has asked the player to send a ping."), f.debug.table(i);
  }
  videoComplete() {
    if (this.simidProtocol.sendMessage(ut.ENDED), this.requestedDuration === hi && this.stopAd(Pt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== hi && this.requestedDuration !== Dr) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Pt.CREATIVE_INITIATED);
      }, e);
    }
  }
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== Dr && i < 0) {
      const r = {
        errorCode: zn.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  compareAdAndReqDurations() {
    this.requestedDuration === hi || this.requestedDuration === Dr || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (f.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Pt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(ct.LOG, i);
  }
};
Fe.NAME = "SIMIDPly::";
let xr = Fe;
function Jn(c) {
  return c.height >= 0 ? c.y + c.height : c.y;
}
function Qn(c) {
  return c.width >= 0 ? c.x : c.x + c.width;
}
function Zn(c) {
  return c.width >= 0 ? c.x + c.width : c.x;
}
function es(c) {
  return c.height >= 0 ? c.y : c.y + c.height;
}
function bo(c, e) {
  let i = 0, r = {
    bottom: Math.min(Jn(c), Jn(e)),
    height: 0,
    left: Math.max(Qn(c), Qn(e)),
    right: Math.min(Zn(c), Zn(e)),
    top: Math.max(es(c), es(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = c.width * c.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class Po {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   */
  constructor(e) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(m)) {
      let i = this.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case m.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case m.ON_AD_PLAYBACK_START:
      case m.ON_AD_PLAYING:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case m.ON_AD_PLAYBACK_FINISHED:
      case m.ON_AD_SKIPPED:
      case m.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(m.ON_AD_NOT_VIEWABLE)), this.removeEventListeners(), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.adSlotController.player.getPlayerSize(), i = this.adSlotController.player.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(m.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = bo(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(m.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (f.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(m.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(m.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function wo(c, e, i) {
  return new Promise((r) => {
    let s = Ot("iframe", {
      id: c,
      style: e
    });
    s.onload = () => {
      let l = Ot("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let h = Ot("style", {});
      h.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(h), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const G = class G extends Ct {
  // ms
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = f.logLevel === pt.NORMAL || f.logLevel === pt.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = Ot("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.timeoutAdLoadedTimer = null, this.timeoutScriptLoadTimer = null, this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), wo(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = Ot("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = Ot("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = Ot("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      f.debug.warn(G.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = w.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest);
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), f.debug.info(
      G.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (f.debug.info(G.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return f.debug.info(
        G.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), f.debug.info(
        G.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), f.debug.info(
      G.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), f.debug.info(
      G.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    f.debug.info(G.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = w.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest);
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    f.debug.info(G.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = w.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness);
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, f.debug.info(G.NAME + "cleanup"), this.dispatchEvent(m.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    f.debug.info(G.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(m.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    f.debug.info(G.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    f.debug.info(G.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    f.debug.info(G.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    f.debug.info(G.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    f.debug.info(G.NAME + "onStartAd"), this.dispatchEvent(m.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression() {
    f.debug.info(G.NAME + "onAdImpression"), this.dispatchEvent(m.ON_AD_IMPRESSION);
  }
  onAdVideoStart() {
    f.debug.info(G.NAME + "onAdVideoStart"), this.dispatchEvent(m.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), G.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (f.debug.warn(G.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, G.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile() {
    f.debug.info(G.NAME + "onAdVideoFirstQuartile"), this.dispatchEvent(m.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint() {
    f.debug.info(G.NAME + "onAdVideoMidpoint"), this.dispatchEvent(m.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile() {
    f.debug.info(G.NAME + "onAdVideoThirdQuartile"), this.dispatchEvent(m.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete() {
    f.debug.info(G.NAME + "onAdVideoComplete"), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.dispatchEvent(m.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange() {
    f.debug.info(G.NAME + "onAdDurationChange"), this.getAllProperties();
  }
  onStopAd() {
    f.debug.info(G.NAME + "onStopAd"), this.dispatchEvent(m.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i) {
    f.debug.info(G.NAME + "onAdError", e, i), this.currentAd.error = this.currentAd.error === null ? w.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(m.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd() {
    this.dispatchEvent(m.ON_AD_SKIPPED), f.debug.info(G.NAME + "onSkipAd"), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(m.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && f.debug.info(
      G.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(m.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange() {
    f.debug.info(G.NAME + "onAdExpandedChange");
  }
  onAdSkippableStateChange() {
    f.debug.info(G.NAME + "onAdSkippableStateChange"), this.dispatchEvent(m.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(m.ON_AD_PROGRESS);
  }
  onAdVolumeChange() {
    f.debug.info(G.NAME + "onAdVolumeChange");
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    f.debug.info(G.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (f.debug.info(G.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(m.ON_AD_CLICKED);
  }
  onAdInteraction(e) {
    f.debug.info(G.NAME + "onAdInteraction", e);
  }
  onAdUserAcceptInvitation() {
    f.debug.info(G.NAME + "onAdUserAcceptInvitation");
  }
  onAdUserMinimize() {
    f.debug.info(G.NAME + "onAdUserMinimize");
  }
  onAdUserClose() {
    f.debug.info(G.NAME + "onAdUserClose");
  }
  onAdPaused() {
    f.debug.info(G.NAME + "onAdPaused");
  }
  onAdPlaying() {
    f.debug.info(G.NAME + "onAdPlaying"), this.dispatchEvent(m.ON_AD_PLAYING);
  }
  onAdLog(e) {
    f.debug.info(G.NAME + "onAdLog", e);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && f.debug.info(
        G.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), f.debug.table(this.debugTiming));
  }
  //Debug -- End
};
G.NAME = "VPAIDBridge::", G.TIMEUPDATE_INTERVAL = 250;
let Vr = G;
const gi = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  //  and it's used in canPlayType, text/html can't be played it's only used for interactive actions.
  VPAID: "application/javascript",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, We = class We extends Ct {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot.
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads.
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {FacadePlayer} player - Facade interface for the player.
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = We.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(m), this.eventTypes = Object.values(m), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  hasOffsetReached(e, i, r) {
    let s = r.offset;
    return typeof s == "string" && s.indexOf("%") > -1 && (s = parseInt(s, 10) / 100 * i), e >= parseInt(s, 10) && !r.requested;
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new Lo(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(gi)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [Ee.COMMERCIAL, Ee.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new Po(this));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    for (const i of this.eventCallbacks)
      i();
    this.eventCallbacks = [];
    for (const i of Object.values(m)) {
      const r = this.addEventListener(i, (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }
    if (this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const h = this.currentAd.config.adSourceSelector(
          l
        ).then((E) => E === null || Object.keys(E).length === 0 ? null : E);
        Promise.race([r, h]).then((E) => {
          E === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = E : this.currentAd.properCreative.selectedResource = E, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(m.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, f.debug.info(We.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === Ee.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), f.debug.info(
          We.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), f.debug.info(We.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      f.debug.info(We.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new Xi().track(e, (s, l) => {
      l && (f.debug.warn(We.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : w.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(m.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === ce.NON_LINEAR) {
      this.currentAd.error = w.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(m.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = w.VAST.UNSUPPORTED_MIMETYPE), f.debug.info(We.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(m.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(m.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = Wi(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(m.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((h) => h.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === Ee.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      f.debug.info(We.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(m.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(m.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(m.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === We.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(m.ON_ENTER_FULLSCREEN), this.dispatchEvent(m.ON_PLAYER_EXPAND)) : (this.dispatchEvent(m.ON_EXIT_FULLSCREEN), this.dispatchEvent(m.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(m.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === Ee.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(m.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Bi(e)), this.currentAd.variant === Ee.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [Ee.COMMERCIAL, Ee.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          this.hasOffsetReached(e, this.adDuration, s) && this.dispatchEvent(m.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(m.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(m.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(m.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(m.ON_AD_FIRST_QUARTILE), e && i.push(m.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((h) => h === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = Kt[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let h = this.currentAd.trackingEvents[r];
      e === m.ON_AD_PROGRESS && (h = h.filter((E) => this.hasOffsetReached(s, l, E))), this.callTrackers(h);
    }
  }
  loadAdSIMID() {
    this.currentAd.properCreative.selectedCreativeFile.fileURL === "" && this.currentAd.properCreative.selectedCreativeFile.resource === null ? (this.currentAd.error = w.SIMID.GENERAL_ERROR, this.cancelAdWithError()) : (this.simidPlayer = new xr(this), this.simidPlayer.initializeAd());
  }
  loadAdVPAID() {
    this.vpaidPlayer = new Vr(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      m.ON_AD_CLICKED,
      m.ON_AD_LOADED,
      m.ON_AD_STARTED,
      m.ON_AD_IMPRESSION,
      m.ON_AD_PLAYING,
      m.ON_AD_PLAYBACK_START,
      m.ON_AD_FIRST_QUARTILE,
      m.ON_AD_MID_POINT,
      m.ON_AD_THIRD_QUARTILE,
      m.ON_AD_PLAYBACK_FINISHED,
      m.ON_AD_STOPPED,
      m.ON_AD_SKIPPED,
      m.ON_AD_ERROR,
      m.ON_AD_PROGRESS,
      m.ON_AD_SIZE_CHANGED,
      m.ON_AD_SKIPPABLE_STATE_CHANGE,
      m.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      m.ON_AD_LINEARITY_CHANGE,
      m.ON_AD_SKIPPED,
      m.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case m.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (f.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case m.ON_AD_SKIPPED:
        case m.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case m.ON_AD_LOADED:
      //onStartAd
      case m.ON_AD_STARTED:
      //onStartAd
      case m.ON_AD_IMPRESSION:
      case m.ON_AD_PLAYING:
      //onAdPlaying()
      case m.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case m.ON_AD_FIRST_QUARTILE:
      case m.ON_AD_MID_POINT:
      case m.ON_AD_THIRD_QUARTILE:
      case m.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case m.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case m.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case m.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case m.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case m.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case m.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case m.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case m.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    f.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
We.NAME = "AdSloCtrl::", We.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let kr = We;
var ci = /* @__PURE__ */ ((c) => (c[c.ERROR_RESOURCE_REJECTED = 1] = "ERROR_RESOURCE_REJECTED", c[c.ERROR_VERIFICATION_NOT_SUPPORTED = 2] = "ERROR_VERIFICATION_NOT_SUPPORTED", c[c.ERROR_ON_RESOURCE_LOAD = 3] = "ERROR_ON_RESOURCE_LOAD", c))(ci || {});
function ve() {
  return ve = Object.assign ? Object.assign.bind() : function(c) {
    for (var e = 1; e < arguments.length; e++) {
      var i = arguments[e];
      for (var r in i) ({}).hasOwnProperty.call(i, r) && (c[r] = i[r]);
    }
    return c;
  }, ve.apply(null, arguments);
}
function Z(c) {
  "@babel/helpers - typeof";
  return Z = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
    return typeof e;
  } : function(e) {
    return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
  }, Z(c);
}
var It = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function xo(c) {
  return c && c.__esModule && Object.prototype.hasOwnProperty.call(c, "default") ? c.default : c;
}
var us = {};
(function(c) {
  (function(e, i, r) {
    if (Z(r) === "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      var s = function(M) {
        for (var re in M)
          M.hasOwnProperty(re) && (M[re] = s(M[re]));
        return Object.freeze(M);
      }, r = {}, l = ["1.6.3-iab357"], h = "default";
      h && l.push(h), i(e, r);
      for (var E in r)
        r.hasOwnProperty(E) && (Object.getOwnPropertyDescriptor(e, E) == null && Object.defineProperty(e, E, {
          value: {}
        }), l.forEach(function(I) {
          if (Object.getOwnPropertyDescriptor(e[E], I) == null) {
            var M = s(r[E]);
            Object.defineProperty(e[E], I, {
              get: function() {
                return M;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(It, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, u) {
      return a.raw = u, a;
    }, r.arrayIteratorImpl = function(a) {
      var u = 0;
      return function() {
        return u < a.length ? {
          done: !1,
          value: a[u++]
        } : {
          done: !0
        };
      };
    }, r.arrayIterator = function(a) {
      return {
        next: r.arrayIteratorImpl(a)
      };
    }, r.makeIterator = function(a) {
      var u = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (u)
        return u.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var u, A = []; !(u = a.next()).done; )
        A.push(u.value);
      return A;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var u = function() {
      };
      return u.prototype = a, new u();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, u, A) {
      return a == Array.prototype || a == Object.prototype || (a[u] = A.value), a;
    }, r.getGlobal = function(a) {
      a = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, a, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, Z(It) == "object" && It];
      for (var u = 0; u < a.length; ++u) {
        var A = a[u];
        if (A && A.Math == Math)
          return A;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && Z(Symbol("x")) === "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, u, A, S) {
      u && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, u, A, S) : r.polyfillUnisolated(a, u, A, S));
    }, r.polyfillUnisolated = function(a, u, A, S) {
      for (A = r.global, a = a.split("."), S = 0; S < a.length - 1; S++) {
        var C = a[S];
        if (!(C in A))
          return;
        A = A[C];
      }
      a = a[a.length - 1], S = A[a], u = u(S), u != S && u != null && r.defineProperty(A, a, {
        configurable: !0,
        writable: !0,
        value: u
      });
    }, r.polyfillIsolated = function(a, u, A, S) {
      var C = a.split(".");
      a = C.length === 1, S = C[0], S = !a && S in r.polyfills ? r.polyfills : r.global;
      for (var se = 0; se < C.length - 1; se++) {
        var de = C[se];
        if (!(de in S))
          return;
        S = S[de];
      }
      C = C[C.length - 1], A = r.IS_SYMBOL_NATIVE && A === "es6" ? S[C] : null, u = u(A), u != null && (a ? r.defineProperty(r.polyfills, C, {
        configurable: !0,
        writable: !0,
        value: u
      }) : u !== A && (r.propertyToPolyfillSymbol[C] === void 0 && (A = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[C] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(C) : r.POLYFILL_PREFIX + A + "$" + C), r.defineProperty(S, r.propertyToPolyfillSymbol[C], {
        configurable: !0,
        writable: !0,
        value: u
      })));
    }, r.getConstructImplementation = function() {
      function a() {
        function A() {
        }
        return Reflect.construct(A, [], function() {
        }), new A() instanceof A;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var u = Reflect.construct;
        return function(A, S, C) {
          return A = u(A, S), C && Reflect.setPrototypeOf(A, C.prototype), A;
        };
      }
      return function(A, S, C) {
        return C === void 0 && (C = A), C = r.objectCreate(C.prototype || Object.prototype), Function.prototype.apply.call(A, C, S) || C;
      };
    }, r.construct = {
      valueOf: r.getConstructImplementation
    }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = {
        a: !0
      }, u = {};
      try {
        return u.__proto__ = a, u.a;
      } catch (A) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, u) {
      if (a.__proto__ = u, a.__proto__ !== u)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, u) {
      if (a.prototype = r.objectCreate(u.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var A = r.setPrototypeOf;
        A(a, u);
      } else
        for (A in u)
          if (A != "prototype")
            if (Object.defineProperties) {
              var S = Object.getOwnPropertyDescriptor(u, A);
              S && Object.defineProperty(a, A, S);
            } else
              a[A] = u[A];
      a.superClass_ = u.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), u = [], A = a; A < arguments.length; A++)
        u[A - a] = arguments[A];
      return u;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var u = r.setPrototypeOf;
        return function(A, S) {
          try {
            return u(A, S), !0;
          } catch (C) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var u = function(de, ft) {
        this.$jscomp$symbol$id_ = de, r.defineProperty(this, "description", {
          configurable: !0,
          writable: !0,
          value: ft
        });
      };
      u.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var A = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", S = 0, C = function(de) {
        if (this instanceof C)
          throw new TypeError("Symbol is not a constructor");
        return new u(A + (de || "") + "_" + S++, de);
      };
      return C;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var u = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), A = 0; A < u.length; A++) {
        var S = r.global[u[A]];
        typeof S == "function" && typeof S.prototype[a] != "function" && r.defineProperty(S.prototype, a, {
          configurable: !0,
          writable: !0,
          value: function() {
            return r.iteratorPrototype(r.arrayIteratorImpl(this));
          }
        });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = {
        next: a
      }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, u) {
      a instanceof String && (a += "");
      var A = 0, S = !1, C = {
        next: function() {
          if (!S && A < a.length) {
            var de = A++;
            return {
              value: u(de, a[de]),
              done: !1
            };
          }
          return S = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return C[Symbol.iterator] = function() {
        return C;
      }, C;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(u) {
          return u;
        });
      };
    }, "es6", "es3"), r.checkStringArgs = function(a, u, A) {
      if (a == null)
        throw new TypeError("The 'this' value for String.prototype." + A + " must not be null or undefined");
      if (u instanceof RegExp)
        throw new TypeError("First argument to String.prototype." + A + " must not be a regular expression");
      return a + "";
    }, r.polyfill("String.prototype.repeat", function(a) {
      return a || function(u) {
        var A = r.checkStringArgs(this, null, "repeat");
        if (0 > u || 1342177279 < u)
          throw new RangeError("Invalid count value");
        u |= 0;
        for (var S = ""; u; )
          u & 1 && (S += A), (u >>>= 1) && (A += A);
        return S;
      };
    }, "es6", "es3"), r.stringPadding = function(a, u) {
      return a = a !== void 0 ? String(a) : " ", 0 < u && a ? a.repeat(Math.ceil(u / a.length)).substring(0, u) : "";
    }, r.polyfill("String.prototype.padStart", function(a) {
      return a || function(u, A) {
        var S = r.checkStringArgs(this, null, "padStart");
        return r.stringPadding(A, u - S.length) + S;
      };
    }, "es8", "es3"), r.owns = function(a, u) {
      return Object.prototype.hasOwnProperty.call(a, u);
    }, r.polyfill("Object.values", function(a) {
      return a || function(u) {
        var A = [], S;
        for (S in u)
          r.owns(u, S) && A.push(u[S]);
        return A;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, u = Object.create(new r.global.Proxy(a, {
          get: function(S, C, se) {
            return S == a && C == "q" && se == u;
          }
        }));
        return u.q === !0;
      } catch (A) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function u() {
        if (!a || !Object.seal)
          return !1;
        try {
          var x = Object.seal({}), F = Object.seal({}), $ = new a([[x, 2], [F, 3]]);
          return $.get(x) != 2 || $.get(F) != 3 ? !1 : ($.delete(x), $.set(F, 4), !$.has(x) && $.get(F) == 4);
        } catch (ot) {
          return !1;
        }
      }
      function A() {
      }
      function S(x) {
        var F = Z(x);
        return F === "object" && x !== null || F === "function";
      }
      function C(x) {
        if (!r.owns(x, de)) {
          var F = new A();
          r.defineProperty(x, de, {
            value: F
          });
        }
      }
      function se(x) {
        if (!r.ISOLATE_POLYFILLS) {
          var F = Object[x];
          F && (Object[x] = function($) {
            return $ instanceof A ? $ : (Object.isExtensible($) && C($), F($));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var de = "$jscomp_hidden_" + Math.random();
      se("freeze"), se("preventExtensions"), se("seal");
      var ft = 0, W = function(F) {
        if (this.id_ = (ft += Math.random() + 1).toString(), F) {
          F = r.makeIterator(F);
          for (var $; !($ = F.next()).done; )
            $ = $.value, this.set($[0], $[1]);
        }
      };
      return W.prototype.set = function(x, F) {
        if (!S(x))
          throw Error("Invalid WeakMap key");
        if (C(x), !r.owns(x, de))
          throw Error("WeakMap key fail: " + x);
        return x[de][this.id_] = F, this;
      }, W.prototype.get = function(x) {
        return S(x) && r.owns(x, de) ? x[de][this.id_] : void 0;
      }, W.prototype.has = function(x) {
        return S(x) && r.owns(x, de) && r.owns(x[de], this.id_);
      }, W.prototype.delete = function(x) {
        return S(x) && r.owns(x, de) && r.owns(x[de], this.id_) ? delete x[de][this.id_] : !1;
      }, W;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function u() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var W = Object.seal({
            x: 4
          }), x = new a(r.makeIterator([[W, "s"]]));
          if (x.get(W) != "s" || x.size != 1 || x.get({
            x: 4
          }) || x.set({
            x: 4
          }, "t") != x || x.size != 2)
            return !1;
          var F = x.entries(), $ = F.next();
          return $.done || $.value[0] != W || $.value[1] != "s" ? !1 : ($ = F.next(), !($.done || $.value[0].x != 4 || $.value[1] != "t" || !F.next().done));
        } catch (ot) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var A = /* @__PURE__ */ new WeakMap(), S = function(x) {
        if (this.data_ = {}, this.head_ = de(), this.size = 0, x) {
          x = r.makeIterator(x);
          for (var F; !(F = x.next()).done; )
            F = F.value, this.set(F[0], F[1]);
        }
      };
      S.prototype.set = function(W, x) {
        W = W === 0 ? 0 : W;
        var F = C(this, W);
        return F.list || (F.list = this.data_[F.id] = []), F.entry ? F.entry.value = x : (F.entry = {
          next: this.head_,
          previous: this.head_.previous,
          head: this.head_,
          key: W,
          value: x
        }, F.list.push(F.entry), this.head_.previous.next = F.entry, this.head_.previous = F.entry, this.size++), this;
      }, S.prototype.delete = function(W) {
        return W = C(this, W), W.entry && W.list ? (W.list.splice(W.index, 1), W.list.length || delete this.data_[W.id], W.entry.previous.next = W.entry.next, W.entry.next.previous = W.entry.previous, W.entry.head = null, this.size--, !0) : !1;
      }, S.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = de(), this.size = 0;
      }, S.prototype.has = function(W) {
        return !!C(this, W).entry;
      }, S.prototype.get = function(W) {
        return (W = C(this, W).entry) && W.value;
      }, S.prototype.entries = function() {
        return se(this, function(W) {
          return [W.key, W.value];
        });
      }, S.prototype.keys = function() {
        return se(this, function(W) {
          return W.key;
        });
      }, S.prototype.values = function() {
        return se(this, function(W) {
          return W.value;
        });
      }, S.prototype.forEach = function(W, x) {
        for (var F = this.entries(), $; !($ = F.next()).done; )
          $ = $.value, W.call(x, $[1], $[0], this);
      }, S.prototype[Symbol.iterator] = S.prototype.entries;
      var C = function(x, F) {
        var $ = F && Z(F);
        $ == "object" || $ == "function" ? A.has(F) ? $ = A.get(F) : ($ = "" + ++ft, A.set(F, $)) : $ = "p_" + F;
        var ot = x.data_[$];
        if (ot && r.owns(x.data_, $))
          for (x = 0; x < ot.length; x++) {
            var Dt = ot[x];
            if (F !== F && Dt.key !== Dt.key || F === Dt.key)
              return {
                id: $,
                list: ot,
                index: x,
                entry: Dt
              };
          }
        return {
          id: $,
          list: ot,
          index: -1,
          entry: void 0
        };
      }, se = function(x, F) {
        var $ = x.head_;
        return r.iteratorPrototype(function() {
          if ($) {
            for (; $.head != x.head_; )
              $ = $.previous;
            for (; $.next != $.head; )
              return $ = $.next, {
                done: !1,
                value: F($)
              };
            $ = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }, de = function() {
        var x = {};
        return x.previous = x.next = x.head = x;
      }, ft = 0;
      return S;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", h = "omid_message_version", E = "omid_message_args", v = function(u, A, S, C) {
      this.guid = u, this.method = A, this.version = S, this.args = C;
    };
    v.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[h] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[h] == "string" && (a[E] === void 0 || a[E] !== void 0);
    }, v.deserialize = function(a) {
      return new v(a[s], a[l], a[h], a[E]);
    }, v.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[h] = this.version, a), this.args !== void 0 && (a[E] = this.args), a;
    };
    var I = {
      AdEventType: {
        SESSION_START: "sessionStart",
        SESSION_FINISH: "sessionFinish"
      },
      MediaEventType: {
        LOADED: "loaded",
        START: "start",
        FIRST_QUARTILE: "firstQuartile",
        MIDPOINT: "midpoint",
        THIRD_QUARTILE: "thirdQuartile",
        COMPLETE: "complete",
        PAUSE: "pause",
        RESUME: "resume",
        BUFFER_START: "bufferStart",
        BUFFER_FINISH: "bufferFinish",
        SKIPPED: "skipped",
        VOLUME_CHANGE: "volumeChange",
        PLAYER_STATE_CHANGE: "playerStateChange",
        AD_USER_INTERACTION: "adUserInteraction"
      },
      ImpressionType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      ErrorType: {
        GENERIC: "generic"
      },
      AccessMode: {
        FULL: "full"
      },
      Environment: {
        APP: "app",
        WEB: "web"
      },
      CreativeType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      CommunicationType: {
        NONE: "NONE",
        DIRECT: "DIRECT",
        POST_MESSAGE: "POST_MESSAGE"
      },
      MessageMethod: {
        IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow"
      }
    }, M = function(u) {
      this.to = u, this.communicationType_ = I.CommunicationType.NONE;
    };
    M.prototype.sendMessage = function(a, u) {
    }, M.prototype.handleMessage = function(a, u) {
      this.onMessage && this.onMessage(a, u);
    }, M.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, M.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, M.prototype.isDirectCommunication = function() {
      return this.communicationType_ === I.CommunicationType.DIRECT;
    }, M.prototype.isCrossOrigin = function() {
    };
    function re(a, u) {
      if (!u)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof u != "string" && !(u instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (u.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function ee(a, u) {
      if (u == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function Te(a, u) {
      if (u == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof u != "number" || isNaN(u))
        throw Error("Value for " + a + " is not a number");
    }
    function z(a, u, A, S) {
      if (Te(a, u), u < A || u > S)
        throw Error("Value for " + a + " is outside the range [" + A + "," + S + "]");
    }
    function K() {
      return typeof i == "undefined" ? null : i;
    }
    function y(a, u) {
      return a && (a[u] || (a[u] = {}));
    }
    function R(a, u, A) {
      (A = A === void 0 ? K() : A) && (a = a.split("."), a.slice(0, a.length - 1).reduce(y, A)[a[a.length - 1]] = u);
    }
    var V = function(u, A) {
      re("Partner.name", u), re("Partner.version", A), this.name = u, this.version = A;
    };
    R("OmidSessionClient.Partner", V);
    var q = function(u, A, S, C) {
      C = C === void 0 ? I.AccessMode.FULL : C, re("VerificationScriptResource.resourceUrl", u), this.resourceUrl = u, this.vendorKey = A, this.verificationParameters = S, this.accessMode = C;
    };
    q.prototype.toJSON = function() {
      return {
        accessMode: this.accessMode,
        resourceUrl: this.resourceUrl,
        vendorKey: this.vendorKey,
        verificationParameters: this.verificationParameters
      };
    }, R("OmidSessionClient.VerificationScriptResource", q);
    var B = function(u, A) {
      re("UniversalAdId.value", u), re("UniversalAdId.idRegistry", A), this.value = u, this.idRegistry = A;
    };
    B.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, R("OmidSessionClient.UniversalAdId", B);
    var J = function(u, A, S, C, se) {
      S = S === void 0 ? null : S, C = C === void 0 ? null : C, se = se === void 0 ? null : se, ee("Context.partner", u), this.partner = u, this.verificationScriptResources = A, this.videoElement = this.slotElement = null, this.contentUrl = S, this.customReferenceData = C, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = se;
    };
    J.prototype.setVideoElement = function(a) {
      ee("Context.videoElement", a), this.videoElement = a;
    }, J.prototype.setSlotElement = function(a) {
      ee("Context.slotElement", a), this.slotElement = a;
    }, J.prototype.setServiceWindow = function(a) {
      ee("Context.serviceWindow", a), this.serviceWindow = a;
    }, R("OmidSessionClient.Context", J);
    var U = {};
    function D() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof It != "undefined" && It)
        return It;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    U.omidGlobal = D();
    var L = {
      ROOT: "omidSessionInterface",
      AD_EVENTS: "adEvents",
      MEDIA_EVENTS: "mediaEvents"
    }, _ = {
      sessionError: "reportError"
    }, H = Object.keys(I.MediaEventType).map(function(a) {
      return I.MediaEventType[a];
    }), Q = ["impressionOccurred"], Ce = function(u) {
      u = u === void 0 ? U.omidGlobal : u, this.interfaceRoot_ = u[L.ROOT];
    };
    Ce.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, Ce.prototype.sendMessage = function(a, u, A) {
      if (a == "registerSessionObserver" && (A = [u]), _[a] && (a = _[a]), u = this.interfaceRoot_, 0 <= Q.indexOf(a) && (u = u[L.AD_EVENTS]), 0 <= H.indexOf(a) && (u = u[L.MEDIA_EVENTS]), u = u[a], !u)
        throw Error("Unrecognized method name: " + a + ".");
      u.apply(null, r.arrayFromIterable(A));
    };
    function je() {
      return typeof crypto != "undefined" && typeof crypto.getRandomValues == "function";
    }
    function it() {
      return je() ? ei() : kt();
    }
    function ei() {
      var a = new Uint8Array(16);
      crypto.getRandomValues(a), a[6] = a[6] & 15 | 64, a[8] = a[8] & 63 | 128;
      for (var u = [], A = 0; 16 > A; A++)
        u.push(a[A].toString(16).padStart(2, "0"));
      return u[0] + u[1] + u[2] + u[3] + "-" + u[4] + u[5] + "-" + u[6] + u[7] + "-" + u[8] + u[9] + "-" + u[10] + u[11] + u[12] + u[13] + u[14] + u[15];
    }
    function kt() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var u = 16 * Math.random() | 0;
        return a = a === "y" ? (u & 3 | 8).toString(16) : u.toString(16), a;
      });
    }
    function qe() {
      var a = r.getRestArguments.apply(0, arguments);
      rt(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function rt(a, u) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && u();
    }
    var Je = {
      Version: "1.6.3-iab357"
    }, gt = 3;
    function nt(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function st(a, u) {
      a = a.split("-")[0].split("."), u = u.split("-")[0].split(".");
      for (var A = 0; A < gt; A++) {
        var S = parseInt(a[A], 10), C = parseInt(u[A], 10);
        if (S > C)
          break;
        if (S < C)
          return !1;
      }
      return !0;
    }
    var Be = "1.0.3";
    function Ut(a, u) {
      return nt(a) && st(a, Be) ? u : JSON.stringify(u);
    }
    function Ft(a, u) {
      return nt(a) && st(a, Be) ? u || [] : u && typeof u == "string" ? JSON.parse(u) : [];
    }
    var ge = {
      SESSION_SERVICE: "SessionService."
    };
    function He(a) {
      return _e(a, ge.SESSION_SERVICE);
    }
    function _e(a, u) {
      return u + a;
    }
    function Pe(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function we(a) {
      if (a === U.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        P(a);
      } catch (u) {
        return !0;
      }
      return !1;
    }
    function P(a) {
      return a.x === "" || a.x !== "";
    }
    function Y(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), Pe(a) ? a : U.omidGlobal;
    }
    function Ie(a) {
      return Pe(a) ? a.top : U.omidGlobal;
    }
    var ae = function(u) {
      M.call(this, u), this.communicationType_ = I.CommunicationType.DIRECT, this.handleExportedMessage = ae.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(ae, M), ae.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.handleExportedMessage(a.serialize(), this);
    }, ae.prototype.handleExportedMessage = function(a, u) {
      v.isValidSerializedMessage(a) && this.handleMessage(v.deserialize(a), u);
    }, ae.prototype.isCrossOrigin = function() {
      return !1;
    };
    var le = function(u, A) {
      A = A === void 0 ? U.omidGlobal : A, M.call(this, A);
      var S = this;
      this.communicationType_ = I.CommunicationType.POST_MESSAGE, u.addEventListener("message", function(C) {
        if (Z(C.data) === "object") {
          var se = C.data;
          v.isValidSerializedMessage(se) && (se = v.deserialize(se), C.source && S.handleMessage(se, C.source));
        }
      });
    };
    r.inherits(le, M), le.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, le.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.postMessage(a.serialize(), "*");
    }, le.prototype.isCrossOrigin = function() {
      return this.to ? we(this.to) : !0;
    };
    var ie = {
      OMID_PRESENT_FRAME_NAME: "omid_v1_present",
      OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web",
      OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app",
      getEnvironmentIframeName: function(u) {
        var A = {};
        return (A[I.Environment.APP] = ie.OMID_PRESENT_FRAME_NAME_APP, A[I.Environment.WEB] = ie.OMID_PRESENT_FRAME_NAME_WEB, A)[u];
      }
    };
    function vt(a, u) {
      try {
        return a.frames && !!a.frames[u];
      } catch (A) {
        return !1;
      }
    }
    ie.isOmidPresent = function(a) {
      return [ie.OMID_PRESENT_FRAME_NAME, ie.OMID_PRESENT_FRAME_NAME_WEB, ie.OMID_PRESENT_FRAME_NAME_APP].some(function(u) {
        return vt(a, u);
      });
    }, ie.getOmidEnvironment = function(a) {
      for (var u = r.makeIterator(Object.values(I.Environment)), A = u.next(); !A.done; A = u.next()) {
        A = A.value;
        var S = ie.getEnvironmentIframeName(A);
        if (vt(a, S))
          return A;
      }
      return null;
    };
    function _t(a, u) {
      a.document.write('<iframe style="display:none" id="' + (u + '" name="' + u + '" sandbox></iframe>'));
    }
    ie.declareOmidPresence = function(a, u) {
      a.frames && a.document && ![ie.OMID_PRESENT_FRAME_NAME, ie.OMID_PRESENT_FRAME_NAME_WEB, ie.OMID_PRESENT_FRAME_NAME_APP].some(function(A) {
        return !!a.frames[A];
      }) && (a.document.body == null && ie.isMutationObserverAvailable_(a) ? ie.registerMutationObserver_(a, u) : (u = ie.getEnvironmentIframeName(u), a.document.body ? (ie.appendPresenceIframe_(a, ie.OMID_PRESENT_FRAME_NAME), ie.appendPresenceIframe_(a, u)) : (_t(a, ie.OMID_PRESENT_FRAME_NAME), _t(a, u))));
    }, ie.appendPresenceIframe_ = function(a, u) {
      var A = a.document.createElement("iframe");
      A.id = u, A.name = u, A.style.display = "none", A.sandbox = "", a.document.body.appendChild(A);
    }, ie.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, ie.registerMutationObserver_ = function(a, u) {
      var A = new MutationObserver(function(S) {
        S.forEach(function(C) {
          C.addedNodes[0].nodeName === "BODY" && (C = ie.getEnvironmentIframeName(u), ie.appendPresenceIframe_(a, ie.OMID_PRESENT_FRAME_NAME), ie.appendPresenceIframe_(a, C), A.disconnect());
        });
      });
      A.observe(a.document.documentElement, {
        childList: !0
      });
    };
    var zi = ["omid", "v1_SessionServiceCommunication"];
    function Ji(a, u) {
      return u.reduce(function(A, S) {
        return A && A[S];
      }, a);
    }
    function ti(a, u, A, S) {
      if (!we(u))
        try {
          var C = Ji(u, A);
          if (C)
            return new ae(C);
        } catch (se) {
        }
      return S(u) ? new le(a, u) : null;
    }
    function Oe(a, u, A, S) {
      u = r.makeIterator(u);
      for (var C = u.next(); !C.done; C = u.next())
        if (C = ti(a, C.value, A, S))
          return C;
      return null;
    }
    function Qi(a, u, A) {
      A = A === void 0 ? ie.isOmidPresent : A;
      var S = [a, Ie(a)];
      return u && S.unshift(u), Oe(a, S, zi, A);
    }
    var ne = function(u, A, S) {
      ee("AdSession.context", u), this.adSessionId_ = it(), this.context_ = u, this.impressionOccurred_ = !1;
      var C = this.context_.serviceWindow || void 0;
      this.communication_ = A || Qi(Y(), C), this.sessionInterface_ = S || new Ce(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(u.verificationScriptResources), this.sendSlotElement_(u.slotElement), this.sendVideoElement_(u.videoElement), this.sendContentUrl_(u.contentUrl), this.watchSessionEvents_();
    };
    ne.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, ne.prototype.setCreativeType = function(a) {
      if (a === I.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + I.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== I.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, ne.prototype.setImpressionType = function(a) {
      if (a === I.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + I.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== I.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, ne.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, ne.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, ne.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, ne.prototype.start = function() {
      var a = {
        customReferenceData: this.context_.customReferenceData,
        underEvaluation: this.context_.underEvaluation
      };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, ne.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, ne.prototype.error = function(a, u) {
      this.sendOneWayMessage("sessionError", a, u, this.adSessionId_);
    }, ne.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, ne.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, ne.prototype.sendOneWayMessage = function(a) {
      var u = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(u)));
    }, ne.prototype.sendMessage = function(a, u) {
      var A = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, u, A) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, u, A);
    }, ne.prototype.sendInternalMessage_ = function(a, u, A) {
      var S = it();
      u && (this.callbackMap_[S] = u), a = new v(S, He(a), Je.Version, Ut(Je.Version, A)), this.communication_.sendMessage(a);
    }, ne.prototype.handleInternalMessage_ = function(a, u) {
      u = a.method;
      var A = a.guid;
      if (a = a.args, u === "response" && this.callbackMap_[A]) {
        var S = Ft(Je.Version, a);
        this.callbackMap_[A].apply(this, S);
      }
      u === "error" && window.console && qe(a);
    }, ne.prototype.sendInterfaceMessage_ = function(a, u, A) {
      try {
        this.sessionInterface_.sendMessage(a, u, A);
      } catch (S) {
        qe("Failed to communicate with SessionInterface with error:"), qe(S);
      }
    }, ne.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, ne.prototype.impressionOccurred = function() {
      if (this.creativeType_ === I.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === I.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, ne.prototype.creativeLoaded = function() {
      if (this.creativeType_ === I.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === I.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, ne.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", Je.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, ne.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(u) {
        return u.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, ne.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, ne.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, ne.prototype.sendElement_ = function(a, u) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(u, a, this.adSessionId_) : this.error(I.ErrorType.GENERIC, "Session Client " + u + " called when communication is cross-origin"));
    }, ne.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, ne.prototype.setElementBounds = function(a) {
      ee("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, ne.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(u) {
        u.type === I.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = u.data.creativeType, a.impressionType_ = u.data.impressionType), u.type === I.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, R("OmidSessionClient.AdSession", ne);
    var $t = function(u, A, S, C) {
      this.isSkippable = u, this.skipOffset = A, this.isAutoPlay = S, this.position = C;
    };
    $t.prototype.toJSON = function() {
      return {
        isSkippable: this.isSkippable,
        skipOffset: this.skipOffset,
        isAutoPlay: this.isAutoPlay,
        position: this.position
      };
    };
    var ii = function(u) {
      ee("AdEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerAdEvents(), this.adSession = u;
      } catch (A) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    ii.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, ii.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, R("OmidSessionClient.AdEvents", ii);
    var Re = function(u) {
      ee("MediaEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerMediaEvents(), this.adSession = u;
      } catch (A) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    Re.prototype.start = function(a, u) {
      Te("MediaEvents.start.duration", a), z("MediaEvents.start.mediaPlayerVolume", u, 0, 1), this.adSession.sendOneWayMessage("start", a, u, this.adSessionId_);
    }, Re.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, Re.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, Re.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, Re.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, Re.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, Re.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, Re.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, Re.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, Re.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, Re.prototype.volumeChange = function(a) {
      z("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, Re.prototype.playerStateChange = function(a) {
      ee("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, Re.prototype.adUserInteraction = function(a) {
      ee("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, R("OmidSessionClient.MediaEvents", Re);
    var Zi = function(u, A) {
      re("OmidVersion.semanticVersion", u), re("OmidVersion.apiLevel", A);
    };
    R("OmidSessionClient.OmidVersion", Zi);
    function er(a) {
      var u = Y();
      new le(u).onMessage = function(A, S) {
        A.method === I.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(S);
      };
    }
    R("OmidSessionClient.listenForServiceWindow", er), R("OmidSessionClient.VastProperties", $t);
    var xe = {
      VerificationVendorId: {
        OTHER: 1,
        MOAT: 2,
        DOUBLEVERIFY: 3,
        INTEGRAL_AD_SCIENCE: 4,
        PIXELATE: 5,
        NIELSEN: 6,
        COMSCORE: 7,
        MEETRICS: 8,
        GOOGLE: 9,
        HUMAN: 10,
        MOBIAN: 11
      }
    };
    function ri(a) {
      for (var u = r.makeIterator(yi.keys()), A = u.next(); !A.done; A = u.next()) {
        A = A.value;
        for (var S = r.makeIterator(yi.get(A)), C = S.next(); !C.done; C = S.next())
          if (C.value.test(a))
            return A;
      }
      return xe.VerificationVendorId.OTHER;
    }
    var yi = /* @__PURE__ */ new Map([[xe.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [xe.VerificationVendorId.INTEGRAL_AD_SCIENCE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/]], [xe.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [xe.VerificationVendorId.NIELSEN, []], [xe.VerificationVendorId.COMSCORE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/]], [xe.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [xe.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [xe.VerificationVendorId.HUMAN, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]], [xe.VerificationVendorId.MOBIAN, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.outcomes\.net\/.*$/]]]);
    R("OmidSessionClient.verificationVendorIdForScriptUrl", ri), R("OmidSessionClient.VerificationVendorId", xe.VerificationVendorId), xe.verificationVendorIdForScriptUrl = ri;
  }, c);
})(us);
const Vo = /* @__PURE__ */ xo(us), Ae = class Ae {
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = Vo.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      f.debug.warn(Ae.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      f.debug.info(
        Ae.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (f.debug.info(
      Ae.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), f.debug.table(this.verifications), e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      f.debug.info(
        Ae.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      Ae.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, ci.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        ci.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  initOMIDJS() {
    this.adSession = this.createAdSession();
    const e = this.ad.adType === "video" ? Ae.IMPRESSION_TYPE.RENDER : Ae.IMPRESSION_TYPE.AUDIBLE;
    if (this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? e : Ae.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), f.debug.info(Ae.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return f.debug.error(Ae.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((r) => {
        this.trackError(
          r.tracking.verificationNotExecuted,
          ci.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const i = () => {
      const r = this.createVastProperties();
      this.adEvents.loaded(r), this.video.removeEventListener("canplaythrough", i);
    };
    return this.video.addEventListener("canplaythrough", i), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  createAdSession() {
    let e = new this.sessionClient.Partner(
      Ae.PARTNER_NAME,
      Ae.PARTNER_VERSION
    ), i = this.verifications.map((s) => (f.debug.info(
      Ae.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      Wi(
        s.javascriptResource.url,
        s.javascriptResource.url
      ),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      Wi(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(m)) {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case m.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), f.debug.info(Ae.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case m.ON_AD_SKIPPED:
      case m.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          f.debug.info(Ae.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (f.debug.info(Ae.NAME + i, e), !this.adEvents) {
      f.debug.warn(Ae.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case m.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case m.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case m.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case m.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case m.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case m.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case m.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case m.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case m.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case m.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case m.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case m.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case m.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case m.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case m.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case m.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  trackError(e, i) {
    this.ad.enrichment.set("REASON", i, "reason"), this.adSlotDelivery.adSlotController.callTrackers(e);
  }
};
Ae.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, Ae.PARTNER_NAME = "Smartcliptv", Ae.PARTNER_VERSION = "7.6.2", Ae.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], Ae.NAME = "OMID::";
let Ur = Ae;
const Lr = "Resource", Yi = {
  STATIC: `Static${Lr}`,
  HTML: `HTML${Lr}`,
  IFRAME: `IFrame${Lr}`
}, Tt = class Tt extends Ct {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case Yi.STATIC:
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    f.debug.info(Tt.NAME + "pause");
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    f.debug.info(Tt.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    f.debug.info(Tt.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    f.debug.info(Tt.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(m.ON_AD_LOADED), this.dispatchEvent(m.ON_AD_STARTED), this.dispatchEvent(m.ON_AD_IMPRESSION), this.dispatchEvent(m.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    f.debug.info(Tt.NAME + "onStopAd"), this.dispatchEvent(m.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(m.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
Tt.NAME = "NonLinear::";
let Fr = Tt;
const tt = class tt extends Ct {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i) {
    super(), this.adSlotController = i, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i.player;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        f.debug.info(
          tt.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (I(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, h = this.getRemoveHandlerForAdSlotControllerEvent(
          m.ON_AD_STARTED,
          s
        ), E = this.getRemoveHandlerForAdSlotControllerEvent(
          m.ON_AD_ERROR,
          l
        ), v = this.getRemoveHandlerForAdSlotControllerEvent(
          m.ON_VPAID_CLEANUP,
          r
        ), I = () => {
          h(), E(), v();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      m.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(Xe.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(Xe.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(m.ON_AD_PAUSED);
    }), this.addPlayerEventListener(Xe.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(m.ON_AD_PLAYING);
    }), this.addPlayerEventListener(Xe.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(m.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(m.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(m.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(m.ON_AD_START, this.saveStartVolume), super.addEventListener(m.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(Xe.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(m.ON_AD_STOPPED), f.debug.info(tt.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(Xe.ON_ERROR, () => {
      f.debug.info(
        tt.NAME + "on - Player sent error event"
      );
    });
  }
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => {
      if (!this.adSlotHasStarted)
        return e();
      this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(m.ON_AD_SLOT_STOPPED));
      for (const i of this.eventCallbacks)
        i();
      return this.eventCallbacks = [], e();
    });
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), f.debug.info(tt.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(m.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart;
        e.removeImpressionOnStartHandler = (s ? e.adSlotController : e).addEventListener(
          // To bridge the gap between impression (ad loaded) and start (first timeupdate),
          //  a publisher may want the impression to be tracked with the start trackers first.
          s ? m.ON_AD_PLAYBACK_START : m.ON_AD_STARTED,
          () => {
            e.adSlotController.dispatchEvent(m.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(m.ON_AD_CREATIVE_VIEW);
          }
        );
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(m.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    if (e && e.length > 0 && this.dispatchEvent(m.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(m.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(m.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(m.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0) {
      if (!this.currentAd.config.adVerification.disabled)
        this.currentAd.config.adVerification.playerHandles || new Ur(this.currentAd, this);
      else {
        f.debug.warn(
          tt.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
        );
        for (const i of this.currentAd.adVerifications)
          this.currentAd.enrichment.set("REASON", ci.ERROR_RESOURCE_REJECTED, "reason"), this.adSlotController.callTrackers(i.tracking.verificationNotExecuted);
      }
      this.dispatchEvent(m.ON_VERIFICATION_DETECTED);
    }
  }
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(m.ON_AD_ERROR)), pe.EventDispatcher.dispatchEvent(m.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (h) => {
        s = !0, f.debug.error("VideoProxy load timeout.", h), this.currentAd.error = w.VAST.TIMEOUT, this.deliverOrHOMAD(pe.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), f.debug.info(tt.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (f.debug.info(tt.NAME + i + "success."), this.adSlotController.dispatchEvent(m.ON_AD_LOADED), this.dispatchEvent(m.ON_AD_STARTED));
      }, (h) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        f.debug.error(tt.NAME + i + "failed", h);
        const E = {
          [w.VAST.GENERAL_ERROR.code]: w.VAST.GENERAL_ERROR,
          [w.VAST.FILE_NOT_FOUND.code]: w.VAST.FILE_NOT_FOUND,
          [w.VAST.UNSUPPORTED_MIMETYPE.code]: w.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = E[h] || w.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(pe.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(Xe.ON_LOADED_DATA, () => {
          this.dispatchEvent(m.ON_AD_STARTED), this.dispatchEvent(m.ON_AD_IMPRESSION), this.dispatchEvent(m.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(Xe.ON_ENDED, () => {
          this.dispatchEvent(m.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(m.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, f.debug.error(s + " timeout.", l), this.currentAd.error = w.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(m.ON_AD_ERROR), this.deliverOrHOMAD(pe.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (f.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (f.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Fr(this, i), [
        m.ON_AD_STARTED,
        m.ON_AD_IMPRESSION,
        m.ON_AD_CREATIVE_VIEW,
        m.ON_AD_NONLINEAR_STOPPED,
        m.ON_AD_STOPPED
      ].map((l) => {
        const h = this.adSlotController.nonLinearView.addEventListener(
          l,
          (E) => {
            this.dispatchEvent(E.type), E.type === m.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(h);
      }), this.addPlayerEventListener(Xe.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(Xe.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && f.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (f.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = w.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(m.ON_AD_ERROR), this.deliverOrHOMAD(pe.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
tt.NAME = "AdSloDel::";
let $r = tt;
class Yr {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, h;
    this.adParameters = ((s = (r = X(i, "AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((h = (l = X(i, e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : h.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [];
    const r = Object.values(Yi).join(", ");
    let s = te(e, r);
    for (let l = 0; l < s.length; l++)
      i.push({
        creativeType: s[l].getAttribute("creativeType"),
        resource: Se(s[l].textContent || ""),
        type: s[l].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    const s = te(i, e + "ClickTracking");
    for (const l of s)
      r.push({
        url: Se(l.textContent),
        id: l.getAttribute("id")
      });
    return r;
  }
}
class ko extends Yr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = Se(((s = X(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || os(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function ye(c, e) {
  const i = (c == null ? void 0 : c.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class Uo extends Yr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = Se(((s = X(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = ye(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = Se(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = Nt(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = ye(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class Fo extends Yr {
  constructor(e, i, r) {
    const s = ye(r, "expandedHeight"), l = ye(r, "expandedWidth"), h = ye(r, "height"), E = r.getAttribute("id"), v = r.getAttribute("maintainAspectRatio") !== "false", I = Nt(
      r.getAttribute("minSuggestedDuration")
    ), M = r.getAttribute("scalable") !== "false", re = ye(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = h, this.id = E, this.maintainAspectRatio = v, this.minSuggestedDuration = I != null ? I : -1, this.scalable = M, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = re;
  }
}
var vi = ((c) => (c.COMPANION = "companion", c[c.LINEAR = ce.LINEAR] = "LINEAR", c[c.NON_LINEAR = ce.NON_LINEAR] = "NON_LINEAR", c))(vi || {});
class $o {
  constructor(e) {
    this.adXML = e, this.VASTVersion = this.adXML.parentElement && typeof this.adXML.parentElement.getAttribute == "function" ? parseInt(this.adXML.parentElement.getAttribute("version"), 10) : null, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, h = e.mediaFiles.vpaid, E = [];
    return E = E.concat(
      ...h,
      ...l,
      ...r,
      ...s,
      ...i
    ), E;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  getLinear() {
    let e = X(this.adXML, "InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = X(e, "MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getBaseForVersion(e, i) {
    if (i === null)
      return e;
    const s = {
      2: 3,
      3: 1,
      4: 0
    }[i];
    let l = e;
    for (let h = 0; h < s && l.parentElement; h++)
      l = l.parentElement;
    return l;
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  extractInteractiveCreativeUrl(e) {
    for (const i of e.childNodes)
      if (i.wholeText)
        return i.wholeText.trim();
    return "";
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = te(e, 'MediaFile[apiFramework="VPAID"]'), s = X(e, "AdParameters");
    for (let h = 0; h < r.length; h++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: ye(r[h], "bitrate"),
        fileURL: Se(r[h].textContent),
        height: ye(r[h], "height"),
        linearity: ce.LINEAR,
        mimeType: r[h].getAttribute("type"),
        width: ye(r[h], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = te(e, 'MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: ye(r[s], "bitrate"),
        fileURL: Se(r[s].textContent),
        height: ye(r[s], "height"),
        linearity: ce.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: ye(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var E;
    const i = [], r = this.getBaseForVersion(e, this.VASTVersion), s = te(r, "InteractiveCreativeFile"), l = X(r, "AdParameters"), h = X(r, "HTMLResource");
    for (let v = 0; v < s.length; v++) {
      let I = "", M = null;
      this.VASTVersion && this.VASTVersion < 4 ? (I = this.extractInteractiveCreativeUrl(s[v]), M = I === "" && h ? h.textContent.trim() : null) : I = s[v].textContent.trim(), i.push({
        adParameters: ((E = l == null ? void 0 : l.textContent) == null ? void 0 : E.trim()) || null,
        apiFramework: s[v].getAttribute("apiFramework"),
        delivery: s[v].getAttribute("delivery"),
        fileURL: I,
        linearity: ce.LINEAR,
        mimeType: s[v].getAttribute("type"),
        resource: M,
        variableDuration: s[v].getAttribute("variableDuration") === "true"
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = X(e, "ClosedCaptionFiles");
    if (r) {
      let s = te(r, "ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: ce.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [], s = te(e, i);
    for (const l of s)
      r.push({
        url: Se(l.textContent) || ""
      });
    return r;
  }
  getIndustryIcons() {
    const e = {};
    let i = te(this.adXML, "Creatives > Creative > Linear", "Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), h = new Uo("Icon", l, i[r]);
      e[s] = h;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  getNonLinear() {
    let e = te(this.adXML, "InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    f.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = te(e, "NonLinear"), r = [{
      type: vi.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new Fo(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = te(this.adXML, "Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: vi.COMPANION,
        variations: []
      };
      const s = te(e[r], "Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const h = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let E = new ko(
            "Companion",
            h,
            s[l]
          );
          i[r].hasCompanionResources = E.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(E);
        }
    }
    return i.reverse();
  }
  getTrackers(e) {
    const i = {}, r = Array.from(te(this.adXML, "ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], h = l.nodeName === l.nodeName.toUpperCase() ? l.nodeName.toLowerCase() : l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), E = l.getAttribute("event") || h, v = l.getAttribute("offset"), I = {
        offset: "",
        url: Se(l.textContent)
      };
      if (E === Kt.ON_AD_PROGRESS && v) {
        const M = Nt(v);
        I.offset = typeof M == "number" ? M.toString() : v;
      }
      i[E] = i[E] || [], i[E].push(I);
    }
    return i;
  }
}
class jo extends f {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    const e = " > Creatives > Creative";
    let i = [];
    const r = te(this.adXML, "Ad > Wrapper");
    let s = [];
    for (const h of r) {
      let E = te(h, "Wrapper" + e);
      if (E.length > 0)
        for (const v of E)
          s.push(v);
      else
        i.push(h);
    }
    if (s.length > 0)
      for (const h of s)
        i.push(h);
    let l = te(this.adXML, "InLine" + e);
    for (const h of l)
      i.push(h);
    return i;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = te(this.adXML, "Creative");
      for (let h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    for (const l of r) {
      const h = l.getAttributeNames().find((E) => E.toLowerCase() === "adid");
      s.push(l.getAttribute(h) || null);
    }
    return s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (At(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = X(this.adXML, "InLine", "Advertiser");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = te(this.adXML, "AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", h = X(s, "JavaScriptResource"), E = this.getNodeContentsAsText(
        X(s, "VerificationParameters") || document.createElement("div")
      ), v = this.getTrackerNodesAsURLArray(
        X(s, "TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && h) {
        const I = {
          javascriptResource: {
            url: Se(this.getNodeContentsAsText(h)),
            apiFramework: h.getAttribute("apiFramework") || "",
            browserOptional: h.getAttribute("browserOptional") === "true" || !1
          },
          tracking: v,
          vendor: l,
          verificationParameters: E
        };
        i.push(I);
      }
    }
    return i.length > 0 ? Io(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = At(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new $o(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = X(this.adXML, "InLine", "Description");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = At(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = At(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    if (this.wrappers.length > 0) {
      let s = te(this.adXML, "Ad > Wrapper");
      for (const l of s) {
        const h = l.parentElement.getAttribute("id");
        e.push(h);
      }
    }
    let i = null, r = At(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = te(this.adXML, "Creative");
      for (const h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    let r = [];
    const s = this.getElementsSortedByDepth(i);
    for (const l of s)
      r.push(l.getAttribute("id") || null);
    return r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = X(this.adXML, "InLine", "AdServingId");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = X(this.adXML, "InLine", "Pricing") || At(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = X(this.adXML, "InLine", "Survey");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = X(this.adXML, "InLine", "AdSystem");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = X(this.adXML, "InLine", "AdTitle");
    return Se((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML.hasAttribute && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(ye(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(ye(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: ye(this.rawXML, "_loadEnd") - ye(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = te(this.adXML, "VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(ye(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(ye(i[r], "_loadEnd")).toISOString(),
        loadTime: ye(i[r], "_loadEnd") - ye(i[r], "_loadStart"),
        url: Se(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = te(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = te(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = te(this.adXML, "Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || Se(e.getAttribute("idValue") || "unknown")
    };
  }
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML);
      for (const r of i) {
        const s = r.nodeName === r.nodeName.toUpperCase() ? r.nodeName.toLowerCase() : r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      }
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} - Tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    if (!e)
      return i;
    for (const r of te(e, "Tracking")) {
      const s = this.getNodeContentsAsText(r);
      if (s.length === 0)
        continue;
      const l = r.getAttribute("event");
      l && (i[l] || (i[l] = []), i[l].push(
        { url: s }
      ));
    }
    return i;
  }
}
class Vt extends jo {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = te(this.adXML, "Creative", "Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      At(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return Ee.SPONSORED;
      default:
        return Ee.COMMERCIAL;
    }
  }
  parseSkipOffsetToNumber() {
    var i;
    const e = Nt(
      ((i = X(this.adXML, "InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  getVariant(e) {
    if (e === null)
      return Ee.COMMERCIAL;
    let i = Ee.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  getDuration() {
    var i, r;
    const e = ((r = (i = At(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || Vt.FALLBACK_LINEAR_DURATION;
    return Nt(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  getError() {
    function e(r) {
      if (r.parentNode)
        return X(r.parentNode, ":scope > parsererror");
    }
    const i = X(this.adXML, "parsererror") || e(this.adXML);
    return i ? {
      code: ye(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  flagCappedAds() {
    return X(this.adXML, "InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: w.WRAPPER.NO_RESPONSE.code,
      message: w.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = At(this.adXML, e);
    return Se((i == null ? void 0 : i.textContent) || "");
  }
}
Vt.FALLBACK_LINEAR_DURATION = "00:00:20";
class Bo {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  handleXMLDoc(e) {
    let i = X(e, "parsererror"), r = te(e, ":root > *"), s;
    if (!(X(e, "html") && i)) {
      if (X(e, "html")) {
        s = document.createElement("VAST");
        const l = new Vt(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new Vt(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const h = new Vt(r[l], e);
        this.adList.push(h);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function Ho(c, e) {
  const i = Object.values(gi);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let h = i;
  return e && e.length > 0 && (r = e, h = e), h.filter((v) => !("canPlayType" in s) || v === "application/javascript" || s.canPlayType(v) !== "" || l.canPlayType(v) !== "" ? r.push(v) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = h), c.filter((v) => r.find((I) => v.mimeType === I));
}
class Gi {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === ce.NON_LINEAR ? Xo.select(r, i) : Wo.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class Wo {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((E) => {
        var v;
        !s.selectedCreativeFile && E.apiFramework && (E.isSIMID = (E.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = E.isSIMID ? E : null), (v = s.selectedCreativeFile) != null && v.isSIMID && (E.isSIMID = !0), E.isVPAID = (E.apiFramework + "").toUpperCase() === "VPAID";
      }), l = Gi.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let h = Ho(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        h,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  static selectMediaFile(e, i, r) {
    let s = e.filter((E) => E.isSIMID), l = e.filter((E) => E.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let h = [];
    for (let E = 0; E < r.length; ) {
      if (E > 0 && h.length > 0) {
        e = h;
        break;
      }
      e.filter((v) => {
        v.mimeType === r[E] && h.push(v);
      }), E++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, h) => h.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class Xo {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((h) => {
        h.selectedResource = null, (h.apiFramework + "").toUpperCase() === "VPAID" && (h.isVPAID = !0, h.resources = h.resources.filter((E) => Gi.isFriendlyVendorHost(
          E.resource,
          i.desiredVPAIDVendors
        )));
      });
      for (const h of l)
        h.resources.length <= 0 ? h.hasCreative = !1 : h.selectedResource = h.resources[0];
      s.variations = l.filter((h) => !!h.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
function jr(c) {
  let e = 0, i = 0, r = 0;
  const s = c.length;
  for (let l = 0; l < c.length; l++) {
    let h = c[l];
    h.variant === Ee.COMMERCIAL ? (h.currentCommercial = i += 1, (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (e += 1), h.currentPodSequencing = i - e) : (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (r += 1), h.variant !== Ee.COMMERCIAL && (h.currentCommercial = -1), h.sequence = l + 1, h.currentClip = l + 1;
  }
  return {
    totalClips: s,
    totalPlayableClips: s - e - r,
    totalCommercials: i,
    totalPlayableCommercials: i - e
  };
}
const ts = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function qo(c, e, i, r) {
  let s = c;
  const l = i, h = r, E = e, v = {
    DIVIDER: Ee.DIVIDER,
    CLOSER: Ee.CLOSER,
    OPENER: Ee.OPENER
  };
  function I(ee) {
    let Te = [], z = {
      adParameters: null,
      creativeTrackers: {},
      duration: Vt.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: ce.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let K in ee)
      if (Object.prototype.hasOwnProperty.call(ee, K) && Object.prototype.hasOwnProperty.call(ts, K.toUpperCase())) {
        let y = ee[K];
        if (typeof y == "string" && y.length > 0) {
          let R = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: y,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: ts[K.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          z.mediaFiles.push(R);
        }
      }
    return z.supportedMediaFiles = z.mediaFiles, Te.push(z), Te;
  }
  function M() {
    Object.keys(v).forEach((ee) => {
      if (l && Object.prototype.hasOwnProperty.call(l, v[ee])) {
        const Te = l[v[ee]];
        if (!E && !Te.forcePlay)
          return;
        let z = {};
        z.adTrackers = [], z.creatives = I(Te), z.extensions = [], z.id = z.adId = v[ee], z.isLinear = !0, z.variant = v[ee], z.properCreative = z.creatives[0], z.properCreative.selectedMediaFile = z.properCreative.supportedMediaFiles[0], z.config = h, z.enrichment = new Rt(), z.adReinsertion = new pe(h.adReinsertion, z.enrichment), z.expectedAdType = l.type, z.isPaused = !0;
        let K = [];
        switch (v[ee]) {
          case v.DIVIDER:
            for (let y = 0; y < s.length; y++)
              y > 0 && s[y].variant !== s[y - 1].variant && K.push({
                offset: y,
                ad: z
              });
            if (l[v[ee]].forcePlay && K.length === 0) {
              s[0].variant === Ee.SPONSORED ? s.unshift(z) : s.push(z);
              break;
            }
            for (let y = 0; y < K.length; y++) {
              const R = K[y].offset + y;
              s.splice(R, 0, K[y].ad);
            }
            break;
          case v.CLOSER:
            s.push(z);
            break;
          case v.OPENER:
            s.unshift(z);
            break;
        }
      }
    });
  }
  M();
  let re = jr(s);
  return { enrichedManifest: s, sequenceData: re };
}
function is(c) {
  let e = c;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    for (let l of s)
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
  }
  return e;
}
class Yo {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), is(this.adSlotModelList), this.adSlotBuffetList = is(this.adSlotBuffetList), f.debug.info(this.NAME + "adPod", this.adSlotModelList), f.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  decorateAdList() {
    for (let e = 0; e < this.adList.length; e++) {
      let i = this.adList[e];
      if (i.adBreakPosition = this.adBreak.adBreakPosition, i.config = this.config, i.enrichment = new Rt(), i.enrichment.setFromObject(i.publisherMacros), i.expectedAdType = this.adBreak.type, i.publisherMacros = this.environmentVars.vastMacros, i.adReinsertion = new pe(i.config.adReinsertion, i.enrichment), i.isPaused = !0, !i.hasError) {
        if (i.creatives.length < 1) {
          i.error = {}, i.error = w.WRAPPER.NO_RESPONSE;
          continue;
        }
        if (i.expectedAdType === ce.LINEAR && i.creativeClass.linearAsArray[0].mediaFiles.length === 0 || i.expectedAdType === ce.NON_LINEAR && i.creativeClass.nonLinear.length === 0) {
          i.error = {}, i.error = w.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          continue;
        }
        i.expectedAdType === ce.LINEAR ? (i.properCreative = Gi.getProperCreative(
          i.creativeClass.linearAsArray,
          this.environmentVars
        ), i.properCreative && (i.closedCaptions = i.properCreative.captions, i.icons = i.properCreative.icons)) : i.properCreative = Gi.getProperCreative(
          i.creativeClass.nonLinear,
          this.environmentVars
        ), i.properCreative || (i.error = {}, i.error = w.VAST.UNSUPPORTED_MIMETYPE);
      }
    }
  }
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.sequenceInfo = jr(this.adSlotModelList), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = [], this.sequenceInfo = jr(this.adSlotModelList));
  }
  extendWithSeparationClips() {
    if (this.adBreak.type !== ce.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = qo(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && X(e.adXML, `ParserError[code="${w.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
var Si = /* @__PURE__ */ ((c) => (c.XHR = "xhr", c.JSONP = "jsonp", c))(Si || {});
const zr = class zr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = te(this.XMLDoc, "VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((h) => {
          e(h);
        });
      }
    }
  }
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, h) => {
      let E = X(r, "VASTAdTagURI");
      if (E.setAttribute("_loadStart", Date.now().toString()), E.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return ze(r, w.WRAPPER.CHAIN_TIMEOUT), h(), e;
      if (i >= this.maxWrapperDepth)
        return ze(
          r,
          w.WRAPPER.LIMIT_REACHED
        ), h(), e;
      if (this.isInsecureURL(e))
        return ze(r, w.SESSION.MIXED_CONTENT), h(), e;
      if (this.hasSessionTimeoutError)
        return h(), e;
      let v, I;
      this.loadURL(e, !0).then((M) => {
        let re = X(M, "VASTAdTagURI");
        v = ((re || {}).textContent || "").trim(), v && (I = re.parentNode), this.addContentToWrapperNode(r, M), E.setAttribute("_loadEnd", Date.now().toString()), l([v, I]);
      });
    }).then((l) => {
      let [h, E] = l;
      return h ? this.walkDownAdWrappers(h, i + 1, E, s) : e;
    });
  }
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, this.urlHandlerOptions.adRequestMethod === Si.JSONP && f.debug.warn(
      `Request method ${Si.JSONP} is deprecated since v7.6.2 and will be removed in v8.`
    ), new Promise((r) => {
      new qr().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let h = l || document.createDocumentFragment(), E = X(h, "Ad") || h.documentElement || h;
          this.hasSessionTimeoutError = !0, ze(E, w.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: pe.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && X(l, "parsererror")) {
          let h = document.createDocumentFragment();
          ze(h, w.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: pe.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const h = X(l, "VAST");
          if (h && te(h, ":scope > *").length === 0) {
            let E = document.createDocumentFragment();
            ze(E, w.WRAPPER.NO_RESPONSE), r(E);
          }
        }
        if (s && !l) {
          let h = document.createDocumentFragment();
          f.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), ze(h, s), r(h);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  isInsecureURL(e) {
    return this.blockInsecureURL && !as(e);
  }
  /* c8 ignore stop */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = X(r, "VAST");
      s && s.setAttribute(e, i);
    }
  }
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
zr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Br = zr;
class Go {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(h, E) {
      const v = e[h];
      return !v || v.length <= 0 ? (f.debug.info(E), []) : v;
    }
    const r = (h, E) => {
      const v = e.creatives;
      if (v && v.length !== 0) {
        const I = v.find(
          (M) => M.type === h
        );
        if (I && I.variations && I.variations.length > 0)
          return I.variations;
      }
      return f.debug.info(E), [];
    };
    function s(h) {
      return h.charAt(0).toUpperCase() + h.slice(1);
    }
    const l = (h) => {
      var v, I;
      if (e.isLinear) {
        const M = e.properCreative && e.properCreative.selectedMediaFile;
        return M ? M[h] : -1;
      }
      const E = (I = (v = e.creativesArray) == null ? void 0 : v.nonLinearCreative[0]) == null ? void 0 : I.variations[0];
      if (E && e.isExpanded) {
        const M = `expanded${s(h)}`;
        return E[M] === -1 ? E[h] : E[M];
      }
      return E ? E[h] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(vi.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function h(v, I) {
          return I === 0 || !v.parentElement ? v : h(v.parentElement, I - 1);
        }
        function E(v) {
          const I = h(v, 3), M = I.getAttributeNames().find((re) => re.toLowerCase() === "adid");
          return {
            adId: I.getAttribute(M) || null,
            id: I.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let v = null;
          if (e.isSIMID ? v = "InteractiveCreativeFile" : e.isVPAID ? v = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (v = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), v) {
            const I = X(e.adXML, v);
            return E(I);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const v = e.properCreative.variations[0].selectedResource.type, I = e.properCreative.variations[0].selectedResource.creativeType, M = v !== Yi.IFRAME ? X(e.adXML, `${v}[creativeType="${I}"]`) : X(e.adXML, v);
          return E(M);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (f.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== Yi.IFRAME;
        } catch (h) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (f.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const h = e.properCreative;
        return h && h.length !== 0 ? h : (f.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(vi.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(h) {
        e.volume = h;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Ko {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class hs {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", f.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, f.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class zo extends hs {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Jo extends hs {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class Qo {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      f.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new Jo(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new zo(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : f.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    f.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Gr(c) {
  if (typeof c != "object" || c === null)
    return c;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(c)) {
    const r = c[i];
    ls(r) || (e[i] = Gr(c[i]));
  }
  return e;
}
function Zo(c) {
  const e = document.implementation.createDocument(null, "VAST", null);
  e.documentElement.setAttribute("version", "3.0");
  for (const i of c) {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }
  return e;
}
function ea(c) {
  let e = c;
  if (e.originConfig = Gr(c), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = Zo(e.urls)), e.requested = !1, e;
}
const rs = "AdBreakValidation";
function ta(c) {
  var s, l;
  if (!c || typeof c != "object" || Array.isArray(c) || Object.keys(c).length === 0)
    return f.debug.warn(rs + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof c.tag == "string" || Array.isArray(c.tag)) && c.tag.length > 0, i = ((l = (s = c.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = c[Ee.CLOSER] || c[Ee.DIVIDER] || c[Ee.OPENER];
  return !e && !i && !r ? (f.debug.warn(rs + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function ia(c, e, i, r, s) {
  var l = l || {};
  (function(h) {
    var E = {
      globalConfig: c,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function v(y) {
        y = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, y, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : Z(global)) == "object" && global];
        for (var R = 0; R < y.length; ++R) {
          var V = y[R];
          if (V && V.Math == Math) return V;
        }
        throw Error("Cannot find global object");
      }
      var I = v(this);
      function M(y) {
        var R = 0;
        return function() {
          return R < y.length ? {
            done: !1,
            value: y[R++]
          } : {
            done: !0
          };
        };
      }
      var re = typeof Object.defineProperties == "function" ? Object.defineProperty : function(y, R, V) {
        return y == Array.prototype || y == Object.prototype || (y[R] = V.value), y;
      };
      function ee(y, R) {
        if (R) e: {
          var V = I;
          y = y.split(".");
          for (var q = 0; q < y.length - 1; q++) {
            var B = y[q];
            if (!(B in V)) break e;
            V = V[B];
          }
          y = y[y.length - 1], q = V[y], R = R(q), R != q && R != null && re(V, y, {
            configurable: !0,
            writable: !0,
            value: R
          });
        }
      }
      ee("Symbol", function(y) {
        function R(B) {
          if (this instanceof R) throw new TypeError("Symbol is not a constructor");
          return new V("jscomp_symbol_" + (B || "") + "_" + q++, B);
        }
        function V(B, J) {
          this.j = B, re(this, "description", {
            configurable: !0,
            writable: !0,
            value: J
          });
        }
        if (y) return y;
        V.prototype.toString = function() {
          return this.j;
        };
        var q = 0;
        return R;
      }), ee("Symbol.iterator", function(y) {
        if (y) return y;
        y = Symbol("Symbol.iterator");
        for (var R = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), V = 0; V < R.length; V++) {
          var q = I[R[V]];
          typeof q == "function" && typeof q.prototype[y] != "function" && re(q.prototype, y, {
            configurable: !0,
            writable: !0,
            value: function() {
              return Te(M(this));
            }
          });
        }
        return y;
      });
      function Te(y) {
        return y = {
          next: y
        }, y[Symbol.iterator] = function() {
          return this;
        }, y;
      }
      function z(y) {
        var R = typeof Symbol != "undefined" && Symbol.iterator && y[Symbol.iterator];
        return R ? R.call(y) : {
          next: M(y)
        };
      }
      function K(y, R) {
        return Object.prototype.hasOwnProperty.call(y, R);
      }
      ee("WeakMap", function(y) {
        function R(L) {
          if (this.h = (D += Math.random() + 1).toString(), L) {
            L = z(L);
            for (var _; !(_ = L.next()).done; ) _ = _.value, this.set(_[0], _[1]);
          }
        }
        function V() {
        }
        function q(L) {
          var _ = Z(L);
          return _ === "object" && L !== null || _ === "function";
        }
        function B(L) {
          if (!K(L, U)) {
            var _ = new V();
            re(L, U, {
              value: _
            });
          }
        }
        function J(L) {
          var _ = Object[L];
          _ && (Object[L] = function(H) {
            return H instanceof V ? H : (Object.isExtensible(H) && B(H), _(H));
          });
        }
        if (function() {
          if (!y || !Object.seal) return !1;
          try {
            var L = Object.seal({}), _ = Object.seal({}), H = new y([[L, 2], [_, 3]]);
            return H.get(L) != 2 || H.get(_) != 3 ? !1 : (H.delete(L), H.set(_, 4), !H.has(L) && H.get(_) == 4);
          } catch (Q) {
            return !1;
          }
        }()) return y;
        var U = "$jscomp_hidden_" + Math.random();
        J("freeze"), J("preventExtensions"), J("seal");
        var D = 0;
        return R.prototype.set = function(L, _) {
          if (!q(L)) throw Error("Invalid WeakMap key");
          if (B(L), !K(L, U)) throw Error("WeakMap key fail: " + L);
          return L[U][this.h] = _, this;
        }, R.prototype.get = function(L) {
          return q(L) && K(L, U) ? L[U][this.h] : void 0;
        }, R.prototype.has = function(L) {
          return q(L) && K(L, U) && K(L[U], this.h);
        }, R.prototype.delete = function(L) {
          return q(L) && K(L, U) && K(L[U], this.h) ? delete L[U][this.h] : !1;
        }, R;
      }), ee("Map", function(y) {
        function R() {
          var D = {};
          return D.c = D.next = D.head = D;
        }
        function V(D, L) {
          var _ = D.b;
          return Te(function() {
            if (_) {
              for (; _.head != D.b; ) _ = _.c;
              for (; _.next != _.head; ) return _ = _.next, {
                done: !1,
                value: L(_)
              };
              _ = null;
            }
            return {
              done: !0,
              value: void 0
            };
          });
        }
        function q(D, L) {
          var _ = L && Z(L);
          _ == "object" || _ == "function" ? J.has(L) ? _ = J.get(L) : (_ = "" + ++U, J.set(L, _)) : _ = "p_" + L;
          var H = D.g[_];
          if (H && K(D.g, _)) for (D = 0; D < H.length; D++) {
            var Q = H[D];
            if (L !== L && Q.key !== Q.key || L === Q.key) return {
              id: _,
              list: H,
              index: D,
              a: Q
            };
          }
          return {
            id: _,
            list: H,
            index: -1,
            a: void 0
          };
        }
        function B(D) {
          if (this.g = {}, this.b = R(), this.size = 0, D) {
            D = z(D);
            for (var L; !(L = D.next()).done; ) L = L.value, this.set(L[0], L[1]);
          }
        }
        if (function() {
          if (!y || typeof y != "function" || !y.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var D = Object.seal({
              x: 4
            }), L = new y(z([[D, "s"]]));
            if (L.get(D) != "s" || L.size != 1 || L.get({
              x: 4
            }) || L.set({
              x: 4
            }, "t") != L || L.size != 2) return !1;
            var _ = L.entries(), H = _.next();
            return H.done || H.value[0] != D || H.value[1] != "s" ? !1 : (H = _.next(), !(H.done || H.value[0].x != 4 || H.value[1] != "t" || !_.next().done));
          } catch (Q) {
            return !1;
          }
        }()) return y;
        var J = /* @__PURE__ */ new WeakMap();
        B.prototype.set = function(D, L) {
          D = D === 0 ? 0 : D;
          var _ = q(this, D);
          return _.list || (_.list = this.g[_.id] = []), _.a ? _.a.value = L : (_.a = {
            next: this.b,
            c: this.b.c,
            head: this.b,
            key: D,
            value: L
          }, _.list.push(_.a), this.b.c.next = _.a, this.b.c = _.a, this.size++), this;
        }, B.prototype.delete = function(D) {
          return D = q(this, D), D.a && D.list ? (D.list.splice(D.index, 1), D.list.length || delete this.g[D.id], D.a.c.next = D.a.next, D.a.next.c = D.a.c, D.a.head = null, this.size--, !0) : !1;
        }, B.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = R(), this.size = 0;
        }, B.prototype.has = function(D) {
          return !!q(this, D).a;
        }, B.prototype.get = function(D) {
          return (D = q(this, D).a) && D.value;
        }, B.prototype.entries = function() {
          return V(this, function(D) {
            return [D.key, D.value];
          });
        }, B.prototype.keys = function() {
          return V(this, function(D) {
            return D.key;
          });
        }, B.prototype.values = function() {
          return V(this, function(D) {
            return D.value;
          });
        }, B.prototype.forEach = function(D, L) {
          for (var _ = this.entries(), H; !(H = _.next()).done; ) H = H.value, D.call(L, H[1], H[0], this);
        }, B.prototype[Symbol.iterator] = B.prototype.entries;
        var U = 0;
        return B;
      }), ee("Object.is", function(y) {
        return y || function(R, V) {
          return R === V ? R !== 0 || 1 / R === 1 / V : R !== R && V !== V;
        };
      }), ee("Array.prototype.includes", function(y) {
        return y || function(R, V) {
          var q = this;
          q instanceof String && (q = String(q));
          var B = q.length;
          for (V = V || 0, 0 > V && (V = Math.max(V + B, 0)); V < B; V++) {
            var J = q[V];
            if (J === R || Object.is(J, R)) return !0;
          }
          return !1;
        };
      }), ee("String.prototype.includes", function(y) {
        return y || function(R, V) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (R instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(R, V || 0) !== -1;
        };
      }), ee("Array.from", function(y) {
        return y || function(R, V, q) {
          V = V != null ? V : function(D) {
            return D;
          };
          var B = [], J = typeof Symbol != "undefined" && Symbol.iterator && R[Symbol.iterator];
          if (typeof J == "function") {
            R = J.call(R);
            for (var U = 0; !(J = R.next()).done; ) B.push(V.call(q, J.value, U++));
          } else for (J = R.length, U = 0; U < J; U++) B.push(V.call(q, R[U], U));
          return B;
        };
      }), function() {
        function y() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function R() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function V(U) {
          return U == "True" || U == "true" || U == 1 || U == "1" || U == 1;
        }
        function q() {
          var U = function() {
            var H = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), Q = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Ce = H.slice(0, H.length / 2).split("").reverse().join("");
            return H = H.slice(H.length / 2).split("").reverse().join(""), Q + Ce + Q + H + Q;
          }(), D = function(H) {
            var Q = 0, Ce;
            if (H.length == 0) return Q;
            var je = 0;
            for (Ce = H.length; je < Ce; je++) Q = (Q << 5) - Q + H.charCodeAt(je), Q |= 0;
            return Math.abs(Q);
          }(U).toString();
          D = (D + D.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), U = btoa(U).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var L = "", _ = 0; _ < D.length; _++) L += U.charAt(D[_]);
          return L || "zork";
        }
        function B(U, D) {
          return U = Math.round(Math.abs(U)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, U);
        }
        y.prototype.getItem = function(U) {
          return this.i[U] || this.client[U] || this.f[U];
        }, y.prototype.l = function(U) {
          this.f = U.embed, this.global = U.global, this.client = U.client, this.i = U.customer;
        };
        var J = null;
        J = new y(), function(U) {
          function D(P, Y, Ie) {
            var ae = {
              homad_url_prefix_alias: "",
              homad_track_key: "*" + encodeURIComponent(P) + "*",
              homad_track_value: "*" + encodeURIComponent(Y.toString()) + "*"
            }, le = Ie ? null : function() {
              D(P, Y, !0);
            };
            Ie = Ie ? L(!0) : _(), rt(Ie, null, le, ae);
          }
          function L(P) {
            return P = P ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + P.slice(P.length - 2).join(".") + "/[hash]/").replace("[hash]", R(B()));
          }
          function _() {
            if (_e && _e.server) {
              var P = _e.server[Math.floor(Math.random() * _e.server.length)] + "";
              return P.replace("[hash]", R(B()));
            }
            return L(!1);
          }
          function H() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(Y) {
              try {
                Y.pause();
              } catch (Ie) {
              }
              Y.parentNode.removeChild(Y);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(Y) {
              Y.parentNode.removeChild(Y);
            }), window.self != window.top) for (var P = window.document; P.hasChildNodes(); ) P.removeChild(P.lastChild);
            we.get("setTimeout")(H, Math.round(1e3 + 100 * Math.random()));
          }
          function Q(P) {
            return Be && clearTimeout(Be), D("stats_embed_penalty", P), H(), !1;
          }
          function Ce() {
            He && He.enabled === !1 || _e && _e.enabled === !1 || Pe && Pe.enabled === !1 ? clearTimeout(Be) : Q("load_main");
          }
          function je() {
            rt(Pe.src.toString(), function(P) {
              Pe.src.toString() === P.responseURL ? (P = gt(P.responseText), Pe.data = P, Pe.enabled = V(P.enabled), Ce()) : Q("redirect_customer");
            }, function() {
              Pe.data = {}, Pe.enabled = void 0, Ce();
            });
          }
          function it() {
            var P = _e.src;
            typeof P == "string" ? rt(P.toString(), function(Y) {
              P.toString() === Y.responseURL ? (Y = gt(Y.responseText), _e.data = Y, _e.enabled = V(Y.enabled), Pe.src = Y.config, je()) : Q("redirect_client");
            }, function() {
              _e.data = {}, _e.enabled = void 0, je();
            }) : (_e.data = typeof P == "function" ? P() : P, je());
          }
          function ei() {
            rt(He.src.toString(), function(P) {
              He.src.toString() === P.responseURL ? (P = gt(P.responseText), He.data = P, He.enabled = V(P.enabled), it()) : Q("redirect_global");
            }, function() {
              He.data = {}, He.enabled = void 0, it();
            });
          }
          function kt(P) {
            clearTimeout(Be);
            var Y = new P();
            Y.init(J.f.globalConfig, J.f.clientConfig, !0, function() {
              J.f.utilsReady(Y);
            }, function() {
              Q("utils_init");
            }, J.f);
          }
          function qe(P) {
            var Y = ge.shift();
            Y ? !window[q()] || P ? Je(Y) : P || clearTimeout(Be) : ei();
          }
          function rt(P, Y, Ie, ae) {
            ae = ae === void 0 ? null : ae;
            var le = new XMLHttpRequest();
            if (le.onreadystatechange = function() {
              Y && le.readyState == 4 && le.status == 200 && Y(le), Ie && le.readyState == 4 && le.status != 200 && Ie(le);
            }, ae) {
              var ie = "", vt;
              for (vt in ae) ie += "&" + vt + "=" + encodeURIComponent(ae[vt]);
              ie = ie.substr(1), le.open("POST", P, !0), le.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), le.send(ie);
            } else le.open("GET", P, !0), le.send();
          }
          function Je(P) {
            var Y = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("script") : we.get("createElement")("script"), Ie;
            if (Y.setAttribute("data-info", st), Y.src = P, Y.onload = function(le) {
              le.currentTarget.getAttribute("id") === q() ? nt() ? (le = Ie[st.split("").reverse().join("")], kt(le)) : clearTimeout(Be) : ge.length ? qe(!0) : Q("main_redirect");
            }, Y.onerror = function() {
              qe(!0);
            }, window[q()] || (window[q()] = B(5 + Math.round(5 * Math.random()))), nt()) {
              var ae = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("iframe") : we.get("createElement")("iframe");
              if (!ae || ae.nodeName.toLowerCase() !== "iframe" || !ae.nodeType) return Q("utils_iframe");
              ae.style.display = "none", ae.onload = function() {
                if (Ie = ae.contentWindow, Ie[st] = U, ae.contentWindow.document.body.appendChild(Y) !== Y) return Q("utils_script");
              }, document.body.appendChild(ae);
            } else document.head.appendChild(Y);
          }
          function gt(P) {
            var Y = we.get("JSON");
            try {
              var Ie = Y.parse(P);
            } catch (ae) {
              Ie = {};
            }
            return Ie;
          }
          function nt() {
            return J.f.utilsReady != null;
          }
          var st = B(10 + Math.round(10 * Math.random()));
          window[st] = U, J = new y(), J.l({
            embed: U
          }), J.f.version = "20230601_1407";
          var Be = 0, Ut = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], Ft = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], ge = nt() ? Ft : Ut, He = {
            src: U.globalConfig,
            enabled: void 0,
            data: null
          }, _e = {
            src: U.clientConfig,
            enabled: void 0,
            data: null
          }, Pe = {
            src: null,
            enabled: void 0,
            data: null
          }, we = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var P = document.createElement("iframe");
              P.style.display = "none", document.body.appendChild(P);
              var Y = P.contentWindow;
            } else document.head ? (P = document.createElement("iframe"), P.style.display = "none", document.head.appendChild(P), Y = P.contentWindow) : Y = window;
            we.set("JSON", Y.JSON), we.set("createElement", Y.document.createElement.bind(document)), we.set("setTimeout", Y.setTimeout.bind(window)), P && P.parentNode && P.parentNode.removeChild(P);
          })(), function() {
            Be = we.get("setTimeout")(function() {
              Q("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), qe();
        }(E);
      }();
    })();
  }).bind(l)(l);
}
let be = null, Ue = null;
const he = class he extends Ct {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: ce.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = be = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : Et, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(m.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = pe.EventDispatcher.addEventListener(
      m.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = be.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  initializeHOMAD(e) {
    const i = new Rt();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(gi)), Ue = new pe(this.config.adReinsertion, i);
    let r = (l) => {
      f.debug.info(he.NAME + "initializeHOMAD - Utils ready.", l), f.debug.info(he.NAME + "initializeHOMAD - Set vendor API.", l), Ue.setVendorAPI(l), Ue.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), Ue.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      f.debug.warn(he.NAME + "initializeHOMAD Penalty"), r = () => {
      }, Ue.vendorAPI ? (f.debug.warn("initializeHOMAD - Penalty during ad playback."), ht.call(this, w.SESSION.AD_REINSERTION_PENALTY)) : (f.debug.warn("initializeHOMAD - Error.", l), ht.call(this, w.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(m.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      ia(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (h) => {
          r(h);
        },
        (h) => {
          s(h);
        }
      );
    }
  }
  forceHOMADActivation() {
    this.error && this.error.code === w.SETUP.AD_REINSERTION_PENALTY.code || (Ue.setReinsertionReason({
      reason: pe.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), Ue.enable(
      () => {
        f.debug.info(
          he.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(m.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        f.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (ht.call(this, w.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : ta(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = Qt(be.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, f.debug.info(he.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = ce.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === ce.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === ce.NON_LINEAR && !this.environmentVars.adContainer && f.debug.warn(he.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(m.ON_AD_MANIFEST_LOAD_ERROR, () => (f.debug.info(he.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(m.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const h = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        f.debug.info(
          he.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), ht.call(this, w.SESSION.TIMEOUT), this.dispatchEvent(m.ON_AD_MANIFEST_LOAD_ERROR);
      }, h * 1e3), this.parse(this.adBreak);
    })) : (ht.call(this, w.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, h) => {
      if (!be.adReinsertion.homad.utils)
        throw f.debug.info(r + s), new Error(r + s);
      be.adReinsertion.homad.utils.corroborate(i).then(() => {
        f.debug.info(r + "resolved."), l();
      }).catch((E) => {
        f.debug.info(r + "rejected.", E), h(E);
      });
    });
  }
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!be.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = be.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, h = setTimeout(() => (l = !0, i()), pe.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), E = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(h), f.debug.info(E + "approved."), !l)
            return i();
        }, (v) => {
          if (clearTimeout(h), f.debug.warn(E + "declined.", typeof v), v && v.stack && v.message)
            return Ue.disable(), i();
          if (!l)
            return Ue.disable(), r();
        });
      } catch (v) {
        return clearTimeout(h), f.debug.warn(E + "failed. Error in activationCallback:", v), l = !0, Ue.disable(), i();
      }
    });
  }
  setupEnrichmentAndTCF() {
    const e = new Rt();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(gi)), this.environmentVars.vastMacros.GDPRCONSENT || new Qo(e), e;
  }
  restartAdSlot() {
    f.debug.info(he.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), be.urlhandler = qi, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : f.debug.warn(he.NAME + "What to do next?");
    }).catch((e) => {
      f.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  parse(e) {
    const i = ea(e);
    f.debug.info(he.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    Ue = new pe(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(be.timeouts));
    const l = {
      adReinsertion: Ue,
      blockInsecureURL: be.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: be.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: be.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: Qt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let h = null, E = this.adBreak;
    if (typeof i == "object" && (E = i), E.urls.length === 1 && (h = E.urls[0], l.response = null), h || l.response) {
      let v = new Br(l);
      h ? v.requestURL(E.urls[0], this.onXMLLoadDone.bind(this, l)) : v.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      f.debug.warn(
        he.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new Bo(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let E = Ei;
      r.adReinsertion = new pe(E.adReinsertion, new Rt()), r.timeouts = E.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new Yo(
      e,
      be,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, h = () => {
      if (!s.hasValidAds || l) {
        ht.call(this, l ? w.SESSION.TIMEOUT : w.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(m.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new kr(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(m.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      f.debug.info(
        he.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (E) => {
          f.debug.info(
            he.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            E
          ), h();
        }
      );
      return;
    }
    h();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      f.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      f.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      f.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === ce.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(m.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(m.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = $r;
      this.slot = new i(this.currentAd, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(m.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      for (const s of Object.values(m))
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      this.slot.deliverNextAd();
    };
    this.adBreak.type === ce.LINEAR ? (f.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      f.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      f.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  resetErrorWarning() {
    const e = [
      w.WARNING.TRACKER_LOAD_FAILED.code,
      w.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === ce.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(he.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(m.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        f.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  resetContent() {
    f.debug.info(he.NAME + "Reset content.");
    let e = {
      code: w.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, f.debug.error(he.NAME + "resetContent - timeout"), ht.call(this, e), this.dispatchEvent(m.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), f.debug.info(he.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (h) => {
      i || (clearTimeout(l), f.debug.error(
        he.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        h
      ), e.message = "SessionError: Reset content failed.", ht.call(this, e), this.dispatchEvent(m.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  closeAdSlot() {
    Ue && be.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (Ue.disable(), be.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(he.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string|void} The landing page URL.
   */
  clickThrough(e = !1) {
    if (!this.slot)
      return;
    if (this.ad.hasClickThrough)
      return this.slot.adSlotController.onClickThrough(e);
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(m.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {string} reason The reason code corresponding to the cause of the failure.
   */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(m.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (f.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(m.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (f.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const h = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, h);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot && this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot && this.slot.play();
  }
  dispatchEvent(e) {
    return f.debug.info(he.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI|null} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Go(this.adSlotController.currentAd) : (f.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot|null} Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Ko(this.adSlotController, this.sequenceData) : (f.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return ds.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
he.NAME = "AdSAPI::", he.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Hr = he;
const Jt = class Jt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (f.debug.info(Jt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Hr(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (f.debug.info(Jt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (f.debug.info(Jt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new Pr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Jt.NAME = "MainCtlr::";
let Wr = Jt;
function ra() {
  var c = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? {
          done: !1,
          value: t[n++]
        } : {
          done: !0
        };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return {
        next: r(t)
      };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var h = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, E = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function v(t) {
      t = [(typeof globalThis == "undefined" ? "undefined" : Z(globalThis)) == "object" && globalThis, t, (typeof window == "undefined" ? "undefined" : Z(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : Z(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : Z(global)) == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var I = v(this);
    function M(t, n) {
      if (n) e: {
        var o = I;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var p = t[d];
          if (!(p in o)) break e;
          o = o[p];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && E(o, t, {
          configurable: !0,
          writable: !0,
          value: n
        });
      }
    }
    var re;
    if (typeof Object.setPrototypeOf == "function") re = Object.setPrototypeOf;
    else {
      var ee;
      e: {
        var Te = {
          a: !0
        }, z = {};
        try {
          z.__proto__ = Te, ee = z.a;
          break e;
        } catch (t) {
        }
        ee = !1;
      }
      re = ee ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var K = re;
    function y(t, n) {
      if (t.prototype = h(n.prototype), t.prototype.constructor = t, K) K(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.xa = n.prototype;
    }
    function R() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function V(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var q = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var p in d) V(d, p) && (t[p] = d[p]);
      }
      return t;
    };
    M("Object.assign", function(t) {
      return t || q;
    }), M("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), M("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var p = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + p, 0)); o < p; o++) {
          var g = d[o];
          if (g === n || Object.is(g, n)) return !0;
        }
        return !1;
      };
    });
    function B(t, n, o) {
      if (t == null) throw new TypeError("The 'this' value for String.prototype." + o + " must not be null or undefined");
      if (n instanceof RegExp) throw new TypeError("First argument to String.prototype." + o + " must not be a regular expression");
      return t + "";
    }
    M("String.prototype.includes", function(t) {
      return t || function(n, o) {
        return B(this, n, "includes").indexOf(n, o || 0) !== -1;
      };
    }), M("Symbol", function(t) {
      function n(g) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (g || "") + "_" + p++, g);
      }
      function o(g, T) {
        this.g = g, E(this, "description", {
          configurable: !0,
          writable: !0,
          value: T
        });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", p = 0;
      return n;
    }), M("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = I[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && E(d.prototype, t, {
          configurable: !0,
          writable: !0,
          value: function() {
            return J(r(this));
          }
        });
      }
      return t;
    });
    function J(t) {
      return t = {
        next: t
      }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    M("WeakMap", function(t) {
      function n(N) {
        if (this.g = (O += Math.random() + 1).toString(), N) {
          N = s(N);
          for (var b; !(b = N.next()).done; ) b = b.value, this.set(b[0], b[1]);
        }
      }
      function o() {
      }
      function d(N) {
        var b = Z(N);
        return b === "object" && N !== null || b === "function";
      }
      function p(N) {
        if (!V(N, T)) {
          var b = new o();
          E(N, T, {
            value: b
          });
        }
      }
      function g(N) {
        var b = Object[N];
        b && (Object[N] = function(j) {
          return j instanceof o ? j : (Object.isExtensible(j) && p(j), b(j));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var N = Object.seal({}), b = Object.seal({}), j = new t([[N, 2], [b, 3]]);
          return j.get(N) != 2 || j.get(b) != 3 ? !1 : (j.delete(N), j.set(b, 4), !j.has(N) && j.get(b) == 4);
        } catch (fe) {
          return !1;
        }
      }()) return t;
      var T = "$jscomp_hidden_" + Math.random();
      g("freeze"), g("preventExtensions"), g("seal");
      var O = 0;
      return n.prototype.set = function(N, b) {
        if (!d(N)) throw Error("Invalid WeakMap key");
        if (p(N), !V(N, T)) throw Error("WeakMap key fail: " + N);
        return N[T][this.g] = b, this;
      }, n.prototype.get = function(N) {
        return d(N) && V(N, T) ? N[T][this.g] : void 0;
      }, n.prototype.has = function(N) {
        return d(N) && V(N, T) && V(N[T], this.g);
      }, n.prototype.delete = function(N) {
        return d(N) && V(N, T) && V(N[T], this.g) ? delete N[T][this.g] : !1;
      }, n;
    }), M("Map", function(t) {
      function n() {
        var O = {};
        return O.L = O.next = O.head = O;
      }
      function o(O, N) {
        var b = O.g;
        return J(function() {
          if (b) {
            for (; b.head != O.g; ) b = b.L;
            for (; b.next != b.head; ) return b = b.next, {
              done: !1,
              value: N(b)
            };
            b = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }
      function d(O, N) {
        var b = N && Z(N);
        b == "object" || b == "function" ? g.has(N) ? b = g.get(N) : (b = "" + ++T, g.set(N, b)) : b = "p_" + N;
        var j = O.h[b];
        if (j && V(O.h, b)) for (O = 0; O < j.length; O++) {
          var fe = j[O];
          if (N !== N && fe.key !== fe.key || N === fe.key) return {
            id: b,
            list: j,
            index: O,
            A: fe
          };
        }
        return {
          id: b,
          list: j,
          index: -1,
          A: void 0
        };
      }
      function p(O) {
        if (this.h = {}, this.g = n(), this.size = 0, O) {
          O = s(O);
          for (var N; !(N = O.next()).done; ) N = N.value, this.set(N[0], N[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var O = Object.seal({
            x: 4
          }), N = new t(s([[O, "s"]]));
          if (N.get(O) != "s" || N.size != 1 || N.get({
            x: 4
          }) || N.set({
            x: 4
          }, "t") != N || N.size != 2) return !1;
          var b = N.entries(), j = b.next();
          return j.done || j.value[0] != O || j.value[1] != "s" ? !1 : (j = b.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !b.next().done));
        } catch (fe) {
          return !1;
        }
      }()) return t;
      var g = /* @__PURE__ */ new WeakMap();
      p.prototype.set = function(O, N) {
        O = O === 0 ? 0 : O;
        var b = d(this, O);
        return b.list || (b.list = this.h[b.id] = []), b.A ? b.A.value = N : (b.A = {
          next: this.g,
          L: this.g.L,
          head: this.g,
          key: O,
          value: N
        }, b.list.push(b.A), this.g.L.next = b.A, this.g.L = b.A, this.size++), this;
      }, p.prototype.delete = function(O) {
        return O = d(this, O), O.A && O.list ? (O.list.splice(O.index, 1), O.list.length || delete this.h[O.id], O.A.L.next = O.A.next, O.A.next.L = O.A.L, O.A.head = null, this.size--, !0) : !1;
      }, p.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, p.prototype.has = function(O) {
        return !!d(this, O).A;
      }, p.prototype.get = function(O) {
        return (O = d(this, O).A) && O.value;
      }, p.prototype.entries = function() {
        return o(this, function(O) {
          return [O.key, O.value];
        });
      }, p.prototype.keys = function() {
        return o(this, function(O) {
          return O.key;
        });
      }, p.prototype.values = function() {
        return o(this, function(O) {
          return O.value;
        });
      }, p.prototype.forEach = function(O, N) {
        for (var b = this.entries(), j; !(j = b.next()).done; ) j = j.value, O.call(N, j[1], j[0], this);
      }, p.prototype[Symbol.iterator] = p.prototype.entries;
      var T = 0;
      return p;
    }), M("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({
            x: 4
          }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({
            x: 4
          }) != d || d.size != 2) return !1;
          var p = d.entries(), g = p.next();
          return g.done || g.value[0] != o || g.value[1] != o ? !1 : (g = p.next(), g.done || g.value[0] == o || g.value[0].x != 4 || g.value[1] != g.value[0] ? !1 : p.next().done);
        } catch (T) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var p = this;
        this.g.forEach(function(g) {
          return o.call(d, g, g, p);
        });
      }, n);
    }), M("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) V(n, d) && o.push(n[d]);
        return o;
      };
    });
    function U(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, p = {
        next: function() {
          if (!d && o < t.length) {
            var T = o++;
            return {
              value: n(T, t[T]),
              done: !1
            };
          }
          return d = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return p[Symbol.iterator] = function() {
        return p;
      }, p;
    }
    M("Array.prototype.keys", function(t) {
      return t || function() {
        return U(this, function(n) {
          return n;
        });
      };
    }), M("String.prototype.repeat", function(t) {
      return t || function(n) {
        var o = B(this, null, "repeat");
        if (0 > n || 1342177279 < n) throw new RangeError("Invalid count value");
        n |= 0;
        for (var d = ""; n; ) n & 1 && (d += o), (n >>>= 1) && (o += o);
        return d;
      };
    }), M("String.prototype.padStart", function(t) {
      return t || function(n, o) {
        var d = B(this, null, "padStart");
        return n -= d.length, o = o !== void 0 ? String(o) : " ", (0 < n && o ? o.repeat(Math.ceil(n / o.length)).substring(0, n) : "") + d;
      };
    }), M("Array.prototype.values", function(t) {
      return t || function() {
        return U(this, function(n, o) {
          return o;
        });
      };
    });
    var D = {
      oa: "loaded",
      ua: "start",
      la: "firstQuartile",
      pa: "midpoint",
      va: "thirdQuartile",
      ja: "complete",
      qa: "pause",
      sa: "resume",
      ia: "bufferStart",
      ha: "bufferFinish",
      ta: "skipped",
      wa: "volumeChange",
      ra: "playerStateChange",
      ga: "adUserInteraction"
    }, L = {
      ma: "full",
      ka: "domain",
      na: "limited"
    };
    function _(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.D = t.D || void 0, this.X = t.X || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.R = t.R !== void 0 ? t.R === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.F = t.F || void 0, this.ba = t.ba || void 0, this.Y = t.Y === "true" || t.Y === !0 || !1, this.O = t.O || [], this.S = t.S || !1, this.g = n;
    }
    function H(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function Q(t) {
      var n = {};
      return ve({}, H(t), (n.x = t.x, n.y = t.y, n));
    }
    function Ce(t) {
      var n = Q(t), o = {};
      return ve({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    _.prototype.T = function(t) {
      if (t == null) return !1;
      t = Q(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function je(t) {
      return t.width * t.height;
    }
    function it(t) {
      return t.width === 0 || t.height === 0;
    }
    function ei(t, n) {
      t = Q(t);
      for (var o = [], d = [], p = 0; p < n.length; p++) {
        var g = Q(n[p]);
        g = kt(t, g), qe(o, g.x), qe(o, g.J), qe(d, g.y), qe(d, g.K);
      }
      return o = o.sort(function(T, O) {
        return T - O;
      }), d = d.sort(function(T, O) {
        return T - O;
      }), {
        ea: o,
        fa: d
      };
    }
    function kt(t, n) {
      return {
        x: Math.max(t.x, n.x),
        y: Math.max(t.y, n.y),
        J: Math.min(t.x + t.width, n.x + n.width),
        K: Math.min(t.y + t.height, n.y + n.height)
      };
    }
    function qe(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function rt() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    rt.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(Je(this)) === JSON.stringify(Je(t));
    };
    function Je(t) {
      var n = [], o = [], d = {
        viewport: t.l,
        adView: {
          percentageInView: t.u,
          pixelsInView: t.B,
          reasons: t.m
        },
        declaredFriendlyObstructions: t.o.length
      };
      if (t.g !== void 0) {
        d.adView.geometry = Q(t.g), d.adView.geometry.pixels = je(t.g), d.adView.onScreenGeometry = Q(t.h), d.adView.onScreenGeometry.pixels = He(t);
        for (var p = 0; p < t.j.length; p++) n.push(Q(t.j[p]));
        for (p = 0; p < t.v.length; p++) {
          var g = t.v[p], T = g, O = {};
          T.h && (O.obstructionClass = T.h), T.i && (O.obstructionPurpose = T.i), T.j && (O.obstructionReason = T.j), g = kt(t.g, g), o.push(ve({}, {
            x: g.x,
            y: g.y,
            width: g.J - g.x,
            height: g.K - g.y
          }, O));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function gt(t, n) {
      n = H(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function nt() {
      return {
        x: 0,
        y: 0,
        endX: 0,
        endY: 0,
        width: 0,
        height: 0
      };
    }
    function st(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function Be(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function Ut(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = je(t.g);
        if (n !== 0) {
          var o = He(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function Ft(t, n) {
      if (it(n) || !t.h) n = !1;
      else {
        var o = Ce(t.h), d = o.y, p = o.endX;
        t = o.endY;
        var g = n.J;
        o = o.x, (g = g < o || 0.01 > Math.abs(g - o)) || (g = n.x, g = g > p || 0.01 > Math.abs(g - p)), (p = g) || (p = n.K, p = p < d || 0.01 > Math.abs(p - d)), (d = p) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function ge(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function He(t) {
      var n = Math, o = n.max, d = je(t.h), p = t.j, g = 0;
      if (0 < p.length) {
        var T = ei(t.h, p);
        t = T.ea, T = T.fa;
        for (var O = 0; O < t.length - 1; O++) for (var N = (t[O] + (t[O] + 1)) / 2, b = t[O + 1] - t[O], j = 0; j < T.length - 1; j++) {
          for (var fe = (T[j] + (T[j] + 1)) / 2, lt = T[j + 1] - T[j], mt = !1, Qe = 0; Qe < p.length; Qe++) {
            var Ye = Q(p[Qe]);
            if (Ye.x < N && Ye.x + Ye.width > N && Ye.y < fe && Ye.y + Ye.height > fe) {
              mt = !0;
              break;
            }
          }
          mt && (g += Math.round(b) * Math.round(lt));
        }
      }
      return o.call(n, 0, d - g);
    }
    function _e() {
    }
    function Pe() {
    }
    function we(t, n, o, d) {
      var p = n.S ? !0 : n.D === d;
      if (p) {
        o.g = n;
        var g = Ce(o.g);
        t = st(o.i, g);
        var T = o.g;
        T.F === "notAttached" || T.F === "noWindowFocus" || T.F === "noAdView" ? (ge(o, "notFound"), o.h = new _(nt(), !1)) : (T = o.g, T.F === "viewInvisible" || T.F === "viewGone" || T.F === "viewNotVisible" || T.F === "viewAlphaZero" || T.F === "viewHidden" || o.g.F !== void 0 || it(o.g) ? (ge(o, "hidden"), o.h = new _(nt(), !1)) : (o.g.Y && ge(o, "pictureInPicture"), o.g.m || (ge(o, "backgrounded"), ge(o, "noWindowFocus")), Be(t, g) && ge(o, "clipped"), o.h = new _(t, !1)));
      } else if (g = !0, n.g && (g = n.X.indexOf(d) !== -1 ? !1 : n.R === !1), g) {
        T = n.O;
        for (var O = 0; O < T.length; O++) g = o.g !== void 0, we(t, new _(T[O], g), o, d);
      }
      p || o.g === void 0 || (n.g ? n.X.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (p = Ce(n), d = Ce(o.h), Q(o.h), !it(o.h) && n.R && (n = st(d, p), Be(n, d) && (ge(o, "clipped"), o.h = new _(n, !1)))));
    }
    function P() {
      var t = R.apply(0, arguments);
      Ie(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function Y() {
      var t = R.apply(0, arguments);
      Ie(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function Ie(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function ae(t) {
      return t && t.omidNative && typeof t.omidNative.attest == "function";
    }
    function le() {
      var t = Oe;
      if (!t || !t.navigator) return !1;
      t = t.navigator.userAgent;
      var n = /Safari\/[\d.]*$/.test(t) && !/Chrome|Firefox|Edg|OPR/.test(t), o = /(iPhone|iPad|iPod)/.test(t), d = /(Macintosh)/.test(t);
      try {
        if (o) {
          var p = /(iPhone OS|iPad OS|CPU OS) (\d+[_.]\d+)/.exec(t);
          return p ? 16 <= parseInt(p[2], 10) : !1;
        }
        if (n && d) {
          var g = /OS X (\d+(?:[_.]\d+)+)/.exec(t);
          if (!g) return !0;
          e: {
            if (g && g[1]) {
              var T = g[0].indexOf(".") !== -1 ? "." : "_", O = g[1].split(T);
              if (O.length === 3) {
                var N = parseInt(O[1], 10);
                break e;
              }
              if (O.length === 2) {
                N = parseInt(O[0], 10);
                break e;
              }
            }
            N = null;
          }
          return (p = N) ? 13 <= p : void 0;
        }
      } catch (b) {
        P("Error analyzing the user agent. Contact OM SDK with the user agent.");
      }
      return !1;
    }
    function ie() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    ie.prototype.setInterval = function(t, n) {
      return _t(this, "setInterval")(t, n);
    }, ie.prototype.clearInterval = function(t) {
      _t(this, "clearInterval")(t);
    };
    function vt(t, n) {
      _t(t, "clearTimeout")(n);
    }
    function _t(t, n) {
      return t.g && t.g[n] ? t.g[n] : ti(t, n);
    }
    function zi(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var p = t.g.document.createElement("img");
        p.width = 1, p.height = 1, p.style.display = "none", p.src = n, o && p.addEventListener("load", function() {
          return o();
        }), d && p.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(p);
      } else ti(t, "sendUrl")(n, o, d);
    }
    function Ji(t, n, o) {
      if (n) try {
        if (ae(t.g)) t.g.omidNative.attest(n, o);
        else if (t.g.document && t.g.document.body) {
          var d = t.g.document.createElement("img");
          d.width = 1, d.height = 1, d.style.display = "none", d.src = n, o && d.addEventListener("load", function() {
            return o();
          }), t.g.document.body.appendChild(d);
        }
      } catch (p) {
      }
    }
    function ti(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    var Oe = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function Qi() {
      this.h = /* @__PURE__ */ new Map(), this.i = null, this.g = [], ae(Oe) ? this.g.push({
        mechanism: "ApplePAT",
        version: "default",
        executionEnvironment: "native"
      }) : le() && this.g.push({
        mechanism: "ApplePAT",
        version: "default",
        executionEnvironment: "web"
      });
    }
    function ne() {
      return $t || ($t = new Qi()), $t;
    }
    var $t = null;
    function ii() {
      this.h = /* @__PURE__ */ new Set(), this.g = 0;
    }
    function Re(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function Zi() {
      this.D = null, this.i = {
        apiVersion: "1.0",
        accessMode: "limited",
        environment: "web",
        omidJsInfo: {
          omidImplementer: "omsdk",
          serviceVersion: "1.6.3-iab357"
        },
        adSessionType: "html",
        supports: ["clid", "vlid"]
      }, this.H = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.M = this.h = this.g = this.N = this.C = null, this.u = /* @__PURE__ */ new Map(), this.v = new ii();
    }
    function er(t) {
      if (t === Oe) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function xe() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return er(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function ri(t, n) {
      this.g = t, this.h = n;
    }
    I.Object.defineProperties(ri.prototype, {
      event: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.g;
        }
      },
      origin: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.h;
        }
      }
    });
    function yi(t) {
      return {
        supportedAttestationMechanisms: t.map(function(n) {
          return {
            mechanism: n.mechanism,
            version: n.version
          };
        })
      };
    }
    function a(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function u(t, n) {
      if (t.g !== void 0 && t.g.D && C(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function A(t, n) {
      t.m.push(n), u(t, n);
    }
    function S(t, n, o) {
      t.g !== void 0 && t.g.D && t.m.filter(function(d) {
        return d.event.type === n && C(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function C(t, n) {
      var o = n.event.type, d = Object.values(D).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function se(t, n, o) {
      Object.keys(D).forEach(function(d) {
        d = D[d];
        var p = {
          type: d,
          W: o,
          I: n
        };
        t.j.push(p), S(t, d, p);
      });
    }
    function de(t, n, o, d) {
      var p = {
        ca: o,
        W: d,
        I: n
      };
      t.l.push(p), t.i.forEach(function(g) {
        var T = Qr(g);
        g.event.type === "sessionStart" && x(t, T, p), t.h(p.I, T);
      });
    }
    function ft(t, n, o) {
      var d = St(t, "sessionError", "native", {
        errorType: n,
        message: o
      });
      t.i.push(d), t.l.forEach(function(p) {
        t.h(p.I, d.event);
      });
    }
    function W(t, n) {
      if (t.o = ve(t.o, n), n = t.g.i, n !== void 0) {
        n = ve({}, cs(Ii(t, Ti(t, {
          context: n
        }), !0)), {
          supportsLoadedEvent: !!t.g.h || t.g.g == "video"
        }), ve(n, {
          pageUrl: xe(),
          contentUrl: t.g.H
        }), ps(n);
        var o = St(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var p = Qr(o);
          x(t, p, d), t.h(d.I, p);
        }, t), $(t);
      }
    }
    function x(t, n, o) {
      o.ca && (n.data.verificationParameters = t.o[o.ca]), o.W && (o = t.g.u.get(o.W)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function F(t) {
      var n = St(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    a.prototype.h = function(t) {
      var n = R.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        Y(o);
      }
    };
    function $(t) {
      var n = t.m.filter(function(g) {
        return Object.values(D).indexOf(g.event.type) !== -1 && t.g.g == "video" && g.origin === t.g.j || g.event.type == "loaded" && t.g.g == "display" && g.origin === t.g.s;
      }).map(function(g) {
        return g.event;
      }), o = t.g.D || "", d = {};
      n = s(n);
      for (var p = n.next(); !p.done; d = {
        G: d.G
      }, p = n.next()) {
        if (d.G = p.value, d.G.adSessionId || (d.G.adSessionId = o), d.G.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.G.data = Ii(t, Ti(t, d.G.data));
        }
        t.j.filter(/* @__PURE__ */ function(g) {
          return function(T) {
            return T.type === g.G.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(g) {
          return function(T) {
            return T.I(g.G);
          };
        }(d));
      }
    }
    function ot(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? (P("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function Dt(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? (P("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function tr(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? (P("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function Ii(t, n, o) {
      return o = o === void 0 ? !1 : o, n = ve({}, n), t.g.g && ve(n, {
        mediaType: t.g.g
      }), t.g.h && (o || t.g.h !== "definedByJavaScript") && ve(n, {
        creativeType: t.g.h
      }), n;
    }
    function cs(t) {
      var n = ne().i;
      return n ? ve({}, t, {
        lastActivity: n
      }) : t;
    }
    function Ti(t, n) {
      return t.g.M ? ve({}, n, {
        impressionType: t.g.M
      }) : n;
    }
    function ps(t) {
      var n = ne().g;
      ve(t, yi(n));
    }
    function St(t, n, o, d) {
      return new ri({
        adSessionId: t.g.D || "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: n,
        data: d
      }, o);
    }
    function Qr(t) {
      t = t.event;
      var n = t.data ? ve({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = ve({}, n.context)), {
        adSessionId: t.adSessionId,
        timestamp: t.timestamp,
        type: t.type,
        data: n
      };
    }
    function Zr(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.C);
    }
    function en(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (ve(o, {
          mediaPlayerVolume: n
        }), t.g.N = n) : d != null && (ve(o, {
          videoPlayerVolume: d
        }), t.g.N = d);
      }
    }
    function fs(t, n) {
      this.h = t, this.g = n;
    }
    function tn(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function at(t, n, o, d, p) {
      this.j = t, this.da = n, this.U = o, this.i = d, this.aa = p, this.h = null, this.g = this.m = this.M = void 0, this.$ = !0, this.o = void 0, Oi(this);
    }
    function Oi(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.$ && (ft(t.U, "generic", "More than one element with 'omid-element' class name."), t.$ = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        Ri(t);
      }
    }
    function Ri(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, tn(t.h) ? t.i.o && t.s() : t.s());
    }
    function ni(t) {
      t.g && (tn(t.h) ? t.i.o && (t.P(), rn(t)) : (t.P(), rn(t)));
    }
    at.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, at.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", ni(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function rn(t) {
      if (t.M) {
        t.i.U = t.M, t = t.da;
        var n = t.g.U, o = t.g.P;
        if (n && !n.T(o)) {
          o = Je(n);
          var d = t.h;
          d.g.h != "audio" && A(d, St(d, "geometryChange", "native", o)), t.g.P = n;
        }
      }
    }
    function nn(t) {
      if (t.g && t.i.o) {
        var n = new _(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.R = !0, n;
      }
    }
    function jt(t, n, o, d, p, g) {
      at.call(this, t, o, d, p, g), this.u = n, this.l = void 0;
    }
    y(jt, at), jt.prototype.v = function() {
      this.l !== void 0 && (this.aa.clearInterval(this.l), this.l = void 0), at.prototype.v.call(this);
    }, jt.prototype.s = function() {
      var t = this;
      at.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.aa.setInterval(function() {
        return sn(t);
      }, 200), sn(this));
    }, jt.prototype.P = function() {
      if (this.m) {
        var t = nn(this);
        if (t) {
          this.g.S = !1, t.S = !0;
          for (var n = !1, o = 0; o < this.g.O.length; o++) if (this.g.O[o].S) {
            this.g.O[o] = t, n = !0;
            break;
          }
          n || this.g.O.push(t);
        } else this.g.S = !0;
        n = this.u, o = this.i.B;
        var d = this.i.D, p = this.N();
        t = new rt();
        var g = new _(this.m, !1);
        if (gt(t, g), we(n, g, t, d), p)
          if (g.ba) ge(t, "backgrounded"), ge(t, "noOutputDevice");
          else if (o === "backgrounded") ge(t, "backgrounded");
          else if (t.g !== void 0) {
            for (n = 0; n < t.o.length; n++) Ft(t, t.o[n]) && t.v.push(t.o[n]);
            for (n = 0; n < t.s.length; n++) {
              if (o = Ft(t, t.s[n])) {
                e: {
                  for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                    o = !0;
                    break e;
                  }
                  o = !1;
                }
                o = !o;
              }
              o && (ge(t, "obstructed"), t.j.push(t.s[n]));
            }
            Ut(t);
          } else ge(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new _((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = nt();
        this.M = t;
      }
    }, jt.prototype.N = function() {
      return on(this);
    };
    function sn(t) {
      if (t.l !== void 0) {
        if (on(t)) {
          var n = t.j.top;
          n = new _(new Re(n.innerWidth, n.innerHeight), !1);
        } else n = new _(new Re(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new _(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.R = !0, t.m = n, t.m.O.push(t.g), ni(t));
      }
    }
    function on(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function Bt(t, n, o, d, p, g) {
      at.call(this, t, o, d, p, g), this.C = this.u = this.B = this.l = void 0, this.Z = !1, this.H = void 0;
    }
    y(Bt, at), Bt.prototype.v = function() {
      this.l && this.l.disconnect(), an(this), at.prototype.v.call(this);
    }, Bt.prototype.s = function() {
      if (at.prototype.s.call(this), this.h && (this.l || (this.l = ms(this)), ln(this), dn(this.h) && As(this), this.i.B === "backgrounded")) {
        var t = Ni(new Re(0, 0));
        this.H = this.g = this.m = t, ni(this);
      }
    }, Bt.prototype.P = function() {
      if (this.g && this.H) {
        var t = nn(this);
        if (t) {
          var n = t, o = this.H, d = Math.max(t.x, o.x), p = Math.max(t.y, o.y), g = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), g <= d || t <= p ? d = null : (o = {}, d = new _((o.x = d, o.y = p, o.width = Math.abs(g - d), o.height = Math.abs(t - p), o), !1)), d || (d = new _({
            x: 0,
            y: 0,
            width: 0,
            height: 0
          }, !1));
        } else n = this.g, d = this.H;
        p = new rt(), this.m && gt(p, this.m), (g = this.i.B == "backgrounded") && ge(p, "backgrounded"), p.g = n, p.h = d, Ut(p), this.Z ? !g && it(p.g) ? ge(p, "hidden") : g || p.u === 100 || ge(p, "clipped") : ge(p, "viewport"), this.M = p;
      }
    }, Bt.prototype.N = function() {
      return !0;
    };
    function an(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function ln(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function dn(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function ms(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], p = 1; p < n.length; p++) n[p].time > d.time && (d = n[p]);
            o = d, t.m = Ni(o.rootBounds), t.g = Ni(o.boundingClientRect), t.H = Ni(o.intersectionRect), t.Z = !!o.isIntersecting, ni(t);
          }
        } catch (g) {
          t.v(), ft(t.U, "generic", "Problem handling IntersectionObserver callback: " + g.message);
        }
      }, {
        root: null,
        rootMargin: "0px",
        threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]
      });
    }
    function As(t) {
      t.j.ResizeObserver ? t.B || (t.B = Es(t, function() {
        return ir(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return ir(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return ir(t);
      }), t.u.observe(t.h, {
        childList: !1,
        attributes: !0,
        subtree: !1
      })));
    }
    function ir(t) {
      t.h && !dn(t.h) && (ln(t), an(t));
    }
    function Es(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function Ni(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new _(t, !1);
    }
    function rr(t) {
      if (Z(t) === "object" && Z(t.webOSSystem) === "object") return t.webOSSystem;
    }
    function Ci(t) {
      return Z(rr(t)) === "object";
    }
    function Ht(t) {
      if (Z(t) === "object" && Z(t.tizen) === "object") return t.tizen;
    }
    function Lt(t) {
      return Z(Ht(t)) === "object";
    }
    function gs(t, n) {
      this.h = t, this.g = n;
    }
    function nr() {
      return typeof crypto != "undefined" && typeof crypto.getRandomValues == "function";
    }
    function sr() {
      var t = new Uint8Array(16);
      crypto.getRandomValues(t), t[6] = t[6] & 15 | 64, t[8] = t[8] & 63 | 128;
      for (var n = [], o = 0; 16 > o; o++) n.push(t[o].toString(16).padStart(2, "0"));
      return n[0] + n[1] + n[2] + n[3] + "-" + n[4] + n[5] + "-" + n[6] + n[7] + "-" + n[8] + n[9] + "-" + n[10] + n[11] + n[12] + n[13] + n[14] + n[15];
    }
    function or() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function vs(t, n) {
      var o = o === void 0 ? Oe : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function un(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, p = typeof d == "string" && Object.values(L).indexOf(d) !== -1 ? o.accessMode : null, g = p ? p == "domain" ? "limited" : p : "limited";
          o.accessMode = g;
          e: {
            var T = o.resourceUrl, O = t.g.location.origin;
            try {
              var N = new URL(T, O);
              break e;
            } catch (lt) {
            }
            try {
              N = new URL(T);
              break e;
            } catch (lt) {
            }
            N = null;
          }
          if (d = N) {
            var b = nr() ? sr() : or();
            Ss(t, b, d, g);
            var j = o.vendorKey, fe = o.verificationParameters;
            j = j === void 0 ? "" : j, fe = fe === void 0 ? "" : fe, j && typeof j == "string" && j !== "" && fe && typeof fe == "string" && fe !== "" && (t.i.o[j] = fe), t.j.u.set(b, o);
          }
        } catch (lt) {
          Y("OMID verification script " + o.resourceUrl + " failed to load: " + lt);
        }
      });
    }
    function Ss(t, n, o, d) {
      var p = t.g.document, g = p.createElement("iframe");
      if (g.id = "omid-verification-script-frame-" + n, g.style.display = "none", d == "full") {
        var T = function() {
          var N = g.contentWindow;
          N.omidVerificationProperties = {
            serviceWindow: t.g,
            injectionSource: "web",
            injectionId: n
          }, N = N.document;
          var b = N.createElement("script");
          b.src = o.href, N.head.appendChild(b), g.removeEventListener("load", T);
        };
        g.addEventListener("load", T);
      } else d == "limited" && (g.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, g.sandbox = "allow-scripts");
      p.body.appendChild(g), ne().h.set(n, g);
    }
    function ar(t, n) {
      var o = window, d = this;
      if (Ci(o)) if (o)
        if (o.WebOSServiceBridge) {
          this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(p) {
            try {
              var g = JSON.parse(p);
              if (g && g.errorCode) d.error(p);
              else if (!g) d.error("No object recieved from webOS bridge");
              else if (!_i(d, p, g, "volumeStatus", "object")) {
                var T = g.volumeStatus;
                _i(d, p, T, "muteStatus", "boolean") || _i(d, p, T, "volume", "number") || _i(d, p, T, "maxVolume", "number") || (0 >= T.maxVolume ? d.error("Invalid max volume status.") : d.i(T.muteStatus ? 0 : T.volume / T.maxVolume));
              }
            } catch (O) {
              d.error(O);
            }
          };
          try {
            this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
          } catch (p) {
            this.error(p);
          }
        } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    ar.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, ar.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function _i(t, n, o, d, p) {
      return Z(o[d]) === p ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + p + '" but was of type "' + Z(o[d]) + '".'), !0);
    }
    function hn(t) {
      return Lt(t) ? Z(Ht(t).tvinputdevice) === "object" : !1;
    }
    function Di(t, n) {
      var o = window, d = this;
      if (o)
        if (this.validate(o)) {
          this.h = n;
          var p = Ht(o).tvaudiocontrol;
          this.g = void 0, n = function() {
            var T = p.isMute() ? 0 : p.getVolume() / 100;
            (d.g === void 0 || d.g != T) && (d.g = T, t(d.g));
          }, n(), this.i = o.setInterval(n, 200), this.j = o;
        } else n("Invalid Tizen window context");
      else n("No window context");
    }
    Di.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, Di.prototype.validate = function(t) {
      return Lt(t) && hn(t) && Z(Ht(t).tvaudiocontrol) === "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, Di.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function cn(t, n, o, d, p) {
      var g = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = p, this.m = !1, lr(this, function(T) {
        if (T.type === "sessionStart") {
          g.m = !0;
          try {
            un(g.l);
          } catch (O) {
            P(O.message);
          }
        }
        T.type === "sessionFinish" && (g.m = !1);
      });
    }
    function lr(t, n, o, d) {
      de(t.i, n, o, d);
    }
    i = cn.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && Ri(this.h)) : P("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && Ri(this.h), this.h && ni(this.h);
    }, i.error = function(t, n) {
      ft(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        un(this.l);
      } catch (o) {
        P(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.M = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = ve({}, d.omidJsInfo, {
        sessionClientVersion: t,
        partnerName: n,
        partnerVersion: o
      }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function ys(t) {
      if (Lt(window) || Ci(window)) {
        var n = function(p) {
          if (t.g.C !== p && t.i.g.j !== "none" && typeof p == "number" && !isNaN(p)) {
            t.g.C = p;
            var g = t.o, T = g.g.N;
            T != null && (p = g.h, g = {
              mediaPlayerVolume: T,
              deviceVolume: g.g.C
            }, Zr(p, "volumeChange", g), en(p, "volumeChange", g), A(p, St(p, "volumeChange", "native", g)));
          }
        }, o = function(p) {
          P(p);
        };
        Ci(window) ? t.j = new ar(n, o) : Lt(window) && (t.j = new Di(n, o));
      }
    }
    function dr(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function Ve(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function ur(t) {
      var n = new Zi(), o = new a(n), d = new _e(), p = new Pe(), g = new fs(o, n);
      t = t.i;
      var T = e;
      return d = T ? T.IntersectionObserver && (T.MutationObserver || T.ResizeObserver) ? new Bt(T, d, g, o, n, t) : new jt(T, p, g, o, n, t) : null, new cn(n, o, d, new vs(o, n), new gs(o, n));
    }
    function Wt(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function pn(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function fn(t) {
      return new Wt(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function mn(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function An(t) {
      this.i = t;
    }
    function Xt(t) {
      this.i = t, this.handleExportedMessage = Xt.prototype.j.bind(this);
    }
    y(Xt, An), Xt.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(mn(t), this);
    }, Xt.prototype.j = function(t, n) {
      pn(t) && this.g && this.g(fn(t), n);
    };
    function Li(t) {
      return hr(t, "SessionService.");
    }
    function hr(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function cr(t, n) {
      this.h = t, this.i = n;
    }
    cr.prototype.g = function(t) {
      var n = R.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, cr.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function oe(t, n) {
      return t.g.bind(t, n);
    }
    function Is(t, n) {
      n = n === void 0 ? Oe : n, n.omidSessionInterface == null && (t = {
        setSessionClientWindow: t.i,
        setClientInfo: oe(t, "setClientInfo"),
        registerSessionObserver: oe(t, "registerSessionObserver"),
        startAdSession: oe(t, "startSession"),
        finishAdSession: oe(t, "finishSession"),
        reportError: oe(t, "sessionError"),
        registerAdEvents: oe(t, "registerAdEvents"),
        registerMediaEvents: oe(t, "registerMediaEvents"),
        injectVerificationScriptResources: oe(t, "injectVerificationScriptResources"),
        setSlotElement: oe(t, "setSlotElement"),
        setVideoElement: oe(t, "setVideoElement"),
        setElementBounds: oe(t, "setElementBounds"),
        setCreativeType: oe(t, "setCreativeType"),
        setImpressionType: oe(t, "setImpressionType"),
        setContentUrl: oe(t, "setContentUrl"),
        adEvents: {
          impressionOccurred: oe(t, "impressionOccurred"),
          loaded: oe(t, "loaded")
        },
        mediaEvents: {
          start: oe(t, "start"),
          firstQuartile: oe(t, "firstQuartile"),
          midpoint: oe(t, "midpoint"),
          thirdQuartile: oe(t, "thirdQuartile"),
          complete: oe(t, "complete"),
          pause: oe(t, "pause"),
          resume: oe(t, "resume"),
          bufferStart: oe(t, "bufferStart"),
          bufferFinish: oe(t, "bufferFinish"),
          skipped: oe(t, "skipped"),
          volumeChange: oe(t, "volumeChange"),
          playerStateChange: oe(t, "playerStateChange"),
          adUserInteraction: oe(t, "adUserInteraction")
        }
      }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", {
        value: t,
        writable: !1
      }));
    }
    function Mi(t, n) {
      this.i = n = n === void 0 ? Oe : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (Z(d.data) === "object") {
          var p = d.data;
          pn(p) && d.source && o.g && o.g(fn(p), d.source);
        }
      });
    }
    y(Mi, An), Mi.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(mn(t), "*");
    };
    function Ts(t) {
      if (Oe.document) {
        var n = Oe.document.createElement("iframe");
        n.style.display = "none", n.src = t, t = function() {
          var d = Oe.document.body || Oe.document.documentElement;
          d && (d.appendChild(n), setTimeout(function() {
            n.parentNode && n.parentNode.removeChild(n);
          }, 100));
        }, Oe.document.readyState === "loading" ? Oe.document.addEventListener("DOMContentLoaded", t) : t();
      }
    }
    function En() {
      this.g = Dn;
    }
    i = En.prototype, i.registerSessionObserver = function(t, n) {
      lr(Ve(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      Ve(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      Ve(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      Ve(this.g, t).error(n, o);
    };
    function De(t, n, o, d) {
      t = Ve(t.g, n), o == "impression" ? Dt(t.i) && (o = t.i, d = (d = o.g.P) ? Je(d) : null, d = Ii(o, Ti(o, d)), A(o, St(o, "impression", "javascript", d)), t.h && Oi(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, tr(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = St(d, "loaded", "javascript", Ii(d, Ti(d, n === void 0 ? null : n))), A(d, n))) : tr(t.i) && (n = t.i, Zr(n, o, d), en(n, o, d), A(n, St(n, o, "javascript", d))), ["loaded", "start"].indexOf(o) !== -1 && t.h && Oi(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      Ve(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, Ve(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      Ve(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var p = this.g;
      if (t == null) t = p.g;
      else {
        var g = [].concat(l(p.h.values())).indexOf(p.g) !== -1 ? ur(p) : p.g;
        p.h.set(t, g), t = g;
      }
      return t.setClientInfo(n, o, d);
    };
    function gn(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), p = parseInt(n[o], 10);
        if (d > p) break;
        if (d < p) return !1;
      }
      return !0;
    }
    function vn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && gn(t) ? n : JSON.stringify(n);
    }
    function Sn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && gn(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function pr() {
      var t = Ls, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new Xt(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new Mi(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new cr(function(d, p, g) {
        try {
          In(n, d, p, g);
        } catch (T) {
          P(Tn(T));
        }
      }, function(d) {
        n.m = d;
        var p = nr() ? sr() : or();
        n.i.h(new Wt(p, "identifyServiceWindow", "1.6.3-iab357"), d);
      }), Is(this.s, this.h);
    }
    pr.prototype.l = function(t, n) {
      Li(t.method) != null && yn(this, t, n, this.j);
    }, pr.prototype.o = function(t, n) {
      if (Li(t.method) != null) {
        if (!this.m || n !== this.m) return P("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        yn(this, t, n, this.i);
      }
    };
    function yn(t, n, o, d) {
      function p() {
        var N = new Wt(g, "response", O, vn(O, R.apply(0, arguments)));
        d.h(N, o);
      }
      var g = n.h, T = n.method, O = n.version;
      n = Sn(O, n.g);
      try {
        In(t, T, p, n);
      } catch (N) {
        d.h(new Wt(g, "error", O, Tn(N)), o);
      }
    }
    function In(t, n, o, d) {
      if (Li(n) != null) switch (Li(n)) {
        case "registerAdEvents":
          var p = s(d).next().value, g = Ve(t.g.g, p).i;
          ot(g, ["impression"]) && Dt(g) && (g.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var T = s(d).next().value, O = Ve(t.g.g, T).i;
          ot(O, Object.values(D)) && tr(O) && (O.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var N = s(d).next().value;
          t.g.registerSessionObserver(N, o);
          break;
        case "setSlotElement":
          var b = s(d), j = b.next().value, fe = b.next().value;
          t.g.setSlotElement(fe, j);
          break;
        case "setVideoElement":
          var lt = s(d), mt = lt.next().value, Qe = lt.next().value, Ye = Ve(t.g.g, Qe);
          mt && mt.tagName && mt.tagName.toLowerCase() === "video" ? (Ye.g.l = mt, Ye.h && Ri(Ye.h)) : P("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Pi = s(d), Ar = Pi.next().value, Er = Pi.next().value;
          t.g.setElementBounds(Er, Ar);
          break;
        case "startSession":
          var wi = s(d), Ze = wi.next().value, si = wi.next().value, et = t.h;
          if (Ze != null && Z(Ze) === "object") {
            var oi = Ze.customReferenceData, ai = Ze.underEvaluation, li = Ze.universalAdId;
            typeof oi == "string" || (oi = void 0), typeof ai == "boolean" || (ai = !1);
            var dt = {
              customReferenceData: oi,
              underEvaluation: ai
            };
            if (typeof li == "string" && (dt.universalAdId = li), Ci(et)) {
              var xi = rr(et), qt;
              Z(xi) === "object" && (qt = xi.identifier), dt.app = {
                appId: qt && typeof qt == "string" ? qt : void 0
              };
              e: {
                var Vi = rr(et);
                if (Z(Vi) === "object") {
                  try {
                    var ke = JSON.parse(Vi.deviceInfo);
                  } catch (go) {
                    var gr = void 0;
                    break e;
                  }
                  gr = {
                    deviceType: ke.modelName || "Unknown",
                    osVersion: ke.platformVersion || "Unknown",
                    os: "webOS"
                  };
                } else gr = void 0;
              }
              dt.deviceInfo = gr, dt.deviceCategory = "ctv";
            } else if (Lt(et)) {
              e: {
                if (Lt(et)) {
                  try {
                    var Ln = Ht(et).application.getCurrentApplication().appInfo.id;
                  } catch (go) {
                    var vr = void 0;
                    break e;
                  }
                  if (typeof Ln == "string") {
                    vr = Ln;
                    break e;
                  }
                }
                vr = void 0;
              }
              if (dt.app = {
                appId: vr
              }, Lt(et)) {
                var ki = Ht(et).systeminfo;
                if (Z(ki) === "object" && typeof ki.getCapability == "function")
                  var Ms = ki.getCapability("http://tizen.org/system/model_name"), bs = ki.getCapability("http://tizen.org/feature/platform.version");
                var Mn = {
                  deviceType: Ms || "Unknown",
                  osVersion: bs || "Unknown",
                  os: "tizen"
                };
              } else Mn = void 0;
              dt.deviceInfo = Mn, hn(et) && (dt.deviceCategory = "ctv");
            }
            Ze = dt;
          } else Ze = null;
          if (Ze == null) break;
          var Mt = Ze, Sr = Sr === void 0 ? null : Sr, yt = Ve(t.g.g, si), bn = yt.g.i;
          bn.sessionOwner || (bn.sessionOwner = "javascript");
          var Ps = si || (nr() ? sr() : or());
          yt.g.D = Ps, Mt.canMeasureVisibility = yt.h.N();
          var yr = yt.g;
          Mt.contentUrl !== void 0 && (yr.H = Mt.contentUrl, Mt.contentUrl = void 0);
          var Pn = yr.i || {};
          Mt.omidJsInfo = ve({}, Pn.omidJsInfo || {}, Mt.omidJsInfo || {});
          var ws = ve({}, Pn, Mt);
          yr.i = ws, W(yt.i, Sr), yt.h && Oi(yt.h), ys(yt);
          break;
        case "finishSession":
          var xs = s(d).next().value, wn = t.g, di = Ve(wn.g, xs), xn = wn.g;
          xn.g = ur(xn), F(di.i), di.h.v(), di.j && (di.j.stop(), di.j = null);
          break;
        case "impressionOccurred":
          var Vs = s(d).next().value;
          De(t.g, Vs, "impression");
          break;
        case "loaded":
          var Vn = s(d), Yt = Vn.next().value, kn = Vn.next().value;
          if (Yt) {
            var Un = {
              skippable: Yt.isSkippable,
              autoPlay: Yt.isAutoPlay,
              position: Yt.position
            };
            Yt.isSkippable && (Un.skipOffset = Yt.skipOffset), De(t.g, kn, "loaded", Un);
          } else De(t.g, kn, "loaded");
          break;
        case "start":
          var Ir = s(d), ks = Ir.next().value, Us = Ir.next().value, Fs = Ir.next().value;
          De(t.g, Fs, "start", {
            duration: ks,
            mediaPlayerVolume: Us
          });
          break;
        case "firstQuartile":
          var $s = s(d).next().value;
          De(t.g, $s, "firstQuartile");
          break;
        case "midpoint":
          var js = s(d).next().value;
          De(t.g, js, "midpoint");
          break;
        case "thirdQuartile":
          var Bs = s(d).next().value;
          De(t.g, Bs, "thirdQuartile");
          break;
        case "complete":
          var Hs = s(d).next().value;
          De(t.g, Hs, "complete");
          break;
        case "pause":
          var Ws = s(d).next().value;
          De(t.g, Ws, "pause");
          break;
        case "resume":
          var Xs = s(d).next().value;
          De(t.g, Xs, "resume");
          break;
        case "bufferStart":
          var qs = s(d).next().value;
          De(t.g, qs, "bufferStart");
          break;
        case "bufferFinish":
          var Ys = s(d).next().value;
          De(t.g, Ys, "bufferFinish");
          break;
        case "skipped":
          var Gs = s(d).next().value;
          De(t.g, Gs, "skipped");
          break;
        case "volumeChange":
          var Fn = s(d), Ks = Fn.next().value, zs = Fn.next().value;
          De(t.g, zs, "volumeChange", {
            mediaPlayerVolume: Ks
          });
          break;
        case "playerStateChange":
          var $n = s(d), Js = $n.next().value, Qs = $n.next().value;
          De(t.g, Qs, "playerStateChange", {
            state: Js
          });
          break;
        case "adUserInteraction":
          var jn = s(d), Zs = jn.next().value, eo = jn.next().value;
          De(t.g, eo, "adUserInteraction", {
            interactionType: Zs
          });
          break;
        case "setClientInfo":
          var Ui = s(d), to = Ui.next().value, io = Ui.next().value, ro = Ui.next().value, no = Ui.next().value, so = t.g.setClientInfo(no, to, io, ro);
          o(so);
          break;
        case "injectVerificationScriptResources":
          var Bn = s(d), oo = Bn.next().value, ao = Bn.next().value;
          t.g.injectVerificationScriptResources(ao, oo);
          break;
        case "setCreativeType":
          var Hn = s(d), lo = Hn.next().value, uo = Hn.next().value;
          t.g.setCreativeType(uo, lo);
          break;
        case "setImpressionType":
          var Wn = s(d), ho = Wn.next().value, co = Wn.next().value;
          t.g.setImpressionType(co, ho);
          break;
        case "setContentUrl":
          var Xn = s(d), po = Xn.next().value, fo = Xn.next().value;
          Ve(t.g.g, fo).g.H = po;
          break;
        case "sessionError":
          var Tr = s(d), mo = Tr.next().value, Ao = Tr.next().value, Eo = Tr.next().value;
          t.g.error(Eo, mo, Ao);
      }
    }
    function Tn(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function fr() {
      var t = Dn, n = _n, o = this, d = d === void 0 ? Oe : d;
      this.i = t, this.g = n, this.l = {}, this.m = {}, this.j = new Xt(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.j, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new Mi(d)), this.j.g = function(p, g) {
        Rn(o, p, g, o.j);
      }, this.h && (this.h.g = function(p, g) {
        o.h && Rn(o, p, g, o.h);
      });
    }
    function On(t) {
      t({
        adSessionId: "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: "sessionError",
        data: {
          errorType: "generic",
          message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected."
        }
      });
    }
    function Os(t, n, o, d) {
      t = dr(t.i, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? se(t, o, d) : (o = {
        type: n,
        W: d,
        I: o
      }, t.j.push(o), S(t, n, o))) : On(o);
    }
    function Rs(t, n, o, d) {
      t = dr(t.i, d), d !== void 0 && t.g.u.has(d) ? lr(t, n, o, d) : On(n);
    }
    function Ns(t, n, o, d, p, g, T) {
      T = dr(t.i, T);
      var O = 2 <= T.g.v.g ? {
        V: !1,
        reason: "SESSION_ATTESTATION_LIMIT_EXCEEDED"
      } : T.g.v.h.has(g) ? {
        V: !1,
        reason: "TOO_MANY_REQUESTS"
      } : 0.5 <= Math.random() ? {
        V: !1,
        reason: "SAMPLING_REJECTED"
      } : {
        V: !0,
        reason: null
      };
      if (T.g.v.h.add(g), O.V)
        if (T.g.v.g++, g = T.g.D, n === "ApplePAT") Ji(t.g, d.ya, p);
        else try {
          t = {};
          for (var N in d) d.hasOwnProperty(N) && (t[N.toLowerCase()] = d[N]);
          var b = Oe.webkit ? Oe.webkit.messageHandlers.omidJsAttestationListener : Oe.omidJsAttestationListener;
          if (b) b.postMessage(JSON.stringify({
            method: "attest",
            data: {
              adSessionId: g,
              mechanism: n,
              version: o,
              attestationArgs: t
            }
          }));
          else {
            d = "";
            for (var j in t) t.hasOwnProperty(j) && (d += "&" + j + "=" + t[j]);
            Ts("omid-native://?method=attest&adSessionId=" + g + "&mechanism=" + n + "&version=" + o + d);
          }
          p(!0, "SUCCESS");
        } catch (fe) {
          P("Failed to trigger native-layer attestation method: " + fe.message), p(!1, "FAILED_TO_TRIGGER_ATTESTATION");
        }
      else p(!1, O.reason);
    }
    function Cs(t, n, o, d) {
      zi(t.g, n, o, d);
    }
    fr.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, fr.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function _s(t, n, o, d) {
      ti(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function Rn(t, n, o, d) {
      function p() {
        var ke = new Wt(g, "response", O, vn(O, R.apply(0, arguments)));
        d.h(ke, o);
      }
      var g = n.h, T = n.method, O = n.version;
      if (n = Sn(O, n.g), hr(T, "VerificationService.") != null) {
        T = hr(T, "VerificationService.");
        try {
          switch (T) {
            case "addEventListener":
              var N = s(n), b = N.next().value, j = N.next().value || mr(o);
              Os(t, b, p, j);
              break;
            case "addSessionListener":
              var fe = s(n), lt = fe.next().value, mt = fe.next().value || mr(o);
              Rs(t, p, lt, mt);
              break;
            case "attest":
              var Qe = s(n), Ye = Qe.next().value, Pi = Qe.next().value, Ar = Qe.next().value, Er = Qe.next().value, wi = Qe.next().value || mr(o);
              Ns(t, Ye, Pi, Ar, p, Er, wi);
              break;
            case "sendUrl":
              var Ze = s(n).next().value;
              Cs(t, Ze, function() {
                return p(!0);
              }, function() {
                return p(!1);
              });
              break;
            case "setTimeout":
              var si = s(n), et = si.next().value, oi = si.next().value;
              t.l[et] = _t(t.g, "setTimeout")(p, oi);
              break;
            case "clearTimeout":
              var ai = s(n).next().value;
              vt(t.g, t.l[ai]);
              break;
            case "setInterval":
              var li = s(n), dt = li.next().value, xi = li.next().value;
              t.m[dt] = t.setInterval(p, xi);
              break;
            case "clearInterval":
              var qt = s(n).next().value;
              t.clearInterval(t.m[qt]);
              break;
            case "injectJavaScriptResource":
              var Vi = s(n).next().value;
              _s(t, Vi, function(ke) {
                return p(!0, ke);
              }, function() {
                return p(!1);
              });
              break;
            case "getVersion":
              p("1.6.3-iab357");
          }
        } catch (ke) {
          d.h(new Wt(g, "error", O, `
              name: ` + ke.name + `
              message: ` + ke.message + `
              filename: ` + ke.filename + `
              lineNumber: ` + ke.lineNumber + `
              columnNumber: ` + ke.columnNumber + `
              stack: ` + ke.stack + `
              toString(): ` + ke.toString() + `
          `), o);
        }
      }
    }
    function mr(t) {
      for (var n = ne().h, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var p = n.get(d);
        if (p) {
          if (p.contentWindow === t) return d;
          try {
            if (p.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (g) {
          }
        }
      }
    }
    function Nn(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function Cn(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function bi(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function Ds(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(p) {
          p.addedNodes[0].nodeName === "BODY" && (p = Nn(n), bi(t, "omid_v1_present"), bi(t, p), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, {
        childList: !0
      });
    }
    var _n = new ie(), Dn = new function() {
      this.i = _n, this.h = /* @__PURE__ */ new Map(), this.g = ur(this);
    }(), Ls = new En();
    new fr(), new pr(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? Ds(t, n) : (n = Nn(n), t.document.body ? (bi(t, "omid_v1_present"), bi(t, n)) : (Cn(t, "omid_v1_present"), Cn(t, n))));
    }(Oe, "web");
  }).call(c, c);
}
const ns = "4.0", ss = ["4.0"], Jr = class Jr {
  constructor() {
    this.OmidServiceClient = ra();
  }
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      f.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (f.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  hasValidHandshake(e, i = ns, r = ss) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  hasValidFacadeImplementation(e, i = yo) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  validate(e) {
    if (!e) {
      this.error = w.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = w.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = w.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = Qt(Ei, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function h(E) {
        f.debug.critical("init - error", E), l(E);
      }
      Object.keys(this.initError).length > 0 ? h(this.initError) : s(new Wr(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return f.debug.warn(
      `Request method ${Si.JSONP} is deprecated since v7.6.2 and will be removed in v8.`
    ), Si;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return ce;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return Ee;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Gr(Ei);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return gi;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return m;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(m);
  }
  get LOGLEVEL() {
    return pt;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    f.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return f.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return f.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return ns;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return ss;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.6.2";
  }
};
Jr.NAME = "Core::";
let Ki = Jr;
const na = new Ki();
typeof window != "undefined" && (window.smartclientcore = na);
typeof exports == "object" && (exports = {
  smartclientcore: Ki
});
export {
  yo as FacadeBase,
  na as default
};
