Object.entries || (Object.entries = function(e) {
  var t = [];
  for (k in e)
    typeof k == "string" && e.propertyIsEnumerable(k) && t.push([k, e[k]]);
  return t;
});
(function() {
  if (typeof navigator != "undefined" && navigator.userAgent) {
    var a = function(i, r) {
      r = r || {
        bubbles: !1,
        cancelable: !1,
        detail: void 0
      };
      var s = document.createEvent("CustomEvent");
      return s.initCustomEvent(i, r.bubbles, r.cancelable, r.detail), s;
    }, e = navigator.userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    /trident|msie/i.test(e[1]) && (a.prototype = window.Event.prototype, window.CustomEvent = a, window.Event = a);
  }
})();
(function(a) {
  a && a.prototype && a.prototype.firstElementChild === void 0 && Object.defineProperty(a.prototype, "firstElementChild", {
    get: function() {
      for (var t, i = this.childNodes, r = 0; t = i[r++]; )
        if (t.nodeType === 1)
          return t;
      return null;
    }
  });
})(typeof window != "undefined" ? window.Node || window.Element : null);
var ce = /* @__PURE__ */ ((a) => (a[a.SILENT = 0] = "SILENT", a[a.ERROR = 1] = "ERROR", a[a.NORMAL = 2] = "NORMAL", a[a.VERBOSE = 3] = "VERBOSE", a))(ce || {}), z = /* @__PURE__ */ ((a) => (a[a.CRITICAL = 0] = "CRITICAL", a[a.ERROR = 1] = "ERROR", a[a.INFO = 2] = "INFO", a[a.TABLE = 3] = "TABLE", a[a.WARN = 4] = "WARN", a))(z || {});
let De = ce.SILENT;
const $e = "[OIS_DEBUG]", Ai = {
  [ce.ERROR]: [z.CRITICAL, z.ERROR],
  [ce.NORMAL]: [z.INFO, z.TABLE, z.WARN],
  [ce.SILENT]: [],
  [ce.VERBOSE]: [z.CRITICAL, z.ERROR, z.INFO, z.TABLE, z.WARN]
};
function Fe() {
}
class o {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    De = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return De;
  }
  static shouldLog(e, t) {
    return t !== ce.SILENT && Ai[t].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(z.CRITICAL, De) ? console.error : Fe).bind(console, $e),
      info: (this.shouldLog(z.INFO, De) ? console.info : Fe).bind(console, $e),
      error: (this.shouldLog(z.ERROR, De) ? console.error : Fe).bind(console, $e),
      table: (this.shouldLog(z.TABLE, De) ? console.table : Fe).bind(console),
      warn: (this.shouldLog(z.WARN, De) ? console.warn : Fe).bind(console, $e)
    };
  }
}
const pi = "4.0";
class Ei {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, t) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return pi;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, t = !0, i = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, t) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var V = /* @__PURE__ */ ((a) => (a.LINEAR = "linear", a.NON_LINEAR = "nonlinear", a))(V || {});
function Xt(a, e = "") {
  return (Array.isArray(a) ? a : [a]).map((i) => e ? `${i} ${e}` : i).join(",");
}
class Ue {
  static cTSTS(e) {
    const t = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(t) ? null : t / 1e3;
  }
  static gMNE(e, t) {
    let i = -1, r = null;
    for (const s of b(e, t)) {
      let n = 0, l = s;
      for (; l.parentNode !== e; )
        n++, l = l.parentNode;
      n > i && (i = n, r = s);
    }
    return r;
  }
  static gU(e, t) {
    const i = e.map((s) => s[t]);
    return e.filter((s, n) => !i.includes(s[t], n + 1));
  }
  static t(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
  static f(e, t, i = "") {
    return e.querySelector(Xt(t, i));
  }
  static fA(e, t, i = "") {
    return e.querySelectorAll(Xt(t, i));
  }
}
const Re = Ue.cTSTS, v = Ue.f, b = Ue.fA, fi = Ue.gU, pe = Ue.gMNE, q = Ue.t;
class mi {
  constructor(e) {
    this.adSourceXML = e, this.adSource = v(this.adSourceXML, "AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? q(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : q(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const be = class be {
  constructor(e, t = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = t, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return V.NON_LINEAR;
      default:
        return V.LINEAR;
    }
  }
  queryElements(e) {
    return b(this.adBreakXML, e);
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = v(this.adBreakXML, ":scope > AdSource");
    return e ? new mi(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[be.POSITION[this.breakPosition]] && this.publisherSpecs[be.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[be.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = Re(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  getBreakPosition() {
    return this.type === V.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || Re(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  getExtensions() {
    const e = this.queryElements(":scope > Extensions > Extension"), t = [];
    for (const i of e)
      t.push({
        extensionXML: i,
        type: i.getAttribute("type") || ""
      });
    return t;
  }
  getTrackers() {
    const e = this.queryElements(":scope > TrackingEvents > Tracking");
    let t = {};
    for (const i of e) {
      const r = i.getAttribute("event"), s = i.textContent.trim();
      s && (t[r] = t[r] || [], t[r].push({ url: s }));
    }
    return t;
  }
  getSeparationClips() {
    return this.publisherSpecs[be.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = v(this.adBreakXML, "ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
be.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let We = be;
class gi {
  constructor(e, t) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, t);
  }
  createAdSlotList(e, t) {
    let i = e.documentElement || e, r = b(i, ":scope > *");
    const s = [];
    for (const L of r)
      s.push(new We(L, t));
    this.adSlotList = s;
    let n = {}, l = [];
    const h = "Ad", A = "AdTagURI", C = "adtaguri", K = "allowMultipleAds", B = "sequence", J = "type", P = "VAST";
    for (let L = 0; L < r.length; L++) {
      let u = s[L];
      u.breakPosition === 2 && u.timeOffset !== null && (n[u.timeOffset] = (n[u.timeOffset] || 0) + 1, n[u.timeOffset] > 1 && (u.multiMidroll = !0, l.length === 0 && (this.adSlotList[L - 1].multiMidroll = !0, this.adSlotList[L - 1].adBreakXML.setAttribute(
        J,
        this.adSlotList[L - 1].adSource.type
      ), this.adSlotList[L - 1].adBreakXML.setAttributeNS(
        null,
        K,
        this.adSlotList[L].adSource.allowMultipleAds.toString()
      ), l.push(this.adSlotList[L - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[L].multiMidroll = !0, u.adBreakXML.setAttribute(J, this.adSlotList[L].adSource.type), u.adBreakXML.setAttributeNS(
        null,
        K,
        this.adSlotList[L].adSource.allowMultipleAds.toString()
      ), l.push(u.adBreakXML.cloneNode(!0))));
    }
    if (this.midrollHasSameTimeOffset) {
      let L = [];
      for (let c = 0; c < l.length; c++)
        if (l[c].getAttribute(J).includes(C)) {
          let S = document.createElementNS(null, h);
          S.setAttribute(B, (c + 1).toString());
          let O = document.createElementNS(null, "Wrapper");
          O.setAttributeNS(
            null,
            "fallbackOnNoAd",
            l[c].getAttribute(K)
          );
          let I = document.createElementNS(null, P + A);
          I.textContent = v(l[c], A).textContent.trim(), O.appendChild(I), S.appendChild(O), L.push(S);
        } else
          v(l[c], h).setAttribute(B, (c + 1).toString()), L.push(v(l[c], h));
      let u = null;
      for (let c = 0; c < this.adSlotList.length; c++) {
        if (!this.adSlotList[c].multiMidroll)
          continue;
        if (this.adSlotList[c].adBreakXML.hasAttribute(J) && this.adSlotList[c].adBreakXML.getAttribute(J).includes(C) && (u = document.createElementNS(null, P + "AdData")), v(this.adSlotList[c].adBreakXML, "Ad") || u) {
          if (u) {
            v(this.adSlotList[c].adBreakXML, "AdTagURI").remove();
            let O = v(this.adSlotList[c].adBreakXML, "AdSource");
            const I = document.createElementNS(null, "VAST");
            for (const _ of L)
              I.appendChild(_);
            u.appendChild(I), O.appendChild(u);
          } else {
            v(this.adSlotList[c].adBreakXML, "Ad").remove();
            const O = v(this.adSlotList[c].adBreakXML, "VAST");
            for (const I of L)
              O.appendChild(I);
          }
          this.adSlotList[c].multiMidroll = !1, this.adSlotList[c] = new We(this.adSlotList[c].adBreakXML, this.adSlotList[c].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((c) => {
        if (!c.multiMidroll)
          return c;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((t) => !t.hasError && t.adSource).shift();
  }
}
class Ne {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, t) {
    const i = this.listeners[e] || (this.listeners[e] = []);
    return i.includes(t) || i.push(t), () => {
      this.removeEventListener(e, t);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const t = this.listeners[e];
    if (!t)
      return;
    const i = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let r = 0; r < t.length; r++)
      t[r].call(this, i);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, t) {
    const i = this.listeners[e];
    return i && i.indexOf(t) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, t) {
    const i = this.listeners[e];
    if (i) {
      const r = i.indexOf(t);
      r !== -1 && i.splice(r, 1);
    }
  }
}
const f = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let At = null, pt = null, ye = 0, Wt = null, Et = null;
const ae = class ae {
  constructor(e, t) {
    this.enrichment = t, this.reasonData = null, e && e.homad && (Wt = e), this.enrichment.set("BLOCKED", ye, "blocked");
  }
  get isActive() {
    return ye === 1;
  }
  get vendorAPI() {
    return Et;
  }
  setVendorAPI(e) {
    !Et && e && (Et = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    pt = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    At = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, t) {
    if (o.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !Wt.homad.enabled) {
      let s = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      t(s);
      return;
    }
    if (!this.vendorAPI) {
      o.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, t);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let s = new Error("AdReinsertionModel: Fallback not activated.");
      s = f.SESSION.AD_REINSERTION_DECLINED, t(s);
      return;
    }
    if (!pt) {
      t("HOMAD corroboration callback not set.");
      return;
    }
    let i = this.reasonData.reason, r = this.reasonData;
    pt(i, r).then(() => {
      ye !== ae.STATUS.IS_BLOCKED ? At ? At(i).then((s) => {
        o.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          ae.STATUS.IS_BLOCKED,
          "blocked"
        ), ye = ae.STATUS.IS_BLOCKED, e();
      }).catch((s) => {
        o.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), t("AdReinsertion request declined by publisher.", s);
      }) : (o.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        ae.STATUS.IS_BLOCKED,
        "blocked"
      ), ye = ae.STATUS.IS_BLOCKED, e()) : (o.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (s) => {
      this.disable(), t("AdReinsertion request declined by HOMAD.", s);
    });
  }
  disable() {
    ye = 0, this.enrichment.set("BLOCKED", ae.STATUS.IS_OPEN, "blocked");
  }
};
ae.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, ae.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, ae.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, ae.EventDispatcher = new Ne();
let U = ae;
class te {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: te.screenHeight(),
      width: te.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return te.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !te.isIF() || te.isFIF();
  }
}
function Si() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function Ze(a) {
  return encodeURIComponent(a).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function Ti() {
  const a = /* @__PURE__ */ new Date(), e = a.toISOString();
  let t = a.getTimezoneOffset() / 60, i = t < 0 ? "-" : "+" + ("0" + Math.abs(t)).slice(-2);
  return e.replace("Z", i);
}
function vi(a, e, t) {
  if (a.indexOf(e) === -1)
    return a;
  {
    const i = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let r = /\d+/.test(a) ? parseInt(a.match(/\|(\d+)]/)[1], 10) : 0;
    return a.replace(
      i,
      r === 0 ? Ze(t) : Ze(t).substring(0, r)
    );
  }
}
function et(a) {
  let e = !Number.isFinite(a) || a < 0 ? 0 : a;
  const t = /* @__PURE__ */ new Date(0);
  return t.setSeconds(e), t.toISOString().substring(11, 19) + ".000";
}
function ri() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (a) => {
    let e = Math.random() * 16 | 0;
    return (a === "x" ? e : e & 3 | 8).toString(16);
  });
}
class ve {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], te.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], Si), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", et), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", te.userAgent(), "deviceua"), this.set("DOMAIN", te.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", te.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", et), this.set("OS", te.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.6.2", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      te.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", te.screenHeight(), "screenheight"), this.set("SCREENWIDTH", te.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", Ti), this.set("TRANSACTIONID", ri(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((t) => t.idRegistry + " " + t.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  getPlayerDimension(e) {
    var i;
    return ((i = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : i[e]) || 0;
  }
  getResolution(e) {
    const t = parseInt((e == null ? void 0 : e.width) || "0", 10), i = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${t},${i}`;
  }
  getMacros(e = !1) {
    let t = {};
    if (e)
      for (const [i] of this.macroMap)
        t[`[${i}]`] = this.get(i, !0);
    else
      for (const [i] of this.macroMap)
        t[i] = this.get(i, !0);
    return t;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, t, i, r) {
    let s = this.macroMap.get(e) || {}, n = i || s.macroList;
    return s.value = t, n ? Array.isArray(n) ? s.macroList = n : s.macroList = [n] : s.macroList = [e.toLowerCase()], r && (s.transform = r), this.macroMap.set(e, s), this;
  }
  get(e, t = !1) {
    if (!e)
      return null;
    let i = this.macroMap.get(e + "");
    if (!i)
      return null;
    let r = i.value;
    return i.transform && (r = i.transform(r)), t ? Array.isArray(r) ? r.map((s) => Ze(String(s))).join(",") : Ze(String(r)) : r;
  }
  setFromObject(e) {
    if (e)
      for (const t in e) {
        if (!Object.prototype.hasOwnProperty.call(e, t))
          continue;
        const i = e[t], r = typeof i == "string" && i.length === 0 || Array.isArray(i) && i.length === 0 ? "-1" : i;
        this.set(t.toUpperCase(), r, "");
      }
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    let t = e === null ? "" : String(e);
    for (const [i, r] of this.macroMap) {
      const s = String(this.get(i, !0));
      for (const n of r.macroList)
        t = this.replaceMacroWithValue(t, n, s);
    }
    return t;
  }
  replaceMacroWithValue(e, t, i) {
    let r = e.replace(this.getRegExp(t), i);
    return vi(r, "[" + t, i);
  }
  getRegExp(e) {
    let t = "[\\[](" + e + ")[\\]]";
    return new RegExp(t, "gi");
  }
}
class tt {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new tt().xdrRequest();
  }
  get(e, t, i) {
    if (this.xdrRequest()) {
      let r = new XMLHttpRequest();
      r.open("GET", e), r.timeout = t.timeout || 0, r.withCredentials = t.withCredentials !== !1, r.onload = () => {
        let s = new DOMParser().parseFromString(r.responseText, "text/xml");
        i(null, s);
      }, r.onerror = () => {
        i(new Error("Error loading the XML document"));
      }, r.send();
    } else
      i(new Error("XDomainRequest is not supported"));
  }
}
class Ri {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, t, i) {
    let r = !1;
    const s = t.timeouts.adRequest * 1e3, n = setTimeout(() => {
      r = !0;
      let C = new Error("ImageURLHandler: Tracking request timeout.");
      C.code = f.WARNING.TRACKER_TIMEOUT.code, C.description = f.WARNING.TRACKER_TIMEOUT.message, C.type = "AdWarning", i(C);
    }, s);
    let l = new Image();
    l.src = "";
    const h = () => {
      clearTimeout(n), !r && i(null);
    }, A = (C) => {
      h();
    };
    return l.onerror = A, l.onload = h, l.src = e, l;
  }
}
function wt(a) {
  if (typeof a != "string")
    return a;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(a, "text/xml");
  else if (ActiveXObject) {
    let t = new ActiveXObject("Microsoft.XMLDOM");
    t.loadXML(a), e = t;
  }
  return e;
}
const ft = " Response contains neither 'responseXML' nor 'responseText'", Y = class Y {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Y().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, t, i) {
    let r, s = i.timeouts.adRequest * 1e3, l = setTimeout(() => {
      r.onreadystatechange = r.onerror = () => {
        o.debug.info(Y.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let h = new Error(Y.NAME + ": Request timeout");
      h.code = f.WRAPPER.TIMEOUT.code;
      let A = i.timeouts ? i.timeouts.errorMessage : null;
      h.message = A || f.WRAPPER.TIMEOUT.message, i.adReinsertion.setReinsertionReason({
        reason: i.isWrapper ? U.REASON.WRAPPER_CHAIN_TIMEOUT : U.REASON.XHR_TIMEOUT,
        xhr: r,
        xhrError: h
      }), t(h, null);
    }, s);
    try {
      r = this.xhrRequest(), r.withCredentials = i.withCredentials !== !1, r.overrideMimeType && r.overrideMimeType("text/xml"), r.onreadystatechange = () => {
        if (r.readyState === 1) {
          r.send();
          return;
        }
        if (r.readyState === 4)
          if (clearTimeout(l), r.status === 200) {
            let h = r.responseXML;
            if (!h && r.responseText && (h = wt(r.responseText)), !h) {
              o.debug.info(Y.NAME + ft);
              let A = new Error(Y.NAME + ft);
              A.code = i.isWrapper ? f.WRAPPER.NO_RESPONSE.code : f.XML.INVALID_XML.code, A.message = "XHR Response Error:" + ft, i.adReinsertion.setReinsertionReason({
                reason: U.REASON.XHR_ERROR,
                xhr: r,
                xhrError: A
              }), t(A, null);
              return;
            }
            t(null, h);
          } else {
            r.onreadystatechange = r.onerror = () => {
              o.debug.info(Y.NAME + "Ignoring XHR state changes after status error", r.readyState, r.status, e);
            };
            let h = new Error(Y.NAME + r.statusText);
            h.code = i.isWrapper ? f.WRAPPER.TIMEOUT.code : f.XML.INVALID_XML.code, h.message = `XHR Status Error (${r.status}): ${r.statusText}`, i.adReinsertion.setReinsertionReason({
              reason: U.REASON.XHR_UNEXPECTED_STATUS,
              xhr: r,
              xhrError: h
            }), t(h, null);
          }
      }, r.open("GET", e), r.onerror = () => {
        clearTimeout(l), o.debug.info(Y.NAME + ": XHR Error.", r.readyState, r.status, e);
        let h = new Error(Y.NAME + r.statusText);
        h.code = f.WRAPPER.TIMEOUT.code, h.message = `XHR Error (${r.status}): ${r.statusText}`, i.adReinsertion.setReinsertionReason({
          reason: U.REASON.XHR_UNEXPECTED_STATUS,
          xhr: r,
          xhrError: h
        }), t(h, null);
      };
    } catch (h) {
      clearTimeout(l);
      let A = new Error(`${Y.NAME}: Request error.`);
      A.code = f.WRAPPER.TIMEOUT.code, A.message = `XHR Request Error: ${h}`, i.adReinsertion.setReinsertionReason({
        reason: U.REASON.XHR_ERROR,
        xhr: null,
        xhrError: A
      }), t(A, null);
    }
  }
  get(e, t, i) {
    o.debug.info(`${Y.NAME}: XHR get with timeout ${i.timeouts.adRequest} sec: ${e}`), i.issuer && i.issuer === Y.ISSUER.TRACKING ? Ri.getAsImage(e, i, t) : this.getAsXHR(e, t, i);
  }
};
Y.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Y.NAME = "XHRURLHandler";
let Ee = Y;
Ee.DEFAULT_TIMEOUT = 4;
function it(a, e) {
  if (a.indexOf("//") === 0) {
    let t = location.protocol;
    return (t === "about:" || t === "file:") && (t = "https:"), t + a;
  }
  return a.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + a : a;
}
const je = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class kt {
  constructor() {
    this.issuer = Ee.ISSUER.TAG;
  }
  get(e, t, i) {
    if (!t)
      return null;
    let r = i, s = e;
    r || (r = je, r.enrichment = new ve()), r.issuer = this.issuer, r.enrichment = r.enrichment || new ve(), s = r.enrichment.apply(s), s && s.indexOf("//") === 0 && (s = it(s, ""));
    let n = r.urlhandler;
    if (r.response) {
      let l = r.response;
      t(null, wt(l));
    } else return n && n.supported() ? new n().get(s, t, r) : Ee.supported() ? new Ee().get(s, t, r) : tt.supported() ? new tt().get(s, t, r) : t();
    return null;
  }
}
const Be = class Be extends kt {
  constructor() {
    super(), this.issuer = Ee.ISSUER.TRACKING;
  }
  track(e, t, i) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, t, i) : o.debug.info(Be.NAME + "track - without trackers:", e);
  }
  getMultiple(e, t, i) {
    for (const r of e)
      r.requested = !0, r.url && super.get(r.url, (t || this.onResponse).bind(this, r), i);
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, t) {
    t && o.debug.warn(Be.NAME + "onResponse failed:", t.name, t, e);
  }
};
Be.NAME = "TrackingUrlHandler::";
let rt = Be;
const d = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup",
  // HOMAD
  ON_HOMAD_PENALTY: "HOMADPenalty"
}, Me = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, Pe = class Pe {
  constructor(e, t, i) {
    this.player = t, this.config = i, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, Pe.ERROR_CODE_MAP[f.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, Pe.ERROR_CODE_MAP[f.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, t = {}) {
    e.requested = !0, o.debug.info(
      G.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = t;
    const i = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let r = {};
    return r.adBreakPosition = e.breakPosition, r.type = e.type, r[i] = e.adSource.source, r = Object.assign(r, e.separationClips), this.currentAdBreak.enrichment = new ve(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new U(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((s, n) => {
      this.adSlotAPI.initAdSlot(r, t).then(() => {
        o.debug.info(
          G.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), s(e);
      }).catch((l) => {
        o.debug.warn(G.NAME + "initAdSlot - Could not init ad slot", l), n(l);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    o.debug.info(
      G.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(d.ON_AD_SLOT_START, () => {
        this.trackEvent(Me.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(d.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(Me.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(d.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(d.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Pe.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(Me.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(d.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(Me.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), o.debug.info(
      G.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    o.debug.info(
      G.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  trackEvent(e) {
    let t = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(t);
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      o.debug.info(
        G.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const t = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new rt().track(e, (i, r) => {
      r && o.debug.warn(G.NAME + "callTrackers - failed:", r, i);
    }, t);
  }
};
Pe.ERROR_CODE_MAP = {}, Pe.NAME = "AdBreakCtrl::";
let Tt = Pe;
const re = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, mt = "Content - Scan for AdBreaks to play", F = class F extends Ne {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, t) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = t, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((i) => {
      if (i.timeOffset === "end")
        return i;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(d.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(d.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(d.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, o.debug.info(
      F.NAME + "before" + mt + "."
    ), super.dispatchEvent(d.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      o.debug.info(
        F.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(d.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), o.debug.info(
      F.NAME + "start" + mt + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, o.debug.info(
      F.NAME + "after" + mt + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset) {
      this.isSeeking = !1, this.postroll = null;
      for (const r of this.adPlaylist)
        r.timeOffset !== "end" && (r.requested = !0);
      this.requestAdBreak(e);
    }
    if (this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let t = this.find(e), i = t.shift();
    for (const r of t)
      r.requested = !0;
    return i && this.playableAdBreaks.length && (i.requested = !0), new Promise((r, s) => {
      i && !i.requested ? (this.adBreakController = new Tt(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(i, this.player.getEnvironmentVars(i.type)).then((n) => {
        o.debug.info(
          F.NAME + "requestAdBreak - Initialized AdBreak",
          n.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(n), r();
      }).catch((n) => {
        o.debug.warn(
          F.NAME + "requestAdBreak - Failed to initialize ",
          i.timeOffset,
          n
        ), s(n);
      })) : s(
        F.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      F.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), o.debug.info(F.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const t = e;
    return this.adPlaylist.filter((i) => {
      if (i.requested)
        return !1;
      let r = t;
      return i.prefetchOffset > 0 && (r += i.prefetchOffset), this.isExecutableAdBreak(i, r);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, t, i = F.PROCESS.REQUEST) {
    function r(n, l) {
      var A;
      const h = n - l;
      return (A = e.publisherSpecs) != null && A.strictOffsets ? h >= 0 && h <= F.STRICT_OFFSET_THRESHOLD : h >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const n = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return r(t, n);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && i === F.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && i === F.PROCESS.REQUEST)
      return t - this.contentDuration >= 0;
    const s = Re(e.timeOffset);
    return s !== null && r(t, s);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const i = this.player.getContentCurrentTime() + e.repeatAfter;
    let r = e.adBreakXML.cloneNode(!0);
    r.setAttribute("timeOffset", et(i)), this.adPlaylist.push(new We(r, e.publisherSpecs)), o.debug.info(
      F.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), t = 0, i = 0;
    this.addPlayerEventListener(re.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const r = this.player.getContentCurrentTime(), s = r - t, n = (Date.now() - e) / 1e3;
      s > n + 0.075 || s > 2 ? (this.isSeeking = !0, i = 0) : i >= F.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), i = Math.min(
        i + 1,
        F.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), t = r, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(re.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), o.debug.info(
      F.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    o.debug.info(
      F.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, t) {
    this.player.addEventListener(e, t);
    const i = () => this.removePlayerEventListener(e, t);
    return this.eventHandlers.push(i), i;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, t) {
    this.player.removeEventListener(e, t);
  }
};
F.NAME = "AdPlaylistCtrl::", F.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, F.STRICT_OFFSET_THRESHOLD = 2, F.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let G = F;
const Ni = "HomadXHRUrlHandler", jt = ": Response contains neither 'responseXML' nor 'responseText'", we = class we {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new we().xhrRequest();
  }
  getAsXHR(e, t, i) {
    function r(h) {
      t(h, null);
    }
    function s(h) {
      if (i.issuer && i.issuer === Ee.ISSUER.TRACKING) {
        t(null, null);
        return;
      }
      let A = h.responseXML;
      if (!A && h.responseText && (A = wt(h.responseText)), !A) {
        let C = new Error(Ni + jt);
        C.code = f.XML.INVALID_XML.code, C.description = "HOMAD Response Error" + jt, t(C, null);
        return;
      }
      t(null, A);
    }
    if (!i.adReinsertion) {
      let h = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      h.code = f.WRAPPER.TIMEOUT.code, h.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", r(h);
      return;
    }
    const n = i.adReinsertion.vendorAPI.stuffAdTag(e);
    let l = i.adReinsertion.vendorAPI.getUrlRequest(n);
    l.data.homad_macros = JSON.stringify(i.enrichment.getIABMacroList()), o.debug.info(
      we.NAME + "getAsXHR - Provide VAST Macro List" + l.data.homad_macros
    ), i.adReinsertion.vendorAPI.loadFile(l, (h) => {
      s(h);
    }, (h) => {
      let A, C = "HOMADUtils XHR";
      h.timedOut ? (A = new Error("HomadUtilsURLHandler: Request timeout."), A.code = f.WRAPPER.TIMEOUT.code, A.description = `${C} Timeout Error ${i.timeouts.errorMessage || f.WRAPPER.TIMEOUT.message}`) : (A = new Error("HomadUtilsURLHandler: " + h.statusText), A.code = f.XML.INVALID_XML.code, A.description = `${C} Status Error (${h.status}): ${h.statusText}`), r(A);
    }, !1, !1, !1, i.timeouts.adRequest * 1e3);
  }
  get(e, t, i = {}) {
    i.timeouts || (i.timeouts = je.timeouts), o.debug.info(`${we.NAME}: Get with timeout ${i.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, t, i);
  }
};
we.NAME = "HomadUrlHandler::";
let st = we;
function si(a) {
  return window.location.protocol === "https:" && !a.startsWith("http://") || window.location.protocol !== "https:";
}
function oe(a, e) {
  let t = document.createElement("ParserError");
  t.setAttribute("code", e.code.toString()), t.setAttribute("message", e.message), a.appendChild(t);
}
const qe = class qe {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, t) {
    this.callbackLoadingDone = t, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, t) {
    if (o.debug.info(qe.NAME + "requestURL", e), this.callbackLoadingDone = t, this.isInsecureURL(e)) {
      let i = document.createDocumentFragment();
      return oe(i, f.SESSION.MIXED_CONTENT), this.returnVMAP(i);
    }
    return this.loadURL(e).then((i) => {
      this.returnVMAP(i);
    });
  }
  returnVMAP(e) {
    let t = e, i = document.createDocumentFragment();
    b(e, "VMAP").length > 0 && b(e, "AdBreak").length === 0 && (oe(i, f.VMAP.NO_ADBREAKS), t = i), b(e, "VMAP").length === 0 && b(e, "ParserError").length === 0 && (oe(i, f.VMAP.DOCUMENT_ERROR), t = i), this.callbackLoadingDone(t);
  }
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((t) => {
      new kt().get(e, (i, r) => {
        if (!i && r && v(r, "parsererror")) {
          let s = document.createDocumentFragment();
          oe(s, f.VMAP.EXTRACTION_ERROR), t(s);
        }
        if (i && !r) {
          let s = document.createDocumentFragment();
          o.debug.warn(qe.NAME + "loadURL - XHR Request Error", i), oe(s, i), t(s);
        } else
          t(r);
      }, this.urlHandlerOptions);
    });
  }
  isInsecureURL(e) {
    return this.blockInsecureURL && !si(e);
  }
};
qe.NAME = "VMAPReqService::";
let vt = qe;
function ni(a) {
  if (!a || typeof a != "object")
    return !1;
  try {
    return a.self === a;
  } catch (e) {
    return !0;
  }
}
function Ve(a, ...e) {
  for (const t of e)
    if (t)
      for (const i in t)
        Object.prototype.hasOwnProperty.call(t, i) && t[i] !== null && (ni(t[i]) ? a[i] = t[i] : typeof a[i] == "object" && typeof t[i] == "object" ? a[i] = Ve(a[i], t[i]) : a[i] = t[i]);
  return a;
}
function ai() {
  return this.error || null;
}
function he(a) {
  this.error = {
    code: a.code,
    message: a.message,
    timestamp: Date.now()
  };
}
let Kt = null;
const Ft = class Ft extends Ne {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, t) {
    super(), this.player = e, this.config = t.config, o.debug.info(G.NAME + "Create AdPlaylistAPI with", t.config), this.environmentVars = t.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = t, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, t = {}) {
    this.environmentVars = Object.assign(this.environmentVars, t), o.debug.info(G.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = Ve(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let i = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const r = this.adSlotAPI.setupEnrichmentAndTCF();
    Kt = new U(this.config.adReinsertion, r);
    const s = {
      adReinsertion: Kt,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: r,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: Ve({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((n, l) => {
      i = this.addEventListener(d.ON_AD_PLAYLIST_LOAD_ERROR, () => l(this.errorAPI)), this.addEventListener(d.ON_AD_PLAYLIST_LOADED, () => (i(), this.adPlaylistController = new G(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), n("ok")));
      let h = new vt(
        s
      );
      e.tag ? h.requestURL(e.tag, this.onXMLLoadDone.bind(this, s)) : h.requestXML(s.response, this.onXMLLoadDone.bind(this, s));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  onXMLLoadDone(e, t) {
    this.rawVMAPXML = t, this.adPlaylist = new gi(t, this.vmapSetup);
    let i = this.adPlaylist.getAdPlaylist();
    o.debug.info(G.NAME + "onXMLLoadDone and vmap parsed.", t), o.debug.table(i);
    const r = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const s = v(t, "ParserError"), n = s ? {
          code: parseInt(s.getAttribute("code"), 10),
          message: s.getAttribute("message")
        } : this.error = f.VMAP.NO_ADBREAKS;
        he.call(this, n), super.dispatchEvent(d.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(d.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      o.debug.info(
        G.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), o.debug.info(
            G.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = st, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            r();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (s) => {
          o.debug.info(G.NAME + "enable - AdReinsertion remains disabled.", s), he.call(this, s), r();
        }
      );
      return;
    }
    r();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    super.dispatchEvent(d.ON_AD_PLAYLIST_START);
    for (const e of Object.values(d))
      this.adPlaylistController.addEventListener(e, (t) => {
        super.dispatchEvent(t.type);
      });
    return new Promise((e, t) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (i) => {
          t(i);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return ai.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
Ft.NAME = "AdPlaylAPI::";
let Rt = Ft;
var H = /* @__PURE__ */ ((a) => (a.CLOSER = "closer", a.DIVIDER = "divider", a.OPENER = "opener", a.COMMERCIAL = "commercial", a.SPONSORED = "sponsored", a))(H || {});
class Oi {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let t = this.adSlotManifest[e];
      !t.isLinear || t.variant !== H.COMMERCIAL || this.totalCommercialsDurationArray.push(t.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, t) => e + t) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, t) => e + t)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, t) => e + t);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const M = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, le = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, ue = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, ne = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, Xe = class Xe extends o {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.resolutionListeners = {}, this.eventsThatRequireResponse = [
      M.CLICK_THRU,
      M.GET_MEDIA_STATE,
      M.READY,
      M.REPORT_TRACKING,
      M.REQUEST_CHANGE_AD_DURATION,
      M.REQUEST_FULL_SCREEN,
      M.REQUEST_PAUSE,
      M.REQUEST_PLAY,
      M.REQUEST_RESIZE,
      M.REQUEST_SKIP,
      M.REQUEST_STOP,
      M.REQUEST_VIDEO_LOCATION,
      M.REQUEST_VOLUME,
      ue.AD_SKIPPED,
      ue.AD_STOPPED,
      ue.FATAL_ERROR,
      ue.INIT,
      ue.START_CREATIVE,
      ne.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, t) {
    const i = this.nextMessageId++, r = e === ne.CREATE_SESSION ? e : "SIMID:" + e, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: r,
      timestamp: Date.now(),
      args: t
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((n, l) => {
      this.addResolveRejectListener(i, n, l), this.target.postMessage(JSON.stringify(s), "*");
    }) : new Promise((n) => {
      this.target.postMessage(JSON.stringify(s), "*"), n();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, t) {
    this.listeners[e] ? this.listeners[e].push(t) : this.listeners[e] = [t];
  }
  isResolve(e) {
    return e.type === ne.RESOLVE;
  }
  addResolveRejectListener(e, t, i) {
    const r = (s) => {
      this.isResolve(s) ? t(s.args.value) : i(s.args.value);
    };
    this.resolutionListeners[e] = r.bind(this);
  }
  parseData(e) {
    try {
      return JSON.parse(e);
    } catch (t) {
      return null;
    }
  }
  callListeners(e, t) {
    const i = this.listeners[e];
    if (i)
      for (let r = 0; r < i.length; r++)
        i[r](t);
  }
  // eslint-disable-next-line complexity
  isValidSession(e) {
    const t = e.sessionId, i = e.type, r = this.sessionId === "" && i === ne.CREATE_SESSION, s = this.sessionId === t;
    if (!(!(r || s) || i === null)) {
      if (Object.values(ne).includes(i))
        this.handleProtocolMessage(e);
      else if (i.startsWith("SIMID:")) {
        const l = i.substring(6);
        this.callListeners(l, e);
      }
    }
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let t = this.parseData(e.data);
    t && this.isValidSession(t);
  }
  handleProtocolMessage(e) {
    const t = e.type;
    switch (t) {
      case ne.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {}), this.callListeners(t, e);
        break;
      case ne.RESOLVE:
      // intentional fallthrough
      case ne.REJECT:
        const r = e.args.messageId, s = this.resolutionListeners[r];
        s && (s(e), delete this.resolutionListeners[r]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, t) {
    const i = this.nextMessageId++, r = {
      messageId: e.messageId,
      value: t
    }, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: ne.RESOLVE,
      timestamp: Date.now(),
      args: r
    };
    this.target.postMessage(JSON.stringify(s), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, t) {
    const i = this.nextMessageId++, r = {
      messageId: e.messageId,
      value: t
    }, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: ne.REJECT,
      timestamp: Date.now(),
      args: r
    };
    this.target.postMessage(JSON.stringify(s), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      o.debug.info(Xe.NAME + "createSession resolve");
    }, t = () => {
      o.debug.info(Xe.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(ne.CREATE_SESSION, {}).then(
      e,
      t
    );
  }
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let t = "", i;
    for (i = 0; i < 16; i++)
      t += (i === 4 || i === 6 || i === 8 || i === 10 ? "-" : "") + e[i].toString(16);
    this.sessionId = t;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
Xe.NAME = "SIMIDPtl::";
let Nt = Xe;
function Te(a, e) {
  let t = document.createElement(a);
  if (e)
    for (const i in e)
      Object.prototype.hasOwnProperty.call(e, i) && t.setAttribute(i, e[i]);
  return t;
}
const Je = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, Gt = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Le = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, xe = 0, gt = -2, Ii = !0, ee = class ee {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new Nt(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = xe, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((t) => {
      this.resolveSessionCreatedPromise = t;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = xe, this.nonLinearDimensions = null, this.initializationPromise = new Promise((t, i) => {
      this.resolveInitializationPromise = t, this.rejectInitializationPromise = i;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      o.debug.info(
        ee.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = Te("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    if (o.debug.info(ee.NAME + "createSimidIframe with", this.creativeAsset), e.style.display = "none", this.container.appendChild(e), this.creativeAsset.resource) {
      const t = new Blob([this.creativeAsset.resource], { type: "text/html" });
      e.src = URL.createObjectURL(t);
    } else
      e.src = this.creativeAsset.fileURL;
    return this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  addListeners() {
    this.simidProtocol.addListener(ne.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(M.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(M.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(M.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(M.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(M.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(M.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(M.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      M.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(M.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(M.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(M.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(M.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(M.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, t] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, t);
    this.videoTrackingEvents.clear();
  }
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  isValidDimensions(e) {
    const t = this.playerFacade.getPlayerSize().boundingRect, i = e.y + e.height <= t.height, r = e.x + e.width <= t.width;
    return i && r;
  }
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      o.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  setIFrameDimensions(e) {
    o.debug.info(ee.NAME + "resize", e), this.IFrame.style.height = e.height.toString(), this.IFrame.style.width = e.width.toString(), this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(d.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, t) {
    this.simidProtocol.reject(e, t);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const t = {
        errorCode: Je.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, t), o.debug.info(t.message);
    } else {
      const t = this.getFullDimensions();
      this.setIFrameDimensions(t), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const t = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const i = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, i), o.debug.info(i.message);
    } else if (this.isValidDimensions(t))
      this.setIFrameDimensions(t), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const i = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, i), o.debug.info(i.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let t = "onRequestResize - error:";
    if (this.isLinearAd) {
      const i = {
        errorCode: Je.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), o.debug.error(ee.NAME + t, i.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const i = {
        errorCode: Je.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, i), o.debug.error(ee.NAME + t, i.message);
    }
  }
  sendInitMessage() {
    const e = this.getFullDimensions(), t = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), i = {
      videoDimensions: e,
      creativeDimensions: t,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, r = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (r.duration = this.currentAd.duration);
    const s = {
      environmentData: i,
      creativeData: r
    };
    this.simidProtocol.sendMessage(ue.INIT, s).then(() => {
      this.resolveInitializationPromise(), o.debug.info(ee.NAME + "session created");
    }).catch((l) => {
      this.rejectInitializationPromise(l);
    });
  }
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(d.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), o.debug.info(ee.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(ue.START_CREATIVE);
  }
  onAdInitializedFailed(e) {
    this.setError(f.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(d.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), o.debug.error(ee.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  setCreativeControlsState(e) {
    let t = b(document, ".ad_request");
    if (t)
      for (let i of t)
        i.disabled = e;
  }
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        le.ERROR,
        {
          error: f.SIMID.GENERAL_ERROR.code,
          message: f.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = f.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(le.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(le.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(le.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(le.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(le.SEEKING);
    }), this.videoTrackingEvents.set(re.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        le.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        le.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Le.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        le.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, t] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, t);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Le.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(ue.AD_STOPPED).then(() => {
      o.debug.info(ee.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(ue.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(d.ON_AD_SKIPPED), this.loadedSource = null;
  }
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(Ii), this.adSlotController.dispatchEvent(d.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    o.debug.info(ee.NAME + "onReqFullScreen", e);
    let t;
    this.IFrame && (t = this.IFrame.requestFullscreen);
    let i = t == null ? void 0 : t();
    i ? i.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const t = {
          errorCode: Gt.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, t);
      });
    } else {
      const t = {
        errorCode: Je.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, t);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Le.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Le.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const t = e.args.trackingUrls;
    o.debug.info(ee.NAME + "onReportTracking -  Creative has asked the player to send a ping."), o.debug.table(t);
  }
  videoComplete() {
    if (this.simidProtocol.sendMessage(le.ENDED), this.requestedDuration === xe && this.stopAd(Le.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== xe && this.requestedDuration !== gt) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Le.CREATIVE_INITIATED);
      }, e);
    }
  }
  onReqChangeAdDuration(e) {
    const t = e.args.duration;
    if (t !== gt && t < 0) {
      const i = {
        errorCode: Gt.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, i);
    } else
      this.requestedDuration = t, this.compareAdAndReqDurations(), this.resolve(e);
  }
  compareAdAndReqDurations() {
    this.requestedDuration === xe || this.requestedDuration === gt || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (o.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Le.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const t = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, t);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const t = {
      message: e
    };
    this.simidProtocol.sendMessage(ue.LOG, t);
  }
};
ee.NAME = "SIMIDPly::";
let Ot = ee;
function Yt(a) {
  return a.height >= 0 ? a.y + a.height : a.y;
}
function zt(a) {
  return a.width >= 0 ? a.x : a.x + a.width;
}
function Qt(a) {
  return a.width >= 0 ? a.x + a.width : a.x;
}
function $t(a) {
  return a.height >= 0 ? a.y : a.y + a.height;
}
function Ci(a, e) {
  let t = 0, i = {
    bottom: Math.min(Yt(a), Yt(e)),
    height: 0,
    left: Math.max(zt(a), zt(e)),
    right: Math.min(Qt(a), Qt(e)),
    top: Math.max($t(a), $t(e)),
    width: 0
  };
  i.width = i.right - i.left, i.height = i.bottom - i.top;
  let r = a.width * a.height, s = i.width * i.height;
  return s > 0 && (t = s / r), t;
}
class Di {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   */
  constructor(e) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(d)) {
      let t = this.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(t);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case d.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case d.ON_AD_PLAYBACK_START:
      case d.ON_AD_PLAYING:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case d.ON_AD_PLAYBACK_FINISHED:
      case d.ON_AD_SKIPPED:
      case d.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(d.ON_AD_NOT_VIEWABLE)), this.removeEventListeners(), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.adSlotController.player.getPlayerSize(), t = this.adSlotController.player.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || t.boundingRect.height === 0 && t.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(d.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let i = Ci(e.boundingRect, t.boundingRect) * 100;
    i > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: i
    }, this.adSlotController.dispatchEvent(d.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (o.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(d.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: i
    }, this.adSlotController.dispatchEvent(d.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function Li(a, e, t) {
  return new Promise((i) => {
    let r = Te("iframe", {
      id: a,
      style: e
    });
    r.onload = () => {
      let s = Te("script", {
        type: "text/javascript"
      });
      s.innerHTML = "var inDapIF = true;", r.contentDocument.body.appendChild(s);
      let n = Te("style", {});
      n.innerHTML = "html,body{margin:0;}", r.contentDocument.body.appendChild(n), i(r);
    }, t.insertBefore(r, t.firstChild);
  });
}
const R = class R extends Ne {
  // ms
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, t) {
    super(), this.callbacks = null, this.currentAd = t, this.config = t.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = o.logLevel === ce.NORMAL || o.logLevel === ce.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = t.isLinear ? t.properCreative.selectedMediaFile : t.properCreative.variations[0], this.slot = Te("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.timeoutAdLoadedTimer = null, this.timeoutScriptLoadTimer = null, this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), Li(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((i) => {
      this.friendlyIFrame = i, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = Te("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = Te("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = Te("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      o.debug.warn(R.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = f.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest);
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), o.debug.info(
      R.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (o.debug.info(R.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", t = parseInt(e.split(".")[0], 10);
      return o.debug.info(
        R.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        t
      ), o.debug.info(
        R.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), t <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), o.debug.info(
      R.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), o.debug.info(
      R.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    o.debug.info(R.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = f.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest);
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    o.debug.info(R.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = f.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness);
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, o.debug.info(R.NAME + "cleanup"), this.dispatchEvent(d.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    o.debug.info(R.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(d.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    o.debug.info(R.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    o.debug.info(R.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    o.debug.info(R.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, t, i) {
    o.debug.info(R.NAME + "resizeAd", e, t, i), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, t, i);
  }
  onStartAd() {
    o.debug.info(R.NAME + "onStartAd"), this.dispatchEvent(d.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression() {
    o.debug.info(R.NAME + "onAdImpression"), this.dispatchEvent(d.ON_AD_IMPRESSION);
  }
  onAdVideoStart() {
    o.debug.info(R.NAME + "onAdVideoStart"), this.dispatchEvent(d.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), R.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (o.debug.warn(R.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, R.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile() {
    o.debug.info(R.NAME + "onAdVideoFirstQuartile"), this.dispatchEvent(d.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint() {
    o.debug.info(R.NAME + "onAdVideoMidpoint"), this.dispatchEvent(d.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile() {
    o.debug.info(R.NAME + "onAdVideoThirdQuartile"), this.dispatchEvent(d.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete() {
    o.debug.info(R.NAME + "onAdVideoComplete"), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.dispatchEvent(d.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange() {
    o.debug.info(R.NAME + "onAdDurationChange"), this.getAllProperties();
  }
  onStopAd() {
    o.debug.info(R.NAME + "onStopAd"), this.dispatchEvent(d.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, t) {
    o.debug.info(R.NAME + "onAdError", e, t), this.currentAd.error = this.currentAd.error === null ? f.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(d.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd() {
    this.dispatchEvent(d.ON_AD_SKIPPED), o.debug.info(R.NAME + "onSkipAd"), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(d.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && o.debug.info(
      R.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(d.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange() {
    o.debug.info(R.NAME + "onAdExpandedChange");
  }
  onAdSkippableStateChange() {
    o.debug.info(R.NAME + "onAdSkippableStateChange"), this.dispatchEvent(d.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(d.ON_AD_PROGRESS);
  }
  onAdVolumeChange() {
    o.debug.info(R.NAME + "onAdVolumeChange");
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, t = null, i = !1) {
    o.debug.info(R.NAME + "onAdClickThru - creative handles click", !i), i === !0 && (o.debug.info(R.NAME + "onAdClickThru - open landing page", e, t), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = i), this.dispatchEvent(d.ON_AD_CLICKED);
  }
  onAdInteraction(e) {
    o.debug.info(R.NAME + "onAdInteraction", e);
  }
  onAdUserAcceptInvitation() {
    o.debug.info(R.NAME + "onAdUserAcceptInvitation");
  }
  onAdUserMinimize() {
    o.debug.info(R.NAME + "onAdUserMinimize");
  }
  onAdUserClose() {
    o.debug.info(R.NAME + "onAdUserClose");
  }
  onAdPaused() {
    o.debug.info(R.NAME + "onAdPaused");
  }
  onAdPlaying() {
    o.debug.info(R.NAME + "onAdPlaying"), this.dispatchEvent(d.ON_AD_PLAYING);
  }
  onAdLog(e) {
    o.debug.info(R.NAME + "onAdLog", e);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let t in e)
      e.hasOwnProperty(t) && e[t].indexOf("getAd") === 0 && o.debug.info(
        R.NAME + "--vpaidAd." + e[t] + "()",
        this.vpaidAd[e[t]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, t, i) => {
      t === 0 ? e.delta = 0 : e.delta = i[t].time - i[t - 1].time;
    }), o.debug.table(this.debugTiming));
  }
  //Debug -- End
};
R.NAME = "VPAIDBridge::", R.TIMEUPDATE_INTERVAL = 250;
let It = R;
const Ke = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  //  and it's used in canPlayType, text/html can't be played it's only used for interactive actions.
  VPAID: "application/javascript",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, ie = class ie extends Ne {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot.
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads.
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {FacadePlayer} player - Facade interface for the player.
   */
  constructor(e, t, i, r) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = ie.VIEW_MODE.NORMAL, this.environmentVars = i, this.eventCallbacks = [], this.eventKeys = Object.keys(d), this.eventTypes = Object.values(d), this.nonLinearView = null, this.player = r, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, t);
  }
  hasOffsetReached(e, t, i) {
    let r = i.offset;
    return typeof r == "string" && r.indexOf("%") > -1 && (r = parseInt(r, 10) / 100 * t), e >= parseInt(r, 10) && !i.requested;
  }
  prepare(e, t) {
    this.manifest = e.slice(0), this.buffet = (t || []).slice(0), this.adSlotTimes = new Oi(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(Ke)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [H.COMMERCIAL, H.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new Di(this));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    for (const t of this.eventCallbacks)
      t();
    this.eventCallbacks = [];
    for (const t of Object.values(d)) {
      const i = this.addEventListener(t, (r) => {
        this.trackEvent(r.type);
      });
      this.eventCallbacks.push(i);
    }
    if (this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let t = null;
      const i = new Promise((s) => {
        t = setTimeout(s, 250, null);
      }), r = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[r].length) {
        let s = this.currentAd.isLinear ? this.currentAd.properCreative[r] : this.currentAd.properCreative[r][0].resources;
        const n = this.currentAd.config.adSourceSelector(
          s
        ).then((l) => l === null || Object.keys(l).length === 0 ? null : l);
        Promise.race([i, n]).then((l) => {
          l === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = l : this.currentAd.properCreative.selectedResource = l, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(t), this.cancelAd();
    } else {
      this.updateAdSettings();
      const t = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, t);
    }
    const e = this.addEventListener(d.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, o.debug.info(ie.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === H.COMMERCIAL) {
        let t = e.duration;
        this.currentAd.isLinear || (t += this.currentAd.duration), o.debug.info(
          ie.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          t
        ), this.adSlotTimes.setTotalCommercialsDuration(t), this.setTotalCommercialsDuration(), o.debug.info(ie.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      o.debug.info(ie.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const t = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let i = this.currentAd;
    new rt().track(e, (r, s) => {
      s && (o.debug.warn(ie.NAME + "callTrackers failed:", s, r), i.error = s.code ? s : f.WARNING.TRACKER_LOAD_FAILED, i.error.message = `${i.error.message}: ${JSON.stringify(r)}`, this.dispatchEvent(d.ON_AD_WARNING));
    }, t);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === V.NON_LINEAR) {
      this.currentAd.error = f.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(d.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = f.VAST.UNSUPPORTED_MIMETYPE), o.debug.info(ie.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(d.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(d.ON_AD_CLICKED);
    let t = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (t && t.indexOf("//") === 0 && (t = it(t, "")), !e) {
      const i = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(t, i);
    }
    return t;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let t = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(t);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(d.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, t) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let i = this.currentAd.adVerifications.filter((n) => n.vendor === e)[0];
      if (!i || !i.tracking.verificationNotExecuted)
        return;
      let r = i.tracking.verificationNotExecuted, s = parseInt(t, 10);
      t && isFinite(s) && s >= 1 && s <= 3 && this.currentAd.enrichment.set("REASON", s), r && r.length > 0 && this.callTrackers(r);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === H.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      o.debug.info(ie.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(d.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(d.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(d.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, t) {
    if (!this.currentAd.icons[e])
      return null;
    let i = this.currentAd.icons[e].clickTracker;
    this.callTrackers(i);
    let r = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!t) {
      const s = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(r, s);
    }
    return r;
  }
  onResizeAd(e, t) {
    this.currentAd && (t !== this.currentViewMode && (this.currentViewMode = t, t === ie.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(d.ON_ENTER_FULLSCREEN), this.dispatchEvent(d.ON_PLAYER_EXPAND)) : (this.dispatchEvent(d.ON_EXIT_FULLSCREEN), this.dispatchEvent(d.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, t) : this.dispatchEvent(d.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === H.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(d.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", et(e)), this.currentAd.variant === H.COMMERCIAL) {
        const t = this.adDuration - this.currentAd.duration;
        if (t && Number.isFinite(t)) {
          let i = t;
          this.currentAd.isLinear || (i = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(i);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [H.COMMERCIAL, H.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((r) => {
          this.hasOffsetReached(e, this.adDuration, r) && this.dispatchEvent(d.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let t = [], i = [];
        e >= this.adDuration && t.push(d.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && t.push(d.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && t.push(d.ON_AD_MID_POINT), e >= this.adDuration / 4 && t.push(d.ON_AD_FIRST_QUARTILE), e && t.push(d.ON_AD_PLAYBACK_START), i.push(t[0]), this.currentAd.config.trackSkippedQuartiles && (i = t);
        for (let r = i.length - 1; r >= 0; r--)
          this.requestedTrackingEvents.filter((n) => n === i[r]).shift() || (this.dispatchEvent(i[r]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(i[r]));
      }
    }
  }
  trackEvent(e) {
    const t = this.eventKeys[this.eventTypes.indexOf(e)], i = Me[t], r = this.player.getAdCurrentTime(), s = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[i]) {
      let n = this.currentAd.trackingEvents[i];
      e === d.ON_AD_PROGRESS && (n = n.filter((l) => this.hasOffsetReached(r, s, l))), this.callTrackers(n);
    }
  }
  loadAdSIMID() {
    this.currentAd.properCreative.selectedCreativeFile.fileURL === "" && this.currentAd.properCreative.selectedCreativeFile.resource === null ? (this.currentAd.error = f.SIMID.GENERAL_ERROR, this.cancelAdWithError()) : (this.simidPlayer = new Ot(this), this.simidPlayer.initializeAd());
  }
  loadAdVPAID() {
    this.vpaidPlayer = new It(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      d.ON_AD_CLICKED,
      d.ON_AD_LOADED,
      d.ON_AD_STARTED,
      d.ON_AD_IMPRESSION,
      d.ON_AD_PLAYING,
      d.ON_AD_PLAYBACK_START,
      d.ON_AD_FIRST_QUARTILE,
      d.ON_AD_MID_POINT,
      d.ON_AD_THIRD_QUARTILE,
      d.ON_AD_PLAYBACK_FINISHED,
      d.ON_AD_STOPPED,
      d.ON_AD_SKIPPED,
      d.ON_AD_ERROR,
      d.ON_AD_PROGRESS,
      d.ON_AD_SIZE_CHANGED,
      d.ON_AD_SKIPPABLE_STATE_CHANGE,
      d.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (t) => this.vpaidEventHandler(t));
      }
    ) : [
      d.ON_AD_LINEARITY_CHANGE,
      d.ON_AD_SKIPPED,
      d.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (t) => this.nonLinearVpaidEventHandler(t));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case d.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (o.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case d.ON_AD_SKIPPED:
        case d.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let t;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case d.ON_AD_LOADED:
      //onStartAd
      case d.ON_AD_STARTED:
      //onStartAd
      case d.ON_AD_IMPRESSION:
      case d.ON_AD_PLAYING:
      //onAdPlaying()
      case d.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case d.ON_AD_FIRST_QUARTILE:
      case d.ON_AD_MID_POINT:
      case d.ON_AD_THIRD_QUARTILE:
      case d.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case d.ON_AD_CLICKED:
        t = !this.currentAd.handleClickThrough, this.onClickThrough(t);
        break;
      case d.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case d.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case d.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case d.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case d.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case d.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case d.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    o.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
ie.NAME = "AdSloCtrl::", ie.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let Ct = ie;
var He = /* @__PURE__ */ ((a) => (a[a.ERROR_RESOURCE_REJECTED = 1] = "ERROR_RESOURCE_REJECTED", a[a.ERROR_VERIFICATION_NOT_SUPPORTED = 2] = "ERROR_VERIFICATION_NOT_SUPPORTED", a[a.ERROR_ON_RESOURCE_LOAD = 3] = "ERROR_ON_RESOURCE_LOAD", a))(He || {});
const x = class x {
  constructor(e, t) {
    if (this.ad = e, this.adSlotDelivery = t, this.sessionClient = OmidSessionClient.OmidSessionClient, this.removeEventHandlers = [], this.video = t.player.getPlayerElement(), !this.sessionClient) {
      o.debug.warn(x.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = t.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      o.debug.info(
        x.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (o.debug.info(
      x.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), o.debug.table(this.verifications), e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      o.debug.info(
        x.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      x.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  filterVerifications(e, t) {
    return !e || e.length === 0 ? e : e.filter((i) => {
      const r = !t || t.length === 0 || t.includes(i.vendor);
      if (!r)
        return this.trackError(i.tracking.verificationNotExecuted, He.ERROR_RESOURCE_REJECTED), !1;
      if (t)
        return !0;
      const s = i.javascriptResource ? i.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !t && !s ? (r && this.trackError(
        i.tracking.verificationNotExecuted,
        He.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  initOMIDJS() {
    this.adSession = this.createAdSession();
    const e = this.ad.adType === "video" ? x.IMPRESSION_TYPE.RENDER : x.IMPRESSION_TYPE.AUDIBLE;
    if (this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? e : x.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), o.debug.info(x.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return o.debug.error(x.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          He.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const t = () => {
      const i = this.createVastProperties();
      this.adEvents.loaded(i), this.video.removeEventListener("canplaythrough", t);
    };
    return this.video.addEventListener("canplaythrough", t), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  createAdSession() {
    let e = new this.sessionClient.Partner(
      x.PARTNER_NAME,
      x.PARTNER_VERSION
    ), t = this.verifications.map((r) => (o.debug.info(
      x.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      it(
        r.javascriptResource.url,
        r.javascriptResource.url
      ),
      "vendor:",
      r.vendor,
      "verification params:",
      r.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      it(r.javascriptResource.url, r.javascriptResource.url),
      r.vendor,
      r.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), i = new this.sessionClient.Context(e, t, this.CONTENT_URL);
    return i.underEvaluation = !0, i.setVideoElement(this.video), i.setServiceWindow(this.OMSDK_SERVICE_WINDOW), i.supportsLoadedEvent = !0, new this.sessionClient.AdSession(i);
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(d)) {
      let t = this.adSlotDelivery.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(t);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case d.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), o.debug.info(x.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case d.ON_AD_SKIPPED:
      case d.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          o.debug.info(x.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  forwardEventToOMSDK(e) {
    let t = "forwardEventToOMSDK";
    if (o.debug.info(x.NAME + t, e), !this.adEvents) {
      o.debug.warn(x.NAME + t + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let i;
    switch (e) {
      case d.ON_AD_STARTED:
        i = this.createVastProperties(), this.adEvents.start(i);
        break;
      case d.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case d.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case d.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case d.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case d.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case d.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case d.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case d.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case d.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case d.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case d.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case d.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case d.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case d.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case d.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  trackError(e, t) {
    this.ad.enrichment.set("REASON", t, "reason"), this.adSlotDelivery.adSlotController.callTrackers(e);
  }
};
x.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, x.PARTNER_NAME = "Smartcliptv", x.PARTNER_VERSION = "7.6.2", x.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], x.NAME = "OMID::";
let Dt = x;
const St = "Resource", nt = {
  STATIC: `Static${St}`,
  HTML: `HTML${St}`,
  IFRAME: `IFrame${St}`
}, Se = class Se extends Ne {
  constructor(e, t) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = t, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((t) => {
      this.render(), t();
    });
  }
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case nt.STATIC:
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let t = document.createElement(e);
    for (let i in this.ad.attributes)
      this.ad.attributes[i] && t.setAttribute(i, this.ad.attributes[i]);
    t.style.pointerEvents = "auto", t.onload = this.onStartAd.bind(this), e === "iframe" ? (t.style.border = "0", t.setAttribute("scrolling", "no"), t.setAttribute("margin", "0"), t.setAttribute("allowtransparency", "true")) : (t.style.cursor = "pointer", t.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(t), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    o.debug.info(Se.NAME + "pause");
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    o.debug.info(Se.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    o.debug.info(Se.NAME + "play - remove ad in", e, "seconds.");
    const t = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(t);
  }
  onStartAd() {
    o.debug.info(Se.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(d.ON_AD_LOADED), this.dispatchEvent(d.ON_AD_STARTED), this.dispatchEvent(d.ON_AD_IMPRESSION), this.dispatchEvent(d.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    o.debug.info(Se.NAME + "onStopAd"), this.dispatchEvent(d.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(d.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
Se.NAME = "NonLinear::";
let Lt = Se;
const de = class de extends Ne {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, t) {
    super(), this.adSlotController = t, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = t.player;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, t) {
    return this.adSlotController.addEventListener(e, t);
  }
  addPlayerEventListener(e, t) {
    this.player.addEventListener(e, t);
    const i = () => this.removePlayerEventListener(e, t);
    return this.eventCallbacks.push(i), () => this.player.removeEventListener(e, t);
  }
  removePlayerEventListener(e, t) {
    this.player.removeEventListener(e, t);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        o.debug.info(
          de.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const i = () => {
          this.currentAd.replaced ? (t(), this.deliverNextAd()) : (A(), this.cleanAndDeliveryNextAd());
        }, r = () => {
          this.saveStartVolumeVPAID();
        }, s = () => {
          this.adSlotController.applyBuffetAd();
        }, n = this.getRemoveHandlerForAdSlotControllerEvent(
          d.ON_AD_STARTED,
          r
        ), l = this.getRemoveHandlerForAdSlotControllerEvent(
          d.ON_AD_ERROR,
          s
        ), h = this.getRemoveHandlerForAdSlotControllerEvent(
          d.ON_VPAID_CLEANUP,
          i
        ), A = () => {
          n(), l(), h();
        };
      }
    }, t = this.getRemoveHandlerForAdSlotControllerEvent(
      d.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, t) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, t);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(re.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(re.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(d.ON_AD_PAUSED);
    }), this.addPlayerEventListener(re.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(d.ON_AD_PLAYING);
    }), this.addPlayerEventListener(re.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(d.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(d.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(d.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(d.ON_AD_START, this.saveStartVolume), super.addEventListener(d.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(re.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(d.ON_AD_STOPPED), o.debug.info(de.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(re.ON_ERROR, () => {
      o.debug.info(
        de.NAME + "on - Player sent error event"
      );
    });
  }
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => {
      if (!this.adSlotHasStarted)
        return e();
      this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(d.ON_AD_SLOT_STOPPED));
      for (const t of this.eventCallbacks)
        t();
      return this.eventCallbacks = [], e();
    });
  }
  deliverNextAd() {
    var i;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), o.debug.info(de.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function t() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(d.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const r = e.currentAd.config.trackImpressionOnStart;
        e.removeImpressionOnStartHandler = (r ? e.adSlotController : e).addEventListener(
          // To bridge the gap between impression (ad loaded) and start (first timeupdate),
          //  a publisher may want the impression to be tracked with the start trackers first.
          r ? d.ON_AD_PLAYBACK_START : d.ON_AD_STARTED,
          () => {
            e.adSlotController.dispatchEvent(d.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(d.ON_AD_CREATIVE_VIEW);
          }
        );
        let s = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(s);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(d.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (i = e.currentAd) != null && i.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : t();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((t) => t.type === "companion" && t.hasCompanionResources);
    if (e && e.length > 0 && this.dispatchEvent(d.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(d.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(d.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(d.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0) {
      if (!this.currentAd.config.adVerification.disabled)
        this.currentAd.config.adVerification.playerHandles || new Dt(this.currentAd, this);
      else {
        o.debug.warn(
          de.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
        );
        for (const t of this.currentAd.adVerifications)
          this.currentAd.enrichment.set("REASON", He.ERROR_RESOURCE_REJECTED, "reason"), this.adSlotController.callTrackers(t.tracking.verificationNotExecuted);
      }
      this.dispatchEvent(d.ON_VERIFICATION_DETECTED);
    }
  }
  activateHOMAD(e, t) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: t,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(d.ON_AD_ERROR)), U.EventDispatcher.dispatchEvent(d.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let t = "Load MediaFile ", i = e.fileURL, r = !1;
      clearTimeout(this.loadPendingTimeout);
      let s = (n) => {
        r = !0, o.debug.error("VideoProxy load timeout.", n), this.currentAd.error = f.VAST.TIMEOUT, this.deliverOrHOMAD(U.REASON.MEDIAFILE_TIMEOUT, i);
      };
      this.loadPendingTimeout = setTimeout(
        s.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), o.debug.info(de.NAME + t + "from URI", i), this.player.load(i, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && (o.debug.info(de.NAME + t + "success."), this.adSlotController.dispatchEvent(d.ON_AD_LOADED), this.dispatchEvent(d.ON_AD_STARTED));
      }, (n) => {
        if (clearTimeout(this.loadPendingTimeout), r)
          return;
        o.debug.error(de.NAME + t + "failed", n);
        const l = {
          [f.VAST.GENERAL_ERROR.code]: f.VAST.GENERAL_ERROR,
          [f.VAST.FILE_NOT_FOUND.code]: f.VAST.FILE_NOT_FOUND,
          [f.VAST.UNSUPPORTED_MIMETYPE.code]: f.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = l[n] || f.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(U.REASON.MEDIAFILE_LOAD_ERROR, i);
      });
    } else {
      let t, i = !1, r = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(re.ON_LOADED_DATA, () => {
          this.dispatchEvent(d.ON_AD_STARTED), this.dispatchEvent(d.ON_AD_IMPRESSION), this.dispatchEvent(d.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(re.ON_ENDED, () => {
          this.dispatchEvent(d.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(d.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((s) => {
        i = !0, o.debug.error(r + " timeout.", s), this.currentAd.error = f.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(d.ON_AD_ERROR), this.deliverOrHOMAD(U.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (o.debug.info(
        r + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), t = this.adSlotController.environmentVars.adContainer) : (o.debug.warn(r + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), t = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Lt(this, t), [
        d.ON_AD_STARTED,
        d.ON_AD_IMPRESSION,
        d.ON_AD_CREATIVE_VIEW,
        d.ON_AD_NONLINEAR_STOPPED,
        d.ON_AD_STOPPED
      ].map((s) => {
        const n = this.adSlotController.nonLinearView.addEventListener(
          s,
          (l) => {
            this.dispatchEvent(l.type), l.type === d.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(n);
      }), this.addPlayerEventListener(re.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(re.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !i && o.debug.info(r + "Request complete");
      }, (s) => {
        clearTimeout(this.loadPendingTimeout), !i && (o.debug.error("loadAd - VideoProxy load failed", s), this.currentAd.error = f.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(d.ON_AD_ERROR), this.deliverOrHOMAD(U.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
de.NAME = "AdSloDel::";
let bt = de;
class Vt {
  getResources() {
    return this.resources;
  }
  constructor(e, t) {
    var i, r, s, n;
    this.adParameters = ((r = (i = v(t, "AdParameters")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || null, this.apiFramework = t.getAttribute("apiFramework") || null, this.clickThroughURL = ((n = (s = v(t, e + "ClickThrough")) == null ? void 0 : s.textContent) == null ? void 0 : n.trim()) || null, this.clickTracker = this.getClickTracker(e, t), this.resources = this.parseResources(t);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let t = [];
    const i = Object.values(nt).join(", ");
    let r = b(e, i);
    for (let s = 0; s < r.length; s++)
      t.push({
        creativeType: r[s].getAttribute("creativeType"),
        resource: q(r[s].textContent || ""),
        type: r[s].nodeName
      });
    return t;
  }
  getClickTracker(e, t) {
    let i = [];
    const r = b(t, e + "ClickTracking");
    for (const s of r)
      i.push({
        url: q(s.textContent),
        id: s.getAttribute("id")
      });
    return i;
  }
}
class bi extends Vt {
  constructor(e, t, i) {
    var r;
    super(e, i), this.adSlotId = i.getAttribute("adSlotId") || "", this.altText = q(((r = v(i, "AltText")) == null ? void 0 : r.textContent) || ""), this.assetHeight = i.getAttribute("assetHeight") || "", this.assetWidth = i.getAttribute("assetWidth") || "", this.companionXML = i, this.creativeViewTracker = t, this.expandedHeight = i.getAttribute("expandedHeight") || "", this.expandedWidth = i.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = i.getAttribute("height"), this.id = i.getAttribute("id") || ri(), this.pxratio = i.getAttribute("pxratio") || "1", this.renderingMode = i.getAttribute("renderingMode") || "default", this.width = i.getAttribute("width");
  }
}
function X(a, e) {
  const t = (a == null ? void 0 : a.getAttribute(e)) || -1;
  let i = -1;
  return typeof t == "string" && (i = parseInt(t, 10)), isNaN(t) ? -1 : i;
}
class Pi extends Vt {
  constructor(e, t, i) {
    var r;
    super(e, i), this.altText = q(((r = v(i, "AltText")) == null ? void 0 : r.textContent) || ""), this.creativeViewTracker = t, this.duration = X(i, "duration"), this.hasCreative = super.getResources().length > 0, this.height = q(i.getAttribute("height")), this.hoverText = i.getAttribute("hoverText") || null, this.offset = Re(i.getAttribute("offset")), this.program = i.getAttribute("program") || "unknown", this.pxratio = X(i, "pxratio"), this.width = i.getAttribute("width"), this.xPosition = i.getAttribute("xPosition"), this.yPosition = i.getAttribute("yPosition");
  }
}
class _i extends Vt {
  constructor(e, t, i) {
    const r = X(i, "expandedHeight"), s = X(i, "expandedWidth"), n = X(i, "height"), l = i.getAttribute("id"), h = i.getAttribute("maintainAspectRatio") !== "false", A = Re(
      i.getAttribute("minSuggestedDuration")
    ), C = i.getAttribute("scalable") !== "false", K = X(i, "width");
    super(e, i), this.creativeTrackers = t, this.displayDuration = null, this.expandedHeight = r, this.expandedWidth = s, this.height = n, this.id = l, this.maintainAspectRatio = h, this.minSuggestedDuration = A != null ? A : -1, this.scalable = C, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = K;
  }
}
var Ge = ((a) => (a.COMPANION = "companion", a[a.LINEAR = V.LINEAR] = "LINEAR", a[a.NON_LINEAR = V.NON_LINEAR] = "NON_LINEAR", a))(Ge || {});
class yi {
  constructor(e) {
    this.adXML = e, this.VASTVersion = this.adXML.parentElement && typeof this.adXML.parentElement.getAttribute == "function" ? parseInt(this.adXML.parentElement.getAttribute("version"), 10) : null, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, t = this.companion, i = e.mediaFiles.interactive, r = this.nonLinearCreative, s = e.mediaFiles.streaming, n = e.mediaFiles.vpaid, l = [];
    return l = l.concat(
      ...n,
      ...s,
      ...i,
      ...r,
      ...t
    ), l;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  getLinear() {
    let e = v(this.adXML, "InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), t = v(e, "MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(t),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getBaseForVersion(e, t) {
    if (t === null)
      return e;
    const r = {
      2: 3,
      3: 1,
      4: 0
    }[t];
    let s = e;
    for (let n = 0; n < r && s.parentElement; n++)
      s = s.parentElement;
    return s;
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  extractInteractiveCreativeUrl(e) {
    for (const t of e.childNodes)
      if (t.wholeText)
        return t.wholeText.trim();
    return "";
  }
  getVPAIDCreatives(e) {
    var s;
    let t = [], i = b(e, 'MediaFile[apiFramework="VPAID"]'), r = v(e, "AdParameters");
    for (let n = 0; n < i.length; n++)
      t.push({
        adParameters: ((s = r == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null,
        apiFramework: "VPAID",
        bitrate: X(i[n], "bitrate"),
        fileURL: q(i[n].textContent),
        height: X(i[n], "height"),
        linearity: V.LINEAR,
        mimeType: i[n].getAttribute("type"),
        width: X(i[n], "width")
      });
    return t;
  }
  getStreamingCreatives(e) {
    let t = [], i = b(e, 'MediaFile:not([apiFramework="VPAID"])');
    for (let r = 0; r < i.length; r++)
      t.push({
        apiFramework: i[r].getAttribute("apiFramework"),
        bitrate: X(i[r], "bitrate"),
        fileURL: q(i[r].textContent),
        height: X(i[r], "height"),
        linearity: V.LINEAR,
        mimeType: i[r].getAttribute("type"),
        width: X(i[r], "width")
      });
    return t;
  }
  getInteractiveCreatives(e) {
    var l;
    const t = [], i = this.getBaseForVersion(e, this.VASTVersion), r = b(i, "InteractiveCreativeFile"), s = v(i, "AdParameters"), n = v(i, "HTMLResource");
    for (let h = 0; h < r.length; h++) {
      let A = "", C = null;
      this.VASTVersion && this.VASTVersion < 4 ? (A = this.extractInteractiveCreativeUrl(r[h]), C = A === "" && n ? n.textContent.trim() : null) : A = r[h].textContent.trim(), t.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: r[h].getAttribute("apiFramework"),
        delivery: r[h].getAttribute("delivery"),
        fileURL: A,
        linearity: V.LINEAR,
        mimeType: r[h].getAttribute("type"),
        resource: C,
        variableDuration: r[h].getAttribute("variableDuration") === "true"
      });
    }
    return t;
  }
  getClosedCaptionCreatives(e) {
    let t = [], i = v(e, "ClosedCaptionFiles");
    if (i) {
      let r = b(i, "ClosedCaptionFile");
      for (let s = 0; s < r.length; s++)
        t.push({
          fileURL: r[s].textContent,
          // en, en-US, zh-TW
          language: r[s].getAttribute("language"),
          linearity: V.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: r[s].getAttribute("type")
        });
    }
    return t;
  }
  getCreativeViewTrackers(e, t) {
    const i = [], r = b(e, t);
    for (const s of r)
      i.push({
        url: q(s.textContent) || ""
      });
    return i;
  }
  getIndustryIcons() {
    const e = {};
    let t = b(this.adXML, "Creatives > Creative > Linear", "Icon");
    for (let i = 0; i < t.length; i++) {
      const r = t[i].getAttribute("program") || "unknown", s = this.getCreativeViewTrackers(t[i], "IconViewTracking"), n = new Pi("Icon", s, t[i]);
      e[r] = n;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  getNonLinear() {
    let e = b(this.adXML, "InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    o.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let t = b(e, "NonLinear"), i = [{
      type: Ge.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let r = 0; r < t.length; r++) {
      const s = new _i(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        t[r]
      );
      i[r].variations.push(s);
    }
    return i;
  }
  get companion() {
    const e = b(this.adXML, "Creatives > Creative > CompanionAds");
    let t = [];
    for (let i = 0; i < e.length; i++) {
      t[i] = {
        hasCompanionResources: !1,
        required: null,
        type: Ge.COMPANION,
        variations: []
      };
      const r = b(e[i], "Companion");
      for (let s = 0; s < r.length; s++)
        if (r[s].hasChildNodes()) {
          const n = this.getCreativeViewTrackers(
            r[s],
            "Tracking[event=creativeView]"
          );
          let l = new bi(
            "Companion",
            n,
            r[s]
          );
          t[i].hasCompanionResources = l.resources.length > 0, t[i].required = e[i].getAttribute("required"), t[i].variations.push(l);
        }
    }
    return t.reverse();
  }
  getTrackers(e) {
    const t = {}, i = Array.from(b(this.adXML, "ClickTracking, " + e));
    for (let r = 0; r < i.length; r++) {
      const s = i[r], n = s.nodeName === s.nodeName.toUpperCase() ? s.nodeName.toLowerCase() : s.nodeName.charAt(0).toLowerCase() + s.nodeName.slice(1), l = s.getAttribute("event") || n, h = s.getAttribute("offset"), A = {
        offset: "",
        url: q(s.textContent)
      };
      if (l === Me.ON_AD_PROGRESS && h) {
        const C = Re(h);
        A.offset = typeof C == "number" ? C.toString() : h;
      }
      t[l] = t[l] || [], t[l].push(A);
    }
    return t;
  }
}
class Mi extends o {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, t) {
    super(), this.adXML = e, this.rawXML = t instanceof Document ? t.documentElement : t, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((t, i) => {
      const r = Number(Object.keys(t));
      return Number(Object.keys(i)) - r;
    }).map((t) => Object.values(t)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let t = 0, i = e.parentElement;
    for (; i; )
      t++, i = i.parentElement;
    return { [t]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    const e = " > Creatives > Creative";
    let t = [];
    const i = b(this.adXML, "Ad > Wrapper");
    let r = [];
    for (const n of i) {
      let l = b(n, "Wrapper" + e);
      if (l.length > 0)
        for (const h of l)
          r.push(h);
      else
        t.push(n);
    }
    if (r.length > 0)
      for (const n of r)
        t.push(n);
    let s = b(this.adXML, "InLine" + e);
    for (const n of s)
      t.push(n);
    return t;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let s = b(this.adXML, "Creative");
      for (let n of s)
        e.push(n);
    }
    let t = [];
    for (const s of e)
      t.push(this.getNodeDepth(s));
    const i = this.getElementsSortedByDepth(t);
    let r = [];
    for (const s of i) {
      const n = s.getAttributeNames().find((l) => l.toLowerCase() === "adid");
      r.push(s.getAttribute(n) || null);
    }
    return r;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (pe(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = v(this.adXML, "InLine", "Advertiser");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = b(this.adXML, "AdVerifications > Verification");
    let t = [];
    for (let i = 0; i < e.length; i++) {
      const r = e[i], s = r.getAttribute("vendor") || "", n = v(r, "JavaScriptResource"), l = this.getNodeContentsAsText(
        v(r, "VerificationParameters") || document.createElement("div")
      ), h = this.getTrackerNodesAsURLArray(
        v(r, "TrackingEvents") || document.createElement("div")
      );
      if (s && s.length > 0 && n) {
        const A = {
          javascriptResource: {
            url: q(this.getNodeContentsAsText(n)),
            apiFramework: n.getAttribute("apiFramework") || "",
            browserOptional: n.getAttribute("browserOptional") === "true" || !1
          },
          tracking: h,
          vendor: s,
          verificationParameters: l
        };
        t.push(A);
      }
    }
    return t.length > 0 ? fi(t, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = pe(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new yi(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = v(this.adXML, "InLine", "Description");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = pe(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = pe(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    if (this.wrappers.length > 0) {
      let r = b(this.adXML, "Ad > Wrapper");
      for (const s of r) {
        const n = s.parentElement.getAttribute("id");
        e.push(n);
      }
    }
    let t = null, i = pe(this.adXML, "Ad");
    return i && i.hasAttribute("id") && (t = i.id), e.length > 0 ? (e.push(t), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let s = b(this.adXML, "Creative");
      for (const n of s)
        e.push(n);
    }
    let t = [];
    for (const s of e)
      t.push(this.getNodeDepth(s));
    let i = [];
    const r = this.getElementsSortedByDepth(t);
    for (const s of r)
      i.push(s.getAttribute("id") || null);
    return i;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = v(this.adXML, "InLine", "AdServingId");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = v(this.adXML, "InLine", "Pricing") || pe(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = v(this.adXML, "InLine", "Survey");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = v(this.adXML, "InLine", "AdSystem");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = v(this.adXML, "InLine", "AdTitle");
    return q((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML.hasAttribute && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(X(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(X(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: X(this.rawXML, "_loadEnd") - X(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const t = b(this.adXML, "VASTAdTagURI");
    for (let i = 0; i < t.length; i++)
      e.push({
        loadStart: new Date(X(t[i], "_loadStart")).toISOString(),
        loadEnd: new Date(X(t[i], "_loadEnd")).toISOString(),
        loadTime: X(t[i], "_loadEnd") - X(t[i], "_loadStart"),
        url: q(t[i].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = b(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId"), t = e[e.length - 1];
    return t ? this.extractUniversalAdIdInfo(t) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const t = b(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId");
    for (let i = 0; i < t.length; i++)
      e.push(this.extractUniversalAdIdInfo(t[i]));
    return e;
  }
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const t = b(this.adXML, "Extensions > Extension");
      for (let i = 0; i < t.length; i++)
        e.push({
          extensionXML: t[i],
          type: t[i].getAttribute("type")
        });
    }
    return e;
  }
  getNodeContentsAsText(e) {
    var t;
    return ((t = e == null ? void 0 : e.textContent) == null ? void 0 : t.trim()) || "";
  }
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || q(e.getAttribute("idValue") || "unknown")
    };
  }
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const t = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && t.push(this.adXML);
      for (const i of t) {
        const r = i.nodeName === i.nodeName.toUpperCase() ? i.nodeName.toLowerCase() : i.nodeName.charAt(0).toLowerCase() + i.nodeName.slice(1), s = this.getNodeContentsAsText(i);
        s && s.length > 0 && (e[r] = e[r] || [], e[r].push({
          url: s
        }));
      }
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} - Tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const t = {};
    if (!e)
      return t;
    for (const i of b(e, "Tracking")) {
      const r = this.getNodeContentsAsText(i);
      if (r.length === 0)
        continue;
      const s = i.getAttribute("event");
      s && (t[s] || (t[s] = []), t[s].push(
        { url: r }
      ));
    }
    return t;
  }
}
class _e extends Mi {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, t) {
    super(e, t), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = b(this.adXML, "Creative", "Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      pe(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return H.SPONSORED;
      default:
        return H.COMMERCIAL;
    }
  }
  parseSkipOffsetToNumber() {
    var t;
    const e = Re(
      ((t = v(this.adXML, "InLine Linear")) == null ? void 0 : t.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  getVariant(e) {
    if (e === null)
      return H.COMMERCIAL;
    let t = H.COMMERCIAL;
    return e.nodeName === "AdInfo" && (t = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (t = this.mapStringToVariant(e.textContent.trim())), t;
  }
  getDuration() {
    var t, i;
    const e = ((i = (t = pe(this.adXML, "Linear Duration")) == null ? void 0 : t.textContent) == null ? void 0 : i.trim()) || _e.FALLBACK_LINEAR_DURATION;
    return Re(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  getError() {
    function e(i) {
      if (i.parentNode)
        return v(i.parentNode, ":scope > parsererror");
    }
    const t = v(this.adXML, "parsererror") || e(this.adXML);
    return t ? {
      code: X(t, "code"),
      message: t.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  flagCappedAds() {
    return v(this.adXML, "InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: f.WRAPPER.NO_RESPONSE.code,
      message: f.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", t = pe(this.adXML, e);
    return q((t == null ? void 0 : t.textContent) || "");
  }
}
_e.FALLBACK_LINEAR_DURATION = "00:00:20";
class wi {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  handleXMLDoc(e) {
    let t = v(e, "parsererror"), i = b(e, ":root > *"), r;
    if (!(v(e, "html") && t)) {
      if (v(e, "html")) {
        r = document.createElement("VAST");
        const s = new _e(r, e);
        this.adList.push(s);
        return;
      }
      if (e instanceof DocumentFragment && t) {
        r = document.createElement("VAST"), r.appendChild(t);
        const s = new _e(r, e);
        this.adList.push(s);
      }
      for (let s = 0; s < i.length; s++) {
        const n = new _e(i[s], e);
        this.adList.push(n);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function ki(a, e) {
  const t = Object.values(Ke);
  let i = [];
  const r = document.createElement("video"), s = document.createElement("audio");
  let n = t;
  return e && e.length > 0 && (i = e, n = e), n.filter((h) => !("canPlayType" in r) || h === "application/javascript" || r.canPlayType(h) !== "" || s.canPlayType(h) !== "" ? i.push(h) : !1), (i.length <= 0 || i.length === 1 && i[0] === "application/javascript") && (i = n), a.filter((h) => i.find((A) => h.mimeType === A));
}
class at {
  static getProperCreative(e, t) {
    if (!e || e.length < 1)
      return null;
    let i = e.slice(0);
    return e[0].type === V.NON_LINEAR ? Ui.select(i, t) : Vi.select(i, t);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, t = []) {
    return e.filter((i) => i.isVPAID ? this.isFriendlyVendorHost(i.fileURL, t) : !0);
  }
  static isFriendlyVendorHost(e, t = []) {
    return !t || t && t.length === 0 ? !0 : t.some((i) => {
      if (!i.includes("."))
        return !1;
      try {
        const r = new URL(e).hostname;
        return new RegExp(`(^|\\.)${i.replace(".", "\\.")}$`).test(r);
      } catch (r) {
        return !1;
      }
    });
  }
}
class Vi {
  static select(e, t) {
    return e.forEach((r) => {
      r.selectedCreativeFile = null, r.selectedMediaFile = null;
      let s = r.mediaFiles || [];
      s.map((l) => {
        var h;
        !r.selectedCreativeFile && l.apiFramework && (l.isSIMID = (l.apiFramework + "").toUpperCase() === "SIMID", r.selectedCreativeFile = l.isSIMID ? l : null), (h = r.selectedCreativeFile) != null && h.isSIMID && (l.isSIMID = !0), l.isVPAID = (l.apiFramework + "").toUpperCase() === "VPAID";
      }), s = at.removeUnwantedVPAIDVendors(
        s,
        t.desiredVPAIDVendors
      );
      let n = ki(s, t.desiredMimeTypes);
      r.selectedMediaFile = this.selectMediaFile(
        n,
        t.desiredBitrate || 1e3,
        t.desiredMimeTypes || []
      );
    }), e.filter((r) => !!r.selectedMediaFile).shift();
  }
  static selectMediaFile(e, t, i) {
    let r = e.filter((l) => l.isSIMID), s = e.filter((l) => l.isVPAID);
    if (r.length > 0)
      return r[0];
    if (s.length > 0)
      return s[0];
    let n = [];
    for (let l = 0; l < i.length; ) {
      if (l > 0 && n.length > 0) {
        e = n;
        break;
      }
      e.filter((h) => {
        h.mimeType === i[l] && n.push(h);
      }), l++;
    }
    return this.selectMediaFileByBitrate(e, t);
  }
  static selectMediaFileByBitrate(e, t) {
    let i = e.filter((s) => !s.isVPAID).sort((s, n) => n.bitrate - s.bitrate), r = i.filter((s) => s.bitrate <= t);
    return r.length > 0 ? r.shift() : i.pop() || e.shift();
  }
}
class Ui {
  static select(e, t) {
    return e.forEach((r) => {
      const s = r.variations;
      s.map((n) => {
        n.selectedResource = null, (n.apiFramework + "").toUpperCase() === "VPAID" && (n.isVPAID = !0, n.resources = n.resources.filter((l) => at.isFriendlyVendorHost(
          l.resource,
          t.desiredVPAIDVendors
        )));
      });
      for (const n of s)
        n.resources.length <= 0 ? n.hasCreative = !1 : n.selectedResource = n.resources[0];
      r.variations = s.filter((n) => !!n.selectedResource);
    }), e.filter((r) => r.variations.length > 0).shift();
  }
}
function Pt(a) {
  let e = 0, t = 0, i = 0;
  const r = a.length;
  for (let s = 0; s < a.length; s++) {
    let n = a[s];
    n.variant === H.COMMERCIAL ? (n.currentCommercial = t += 1, (n.fallbackOnNoAd || !n.fallbackOnNoAd) && n.hasError && (e += 1), n.currentPodSequencing = t - e) : (n.fallbackOnNoAd || !n.fallbackOnNoAd) && n.hasError && (i += 1), n.variant !== H.COMMERCIAL && (n.currentCommercial = -1), n.sequence = s + 1, n.currentClip = s + 1;
  }
  return {
    totalClips: r,
    totalPlayableClips: r - e - i,
    totalCommercials: t,
    totalPlayableCommercials: t - e
  };
}
const Jt = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function Fi(a, e, t, i) {
  let r = a;
  const s = t, n = i, l = e, h = {
    DIVIDER: H.DIVIDER,
    CLOSER: H.CLOSER,
    OPENER: H.OPENER
  };
  function A(B) {
    let J = [], P = {
      adParameters: null,
      creativeTrackers: {},
      duration: _e.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: V.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let L in B)
      if (Object.prototype.hasOwnProperty.call(B, L) && Object.prototype.hasOwnProperty.call(Jt, L.toUpperCase())) {
        let u = B[L];
        if (typeof u == "string" && u.length > 0) {
          let c = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: u,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Jt[L.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          P.mediaFiles.push(c);
        }
      }
    return P.supportedMediaFiles = P.mediaFiles, J.push(P), J;
  }
  function C() {
    Object.keys(h).forEach((B) => {
      if (s && Object.prototype.hasOwnProperty.call(s, h[B])) {
        const J = s[h[B]];
        if (!l && !J.forcePlay)
          return;
        let P = {};
        P.adTrackers = [], P.creatives = A(J), P.extensions = [], P.id = P.adId = h[B], P.isLinear = !0, P.variant = h[B], P.properCreative = P.creatives[0], P.properCreative.selectedMediaFile = P.properCreative.supportedMediaFiles[0], P.config = n, P.enrichment = new ve(), P.adReinsertion = new U(n.adReinsertion, P.enrichment), P.expectedAdType = s.type, P.isPaused = !0;
        let L = [];
        switch (h[B]) {
          case h.DIVIDER:
            for (let u = 0; u < r.length; u++)
              u > 0 && r[u].variant !== r[u - 1].variant && L.push({
                offset: u,
                ad: P
              });
            if (s[h[B]].forcePlay && L.length === 0) {
              r[0].variant === H.SPONSORED ? r.unshift(P) : r.push(P);
              break;
            }
            for (let u = 0; u < L.length; u++) {
              const c = L[u].offset + u;
              r.splice(c, 0, L[u].ad);
            }
            break;
          case h.CLOSER:
            r.push(P);
            break;
          case h.OPENER:
            r.unshift(P);
            break;
        }
      }
    });
  }
  C();
  let K = Pt(r);
  return { enrichedManifest: r, sequenceData: K };
}
function Zt(a) {
  let e = a;
  for (let t = 0; t < e.length; t++) {
    let r = e[t].extensions;
    for (let s of r)
      typeof s.extensionXML == "string" && (s.extensionXML = new DOMParser().parseFromString(s.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
  }
  return e;
}
class xi {
  constructor(e, t, i, r) {
    this.adBreak = r, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = t, this.environmentVars = i, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), Zt(this.adSlotModelList), this.adSlotBuffetList = Zt(this.adSlotBuffetList), o.debug.info(this.NAME + "adPod", this.adSlotModelList), o.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((t) => t).sort(this.bySequence).reverse();
      for (let t = e.length - 1; t >= 0; t--) {
        const i = e[t];
        if (i.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let r = this.adSlotBuffetList.shift();
          r.sequence = i.sequence + 0.1, this.adSlotModelList.splice(i.sequence - 1, 0, r);
        }
      }
    }
  }
  decorateAdList() {
    for (let e = 0; e < this.adList.length; e++) {
      let t = this.adList[e];
      if (t.adBreakPosition = this.adBreak.adBreakPosition, t.config = this.config, t.enrichment = new ve(), t.enrichment.setFromObject(t.publisherMacros), t.expectedAdType = this.adBreak.type, t.publisherMacros = this.environmentVars.vastMacros, t.adReinsertion = new U(t.config.adReinsertion, t.enrichment), t.isPaused = !0, !t.hasError) {
        if (t.creatives.length < 1) {
          t.error = {}, t.error = f.WRAPPER.NO_RESPONSE;
          continue;
        }
        if (t.expectedAdType === V.LINEAR && t.creativeClass.linearAsArray[0].mediaFiles.length === 0 || t.expectedAdType === V.NON_LINEAR && t.creativeClass.nonLinear.length === 0) {
          t.error = {}, t.error = f.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          continue;
        }
        t.expectedAdType === V.LINEAR ? (t.properCreative = at.getProperCreative(
          t.creativeClass.linearAsArray,
          this.environmentVars
        ), t.properCreative && (t.closedCaptions = t.properCreative.captions, t.icons = t.properCreative.icons)) : t.properCreative = at.getProperCreative(
          t.creativeClass.nonLinear,
          this.environmentVars
        ), t.properCreative || (t.error = {}, t.error = f.VAST.UNSUPPORTED_MIMETYPE);
      }
    }
  }
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.sequenceInfo = Pt(this.adSlotModelList), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = [], this.sequenceInfo = Pt(this.adSlotModelList));
  }
  extendWithSeparationClips() {
    if (this.adBreak.type !== V.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: t
    } = Fi(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = t;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((t) => !t.hasError || t.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((t) => !t.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && v(e.adXML, `ParserError[code="${f.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const t = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, i = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return t || i;
    });
  }
  bySequence(e, t) {
    return e.sequence - t.sequence;
  }
}
var ot = /* @__PURE__ */ ((a) => (a.XHR = "xhr", a.JSONP = "jsonp", a))(ot || {});
const xt = class xt {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, t) {
    this.callbackOnDoneLoading = t, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, t) {
    this.callbackOnDoneLoading = t, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((i) => (this.saveInitialURLToTag(e, i), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), i), this.requestXML(i)));
  }
  /* c8 ignore stop */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let t = b(this.XMLDoc, "VASTAdTagURI");
      if (this.XMLsToLoad = t.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let i = 0; i < this.XMLsToLoad; i++) {
        let s = (t[i].textContent || "").trim();
        this.walkDownAdWrappers(
          s,
          0,
          t[i].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((n) => {
          e(n);
        });
      }
    }
  }
  walkDownAdWrappers(e, t, i, r) {
    return new Promise((s, n) => {
      let l = v(i, "VASTAdTagURI");
      if (l.setAttribute("_loadStart", Date.now().toString()), l.setAttribute("_loadEnd", Date.now().toString()), Date.now() - r > this.wrapperChainTimeout)
        return oe(i, f.WRAPPER.CHAIN_TIMEOUT), n(), e;
      if (t >= this.maxWrapperDepth)
        return oe(
          i,
          f.WRAPPER.LIMIT_REACHED
        ), n(), e;
      if (this.isInsecureURL(e))
        return oe(i, f.SESSION.MIXED_CONTENT), n(), e;
      if (this.hasSessionTimeoutError)
        return n(), e;
      let h, A;
      this.loadURL(e, !0).then((C) => {
        let K = v(C, "VASTAdTagURI");
        h = ((K || {}).textContent || "").trim(), h && (A = K.parentNode), this.addContentToWrapperNode(i, C), l.setAttribute("_loadEnd", Date.now().toString()), s([h, A]);
      });
    }).then((s) => {
      let [n, l] = s;
      return n ? this.walkDownAdWrappers(n, t + 1, l, r) : e;
    });
  }
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  loadURL(e, t = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = t, this.urlHandlerOptions.adRequestMethod === ot.JSONP && o.debug.warn(
      `Request method ${ot.JSONP} is deprecated since v7.6.2 and will be removed in v8.`
    ), new Promise((i) => {
      new kt().get(e, (r, s) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let n = s || document.createDocumentFragment(), l = v(n, "Ad") || n.documentElement || n;
          this.hasSessionTimeoutError = !0, oe(l, f.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: U.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: s
          }), i(n);
        }
        if (!r && s && v(s, "parsererror")) {
          let n = document.createDocumentFragment();
          oe(n, f.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: U.REASON.XML_PARSING_ERROR,
            xmlResponse: s
          }), i(n);
        }
        if (!r && s && s.documentElement.nodeName.toUpperCase() === "VAST") {
          const n = v(s, "VAST");
          if (n && b(n, ":scope > *").length === 0) {
            let l = document.createDocumentFragment();
            oe(l, f.WRAPPER.NO_RESPONSE), i(l);
          }
        }
        if (r && !s) {
          let n = document.createDocumentFragment();
          o.debug.warn(
            this.NAME + " XHR Request Error",
            r.code,
            r.description
          ), oe(n, r), i(n);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  isInsecureURL(e) {
    return this.blockInsecureURL && !si(e);
  }
  /* c8 ignore stop */
  setAttributeToTag(e, t, i) {
    if (i) {
      let r = v(i, "VAST");
      r && r.setAttribute(e, t);
    }
  }
  saveInitialURLToTag(e, t) {
    this.setAttributeToTag("_initialURL", e, t);
  }
  saveInitialTimestampToTag(e, t, i) {
    this.setAttributeToTag("_loadStart", e, i), this.setAttributeToTag("_loadEnd", t, i);
  }
  addContentToWrapperNode(e, t) {
    let i = document.createElement("_VASTAdTagURIContent");
    i.appendChild(t.firstElementChild), e.appendChild(i);
  }
};
xt.EVENT = {
  PARSED: "AdTagService::parsed"
};
let _t = xt;
class Hi {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function t(n, l) {
      const h = e[n];
      return !h || h.length <= 0 ? (o.debug.info(l), []) : h;
    }
    const i = (n, l) => {
      const h = e.creatives;
      if (h && h.length !== 0) {
        const A = h.find(
          (C) => C.type === n
        );
        if (A && A.variations && A.variations.length > 0)
          return A.variations;
      }
      return o.debug.info(l), [];
    };
    function r(n) {
      return n.charAt(0).toUpperCase() + n.slice(1);
    }
    const s = (n) => {
      var h, A;
      if (e.isLinear) {
        const C = e.properCreative && e.properCreative.selectedMediaFile;
        return C ? C[n] : -1;
      }
      const l = (A = (h = e.creativesArray) == null ? void 0 : h.nonLinearCreative[0]) == null ? void 0 : A.variations[0];
      if (l && e.isExpanded) {
        const C = `expanded${r(n)}`;
        return l[C] === -1 ? l[n] : l[C];
      }
      return l ? l[n] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return t("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return t("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return i(Ge.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function n(h, A) {
          return A === 0 || !h.parentElement ? h : n(h.parentElement, A - 1);
        }
        function l(h) {
          const A = n(h, 3), C = A.getAttributeNames().find((K) => K.toLowerCase() === "adid");
          return {
            adId: A.getAttribute(C) || null,
            id: A.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let h = null;
          if (e.isSIMID ? h = "InteractiveCreativeFile" : e.isVPAID ? h = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (h = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), h) {
            const A = v(e.adXML, h);
            return l(A);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const h = e.properCreative.variations[0].selectedResource.type, A = e.properCreative.variations[0].selectedResource.creativeType, C = h !== nt.IFRAME ? v(e.adXML, `${h}[creativeType="${A}"]`) : v(e.adXML, h);
          return l(C);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var n;
        return !e.isLinear && ((n = e.creativesArray) != null && n.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (o.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return t("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== nt.IFRAME;
        } catch (n) {
          return !1;
        }
      },
      get height() {
        return s("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (o.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const n = e.properCreative;
        return n && n.length !== 0 ? n : (o.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return i(Ge.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var n;
        return !e.isLinear && ((n = e.creativesArray) != null && n.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return t("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(n) {
        e.volume = n;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return s("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return t("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Bi {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, t) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return t.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return t.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return t.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return t.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class oi {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, t, i) {
    this.consentAPI = e, this.callback = t, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = i, this.NAME = "TCFAPI::", o.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, t) {
    this.consentAPI(e, this.version, (i) => {
      this.onConsentData(i, t);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, t) {
    this.consentDataInfo = e[t], this.gdprAppliesBoolean = e.gdprApplies, o.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class qi extends oi {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, t) {
    super(e, t, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Xi extends oi {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, t) {
    super(e, t, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class Wi {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const t = window.top;
      t && (this.tcfAPI = t.__tcfapi, this.cmpAPI = t.__cmp);
    } catch (t) {
      o.debug.warn(`${this.NAME}Ctor No window?`, t);
    }
    this.hasTCF() ? this.api = new Xi(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new qi(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : o.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    o.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Ut(a) {
  if (typeof a != "object" || a === null)
    return a;
  const e = /* @__PURE__ */ Object.create(null);
  for (const t of Object.keys(a)) {
    const i = a[t];
    ni(i) || (e[t] = Ut(a[t]));
  }
  return e;
}
function ji(a) {
  const e = document.implementation.createDocument(null, "VAST", null);
  e.documentElement.setAttribute("version", "3.0");
  for (const t of a) {
    const i = e.createElement("Ad"), r = e.createElement("Wrapper"), s = e.createElement("VASTAdTagURI");
    s.appendChild(e.createTextNode(t)), r.appendChild(s), i.appendChild(r), e.documentElement.appendChild(i);
  }
  return e;
}
function Ki(a) {
  let e = a;
  if (e.originConfig = Ut(a), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let t = e.urls[0];
    e.urls = [];
    for (let i = 0; i < e.repeat; i++)
      e.urls.push(t.replace("[count]", (i + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = ji(e.urls)), e.requested = !1, e;
}
const ei = "AdBreakValidation";
function Gi(a) {
  var r, s;
  if (!a || typeof a != "object" || Array.isArray(a) || Object.keys(a).length === 0)
    return o.debug.warn(ei + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof a.tag == "string" || Array.isArray(a.tag)) && a.tag.length > 0, t = ((s = (r = a.response) == null ? void 0 : r.length) != null ? s : 0) > 0, i = a[H.CLOSER] || a[H.DIVIDER] || a[H.OPENER];
  return !e && !t && !i ? (o.debug.warn(ei + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function ge(a) {
  "@babel/helpers - typeof";
  return ge = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
    return typeof e;
  } : function(e) {
    return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
  }, ge(a);
}
function Yi(a, e, t, i, r) {
  var s = s || {};
  (function(n) {
    var l = {
      globalConfig: a,
      clientConfig: e,
      clientAPIs: t,
      utilsReady: i,
      onFailure: r
    };
    (function() {
      function h(u) {
        u = [(typeof globalThis == "undefined" ? "undefined" : ge(globalThis)) == "object" && globalThis, u, (typeof window == "undefined" ? "undefined" : ge(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : ge(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : ge(global)) == "object" && global];
        for (var c = 0; c < u.length; ++c) {
          var S = u[c];
          if (S && S.Math == Math) return S;
        }
        throw Error("Cannot find global object");
      }
      var A = h(this);
      function C(u) {
        var c = 0;
        return function() {
          return c < u.length ? {
            done: !1,
            value: u[c++]
          } : {
            done: !0
          };
        };
      }
      var K = typeof Object.defineProperties == "function" ? Object.defineProperty : function(u, c, S) {
        return u == Array.prototype || u == Object.prototype || (u[c] = S.value), u;
      };
      function B(u, c) {
        if (c) e: {
          var S = A;
          u = u.split(".");
          for (var O = 0; O < u.length - 1; O++) {
            var I = u[O];
            if (!(I in S)) break e;
            S = S[I];
          }
          u = u[u.length - 1], O = S[u], c = c(O), c != O && c != null && K(S, u, {
            configurable: !0,
            writable: !0,
            value: c
          });
        }
      }
      B("Symbol", function(u) {
        function c(I) {
          if (this instanceof c) throw new TypeError("Symbol is not a constructor");
          return new S("jscomp_symbol_" + (I || "") + "_" + O++, I);
        }
        function S(I, _) {
          this.j = I, K(this, "description", {
            configurable: !0,
            writable: !0,
            value: _
          });
        }
        if (u) return u;
        S.prototype.toString = function() {
          return this.j;
        };
        var O = 0;
        return c;
      }), B("Symbol.iterator", function(u) {
        if (u) return u;
        u = Symbol("Symbol.iterator");
        for (var c = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), S = 0; S < c.length; S++) {
          var O = A[c[S]];
          typeof O == "function" && typeof O.prototype[u] != "function" && K(O.prototype, u, {
            configurable: !0,
            writable: !0,
            value: function() {
              return J(C(this));
            }
          });
        }
        return u;
      });
      function J(u) {
        return u = {
          next: u
        }, u[Symbol.iterator] = function() {
          return this;
        }, u;
      }
      function P(u) {
        var c = typeof Symbol != "undefined" && Symbol.iterator && u[Symbol.iterator];
        return c ? c.call(u) : {
          next: C(u)
        };
      }
      function L(u, c) {
        return Object.prototype.hasOwnProperty.call(u, c);
      }
      B("WeakMap", function(u) {
        function c(p) {
          if (this.h = (E += Math.random() + 1).toString(), p) {
            p = P(p);
            for (var m; !(m = p.next()).done; ) m = m.value, this.set(m[0], m[1]);
          }
        }
        function S() {
        }
        function O(p) {
          var m = ge(p);
          return m === "object" && p !== null || m === "function";
        }
        function I(p) {
          if (!L(p, T)) {
            var m = new S();
            K(p, T, {
              value: m
            });
          }
        }
        function _(p) {
          var m = Object[p];
          m && (Object[p] = function(N) {
            return N instanceof S ? N : (Object.isExtensible(N) && I(N), m(N));
          });
        }
        if (function() {
          if (!u || !Object.seal) return !1;
          try {
            var p = Object.seal({}), m = Object.seal({}), N = new u([[p, 2], [m, 3]]);
            return N.get(p) != 2 || N.get(m) != 3 ? !1 : (N.delete(p), N.set(m, 4), !N.has(p) && N.get(m) == 4);
          } catch (y) {
            return !1;
          }
        }()) return u;
        var T = "$jscomp_hidden_" + Math.random();
        _("freeze"), _("preventExtensions"), _("seal");
        var E = 0;
        return c.prototype.set = function(p, m) {
          if (!O(p)) throw Error("Invalid WeakMap key");
          if (I(p), !L(p, T)) throw Error("WeakMap key fail: " + p);
          return p[T][this.h] = m, this;
        }, c.prototype.get = function(p) {
          return O(p) && L(p, T) ? p[T][this.h] : void 0;
        }, c.prototype.has = function(p) {
          return O(p) && L(p, T) && L(p[T], this.h);
        }, c.prototype.delete = function(p) {
          return O(p) && L(p, T) && L(p[T], this.h) ? delete p[T][this.h] : !1;
        }, c;
      }), B("Map", function(u) {
        function c() {
          var E = {};
          return E.c = E.next = E.head = E;
        }
        function S(E, p) {
          var m = E.b;
          return J(function() {
            if (m) {
              for (; m.head != E.b; ) m = m.c;
              for (; m.next != m.head; ) return m = m.next, {
                done: !1,
                value: p(m)
              };
              m = null;
            }
            return {
              done: !0,
              value: void 0
            };
          });
        }
        function O(E, p) {
          var m = p && ge(p);
          m == "object" || m == "function" ? _.has(p) ? m = _.get(p) : (m = "" + ++T, _.set(p, m)) : m = "p_" + p;
          var N = E.g[m];
          if (N && L(E.g, m)) for (E = 0; E < N.length; E++) {
            var y = N[E];
            if (p !== p && y.key !== y.key || p === y.key) return {
              id: m,
              list: N,
              index: E,
              a: y
            };
          }
          return {
            id: m,
            list: N,
            index: -1,
            a: void 0
          };
        }
        function I(E) {
          if (this.g = {}, this.b = c(), this.size = 0, E) {
            E = P(E);
            for (var p; !(p = E.next()).done; ) p = p.value, this.set(p[0], p[1]);
          }
        }
        if (function() {
          if (!u || typeof u != "function" || !u.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var E = Object.seal({
              x: 4
            }), p = new u(P([[E, "s"]]));
            if (p.get(E) != "s" || p.size != 1 || p.get({
              x: 4
            }) || p.set({
              x: 4
            }, "t") != p || p.size != 2) return !1;
            var m = p.entries(), N = m.next();
            return N.done || N.value[0] != E || N.value[1] != "s" ? !1 : (N = m.next(), !(N.done || N.value[0].x != 4 || N.value[1] != "t" || !m.next().done));
          } catch (y) {
            return !1;
          }
        }()) return u;
        var _ = /* @__PURE__ */ new WeakMap();
        I.prototype.set = function(E, p) {
          E = E === 0 ? 0 : E;
          var m = O(this, E);
          return m.list || (m.list = this.g[m.id] = []), m.a ? m.a.value = p : (m.a = {
            next: this.b,
            c: this.b.c,
            head: this.b,
            key: E,
            value: p
          }, m.list.push(m.a), this.b.c.next = m.a, this.b.c = m.a, this.size++), this;
        }, I.prototype.delete = function(E) {
          return E = O(this, E), E.a && E.list ? (E.list.splice(E.index, 1), E.list.length || delete this.g[E.id], E.a.c.next = E.a.next, E.a.next.c = E.a.c, E.a.head = null, this.size--, !0) : !1;
        }, I.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = c(), this.size = 0;
        }, I.prototype.has = function(E) {
          return !!O(this, E).a;
        }, I.prototype.get = function(E) {
          return (E = O(this, E).a) && E.value;
        }, I.prototype.entries = function() {
          return S(this, function(E) {
            return [E.key, E.value];
          });
        }, I.prototype.keys = function() {
          return S(this, function(E) {
            return E.key;
          });
        }, I.prototype.values = function() {
          return S(this, function(E) {
            return E.value;
          });
        }, I.prototype.forEach = function(E, p) {
          for (var m = this.entries(), N; !(N = m.next()).done; ) N = N.value, E.call(p, N[1], N[0], this);
        }, I.prototype[Symbol.iterator] = I.prototype.entries;
        var T = 0;
        return I;
      }), B("Object.is", function(u) {
        return u || function(c, S) {
          return c === S ? c !== 0 || 1 / c === 1 / S : c !== c && S !== S;
        };
      }), B("Array.prototype.includes", function(u) {
        return u || function(c, S) {
          var O = this;
          O instanceof String && (O = String(O));
          var I = O.length;
          for (S = S || 0, 0 > S && (S = Math.max(S + I, 0)); S < I; S++) {
            var _ = O[S];
            if (_ === c || Object.is(_, c)) return !0;
          }
          return !1;
        };
      }), B("String.prototype.includes", function(u) {
        return u || function(c, S) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (c instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(c, S || 0) !== -1;
        };
      }), B("Array.from", function(u) {
        return u || function(c, S, O) {
          S = S != null ? S : function(E) {
            return E;
          };
          var I = [], _ = typeof Symbol != "undefined" && Symbol.iterator && c[Symbol.iterator];
          if (typeof _ == "function") {
            c = _.call(c);
            for (var T = 0; !(_ = c.next()).done; ) I.push(S.call(O, _.value, T++));
          } else for (_ = c.length, T = 0; T < _; T++) I.push(S.call(O, c[T], T));
          return I;
        };
      }), function() {
        function u() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function c() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function S(T) {
          return T == "True" || T == "true" || T == 1 || T == "1" || T == 1;
        }
        function O() {
          var T = function() {
            var N = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), y = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Oe = N.slice(0, N.length / 2).split("").reverse().join("");
            return N = N.slice(N.length / 2).split("").reverse().join(""), y + Oe + y + N + y;
          }(), E = function(N) {
            var y = 0, Oe;
            if (N.length == 0) return y;
            var Ie = 0;
            for (Oe = N.length; Ie < Oe; Ie++) y = (y << 5) - y + N.charCodeAt(Ie), y |= 0;
            return Math.abs(y);
          }(T).toString();
          E = (E + E.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), T = btoa(T).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var p = "", m = 0; m < E.length; m++) p += T.charAt(E[m]);
          return p || "zork";
        }
        function I(T, E) {
          return T = Math.round(Math.abs(T)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, T);
        }
        u.prototype.getItem = function(T) {
          return this.i[T] || this.client[T] || this.f[T];
        }, u.prototype.l = function(T) {
          this.f = T.embed, this.global = T.global, this.client = T.client, this.i = T.customer;
        };
        var _ = null;
        _ = new u(), function(T) {
          function E(g, D, Q) {
            var W = {
              homad_url_prefix_alias: "",
              homad_track_key: "*" + encodeURIComponent(g) + "*",
              homad_track_value: "*" + encodeURIComponent(D.toString()) + "*"
            }, j = Q ? null : function() {
              E(g, D, !0);
            };
            Q = Q ? p(!0) : m(), Ye(Q, null, j, W);
          }
          function p(g) {
            return g = g ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + g.slice(g.length - 2).join(".") + "/[hash]/").replace("[hash]", c(I()));
          }
          function m() {
            if (se && se.server) {
              var g = se.server[Math.floor(Math.random() * se.server.length)] + "";
              return g.replace("[hash]", c(I()));
            }
            return p(!1);
          }
          function N() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(D) {
              try {
                D.pause();
              } catch (Q) {
              }
              D.parentNode.removeChild(D);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(D) {
              D.parentNode.removeChild(D);
            }), window.self != window.top) for (var g = window.document; g.hasChildNodes(); ) g.removeChild(g.lastChild);
            me.get("setTimeout")(N, Math.round(1e3 + 100 * Math.random()));
          }
          function y(g) {
            return Ce && clearTimeout(Ce), E("stats_embed_penalty", g), N(), !1;
          }
          function Oe() {
            fe && fe.enabled === !1 || se && se.enabled === !1 || Ae && Ae.enabled === !1 ? clearTimeout(Ce) : y("load_main");
          }
          function Ie() {
            Ye(Ae.src.toString(), function(g) {
              Ae.src.toString() === g.responseURL ? (g = ht(g.responseText), Ae.data = g, Ae.enabled = S(g.enabled), Oe()) : y("redirect_customer");
            }, function() {
              Ae.data = {}, Ae.enabled = void 0, Oe();
            });
          }
          function Bt() {
            var g = se.src;
            typeof g == "string" ? Ye(g.toString(), function(D) {
              g.toString() === D.responseURL ? (D = ht(D.responseText), se.data = D, se.enabled = S(D.enabled), Ae.src = D.config, Ie()) : y("redirect_client");
            }, function() {
              se.data = {}, se.enabled = void 0, Ie();
            }) : (se.data = typeof g == "function" ? g() : g, Ie());
          }
          function di() {
            Ye(fe.src.toString(), function(g) {
              fe.src.toString() === g.responseURL ? (g = ht(g.responseText), fe.data = g, fe.enabled = S(g.enabled), Bt()) : y("redirect_global");
            }, function() {
              fe.data = {}, fe.enabled = void 0, Bt();
            });
          }
          function li(g) {
            clearTimeout(Ce);
            var D = new g();
            D.init(_.f.globalConfig, _.f.clientConfig, !0, function() {
              _.f.utilsReady(D);
            }, function() {
              y("utils_init");
            }, _.f);
          }
          function lt(g) {
            var D = qt.shift();
            D ? !window[O()] || g ? hi(D) : g || clearTimeout(Ce) : di();
          }
          function Ye(g, D, Q, W) {
            W = W === void 0 ? null : W;
            var j = new XMLHttpRequest();
            if (j.onreadystatechange = function() {
              D && j.readyState == 4 && j.status == 200 && D(j), Q && j.readyState == 4 && j.status != 200 && Q(j);
            }, W) {
              var Qe = "", ct;
              for (ct in W) Qe += "&" + ct + "=" + encodeURIComponent(W[ct]);
              Qe = Qe.substr(1), j.open("POST", g, !0), j.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), j.send(Qe);
            } else j.open("GET", g, !0), j.send();
          }
          function hi(g) {
            var D = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("script") : me.get("createElement")("script"), Q;
            if (D.setAttribute("data-info", ze), D.src = g, D.onload = function(j) {
              j.currentTarget.getAttribute("id") === O() ? ut() ? (j = Q[ze.split("").reverse().join("")], li(j)) : clearTimeout(Ce) : qt.length ? lt(!0) : y("main_redirect");
            }, D.onerror = function() {
              lt(!0);
            }, window[O()] || (window[O()] = I(5 + Math.round(5 * Math.random()))), ut()) {
              var W = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("iframe") : me.get("createElement")("iframe");
              if (!W || W.nodeName.toLowerCase() !== "iframe" || !W.nodeType) return y("utils_iframe");
              W.style.display = "none", W.onload = function() {
                if (Q = W.contentWindow, Q[ze] = T, W.contentWindow.document.body.appendChild(D) !== D) return y("utils_script");
              }, document.body.appendChild(W);
            } else document.head.appendChild(D);
          }
          function ht(g) {
            var D = me.get("JSON");
            try {
              var Q = D.parse(g);
            } catch (W) {
              Q = {};
            }
            return Q;
          }
          function ut() {
            return _.f.utilsReady != null;
          }
          var ze = I(10 + Math.round(10 * Math.random()));
          window[ze] = T, _ = new u(), _.l({
            embed: T
          }), _.f.version = "20230601_1407";
          var Ce = 0, ui = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], ci = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], qt = ut() ? ci : ui, fe = {
            src: T.globalConfig,
            enabled: void 0,
            data: null
          }, se = {
            src: T.clientConfig,
            enabled: void 0,
            data: null
          }, Ae = {
            src: null,
            enabled: void 0,
            data: null
          }, me = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var g = document.createElement("iframe");
              g.style.display = "none", document.body.appendChild(g);
              var D = g.contentWindow;
            } else document.head ? (g = document.createElement("iframe"), g.style.display = "none", document.head.appendChild(g), D = g.contentWindow) : D = window;
            me.set("JSON", D.JSON), me.set("createElement", D.document.createElement.bind(document)), me.set("setTimeout", D.setTimeout.bind(window)), g && g.parentNode && g.parentNode.removeChild(g);
          })(), function() {
            Ce = me.get("setTimeout")(function() {
              y("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), lt();
        }(l);
      }();
    })();
  }).bind(s)(s);
}
let $ = null, Z = null;
const w = class w extends Ne {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, t) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: V.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = $ = t, this.environmentVars = {}, this.error = null, this.initialURLHandler = t.urlhandler ? t.urlhandler : Ee, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(d.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = U.EventDispatcher.addEventListener(
      d.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = $.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  initializeHOMAD(e) {
    const t = new ve();
    t.setFromObject(this.environmentVars.vastMacros), t.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(Ke)), Z = new U(this.config.adReinsertion, t);
    let i = (s) => {
      o.debug.info(w.NAME + "initializeHOMAD - Utils ready.", s), o.debug.info(w.NAME + "initializeHOMAD - Set vendor API.", s), Z.setVendorAPI(s), Z.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), Z.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = s;
    }, r = (s) => {
      o.debug.warn(w.NAME + "initializeHOMAD Penalty"), i = () => {
      }, Z.vendorAPI ? (o.debug.warn("initializeHOMAD - Penalty during ad playback."), he.call(this, f.SESSION.AD_REINSERTION_PENALTY)) : (o.debug.warn("initializeHOMAD - Error.", s), he.call(this, f.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(d.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const s = e.adReinsertion.homad.setup;
      Yi(
        s.globalConfig,
        s.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (n) => {
          i(n);
        },
        (n) => {
          r(n);
        }
      );
    }
  }
  forceHOMADActivation() {
    this.error && this.error.code === f.SETUP.AD_REINSERTION_PENALTY.code || (Z.setReinsertionReason({
      reason: U.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), Z.enable(
      () => {
        o.debug.info(
          w.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(d.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        o.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, t = {}) {
    this.adBreak = e, this.environmentVars = t, this.error = null;
    let i = null;
    return this.rejectSlotChanges ? (he.call(this, f.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Gi(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = Ve($.timeouts, t.timeouts), this.environmentVars.omidServiceWindow = t.omidServiceWindow || this.config.adVerification.serviceWindow, o.debug.info(w.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((r, s) => {
      this.adBreak.type || (this.adBreak.type = V.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === V.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === V.NON_LINEAR && !this.environmentVars.adContainer && o.debug.warn(w.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, i = super.addEventListener(d.ON_AD_MANIFEST_LOAD_ERROR, () => (o.debug.info(w.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), s(this.error))), super.addEventListener(d.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), i && i(), this.rejectSlotChanges = !1, r("ok")));
      const n = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        o.debug.info(
          w.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), he.call(this, f.SESSION.TIMEOUT), this.dispatchEvent(d.ON_AD_MANIFEST_LOAD_ERROR);
      }, n * 1e3), this.parse(this.adBreak);
    })) : (he.call(this, f.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, t) {
    let i = "HOMADUtils.corroborate - ", r = "Utils not ready.";
    return new Promise((s, n) => {
      if (!$.adReinsertion.homad.utils)
        throw o.debug.info(i + r), new Error(i + r);
      $.adReinsertion.homad.utils.corroborate(t).then(() => {
        o.debug.info(i + "resolved."), s();
      }).catch((l) => {
        o.debug.info(i + "rejected.", l), n(l);
      });
    });
  }
  onAdReinsertionActivation(e) {
    return new Promise((t, i) => {
      if (!$.adReinsertion.homad.setup.activationCallback)
        return t();
      let r = $.adReinsertion.homad.setup.activationCallback.bind(this), s = !1, n = setTimeout(() => (s = !0, t()), U.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), l = "onAdReinsertionActivation ";
      try {
        r(e).then(() => {
          if (clearTimeout(n), o.debug.info(l + "approved."), !s)
            return t();
        }, (h) => {
          if (clearTimeout(n), o.debug.warn(l + "declined.", typeof h), h && h.stack && h.message)
            return Z.disable(), t();
          if (!s)
            return Z.disable(), i();
        });
      } catch (h) {
        return clearTimeout(n), o.debug.warn(l + "failed. Error in activationCallback:", h), s = !0, Z.disable(), t();
      }
    });
  }
  setupEnrichmentAndTCF() {
    const e = new ve();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(Ke)), this.environmentVars.vastMacros.GDPRCONSENT || new Wi(e), e;
  }
  restartAdSlot() {
    o.debug.info(w.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), $.urlhandler = st, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : o.debug.warn(w.NAME + "What to do next?");
    }).catch((e) => {
      o.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  parse(e) {
    const t = Ki(e);
    o.debug.info(w.NAME + "parse - Start parsing the ad slot", t);
    const i = this.setupEnrichmentAndTCF();
    Z = new U(this.config.adReinsertion, i);
    let r = JSON.parse(JSON.stringify($.timeouts));
    const s = {
      adReinsertion: Z,
      blockInsecureURL: $.blockInsecureURL,
      enrichment: i,
      maxWrapperDepth: $.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: t.response ? t.responseXML : null,
      timeouts: r,
      urlhandler: $.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: Ve({}, r),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let n = null, l = this.adBreak;
    if (typeof t == "object" && (l = t), l.urls.length === 1 && (n = l.urls[0], s.response = null), n || s.response) {
      let h = new _t(s);
      n ? h.requestURL(l.urls[0], this.onXMLLoadDone.bind(this, s)) : h.requestFinalXML(s.response, this.onXMLLoadDone.bind(this, s));
    } else
      o.debug.warn(
        w.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], s);
  }
  onXMLLoadDone(e, t) {
    this.rawXMLDocument = t, this.rawAdSlotModel = new wi(t), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  handleParserResponse(e, t) {
    let i = t || {};
    if (!t) {
      let l = je;
      i.adReinsertion = new U(l.adReinsertion, new ve()), i.timeouts = l.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let r = new xi(
      e,
      $,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = r.adSlotModel, this.adSlotBuffet = r.adSlotBuffet, this.sequenceData = r.sequenceData;
    const s = r.hasSessionTimeoutError, n = () => {
      if (!r.hasValidAds || s) {
        he.call(this, s ? f.SESSION.TIMEOUT : f.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(d.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new Ct(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(d.ON_AD_MANIFEST_LOADED);
    };
    if (i.adReinsertion.reinsertionReason && !i.adReinsertion.isActive) {
      o.debug.info(
        w.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        i.adReinsertion.reinsertionReason
      ), i.adReinsertion.enable(
        () => {
          i.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (l) => {
          o.debug.info(
            w.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            l
          ), n();
        }
      );
      return;
    }
    n();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      o.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      o.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      o.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === V.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(d.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(d.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const t = bt;
      this.slot = new t(this.currentAd, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(d.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const i = (r) => {
        this.dispatchEvent(r.type);
      };
      for (const r of Object.values(d))
        this.slot.addEventListener(r, i), this.slot.adSlotController.addEventListener(r, i);
      this.slot.deliverNextAd();
    };
    this.adBreak.type === V.LINEAR ? (o.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((t) => {
      o.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      o.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  resetErrorWarning() {
    const e = [
      f.WARNING.TRACKER_LOAD_FAILED.code,
      f.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let t = 0; t < this.adSlotModelList.length; t++)
      e.indexOf(this.adSlotModelList[t].error.code) !== -1 && (this.adSlotModelList[t].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === V.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((t) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(w.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(d.ON_AD_SLOT_COMPLETE), t())), this.slot.stop().then(() => {
        e();
      }, (i) => {
        o.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", i), e();
      });
    });
  }
  resetContent() {
    o.debug.info(w.NAME + "Reset content.");
    let e = {
      code: f.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, t = !1, i = this.player.restoreContentState.bind(this.player), s = setTimeout(() => {
      t = !0, o.debug.error(w.NAME + "resetContent - timeout"), he.call(this, e), this.dispatchEvent(d.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    i().then(() => {
      t || (clearTimeout(s), o.debug.info(w.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (n) => {
      t || (clearTimeout(s), o.debug.error(
        w.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        n
      ), e.message = "SessionError: Reset content failed.", he.call(this, e), this.dispatchEvent(d.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  closeAdSlot() {
    Z && $.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (Z.disable(), $.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(w.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, t) {
    this.slot && this.slot.adSlotController.onResizeAd(e, t);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string|void} The landing page URL.
   */
  clickThrough(e = !1) {
    if (!this.slot)
      return;
    if (this.ad.hasClickThrough)
      return this.slot.adSlotController.onClickThrough(e);
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, t = !1) {
    if (this.slot)
      return this.dispatchEvent(d.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, t);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {string} reason The reason code corresponding to the cause of the failure.
   */
  verificationNotExecuted(e, t) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, t);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const t = this.ad.companions.filter((i) => i.id === e).shift();
    t && (this.dispatchEvent(d.ON_COMPANION_CREATIVE_VIEW), t.creativeViewTracker.length > 0 && (o.debug.table("Request companion creativeView trackers.", t.creativeViewTracker), this.slot.adSlotController.callTrackers(t.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, t = !0) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    if (i) {
      this.dispatchEvent(d.ON_COMPANION_CLICKED), i.clickTracker.length > 0 && (o.debug.table("Request companion click trackers.", i.clickTracker), this.slot.adSlotController.callTrackers(i.clickTracker));
      let r = i.clickThroughURL;
      if (r) {
        let s = this.slot.currentAd.enrichment.apply(r);
        if (!t) {
          const n = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(s, n);
        }
        return s;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot && this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot && this.slot.play();
  }
  dispatchEvent(e) {
    return o.debug.info(w.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI|null} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Hi(this.adSlotController.currentAd) : (o.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot|null} Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Bi(this.adSlotController, this.sequenceData) : (o.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return ai.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
w.NAME = "AdSAPI::", w.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let yt = w;
const ke = class ke {
  constructor(e, t) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = t;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (o.debug.info(ke.NAME + "AdSlotAPI ready"), this.adSlotAPI = new yt(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (o.debug.info(ke.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (o.debug.info(ke.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new Rt(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
ke.NAME = "MainCtlr::";
let Mt = ke;
const ti = "4.0", ii = ["4.0"], Ht = class Ht {
  hasValidHandshake(e, t = ti, i = ii) {
    if (!e.handshakeVersion)
      return !1;
    const r = e.handshakeVersion(t);
    return i.includes(r);
  }
  hasValidFacadeImplementation(e, t = Ei) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new t())).filter((s) => !(s in e)).length <= 0;
  }
  validate(e) {
    if (!e) {
      this.error = f.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = f.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = f.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, t) {
    let i = Ve(je, t);
    return new Promise((r, s) => {
      this.validate(e);
      function n(l) {
        o.debug.critical("init - error", l), s(l);
      }
      Object.keys(this.initError).length > 0 ? n(this.initError) : r(new Mt(i, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return ot;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return V;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return H;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Ut(je);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return Ke;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return d;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(d);
  }
  get LOGLEVEL() {
    return ce;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    o.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return o.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return o.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return ti;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return ii;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.6.2";
  }
};
Ht.NAME = "Core::";
let dt = Ht;
const zi = new dt();
typeof window != "undefined" && (window.smartclientcore = zi);
typeof exports == "object" && (exports = {
  smartclientcore: dt
});
export {
  Ei as FacadeBase,
  zi as default
};
