var dt = /* @__PURE__ */ ((p) => (p[p.SILENT = 0] = "SILENT", p[p.ERROR = 1] = "ERROR", p[p.NORMAL = 2] = "NORMAL", p[p.VERBOSE = 3] = "VERBOSE", p))(dt || {}), _e = /* @__PURE__ */ ((p) => (p[p.CRITICAL = 0] = "CRITICAL", p[p.ERROR = 1] = "ERROR", p[p.INFO = 2] = "INFO", p[p.TABLE = 3] = "TABLE", p[p.WARN = 4] = "WARN", p))(_e || {});
let _t = dt.SILENT;
const xi = "[OIS_DEBUG]", mo = {
  [dt.ERROR]: [_e.CRITICAL, _e.ERROR],
  [dt.NORMAL]: [_e.INFO, _e.TABLE, _e.WARN],
  [dt.SILENT]: [],
  [dt.VERBOSE]: [_e.CRITICAL, _e.ERROR, _e.INFO, _e.TABLE, _e.WARN]
};
function oi() {
}
class c {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    _t = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return _t;
  }
  static shouldLog(e, i) {
    return i !== dt.SILENT && mo[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(_e.CRITICAL, _t) ? console.error : oi).bind(console, xi),
      info: (this.shouldLog(_e.INFO, _t) ? console.info : oi).bind(console, xi),
      error: (this.shouldLog(_e.ERROR, _t) ? console.error : oi).bind(console, xi),
      table: (this.shouldLog(_e.TABLE, _t) ? console.table : oi).bind(console),
      warn: (this.shouldLog(_e.WARN, _t) ? console.warn : oi).bind(console, xi)
    };
  }
}
const Eo = "4.0";
class go {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return Eo;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var le = /* @__PURE__ */ ((p) => (p.LINEAR = "linear", p.NON_LINEAR = "nonlinear", p))(le || {});
function Hn(p, e = "") {
  return (Array.isArray(p) ? p : [p]).map((r) => e ? `${r} ${e}` : r).join(",");
}
class Kt {
  static cTSTS(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  static gMNE(e, i) {
    let r = -1, s = null;
    for (const l of Q(e, i)) {
      let h = 0, E = l;
      for (; E.parentNode !== e; )
        h++, E = E.parentNode;
      h > r && (r = h, s = l);
    }
    return s;
  }
  static gU(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, h) => !r.includes(l[i], h + 1));
  }
  static t(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
  static f(e, i, r = "") {
    return e.querySelector(Hn(i, r));
  }
  static fA(e, i, r = "") {
    return e.querySelectorAll(Hn(i, r));
  }
}
const Ot = Kt.cTSTS, H = Kt.f, Q = Kt.fA, vo = Kt.gU, ct = Kt.gMNE, Ee = Kt.t;
class So {
  constructor(e) {
    this.adSourceXML = e, this.adSource = H(this.adSourceXML, "AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? Ee(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : Ee(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const Lt = class Lt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return le.NON_LINEAR;
      default:
        return le.LINEAR;
    }
  }
  queryElements(e) {
    return Q(this.adBreakXML, e);
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = H(this.adBreakXML, ":scope > AdSource");
    return e ? new So(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] && this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = Ot(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  getBreakPosition() {
    return this.type === le.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || Ot(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  getExtensions() {
    const e = this.queryElements(":scope > Extensions > Extension"), i = [];
    for (const r of e)
      i.push({
        extensionXML: r,
        type: r.getAttribute("type") || ""
      });
    return i;
  }
  getTrackers() {
    const e = this.queryElements(":scope > TrackingEvents > Tracking");
    let i = {};
    for (const r of e) {
      const s = r.getAttribute("event"), l = r.textContent.trim();
      l && (i[s] = i[s] || [], i[s].push({ url: l }));
    }
    return i;
  }
  getSeparationClips() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = H(this.adBreakXML, "ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
Lt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let ci = Lt;
class yo {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let r = e.documentElement || e, s = Q(r, ":scope > *");
    const l = [];
    for (const Y of s)
      l.push(new ci(Y, i));
    this.adSlotList = l;
    let h = {}, E = [];
    const v = "Ad", y = "AdTagURI", M = "adtaguri", ie = "allowMultipleAds", J = "sequence", Se = "type", G = "VAST";
    for (let Y = 0; Y < s.length; Y++) {
      let I = l[Y];
      I.breakPosition === 2 && I.timeOffset !== null && (h[I.timeOffset] = (h[I.timeOffset] || 0) + 1, h[I.timeOffset] > 1 && (I.multiMidroll = !0, E.length === 0 && (this.adSlotList[Y - 1].multiMidroll = !0, this.adSlotList[Y - 1].adBreakXML.setAttribute(
        Se,
        this.adSlotList[Y - 1].adSource.type
      ), this.adSlotList[Y - 1].adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[Y].adSource.allowMultipleAds.toString()
      ), E.push(this.adSlotList[Y - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[Y].multiMidroll = !0, I.adBreakXML.setAttribute(Se, this.adSlotList[Y].adSource.type), I.adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[Y].adSource.allowMultipleAds.toString()
      ), E.push(I.adBreakXML.cloneNode(!0))));
    }
    if (this.midrollHasSameTimeOffset) {
      let Y = [];
      for (let T = 0; T < E.length; T++)
        if (E[T].getAttribute(Se).includes(M)) {
          let V = document.createElementNS(null, v);
          V.setAttribute(J, (T + 1).toString());
          let W = document.createElementNS(null, "Wrapper");
          W.setAttributeNS(
            null,
            "fallbackOnNoAd",
            E[T].getAttribute(ie)
          );
          let $ = document.createElementNS(null, G + y);
          $.textContent = H(E[T], y).textContent.trim(), W.appendChild($), V.appendChild(W), Y.push(V);
        } else
          H(E[T], v).setAttribute(J, (T + 1).toString()), Y.push(H(E[T], v));
      let I = null;
      for (let T = 0; T < this.adSlotList.length; T++) {
        if (!this.adSlotList[T].multiMidroll)
          continue;
        if (this.adSlotList[T].adBreakXML.hasAttribute(Se) && this.adSlotList[T].adBreakXML.getAttribute(Se).includes(M) && (I = document.createElementNS(null, G + "AdData")), H(this.adSlotList[T].adBreakXML, "Ad") || I) {
          if (I) {
            H(this.adSlotList[T].adBreakXML, "AdTagURI").remove();
            let W = H(this.adSlotList[T].adBreakXML, "AdSource");
            const $ = document.createElementNS(null, "VAST");
            for (const K of Y)
              $.appendChild(K);
            I.appendChild($), W.appendChild(I);
          } else {
            H(this.adSlotList[T].adBreakXML, "Ad").remove();
            const W = H(this.adSlotList[T].adBreakXML, "VAST");
            for (const $ of Y)
              W.appendChild($);
          }
          this.adSlotList[T].multiMidroll = !1, this.adSlotList[T] = new ci(this.adSlotList[T].adBreakXML, this.adSlotList[T].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((T) => {
        if (!T.multiMidroll)
          return T;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class It {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const x = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let Sr = null, yr = null, Wt = 0, Wn = null, Or = null;
const qe = class qe {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (Wn = e), this.enrichment.set("BLOCKED", Wt, "blocked");
  }
  get isActive() {
    return Wt === 1;
  }
  get vendorAPI() {
    return Or;
  }
  setVendorAPI(e) {
    !Or && e && (Or = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    yr = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    Sr = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (c.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !Wn.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      c.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = x.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!yr) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    yr(r, s).then(() => {
      Wt !== qe.STATUS.IS_BLOCKED ? Sr ? Sr(r).then((l) => {
        c.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          qe.STATUS.IS_BLOCKED,
          "blocked"
        ), Wt = qe.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        c.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (c.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        qe.STATUS.IS_BLOCKED,
        "blocked"
      ), Wt = qe.STATUS.IS_BLOCKED, e()) : (c.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    Wt = 0, this.enrichment.set("BLOCKED", qe.STATUS.IS_OPEN, "blocked");
  }
};
qe.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, qe.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, qe.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, qe.EventDispatcher = new It();
let de = qe;
class ke {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: ke.screenHeight(),
      width: ke.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return ke.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !ke.isIF() || ke.isFIF();
  }
}
function Oo() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function ki(p) {
  return encodeURIComponent(p).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function Io() {
  const p = /* @__PURE__ */ new Date(), e = p.toISOString();
  let i = p.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function To(p, e, i) {
  if (p.indexOf(e) === -1)
    return p;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(p) ? parseInt(p.match(/\|(\d+)]/)[1], 10) : 0;
    return p.replace(
      r,
      s === 0 ? ki(i) : ki(i).substring(0, s)
    );
  }
}
function Ui(p) {
  let e = !Number.isFinite(p) || p < 0 ? 0 : p;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function rs() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (p) => {
    let e = Math.random() * 16 | 0;
    return (p === "x" ? e : e & 3 | 8).toString(16);
  });
}
class yt {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], ke.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], Oo), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Ui), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", ke.userAgent(), "deviceua"), this.set("DOMAIN", ke.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", ke.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Ui), this.set("OS", ke.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.6.2", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      ke.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", ke.screenHeight(), "screenheight"), this.set("SCREENWIDTH", ke.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", Io), this.set("TRANSACTIONID", rs(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  getMacros(e = !1) {
    let i = {};
    if (e)
      for (const [r] of this.macroMap)
        i[`[${r}]`] = this.get(r, !0);
    else
      for (const [r] of this.macroMap)
        i[r] = this.get(r, !0);
    return i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, h = r || l.macroList;
    return l.value = i, h ? Array.isArray(h) ? l.macroList = h : l.macroList = [h] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => ki(String(l))).join(",") : ki(String(s)) : s;
  }
  setFromObject(e) {
    if (e)
      for (const i in e) {
        if (!Object.prototype.hasOwnProperty.call(e, i))
          continue;
        const r = e[i], s = typeof r == "string" && r.length === 0 || Array.isArray(r) && r.length === 0 ? "-1" : r;
        this.set(i.toUpperCase(), s, "");
      }
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    let i = e === null ? "" : String(e);
    for (const [r, s] of this.macroMap) {
      const l = String(this.get(r, !0));
      for (const h of s.macroList)
        i = this.replaceMacroWithValue(i, h, l);
    }
    return i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return To(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class Fi {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new Fi().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class Ro {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, h = setTimeout(() => {
      s = !0;
      let M = new Error("ImageURLHandler: Tracking request timeout.");
      M.code = x.WARNING.TRACKER_TIMEOUT.code, M.description = x.WARNING.TRACKER_TIMEOUT.message, M.type = "AdWarning", r(M);
    }, l);
    let E = new Image();
    E.src = "";
    const v = () => {
      clearTimeout(h), !s && r(null);
    }, y = (M) => {
      v();
    };
    return E.onerror = y, E.onload = v, E.src = e, E;
  }
}
function Br(p) {
  if (typeof p != "string")
    return p;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(p, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(p), e = i;
  }
  return e;
}
const Ir = " Response contains neither 'responseXML' nor 'responseText'", Ce = class Ce {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Ce().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, E = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        c.debug.info(Ce.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let v = new Error(Ce.NAME + ": Request timeout");
      v.code = x.WRAPPER.TIMEOUT.code;
      let y = r.timeouts ? r.timeouts.errorMessage : null;
      v.message = y || x.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? de.REASON.WRAPPER_CHAIN_TIMEOUT : de.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: v
      }), i(v, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(E), s.status === 200) {
            let v = s.responseXML;
            if (!v && s.responseText && (v = Br(s.responseText)), !v) {
              c.debug.info(Ce.NAME + Ir);
              let y = new Error(Ce.NAME + Ir);
              y.code = r.isWrapper ? x.WRAPPER.NO_RESPONSE.code : x.XML.INVALID_XML.code, y.message = "XHR Response Error:" + Ir, r.adReinsertion.setReinsertionReason({
                reason: de.REASON.XHR_ERROR,
                xhr: s,
                xhrError: y
              }), i(y, null);
              return;
            }
            i(null, v);
          } else {
            s.onreadystatechange = s.onerror = () => {
              c.debug.info(Ce.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let v = new Error(Ce.NAME + s.statusText);
            v.code = r.isWrapper ? x.WRAPPER.TIMEOUT.code : x.XML.INVALID_XML.code, v.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: de.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: v
            }), i(v, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(E), c.debug.info(Ce.NAME + ": XHR Error.", s.readyState, s.status, e);
        let v = new Error(Ce.NAME + s.statusText);
        v.code = x.WRAPPER.TIMEOUT.code, v.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: de.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: v
        }), i(v, null);
      };
    } catch (v) {
      clearTimeout(E);
      let y = new Error(`${Ce.NAME}: Request error.`);
      y.code = x.WRAPPER.TIMEOUT.code, y.message = `XHR Request Error: ${v}`, r.adReinsertion.setReinsertionReason({
        reason: de.REASON.XHR_ERROR,
        xhr: null,
        xhrError: y
      }), i(y, null);
    }
  }
  get(e, i, r) {
    c.debug.info(`${Ce.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Ce.ISSUER.TRACKING ? Ro.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Ce.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Ce.NAME = "XHRURLHandler";
let pt = Ce;
pt.DEFAULT_TIMEOUT = 4;
function ji(p, e) {
  if (p.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + p;
  }
  return p.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + p : p;
}
const pi = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class $r {
  constructor() {
    this.issuer = pt.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = pi, s.enrichment = new yt()), s.issuer = this.issuer, s.enrichment = s.enrichment || new yt(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = ji(l, ""));
    let h = s.urlhandler;
    if (s.response) {
      let E = s.response;
      i(null, Br(E));
    } else return h && h.supported() ? new h().get(l, i, s) : pt.supported() ? new pt().get(l, i, s) : Fi.supported() ? new Fi().get(l, i, s) : i();
    return null;
  }
}
const di = class di extends $r {
  constructor() {
    super(), this.issuer = pt.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : c.debug.info(di.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    for (const s of e)
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && c.debug.warn(di.NAME + "onResponse failed:", i.name, i, e);
  }
};
di.NAME = "TrackingUrlHandler::";
let Bi = di;
const A = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup",
  // HOMAD
  ON_HOMAD_PENALTY: "HOMADPenalty"
}, Xt = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, Mt = class Mt {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, Mt.ERROR_CODE_MAP[x.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, Mt.ERROR_CODE_MAP[x.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, c.debug.info(
      Ie.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new yt(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new de(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, h) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        c.debug.info(
          Ie.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((E) => {
        c.debug.warn(Ie.NAME + "initAdSlot - Could not init ad slot", E), h(E);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    c.debug.info(
      Ie.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(A.ON_AD_SLOT_START, () => {
        this.trackEvent(Xt.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(A.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(Xt.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(A.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(A.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Mt.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(Xt.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(A.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(Xt.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), c.debug.info(
      Ie.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      Ie.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(
        Ie.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new Bi().track(e, (r, s) => {
      s && c.debug.warn(Ie.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
Mt.ERROR_CODE_MAP = {}, Mt.NAME = "AdBreakCtrl::";
let Cr = Mt;
const $e = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, Tr = "Content - Scan for AdBreaks to play", he = class he extends It {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(A.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(A.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(A.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, c.debug.info(
      he.NAME + "before" + Tr + "."
    ), super.dispatchEvent(A.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      c.debug.info(
        he.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(A.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), c.debug.info(
      he.NAME + "start" + Tr + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, c.debug.info(
      he.NAME + "after" + Tr + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset) {
      this.isSeeking = !1, this.postroll = null;
      for (const s of this.adPlaylist)
        s.timeOffset !== "end" && (s.requested = !0);
      this.requestAdBreak(e);
    }
    if (this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    for (const s of i)
      s.requested = !0;
    return r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new Cr(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((h) => {
        c.debug.info(
          he.NAME + "requestAdBreak - Initialized AdBreak",
          h.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(h), s();
      }).catch((h) => {
        c.debug.warn(
          he.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          h
        ), l(h);
      })) : l(
        he.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      he.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), c.debug.info(he.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = he.PROCESS.REQUEST) {
    function s(h, E) {
      var y;
      const v = h - E;
      return (y = e.publisherSpecs) != null && y.strictOffsets ? v >= 0 && v <= he.STRICT_OFFSET_THRESHOLD : v >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const h = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, h);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === he.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === he.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = Ot(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", Ui(r)), this.adPlaylist.push(new ci(s, e.publisherSpecs)), c.debug.info(
      he.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener($e.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, h = (Date.now() - e) / 1e3;
      l > h + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= he.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        he.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener($e.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), c.debug.info(
      he.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      he.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
he.NAME = "AdPlaylistCtrl::", he.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, he.STRICT_OFFSET_THRESHOLD = 2, he.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let Ie = he;
const No = "HomadXHRUrlHandler", Xn = ": Response contains neither 'responseXML' nor 'responseText'", qt = class qt {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new qt().xhrRequest();
  }
  getAsXHR(e, i, r) {
    function s(v) {
      i(v, null);
    }
    function l(v) {
      if (r.issuer && r.issuer === pt.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let y = v.responseXML;
      if (!y && v.responseText && (y = Br(v.responseText)), !y) {
        let M = new Error(No + Xn);
        M.code = x.XML.INVALID_XML.code, M.description = "HOMAD Response Error" + Xn, i(M, null);
        return;
      }
      i(null, y);
    }
    if (!r.adReinsertion) {
      let v = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      v.code = x.WRAPPER.TIMEOUT.code, v.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(v);
      return;
    }
    const h = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let E = r.adReinsertion.vendorAPI.getUrlRequest(h);
    E.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), c.debug.info(
      qt.NAME + "getAsXHR - Provide VAST Macro List" + E.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(E, (v) => {
      l(v);
    }, (v) => {
      let y, M = "HOMADUtils XHR";
      v.timedOut ? (y = new Error("HomadUtilsURLHandler: Request timeout."), y.code = x.WRAPPER.TIMEOUT.code, y.description = `${M} Timeout Error ${r.timeouts.errorMessage || x.WRAPPER.TIMEOUT.message}`) : (y = new Error("HomadUtilsURLHandler: " + v.statusText), y.code = x.XML.INVALID_XML.code, y.description = `${M} Status Error (${v.status}): ${v.statusText}`), s(y);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = pi.timeouts), c.debug.info(`${qt.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
qt.NAME = "HomadUrlHandler::";
let $i = qt;
function ns(p) {
  return window.location.protocol === "https:" && !p.startsWith("http://") || window.location.protocol !== "https:";
}
function Ye(p, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), p.appendChild(i);
}
const ui = class ui {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (c.debug.info(ui.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return Ye(r, x.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    Q(e, "VMAP").length > 0 && Q(e, "AdBreak").length === 0 && (Ye(r, x.VMAP.NO_ADBREAKS), i = r), Q(e, "VMAP").length === 0 && Q(e, "ParserError").length === 0 && (Ye(r, x.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new $r().get(e, (r, s) => {
        if (!r && s && H(s, "parsererror")) {
          let l = document.createDocumentFragment();
          Ye(l, x.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          c.debug.warn(ui.NAME + "loadURL - XHR Request Error", r), Ye(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  isInsecureURL(e) {
    return this.blockInsecureURL && !ns(e);
  }
};
ui.NAME = "VMAPReqService::";
let _r = ui;
function ss(p) {
  if (!p || typeof p != "object")
    return !1;
  try {
    return p.self === p;
  } catch (e) {
    return !0;
  }
}
function Gt(p, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (ss(i[r]) ? p[r] = i[r] : typeof p[r] == "object" && typeof i[r] == "object" ? p[r] = Gt(p[r], i[r]) : p[r] = i[r]);
  return p;
}
function os() {
  return this.error || null;
}
function at(p) {
  this.error = {
    code: p.code,
    message: p.message,
    timestamp: Date.now()
  };
}
let qn = null;
const Xr = class Xr extends It {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, c.debug.info(Ie.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), c.debug.info(Ie.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = Gt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    qn = new de(this.config.adReinsertion, s);
    const l = {
      adReinsertion: qn,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: Gt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((h, E) => {
      r = this.addEventListener(A.ON_AD_PLAYLIST_LOAD_ERROR, () => E(this.errorAPI)), this.addEventListener(A.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new Ie(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), h("ok")));
      let v = new _r(
        l
      );
      e.tag ? v.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : v.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new yo(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    c.debug.info(Ie.NAME + "onXMLLoadDone and vmap parsed.", i), c.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = H(i, "ParserError"), h = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = x.VMAP.NO_ADBREAKS;
        at.call(this, h), super.dispatchEvent(A.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(A.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      c.debug.info(
        Ie.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), c.debug.info(
            Ie.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = $i, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          c.debug.info(Ie.NAME + "enable - AdReinsertion remains disabled.", l), at.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    super.dispatchEvent(A.ON_AD_PLAYLIST_START);
    for (const e of Object.values(A))
      this.adPlaylistController.addEventListener(e, (i) => {
        super.dispatchEvent(i.type);
      });
    return new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return os.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
Xr.NAME = "AdPlaylAPI::";
let Dr = Xr;
var pe = /* @__PURE__ */ ((p) => (p.CLOSER = "closer", p.DIVIDER = "divider", p.OPENER = "opener", p.COMMERCIAL = "commercial", p.SPONSORED = "sponsored", p))(pe || {});
class Co {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== pe.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const oe = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, ot = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, lt = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, Xe = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, hi = class hi extends c {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.resolutionListeners = {}, this.eventsThatRequireResponse = [
      oe.CLICK_THRU,
      oe.GET_MEDIA_STATE,
      oe.READY,
      oe.REPORT_TRACKING,
      oe.REQUEST_CHANGE_AD_DURATION,
      oe.REQUEST_FULL_SCREEN,
      oe.REQUEST_PAUSE,
      oe.REQUEST_PLAY,
      oe.REQUEST_RESIZE,
      oe.REQUEST_SKIP,
      oe.REQUEST_STOP,
      oe.REQUEST_VIDEO_LOCATION,
      oe.REQUEST_VOLUME,
      lt.AD_SKIPPED,
      lt.AD_STOPPED,
      lt.FATAL_ERROR,
      lt.INIT,
      lt.START_CREATIVE,
      Xe.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === Xe.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((h, E) => {
      this.addResolveRejectListener(r, h, E), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((h) => {
      this.target.postMessage(JSON.stringify(l), "*"), h();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  isResolve(e) {
    return e.type === Xe.RESOLVE;
  }
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      this.isResolve(l) ? i(l.args.value) : r(l.args.value);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  parseData(e) {
    try {
      return JSON.parse(e);
    } catch (i) {
      return null;
    }
  }
  callListeners(e, i) {
    const r = this.listeners[e];
    if (r)
      for (let s = 0; s < r.length; s++)
        r[s](i);
  }
  // eslint-disable-next-line complexity
  isValidSession(e) {
    const i = e.sessionId, r = e.type, s = this.sessionId === "" && r === Xe.CREATE_SESSION, l = this.sessionId === i;
    if (!(!(s || l) || r === null)) {
      if (Object.values(Xe).includes(r))
        this.handleProtocolMessage(e);
      else if (r.startsWith("SIMID:")) {
        const E = r.substring(6);
        this.callListeners(E, e);
      }
    }
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i = this.parseData(e.data);
    i && this.isValidSession(i);
  }
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case Xe.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {}), this.callListeners(i, e);
        break;
      case Xe.RESOLVE:
      // intentional fallthrough
      case Xe.REJECT:
        const s = e.args.messageId, l = this.resolutionListeners[s];
        l && (l(e), delete this.resolutionListeners[s]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Xe.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Xe.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      c.debug.info(hi.NAME + "createSession resolve");
    }, i = () => {
      c.debug.info(hi.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(Xe.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
hi.NAME = "SIMIDPtl::";
let Lr = hi;
function St(p, e) {
  let i = document.createElement(p);
  if (e)
    for (const r in e)
      Object.prototype.hasOwnProperty.call(e, r) && i.setAttribute(r, e[r]);
  return i;
}
const Vi = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, Yn = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Dt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, ai = 0, Rr = -2, _o = !0, Ve = class Ve {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new Lr(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = ai, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = ai, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      c.debug.info(
        Ve.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = St("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    if (c.debug.info(Ve.NAME + "createSimidIframe with", this.creativeAsset), e.style.display = "none", this.container.appendChild(e), this.creativeAsset.resource) {
      const i = new Blob([this.creativeAsset.resource], { type: "text/html" });
      e.src = URL.createObjectURL(i);
    } else
      e.src = this.creativeAsset.fileURL;
    return this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  addListeners() {
    this.simidProtocol.addListener(Xe.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(oe.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(oe.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(oe.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(oe.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(oe.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(oe.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(oe.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      oe.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(oe.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(oe.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(oe.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(oe.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(oe.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = e.y + e.height <= i.height, s = e.x + e.width <= i.width;
    return r && s;
  }
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      c.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  setIFrameDimensions(e) {
    c.debug.info(Ve.NAME + "resize", e), this.IFrame.style.height = e.height.toString(), this.IFrame.style.width = e.width.toString(), this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(A.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: Vi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), c.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), c.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: Vi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), c.debug.error(Ve.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: Vi.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.error(Ve.NAME + i, r.message);
    }
  }
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(lt.INIT, l).then(() => {
      this.resolveInitializationPromise(), c.debug.info(Ve.NAME + "session created");
    }).catch((E) => {
      this.rejectInitializationPromise(E);
    });
  }
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(A.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), c.debug.info(Ve.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(lt.START_CREATIVE);
  }
  onAdInitializedFailed(e) {
    this.setError(x.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(A.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), c.debug.error(Ve.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  setCreativeControlsState(e) {
    let i = Q(document, ".ad_request");
    if (i)
      for (let r of i)
        r.disabled = e;
  }
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        ot.ERROR,
        {
          error: x.SIMID.GENERAL_ERROR.code,
          message: x.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = x.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(ot.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(ot.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(ot.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(ot.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(ot.SEEKING);
    }), this.videoTrackingEvents.set($e.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        ot.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        ot.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Dt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        ot.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Dt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(lt.AD_STOPPED).then(() => {
      c.debug.info(Ve.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(lt.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(A.ON_AD_SKIPPED), this.loadedSource = null;
  }
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(_o), this.adSlotController.dispatchEvent(A.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    c.debug.info(Ve.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.requestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: Yn.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: Vi.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    c.debug.info(Ve.NAME + "onReportTracking -  Creative has asked the player to send a ping."), c.debug.table(i);
  }
  videoComplete() {
    if (this.simidProtocol.sendMessage(ot.ENDED), this.requestedDuration === ai && this.stopAd(Dt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== ai && this.requestedDuration !== Rr) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Dt.CREATIVE_INITIATED);
      }, e);
    }
  }
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== Rr && i < 0) {
      const r = {
        errorCode: Yn.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  compareAdAndReqDurations() {
    this.requestedDuration === ai || this.requestedDuration === Rr || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (c.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Dt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(lt.LOG, i);
  }
};
Ve.NAME = "SIMIDPly::";
let Mr = Ve;
function Gn(p) {
  return p.height >= 0 ? p.y + p.height : p.y;
}
function Kn(p) {
  return p.width >= 0 ? p.x : p.x + p.width;
}
function zn(p) {
  return p.width >= 0 ? p.x + p.width : p.x;
}
function Jn(p) {
  return p.height >= 0 ? p.y : p.y + p.height;
}
function Do(p, e) {
  let i = 0, r = {
    bottom: Math.min(Gn(p), Gn(e)),
    height: 0,
    left: Math.max(Kn(p), Kn(e)),
    right: Math.min(zn(p), zn(e)),
    top: Math.max(Jn(p), Jn(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = p.width * p.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class Lo {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   */
  constructor(e) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(A)) {
      let i = this.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case A.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case A.ON_AD_PLAYBACK_START:
      case A.ON_AD_PLAYING:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case A.ON_AD_PLAYBACK_FINISHED:
      case A.ON_AD_SKIPPED:
      case A.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(A.ON_AD_NOT_VIEWABLE)), this.removeEventListeners(), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.adSlotController.player.getPlayerSize(), i = this.adSlotController.player.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(A.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = Do(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(A.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (c.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(A.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(A.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function Mo(p, e, i) {
  return new Promise((r) => {
    let s = St("iframe", {
      id: p,
      style: e
    });
    s.onload = () => {
      let l = St("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let h = St("style", {});
      h.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(h), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const q = class q extends It {
  // ms
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = c.logLevel === dt.NORMAL || c.logLevel === dt.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = St("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.timeoutAdLoadedTimer = null, this.timeoutScriptLoadTimer = null, this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), Mo(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = St("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = St("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = St("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      c.debug.warn(q.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = x.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest);
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), c.debug.info(
      q.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (c.debug.info(q.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return c.debug.info(
        q.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), c.debug.info(
        q.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), c.debug.info(
      q.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), c.debug.info(
      q.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    c.debug.info(q.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = x.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest);
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    c.debug.info(q.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = x.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness);
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, c.debug.info(q.NAME + "cleanup"), this.dispatchEvent(A.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    c.debug.info(q.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(A.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    c.debug.info(q.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    c.debug.info(q.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    c.debug.info(q.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    c.debug.info(q.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    c.debug.info(q.NAME + "onStartAd"), this.dispatchEvent(A.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression() {
    c.debug.info(q.NAME + "onAdImpression"), this.dispatchEvent(A.ON_AD_IMPRESSION);
  }
  onAdVideoStart() {
    c.debug.info(q.NAME + "onAdVideoStart"), this.dispatchEvent(A.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), q.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (c.debug.warn(q.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, q.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile() {
    c.debug.info(q.NAME + "onAdVideoFirstQuartile"), this.dispatchEvent(A.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint() {
    c.debug.info(q.NAME + "onAdVideoMidpoint"), this.dispatchEvent(A.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile() {
    c.debug.info(q.NAME + "onAdVideoThirdQuartile"), this.dispatchEvent(A.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete() {
    c.debug.info(q.NAME + "onAdVideoComplete"), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.dispatchEvent(A.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange() {
    c.debug.info(q.NAME + "onAdDurationChange"), this.getAllProperties();
  }
  onStopAd() {
    c.debug.info(q.NAME + "onStopAd"), this.dispatchEvent(A.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i) {
    c.debug.info(q.NAME + "onAdError", e, i), this.currentAd.error = this.currentAd.error === null ? x.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(A.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd() {
    this.dispatchEvent(A.ON_AD_SKIPPED), c.debug.info(q.NAME + "onSkipAd"), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(A.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && c.debug.info(
      q.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(A.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange() {
    c.debug.info(q.NAME + "onAdExpandedChange");
  }
  onAdSkippableStateChange() {
    c.debug.info(q.NAME + "onAdSkippableStateChange"), this.dispatchEvent(A.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(A.ON_AD_PROGRESS);
  }
  onAdVolumeChange() {
    c.debug.info(q.NAME + "onAdVolumeChange");
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    c.debug.info(q.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (c.debug.info(q.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(A.ON_AD_CLICKED);
  }
  onAdInteraction(e) {
    c.debug.info(q.NAME + "onAdInteraction", e);
  }
  onAdUserAcceptInvitation() {
    c.debug.info(q.NAME + "onAdUserAcceptInvitation");
  }
  onAdUserMinimize() {
    c.debug.info(q.NAME + "onAdUserMinimize");
  }
  onAdUserClose() {
    c.debug.info(q.NAME + "onAdUserClose");
  }
  onAdPaused() {
    c.debug.info(q.NAME + "onAdPaused");
  }
  onAdPlaying() {
    c.debug.info(q.NAME + "onAdPlaying"), this.dispatchEvent(A.ON_AD_PLAYING);
  }
  onAdLog(e) {
    c.debug.info(q.NAME + "onAdLog", e);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && c.debug.info(
        q.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), c.debug.table(this.debugTiming));
  }
  //Debug -- End
};
q.NAME = "VPAIDBridge::", q.TIMEUPDATE_INTERVAL = 250;
let Pr = q;
const fi = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  //  and it's used in canPlayType, text/html can't be played it's only used for interactive actions.
  VPAID: "application/javascript",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, Be = class Be extends It {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot.
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads.
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {FacadePlayer} player - Facade interface for the player.
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = Be.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(A), this.eventTypes = Object.values(A), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  hasOffsetReached(e, i, r) {
    let s = r.offset;
    return typeof s == "string" && s.indexOf("%") > -1 && (s = parseInt(s, 10) / 100 * i), e >= parseInt(s, 10) && !r.requested;
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new Co(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(fi)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [pe.COMMERCIAL, pe.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new Lo(this));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    for (const i of this.eventCallbacks)
      i();
    this.eventCallbacks = [];
    for (const i of Object.values(A)) {
      const r = this.addEventListener(i, (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }
    if (this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const h = this.currentAd.config.adSourceSelector(
          l
        ).then((E) => E === null || Object.keys(E).length === 0 ? null : E);
        Promise.race([r, h]).then((E) => {
          E === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = E : this.currentAd.properCreative.selectedResource = E, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(A.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, c.debug.info(Be.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === pe.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), c.debug.info(
          Be.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), c.debug.info(Be.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(Be.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new Bi().track(e, (s, l) => {
      l && (c.debug.warn(Be.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : x.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(A.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === le.NON_LINEAR) {
      this.currentAd.error = x.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(A.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = x.VAST.UNSUPPORTED_MIMETYPE), c.debug.info(Be.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(A.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(A.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = ji(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(A.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((h) => h.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === pe.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      c.debug.info(Be.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(A.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(A.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(A.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === Be.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(A.ON_ENTER_FULLSCREEN), this.dispatchEvent(A.ON_PLAYER_EXPAND)) : (this.dispatchEvent(A.ON_EXIT_FULLSCREEN), this.dispatchEvent(A.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(A.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === pe.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(A.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Ui(e)), this.currentAd.variant === pe.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [pe.COMMERCIAL, pe.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          this.hasOffsetReached(e, this.adDuration, s) && this.dispatchEvent(A.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(A.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(A.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(A.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(A.ON_AD_FIRST_QUARTILE), e && i.push(A.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((h) => h === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = Xt[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let h = this.currentAd.trackingEvents[r];
      e === A.ON_AD_PROGRESS && (h = h.filter((E) => this.hasOffsetReached(s, l, E))), this.callTrackers(h);
    }
  }
  loadAdSIMID() {
    this.currentAd.properCreative.selectedCreativeFile.fileURL === "" && this.currentAd.properCreative.selectedCreativeFile.resource === null ? (this.currentAd.error = x.SIMID.GENERAL_ERROR, this.cancelAdWithError()) : (this.simidPlayer = new Mr(this), this.simidPlayer.initializeAd());
  }
  loadAdVPAID() {
    this.vpaidPlayer = new Pr(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      A.ON_AD_CLICKED,
      A.ON_AD_LOADED,
      A.ON_AD_STARTED,
      A.ON_AD_IMPRESSION,
      A.ON_AD_PLAYING,
      A.ON_AD_PLAYBACK_START,
      A.ON_AD_FIRST_QUARTILE,
      A.ON_AD_MID_POINT,
      A.ON_AD_THIRD_QUARTILE,
      A.ON_AD_PLAYBACK_FINISHED,
      A.ON_AD_STOPPED,
      A.ON_AD_SKIPPED,
      A.ON_AD_ERROR,
      A.ON_AD_PROGRESS,
      A.ON_AD_SIZE_CHANGED,
      A.ON_AD_SKIPPABLE_STATE_CHANGE,
      A.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      A.ON_AD_LINEARITY_CHANGE,
      A.ON_AD_SKIPPED,
      A.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case A.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (c.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case A.ON_AD_SKIPPED:
        case A.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case A.ON_AD_LOADED:
      //onStartAd
      case A.ON_AD_STARTED:
      //onStartAd
      case A.ON_AD_IMPRESSION:
      case A.ON_AD_PLAYING:
      //onAdPlaying()
      case A.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case A.ON_AD_FIRST_QUARTILE:
      case A.ON_AD_MID_POINT:
      case A.ON_AD_THIRD_QUARTILE:
      case A.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case A.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case A.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case A.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case A.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case A.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case A.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case A.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case A.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    c.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
Be.NAME = "AdSloCtrl::", Be.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let br = Be;
var li = /* @__PURE__ */ ((p) => (p[p.ERROR_RESOURCE_REJECTED = 1] = "ERROR_RESOURCE_REJECTED", p[p.ERROR_VERIFICATION_NOT_SUPPORTED = 2] = "ERROR_VERIFICATION_NOT_SUPPORTED", p[p.ERROR_ON_RESOURCE_LOAD = 3] = "ERROR_ON_RESOURCE_LOAD", p))(li || {}), gt = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function Po(p) {
  return p && p.__esModule && Object.prototype.hasOwnProperty.call(p, "default") ? p.default : p;
}
var as = {};
(function(p) {
  (function(e, i, r) {
    if (typeof r == "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      let v = function(y) {
        for (var M in y)
          y.hasOwnProperty(M) && (y[M] = v(y[M]));
        return Object.freeze(y);
      };
      var r = {}, s = ["1.6.3-iab357"], l = "default";
      l && s.push(l), i(e, r);
      for (var h in r)
        r.hasOwnProperty(h) && (Object.getOwnPropertyDescriptor(e, h) == null && Object.defineProperty(e, h, {
          value: {}
        }), s.forEach(function(y) {
          if (Object.getOwnPropertyDescriptor(e[h], y) == null) {
            var M = v(r[h]);
            Object.defineProperty(e[h], y, {
              get: function() {
                return M;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(gt, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, u) {
      return a.raw = u, a;
    }, r.arrayIteratorImpl = function(a) {
      var u = 0;
      return function() {
        return u < a.length ? { done: !1, value: a[u++] } : { done: !0 };
      };
    }, r.arrayIterator = function(a) {
      return { next: r.arrayIteratorImpl(a) };
    }, r.makeIterator = function(a) {
      var u = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (u)
        return u.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var u, m = []; !(u = a.next()).done; )
        m.push(u.value);
      return m;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var u = function() {
      };
      return u.prototype = a, new u();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, u, m) {
      return a == Array.prototype || a == Object.prototype || (a[u] = m.value), a;
    }, r.getGlobal = function(a) {
      a = [typeof globalThis == "object" && globalThis, a, typeof window == "object" && window, typeof self == "object" && self, typeof gt == "object" && gt];
      for (var u = 0; u < a.length; ++u) {
        var m = a[u];
        if (m && m.Math == Math)
          return m;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && typeof Symbol("x") == "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, u, m, S) {
      u && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, u, m, S) : r.polyfillUnisolated(a, u, m, S));
    }, r.polyfillUnisolated = function(a, u, m, S) {
      for (m = r.global, a = a.split("."), S = 0; S < a.length - 1; S++) {
        var L = a[S];
        if (!(L in m))
          return;
        m = m[L];
      }
      a = a[a.length - 1], S = m[a], u = u(S), u != S && u != null && r.defineProperty(m, a, { configurable: !0, writable: !0, value: u });
    }, r.polyfillIsolated = function(a, u, m, S) {
      var L = a.split(".");
      a = L.length === 1, S = L[0], S = !a && S in r.polyfills ? r.polyfills : r.global;
      for (var fe = 0; fe < L.length - 1; fe++) {
        var me = L[fe];
        if (!(me in S))
          return;
        S = S[me];
      }
      L = L[L.length - 1], m = r.IS_SYMBOL_NATIVE && m === "es6" ? S[L] : null, u = u(m), u != null && (a ? r.defineProperty(r.polyfills, L, { configurable: !0, writable: !0, value: u }) : u !== m && (r.propertyToPolyfillSymbol[L] === void 0 && (m = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[L] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(L) : r.POLYFILL_PREFIX + m + "$" + L), r.defineProperty(S, r.propertyToPolyfillSymbol[L], { configurable: !0, writable: !0, value: u })));
    }, r.getConstructImplementation = function() {
      function a() {
        function m() {
        }
        return Reflect.construct(m, [], function() {
        }), new m() instanceof m;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var u = Reflect.construct;
        return function(m, S, L) {
          return m = u(m, S), L && Reflect.setPrototypeOf(m, L.prototype), m;
        };
      }
      return function(m, S, L) {
        return L === void 0 && (L = m), L = r.objectCreate(L.prototype || Object.prototype), Function.prototype.apply.call(m, L, S) || L;
      };
    }, r.construct = { valueOf: r.getConstructImplementation }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = { a: !0 }, u = {};
      try {
        return u.__proto__ = a, u.a;
      } catch (m) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, u) {
      if (a.__proto__ = u, a.__proto__ !== u)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, u) {
      if (a.prototype = r.objectCreate(u.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var m = r.setPrototypeOf;
        m(a, u);
      } else
        for (m in u)
          if (m != "prototype")
            if (Object.defineProperties) {
              var S = Object.getOwnPropertyDescriptor(u, m);
              S && Object.defineProperty(a, m, S);
            } else
              a[m] = u[m];
      a.superClass_ = u.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), u = [], m = a; m < arguments.length; m++)
        u[m - a] = arguments[m];
      return u;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var u = r.setPrototypeOf;
        return function(m, S) {
          try {
            return u(m, S), !0;
          } catch (L) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var u = function(fe, me) {
        this.$jscomp$symbol$id_ = fe, r.defineProperty(this, "description", { configurable: !0, writable: !0, value: me });
      };
      u.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var m = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", S = 0, L = function(fe) {
        if (this instanceof L)
          throw new TypeError("Symbol is not a constructor");
        return new u(m + (fe || "") + "_" + S++, fe);
      };
      return L;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var u = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), m = 0; m < u.length; m++) {
        var S = r.global[u[m]];
        typeof S == "function" && typeof S.prototype[a] != "function" && r.defineProperty(S.prototype, a, { configurable: !0, writable: !0, value: function() {
          return r.iteratorPrototype(r.arrayIteratorImpl(this));
        } });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = { next: a }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, u) {
      a instanceof String && (a += "");
      var m = 0, S = !1, L = { next: function() {
        if (!S && m < a.length) {
          var fe = m++;
          return { value: u(fe, a[fe]), done: !1 };
        }
        return S = !0, { done: !0, value: void 0 };
      } };
      return L[Symbol.iterator] = function() {
        return L;
      }, L;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(u) {
          return u;
        });
      };
    }, "es6", "es3"), r.checkStringArgs = function(a, u, m) {
      if (a == null)
        throw new TypeError("The 'this' value for String.prototype." + m + " must not be null or undefined");
      if (u instanceof RegExp)
        throw new TypeError("First argument to String.prototype." + m + " must not be a regular expression");
      return a + "";
    }, r.polyfill("String.prototype.repeat", function(a) {
      return a || function(u) {
        var m = r.checkStringArgs(this, null, "repeat");
        if (0 > u || 1342177279 < u)
          throw new RangeError("Invalid count value");
        u |= 0;
        for (var S = ""; u; )
          u & 1 && (S += m), (u >>>= 1) && (m += m);
        return S;
      };
    }, "es6", "es3"), r.stringPadding = function(a, u) {
      return a = a !== void 0 ? String(a) : " ", 0 < u && a ? a.repeat(Math.ceil(u / a.length)).substring(0, u) : "";
    }, r.polyfill("String.prototype.padStart", function(a) {
      return a || function(u, m) {
        var S = r.checkStringArgs(this, null, "padStart");
        return r.stringPadding(m, u - S.length) + S;
      };
    }, "es8", "es3"), r.owns = function(a, u) {
      return Object.prototype.hasOwnProperty.call(a, u);
    }, r.polyfill("Object.values", function(a) {
      return a || function(u) {
        var m = [], S;
        for (S in u)
          r.owns(u, S) && m.push(u[S]);
        return m;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, u = Object.create(new r.global.Proxy(a, { get: function(m, S, L) {
          return m == a && S == "q" && L == u;
        } }));
        return u.q === !0;
      } catch (m) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function u() {
        if (!a || !Object.seal)
          return !1;
        try {
          var w = Object.seal({}), U = Object.seal({}), ee = new a([[w, 2], [U, 3]]);
          return ee.get(w) != 2 || ee.get(U) != 3 ? !1 : (ee.delete(w), ee.set(U, 4), !ee.has(w) && ee.get(U) == 4);
        } catch (ut) {
          return !1;
        }
      }
      function m() {
      }
      function S(w) {
        var U = typeof w;
        return U === "object" && w !== null || U === "function";
      }
      function L(w) {
        if (!r.owns(w, me)) {
          var U = new m();
          r.defineProperty(w, me, { value: U });
        }
      }
      function fe(w) {
        if (!r.ISOLATE_POLYFILLS) {
          var U = Object[w];
          U && (Object[w] = function(ee) {
            return ee instanceof m ? ee : (Object.isExtensible(ee) && L(ee), U(ee));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var me = "$jscomp_hidden_" + Math.random();
      fe("freeze"), fe("preventExtensions"), fe("seal");
      var Rt = 0, k = function(w) {
        if (this.id_ = (Rt += Math.random() + 1).toString(), w) {
          w = r.makeIterator(w);
          for (var U; !(U = w.next()).done; )
            U = U.value, this.set(U[0], U[1]);
        }
      };
      return k.prototype.set = function(w, U) {
        if (!S(w))
          throw Error("Invalid WeakMap key");
        if (L(w), !r.owns(w, me))
          throw Error("WeakMap key fail: " + w);
        return w[me][this.id_] = U, this;
      }, k.prototype.get = function(w) {
        return S(w) && r.owns(w, me) ? w[me][this.id_] : void 0;
      }, k.prototype.has = function(w) {
        return S(w) && r.owns(w, me) && r.owns(w[me], this.id_);
      }, k.prototype.delete = function(w) {
        return S(w) && r.owns(w, me) && r.owns(w[me], this.id_) ? delete w[me][this.id_] : !1;
      }, k;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function u() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var k = Object.seal({ x: 4 }), w = new a(r.makeIterator([[k, "s"]]));
          if (w.get(k) != "s" || w.size != 1 || w.get({ x: 4 }) || w.set({ x: 4 }, "t") != w || w.size != 2)
            return !1;
          var U = w.entries(), ee = U.next();
          return ee.done || ee.value[0] != k || ee.value[1] != "s" ? !1 : (ee = U.next(), !(ee.done || ee.value[0].x != 4 || ee.value[1] != "t" || !U.next().done));
        } catch (ut) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var m = /* @__PURE__ */ new WeakMap(), S = function(k) {
        if (this.data_ = {}, this.head_ = me(), this.size = 0, k) {
          k = r.makeIterator(k);
          for (var w; !(w = k.next()).done; )
            w = w.value, this.set(w[0], w[1]);
        }
      };
      S.prototype.set = function(k, w) {
        k = k === 0 ? 0 : k;
        var U = L(this, k);
        return U.list || (U.list = this.data_[U.id] = []), U.entry ? U.entry.value = w : (U.entry = { next: this.head_, previous: this.head_.previous, head: this.head_, key: k, value: w }, U.list.push(U.entry), this.head_.previous.next = U.entry, this.head_.previous = U.entry, this.size++), this;
      }, S.prototype.delete = function(k) {
        return k = L(this, k), k.entry && k.list ? (k.list.splice(k.index, 1), k.list.length || delete this.data_[k.id], k.entry.previous.next = k.entry.next, k.entry.next.previous = k.entry.previous, k.entry.head = null, this.size--, !0) : !1;
      }, S.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = me(), this.size = 0;
      }, S.prototype.has = function(k) {
        return !!L(this, k).entry;
      }, S.prototype.get = function(k) {
        return (k = L(this, k).entry) && k.value;
      }, S.prototype.entries = function() {
        return fe(this, function(k) {
          return [k.key, k.value];
        });
      }, S.prototype.keys = function() {
        return fe(this, function(k) {
          return k.key;
        });
      }, S.prototype.values = function() {
        return fe(this, function(k) {
          return k.value;
        });
      }, S.prototype.forEach = function(k, w) {
        for (var U = this.entries(), ee; !(ee = U.next()).done; )
          ee = ee.value, k.call(w, ee[1], ee[0], this);
      }, S.prototype[Symbol.iterator] = S.prototype.entries;
      var L = function(k, w) {
        var U = w && typeof w;
        U == "object" || U == "function" ? m.has(w) ? U = m.get(w) : (U = "" + ++Rt, m.set(w, U)) : U = "p_" + w;
        var ee = k.data_[U];
        if (ee && r.owns(k.data_, U))
          for (k = 0; k < ee.length; k++) {
            var ut = ee[k];
            if (w !== w && ut.key !== ut.key || w === ut.key)
              return { id: U, list: ee, index: k, entry: ut };
          }
        return { id: U, list: ee, index: -1, entry: void 0 };
      }, fe = function(k, w) {
        var U = k.head_;
        return r.iteratorPrototype(function() {
          if (U) {
            for (; U.head != k.head_; )
              U = U.previous;
            for (; U.next != U.head; )
              return U = U.next, { done: !1, value: w(U) };
            U = null;
          }
          return { done: !0, value: void 0 };
        });
      }, me = function() {
        var k = {};
        return k.previous = k.next = k.head = k;
      }, Rt = 0;
      return S;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", h = "omid_message_version", E = "omid_message_args", v = function(a, u, m, S) {
      this.guid = a, this.method = u, this.version = m, this.args = S;
    };
    v.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[h] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[h] == "string" && (a[E] === void 0 || a[E] !== void 0);
    }, v.deserialize = function(a) {
      return new v(a[s], a[l], a[h], a[E]);
    }, v.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[h] = this.version, a), this.args !== void 0 && (a[E] = this.args), a;
    };
    var y = { AdEventType: { SESSION_START: "sessionStart", SESSION_FINISH: "sessionFinish" }, MediaEventType: { LOADED: "loaded", START: "start", FIRST_QUARTILE: "firstQuartile", MIDPOINT: "midpoint", THIRD_QUARTILE: "thirdQuartile", COMPLETE: "complete", PAUSE: "pause", RESUME: "resume", BUFFER_START: "bufferStart", BUFFER_FINISH: "bufferFinish", SKIPPED: "skipped", VOLUME_CHANGE: "volumeChange", PLAYER_STATE_CHANGE: "playerStateChange", AD_USER_INTERACTION: "adUserInteraction" }, ImpressionType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, ErrorType: { GENERIC: "generic" }, AccessMode: { FULL: "full" }, Environment: { APP: "app", WEB: "web" }, CreativeType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, CommunicationType: { NONE: "NONE", DIRECT: "DIRECT", POST_MESSAGE: "POST_MESSAGE" }, MessageMethod: { IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow" } }, M = function(a) {
      this.to = a, this.communicationType_ = y.CommunicationType.NONE;
    };
    M.prototype.sendMessage = function(a, u) {
    }, M.prototype.handleMessage = function(a, u) {
      this.onMessage && this.onMessage(a, u);
    }, M.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, M.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, M.prototype.isDirectCommunication = function() {
      return this.communicationType_ === y.CommunicationType.DIRECT;
    }, M.prototype.isCrossOrigin = function() {
    };
    function ie(a, u) {
      if (!u)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof u != "string" && !(u instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (u.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function J(a, u) {
      if (u == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function Se(a, u) {
      if (u == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof u != "number" || isNaN(u))
        throw Error("Value for " + a + " is not a number");
    }
    function G(a, u, m, S) {
      if (Se(a, u), u < m || u > S)
        throw Error("Value for " + a + " is outside the range [" + m + "," + S + "]");
    }
    function Y() {
      return typeof i == "undefined" ? null : i;
    }
    function I(a, u) {
      return a && (a[u] || (a[u] = {}));
    }
    function T(a, u, m) {
      (m = m === void 0 ? Y() : m) && (a = a.split("."), a.slice(0, a.length - 1).reduce(I, m)[a[a.length - 1]] = u);
    }
    var V = function(a, u) {
      ie("Partner.name", a), ie("Partner.version", u), this.name = a, this.version = u;
    };
    T("OmidSessionClient.Partner", V);
    var W = function(a, u, m, S) {
      S = S === void 0 ? y.AccessMode.FULL : S, ie("VerificationScriptResource.resourceUrl", a), this.resourceUrl = a, this.vendorKey = u, this.verificationParameters = m, this.accessMode = S;
    };
    W.prototype.toJSON = function() {
      return { accessMode: this.accessMode, resourceUrl: this.resourceUrl, vendorKey: this.vendorKey, verificationParameters: this.verificationParameters };
    }, T("OmidSessionClient.VerificationScriptResource", W);
    var $ = function(a, u) {
      ie("UniversalAdId.value", a), ie("UniversalAdId.idRegistry", u), this.value = a, this.idRegistry = u;
    };
    $.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, T("OmidSessionClient.UniversalAdId", $);
    var K = function(a, u, m, S, L) {
      m = m === void 0 ? null : m, S = S === void 0 ? null : S, L = L === void 0 ? null : L, J("Context.partner", a), this.partner = a, this.verificationScriptResources = u, this.videoElement = this.slotElement = null, this.contentUrl = m, this.customReferenceData = S, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = L;
    };
    K.prototype.setVideoElement = function(a) {
      J("Context.videoElement", a), this.videoElement = a;
    }, K.prototype.setSlotElement = function(a) {
      J("Context.slotElement", a), this.slotElement = a;
    }, K.prototype.setServiceWindow = function(a) {
      J("Context.serviceWindow", a), this.serviceWindow = a;
    }, T("OmidSessionClient.Context", K);
    var F = {};
    function _() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof gt != "undefined" && gt)
        return gt;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    F.omidGlobal = _();
    var D = { ROOT: "omidSessionInterface", AD_EVENTS: "adEvents", MEDIA_EVENTS: "mediaEvents" }, C = { sessionError: "reportError" }, B = Object.keys(y.MediaEventType).map(function(a) {
      return y.MediaEventType[a];
    }), z = ["impressionOccurred"], Te = function(a) {
      a = a === void 0 ? F.omidGlobal : a, this.interfaceRoot_ = a[D.ROOT];
    };
    Te.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, Te.prototype.sendMessage = function(a, u, m) {
      if (a == "registerSessionObserver" && (m = [u]), C[a] && (a = C[a]), u = this.interfaceRoot_, 0 <= z.indexOf(a) && (u = u[D.AD_EVENTS]), 0 <= B.indexOf(a) && (u = u[D.MEDIA_EVENTS]), u = u[a], !u)
        throw Error("Unrecognized method name: " + a + ".");
      u.apply(null, r.arrayFromIterable(m));
    };
    function Ue() {
      return typeof crypto != "undefined" && typeof crypto.getRandomValues == "function";
    }
    function Ze() {
      return Ue() ? zt() : bt();
    }
    function zt() {
      var a = new Uint8Array(16);
      crypto.getRandomValues(a), a[6] = a[6] & 15 | 64, a[8] = a[8] & 63 | 128;
      for (var u = [], m = 0; 16 > m; m++)
        u.push(a[m].toString(16).padStart(2, "0"));
      return u[0] + u[1] + u[2] + u[3] + "-" + u[4] + u[5] + "-" + u[6] + u[7] + "-" + u[8] + u[9] + "-" + u[10] + u[11] + u[12] + u[13] + u[14] + u[15];
    }
    function bt() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var u = 16 * Math.random() | 0;
        return a = a === "y" ? (u & 3 | 8).toString(16) : u.toString(16), a;
      });
    }
    function He() {
      var a = r.getRestArguments.apply(0, arguments);
      et(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function et(a, u) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && u();
    }
    var Ge = { Version: "1.6.3-iab357" }, ft = 3;
    function tt(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function it(a, u) {
      a = a.split("-")[0].split("."), u = u.split("-")[0].split(".");
      for (var m = 0; m < ft; m++) {
        var S = parseInt(a[m], 10), L = parseInt(u[m], 10);
        if (S > L)
          break;
        if (S < L)
          return !1;
      }
      return !0;
    }
    var Fe = "1.0.3";
    function wt(a, u) {
      return tt(a) && it(a, Fe) ? u : JSON.stringify(u);
    }
    function xt(a, u) {
      return tt(a) && it(a, Fe) ? u || [] : u && typeof u == "string" ? JSON.parse(u) : [];
    }
    var Ae = { SESSION_SERVICE: "SessionService." };
    function je(a) {
      return Re(a, Ae.SESSION_SERVICE);
    }
    function Re(a, u) {
      return u + a;
    }
    function Le(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function Me(a) {
      if (a === F.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        P(a);
      } catch (u) {
        return !0;
      }
      return !1;
    }
    function P(a) {
      return a.x === "" || a.x !== "";
    }
    function X(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), Le(a) ? a : F.omidGlobal;
    }
    function ve(a) {
      return Le(a) ? a.top : F.omidGlobal;
    }
    var ne = function(a) {
      M.call(this, a), this.communicationType_ = y.CommunicationType.DIRECT, this.handleExportedMessage = ne.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(ne, M), ne.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.handleExportedMessage(a.serialize(), this);
    }, ne.prototype.handleExportedMessage = function(a, u) {
      v.isValidSerializedMessage(a) && this.handleMessage(v.deserialize(a), u);
    }, ne.prototype.isCrossOrigin = function() {
      return !1;
    };
    var se = function(a, u) {
      u = u === void 0 ? F.omidGlobal : u, M.call(this, u);
      var m = this;
      this.communicationType_ = y.CommunicationType.POST_MESSAGE, a.addEventListener("message", function(S) {
        if (typeof S.data == "object") {
          var L = S.data;
          v.isValidSerializedMessage(L) && (L = v.deserialize(L), S.source && m.handleMessage(L, S.source));
        }
      });
    };
    r.inherits(se, M), se.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, se.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.postMessage(a.serialize(), "*");
    }, se.prototype.isCrossOrigin = function() {
      return this.to ? Me(this.to) : !0;
    };
    var Z = { OMID_PRESENT_FRAME_NAME: "omid_v1_present", OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web", OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app", getEnvironmentIframeName: function(a) {
      var u = {};
      return (u[y.Environment.APP] = Z.OMID_PRESENT_FRAME_NAME_APP, u[y.Environment.WEB] = Z.OMID_PRESENT_FRAME_NAME_WEB, u)[a];
    } };
    function At(a, u) {
      try {
        return a.frames && !!a.frames[u];
      } catch (m) {
        return !1;
      }
    }
    Z.isOmidPresent = function(a) {
      return [Z.OMID_PRESENT_FRAME_NAME, Z.OMID_PRESENT_FRAME_NAME_WEB, Z.OMID_PRESENT_FRAME_NAME_APP].some(function(u) {
        return At(a, u);
      });
    }, Z.getOmidEnvironment = function(a) {
      for (var u = r.makeIterator(Object.values(y.Environment)), m = u.next(); !m.done; m = u.next()) {
        m = m.value;
        var S = Z.getEnvironmentIframeName(m);
        if (At(a, S))
          return m;
      }
      return null;
    };
    function Tt(a, u) {
      a.document.write('<iframe style="display:none" id="' + (u + '" name="' + u + '" sandbox></iframe>'));
    }
    Z.declareOmidPresence = function(a, u) {
      a.frames && a.document && ![Z.OMID_PRESENT_FRAME_NAME, Z.OMID_PRESENT_FRAME_NAME_WEB, Z.OMID_PRESENT_FRAME_NAME_APP].some(function(m) {
        return !!a.frames[m];
      }) && (a.document.body == null && Z.isMutationObserverAvailable_(a) ? Z.registerMutationObserver_(a, u) : (u = Z.getEnvironmentIframeName(u), a.document.body ? (Z.appendPresenceIframe_(a, Z.OMID_PRESENT_FRAME_NAME), Z.appendPresenceIframe_(a, u)) : (Tt(
        a,
        Z.OMID_PRESENT_FRAME_NAME
      ), Tt(a, u))));
    }, Z.appendPresenceIframe_ = function(a, u) {
      var m = a.document.createElement("iframe");
      m.id = u, m.name = u, m.style.display = "none", m.sandbox = "", a.document.body.appendChild(m);
    }, Z.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, Z.registerMutationObserver_ = function(a, u) {
      var m = new MutationObserver(function(S) {
        S.forEach(function(L) {
          L.addedNodes[0].nodeName === "BODY" && (L = Z.getEnvironmentIframeName(u), Z.appendPresenceIframe_(a, Z.OMID_PRESENT_FRAME_NAME), Z.appendPresenceIframe_(a, L), m.disconnect());
        });
      });
      m.observe(a.document.documentElement, { childList: !0 });
    };
    var qi = ["omid", "v1_SessionServiceCommunication"];
    function Yi(a, u) {
      return u.reduce(function(m, S) {
        return m && m[S];
      }, a);
    }
    function Jt(a, u, m, S) {
      if (!Me(u))
        try {
          var L = Yi(u, m);
          if (L)
            return new ne(L);
        } catch (fe) {
        }
      return S(u) ? new se(a, u) : null;
    }
    function ye(a, u, m, S) {
      u = r.makeIterator(u);
      for (var L = u.next(); !L.done; L = u.next())
        if (L = Jt(a, L.value, m, S))
          return L;
      return null;
    }
    function Gi(a, u, m) {
      m = m === void 0 ? Z.isOmidPresent : m;
      var S = [a, ve(a)];
      return u && S.unshift(u), ye(a, S, qi, m);
    }
    var te = function(a, u, m) {
      J("AdSession.context", a), this.adSessionId_ = Ze(), this.context_ = a, this.impressionOccurred_ = !1;
      var S = this.context_.serviceWindow || void 0;
      this.communication_ = u || Gi(X(), S), this.sessionInterface_ = m || new Te(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(a.verificationScriptResources), this.sendSlotElement_(a.slotElement), this.sendVideoElement_(a.videoElement), this.sendContentUrl_(a.contentUrl), this.watchSessionEvents_();
    };
    te.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, te.prototype.setCreativeType = function(a) {
      if (a === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + y.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, te.prototype.setImpressionType = function(a) {
      if (a === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + y.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, te.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, te.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, te.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, te.prototype.start = function() {
      var a = { customReferenceData: this.context_.customReferenceData, underEvaluation: this.context_.underEvaluation };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, te.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, te.prototype.error = function(a, u) {
      this.sendOneWayMessage("sessionError", a, u, this.adSessionId_);
    }, te.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, te.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, te.prototype.sendOneWayMessage = function(a) {
      var u = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(u)));
    }, te.prototype.sendMessage = function(a, u) {
      var m = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, u, m) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, u, m);
    }, te.prototype.sendInternalMessage_ = function(a, u, m) {
      var S = Ze();
      u && (this.callbackMap_[S] = u), a = new v(S, je(a), Ge.Version, wt(Ge.Version, m)), this.communication_.sendMessage(a);
    }, te.prototype.handleInternalMessage_ = function(a, u) {
      u = a.method;
      var m = a.guid;
      if (a = a.args, u === "response" && this.callbackMap_[m]) {
        var S = xt(Ge.Version, a);
        this.callbackMap_[m].apply(this, S);
      }
      u === "error" && window.console && He(a);
    }, te.prototype.sendInterfaceMessage_ = function(a, u, m) {
      try {
        this.sessionInterface_.sendMessage(a, u, m);
      } catch (S) {
        He("Failed to communicate with SessionInterface with error:"), He(S);
      }
    }, te.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, te.prototype.impressionOccurred = function() {
      if (this.creativeType_ === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, te.prototype.creativeLoaded = function() {
      if (this.creativeType_ === y.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === y.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, te.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", Ge.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, te.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(u) {
        return u.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, te.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, te.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, te.prototype.sendElement_ = function(a, u) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(u, a, this.adSessionId_) : this.error(y.ErrorType.GENERIC, "Session Client " + u + " called when communication is cross-origin"));
    }, te.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, te.prototype.setElementBounds = function(a) {
      J("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, te.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(u) {
        u.type === y.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = u.data.creativeType, a.impressionType_ = u.data.impressionType), u.type === y.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, T("OmidSessionClient.AdSession", te);
    var Vt = function(a, u, m, S) {
      this.isSkippable = a, this.skipOffset = u, this.isAutoPlay = m, this.position = S;
    };
    Vt.prototype.toJSON = function() {
      return { isSkippable: this.isSkippable, skipOffset: this.skipOffset, isAutoPlay: this.isAutoPlay, position: this.position };
    };
    var Qt = function(a) {
      J("AdEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerAdEvents(), this.adSession = a;
      } catch (u) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    Qt.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, Qt.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, T("OmidSessionClient.AdEvents", Qt);
    var Oe = function(a) {
      J("MediaEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerMediaEvents(), this.adSession = a;
      } catch (u) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    Oe.prototype.start = function(a, u) {
      Se("MediaEvents.start.duration", a), G("MediaEvents.start.mediaPlayerVolume", u, 0, 1), this.adSession.sendOneWayMessage("start", a, u, this.adSessionId_);
    }, Oe.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, Oe.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, Oe.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, Oe.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, Oe.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, Oe.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, Oe.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, Oe.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, Oe.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, Oe.prototype.volumeChange = function(a) {
      G("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, Oe.prototype.playerStateChange = function(a) {
      J("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, Oe.prototype.adUserInteraction = function(a) {
      J("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, T("OmidSessionClient.MediaEvents", Oe);
    var Ki = function(a, u) {
      ie("OmidVersion.semanticVersion", a), ie("OmidVersion.apiLevel", u);
    };
    T("OmidSessionClient.OmidVersion", Ki);
    function zi(a) {
      var u = X();
      new se(u).onMessage = function(m, S) {
        m.method === y.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(S);
      };
    }
    T("OmidSessionClient.listenForServiceWindow", zi), T("OmidSessionClient.VastProperties", Vt);
    var Pe = { VerificationVendorId: { OTHER: 1, MOAT: 2, DOUBLEVERIFY: 3, INTEGRAL_AD_SCIENCE: 4, PIXELATE: 5, NIELSEN: 6, COMSCORE: 7, MEETRICS: 8, GOOGLE: 9, HUMAN: 10, MOBIAN: 11 } };
    function Zt(a) {
      for (var u = r.makeIterator(Ei.keys()), m = u.next(); !m.done; m = u.next()) {
        m = m.value;
        for (var S = r.makeIterator(Ei.get(m)), L = S.next(); !L.done; L = S.next())
          if (L.value.test(a))
            return m;
      }
      return Pe.VerificationVendorId.OTHER;
    }
    var Ei = /* @__PURE__ */ new Map([[Pe.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [Pe.VerificationVendorId.INTEGRAL_AD_SCIENCE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/
    ]], [Pe.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [Pe.VerificationVendorId.NIELSEN, []], [Pe.VerificationVendorId.COMSCORE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/
    ]], [Pe.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [Pe.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [
      Pe.VerificationVendorId.HUMAN,
      [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]
    ], [Pe.VerificationVendorId.MOBIAN, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.outcomes\.net\/.*$/]]]);
    T("OmidSessionClient.verificationVendorIdForScriptUrl", Zt), T("OmidSessionClient.VerificationVendorId", Pe.VerificationVendorId), Pe.verificationVendorIdForScriptUrl = Zt;
  }, p);
})(as);
const bo = /* @__PURE__ */ Po(as), ce = class ce {
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = bo.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      c.debug.warn(ce.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      c.debug.info(
        ce.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (c.debug.info(
      ce.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), c.debug.table(this.verifications), e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      c.debug.info(
        ce.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      ce.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, li.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        li.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  initOMIDJS() {
    this.adSession = this.createAdSession();
    const e = this.ad.adType === "video" ? ce.IMPRESSION_TYPE.RENDER : ce.IMPRESSION_TYPE.AUDIBLE;
    if (this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? e : ce.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), c.debug.info(ce.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return c.debug.error(ce.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((r) => {
        this.trackError(
          r.tracking.verificationNotExecuted,
          li.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const i = () => {
      const r = this.createVastProperties();
      this.adEvents.loaded(r), this.video.removeEventListener("canplaythrough", i);
    };
    return this.video.addEventListener("canplaythrough", i), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  createAdSession() {
    let e = new this.sessionClient.Partner(
      ce.PARTNER_NAME,
      ce.PARTNER_VERSION
    ), i = this.verifications.map((s) => (c.debug.info(
      ce.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      ji(
        s.javascriptResource.url,
        s.javascriptResource.url
      ),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      ji(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(A)) {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case A.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), c.debug.info(ce.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case A.ON_AD_SKIPPED:
      case A.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          c.debug.info(ce.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (c.debug.info(ce.NAME + i, e), !this.adEvents) {
      c.debug.warn(ce.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case A.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case A.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case A.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case A.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case A.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case A.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case A.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case A.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case A.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case A.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case A.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case A.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case A.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case A.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case A.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case A.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  trackError(e, i) {
    this.ad.enrichment.set("REASON", i, "reason"), this.adSlotDelivery.adSlotController.callTrackers(e);
  }
};
ce.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, ce.PARTNER_NAME = "Smartcliptv", ce.PARTNER_VERSION = "7.6.2", ce.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], ce.NAME = "OMID::";
let wr = ce;
const Nr = "Resource", Hi = {
  STATIC: `Static${Nr}`,
  HTML: `HTML${Nr}`,
  IFRAME: `IFrame${Nr}`
}, vt = class vt extends It {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case Hi.STATIC:
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    c.debug.info(vt.NAME + "pause");
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    c.debug.info(vt.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    c.debug.info(vt.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    c.debug.info(vt.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(A.ON_AD_LOADED), this.dispatchEvent(A.ON_AD_STARTED), this.dispatchEvent(A.ON_AD_IMPRESSION), this.dispatchEvent(A.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    c.debug.info(vt.NAME + "onStopAd"), this.dispatchEvent(A.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(A.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
vt.NAME = "NonLinear::";
let xr = vt;
const Qe = class Qe extends It {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i) {
    super(), this.adSlotController = i, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i.player;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        c.debug.info(
          Qe.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (y(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, h = this.getRemoveHandlerForAdSlotControllerEvent(
          A.ON_AD_STARTED,
          s
        ), E = this.getRemoveHandlerForAdSlotControllerEvent(
          A.ON_AD_ERROR,
          l
        ), v = this.getRemoveHandlerForAdSlotControllerEvent(
          A.ON_VPAID_CLEANUP,
          r
        ), y = () => {
          h(), E(), v();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      A.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener($e.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener($e.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(A.ON_AD_PAUSED);
    }), this.addPlayerEventListener($e.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(A.ON_AD_PLAYING);
    }), this.addPlayerEventListener($e.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(A.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(A.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(A.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(A.ON_AD_START, this.saveStartVolume), super.addEventListener(A.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener($e.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(A.ON_AD_STOPPED), c.debug.info(Qe.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener($e.ON_ERROR, () => {
      c.debug.info(
        Qe.NAME + "on - Player sent error event"
      );
    });
  }
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => {
      if (!this.adSlotHasStarted)
        return e();
      this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(A.ON_AD_SLOT_STOPPED));
      for (const i of this.eventCallbacks)
        i();
      return this.eventCallbacks = [], e();
    });
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), c.debug.info(Qe.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(A.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart;
        e.removeImpressionOnStartHandler = (s ? e.adSlotController : e).addEventListener(
          // To bridge the gap between impression (ad loaded) and start (first timeupdate),
          //  a publisher may want the impression to be tracked with the start trackers first.
          s ? A.ON_AD_PLAYBACK_START : A.ON_AD_STARTED,
          () => {
            e.adSlotController.dispatchEvent(A.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(A.ON_AD_CREATIVE_VIEW);
          }
        );
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(A.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    if (e && e.length > 0 && this.dispatchEvent(A.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(A.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(A.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(A.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0) {
      if (!this.currentAd.config.adVerification.disabled)
        this.currentAd.config.adVerification.playerHandles || new wr(this.currentAd, this);
      else {
        c.debug.warn(
          Qe.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
        );
        for (const i of this.currentAd.adVerifications)
          this.currentAd.enrichment.set("REASON", li.ERROR_RESOURCE_REJECTED, "reason"), this.adSlotController.callTrackers(i.tracking.verificationNotExecuted);
      }
      this.dispatchEvent(A.ON_VERIFICATION_DETECTED);
    }
  }
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(A.ON_AD_ERROR)), de.EventDispatcher.dispatchEvent(A.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (h) => {
        s = !0, c.debug.error("VideoProxy load timeout.", h), this.currentAd.error = x.VAST.TIMEOUT, this.deliverOrHOMAD(de.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), c.debug.info(Qe.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (c.debug.info(Qe.NAME + i + "success."), this.adSlotController.dispatchEvent(A.ON_AD_LOADED), this.dispatchEvent(A.ON_AD_STARTED));
      }, (h) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        c.debug.error(Qe.NAME + i + "failed", h);
        const E = {
          [x.VAST.GENERAL_ERROR.code]: x.VAST.GENERAL_ERROR,
          [x.VAST.FILE_NOT_FOUND.code]: x.VAST.FILE_NOT_FOUND,
          [x.VAST.UNSUPPORTED_MIMETYPE.code]: x.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = E[h] || x.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(de.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener($e.ON_LOADED_DATA, () => {
          this.dispatchEvent(A.ON_AD_STARTED), this.dispatchEvent(A.ON_AD_IMPRESSION), this.dispatchEvent(A.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener($e.ON_ENDED, () => {
          this.dispatchEvent(A.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(A.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, c.debug.error(s + " timeout.", l), this.currentAd.error = x.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(A.ON_AD_ERROR), this.deliverOrHOMAD(de.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (c.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (c.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new xr(this, i), [
        A.ON_AD_STARTED,
        A.ON_AD_IMPRESSION,
        A.ON_AD_CREATIVE_VIEW,
        A.ON_AD_NONLINEAR_STOPPED,
        A.ON_AD_STOPPED
      ].map((l) => {
        const h = this.adSlotController.nonLinearView.addEventListener(
          l,
          (E) => {
            this.dispatchEvent(E.type), E.type === A.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(h);
      }), this.addPlayerEventListener($e.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener($e.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && c.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (c.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = x.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(A.ON_AD_ERROR), this.deliverOrHOMAD(de.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
Qe.NAME = "AdSloDel::";
let Vr = Qe;
class Hr {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, h;
    this.adParameters = ((s = (r = H(i, "AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((h = (l = H(i, e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : h.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [];
    const r = Object.values(Hi).join(", ");
    let s = Q(e, r);
    for (let l = 0; l < s.length; l++)
      i.push({
        creativeType: s[l].getAttribute("creativeType"),
        resource: Ee(s[l].textContent || ""),
        type: s[l].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    const s = Q(i, e + "ClickTracking");
    for (const l of s)
      r.push({
        url: Ee(l.textContent),
        id: l.getAttribute("id")
      });
    return r;
  }
}
class wo extends Hr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = Ee(((s = H(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || rs(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function ge(p, e) {
  const i = (p == null ? void 0 : p.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class xo extends Hr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = Ee(((s = H(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = ge(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = Ee(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = Ot(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = ge(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class Vo extends Hr {
  constructor(e, i, r) {
    const s = ge(r, "expandedHeight"), l = ge(r, "expandedWidth"), h = ge(r, "height"), E = r.getAttribute("id"), v = r.getAttribute("maintainAspectRatio") !== "false", y = Ot(
      r.getAttribute("minSuggestedDuration")
    ), M = r.getAttribute("scalable") !== "false", ie = ge(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = h, this.id = E, this.maintainAspectRatio = v, this.minSuggestedDuration = y != null ? y : -1, this.scalable = M, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = ie;
  }
}
var Ai = ((p) => (p.COMPANION = "companion", p[p.LINEAR = le.LINEAR] = "LINEAR", p[p.NON_LINEAR = le.NON_LINEAR] = "NON_LINEAR", p))(Ai || {});
class ko {
  constructor(e) {
    this.adXML = e, this.VASTVersion = this.adXML.parentElement && typeof this.adXML.parentElement.getAttribute == "function" ? parseInt(this.adXML.parentElement.getAttribute("version"), 10) : null, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, h = e.mediaFiles.vpaid, E = [];
    return E = E.concat(
      ...h,
      ...l,
      ...r,
      ...s,
      ...i
    ), E;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  getLinear() {
    let e = H(this.adXML, "InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = H(e, "MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getBaseForVersion(e, i) {
    if (i === null)
      return e;
    const s = {
      2: 3,
      3: 1,
      4: 0
    }[i];
    let l = e;
    for (let h = 0; h < s && l.parentElement; h++)
      l = l.parentElement;
    return l;
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  extractInteractiveCreativeUrl(e) {
    for (const i of e.childNodes)
      if (i.wholeText)
        return i.wholeText.trim();
    return "";
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = Q(e, 'MediaFile[apiFramework="VPAID"]'), s = H(e, "AdParameters");
    for (let h = 0; h < r.length; h++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: ge(r[h], "bitrate"),
        fileURL: Ee(r[h].textContent),
        height: ge(r[h], "height"),
        linearity: le.LINEAR,
        mimeType: r[h].getAttribute("type"),
        width: ge(r[h], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = Q(e, 'MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: ge(r[s], "bitrate"),
        fileURL: Ee(r[s].textContent),
        height: ge(r[s], "height"),
        linearity: le.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: ge(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var E;
    const i = [], r = this.getBaseForVersion(e, this.VASTVersion), s = Q(r, "InteractiveCreativeFile"), l = H(r, "AdParameters"), h = H(r, "HTMLResource");
    for (let v = 0; v < s.length; v++) {
      let y = "", M = null;
      this.VASTVersion && this.VASTVersion < 4 ? (y = this.extractInteractiveCreativeUrl(s[v]), M = y === "" && h ? h.textContent.trim() : null) : y = s[v].textContent.trim(), i.push({
        adParameters: ((E = l == null ? void 0 : l.textContent) == null ? void 0 : E.trim()) || null,
        apiFramework: s[v].getAttribute("apiFramework"),
        delivery: s[v].getAttribute("delivery"),
        fileURL: y,
        linearity: le.LINEAR,
        mimeType: s[v].getAttribute("type"),
        resource: M,
        variableDuration: s[v].getAttribute("variableDuration") === "true"
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = H(e, "ClosedCaptionFiles");
    if (r) {
      let s = Q(r, "ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: le.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [], s = Q(e, i);
    for (const l of s)
      r.push({
        url: Ee(l.textContent) || ""
      });
    return r;
  }
  getIndustryIcons() {
    const e = {};
    let i = Q(this.adXML, "Creatives > Creative > Linear", "Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), h = new xo("Icon", l, i[r]);
      e[s] = h;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  getNonLinear() {
    let e = Q(this.adXML, "InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    c.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = Q(e, "NonLinear"), r = [{
      type: Ai.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new Vo(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = Q(this.adXML, "Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: Ai.COMPANION,
        variations: []
      };
      const s = Q(e[r], "Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const h = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let E = new wo(
            "Companion",
            h,
            s[l]
          );
          i[r].hasCompanionResources = E.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(E);
        }
    }
    return i.reverse();
  }
  getTrackers(e) {
    const i = {}, r = Array.from(Q(this.adXML, "ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], h = l.nodeName === l.nodeName.toUpperCase() ? l.nodeName.toLowerCase() : l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), E = l.getAttribute("event") || h, v = l.getAttribute("offset"), y = {
        offset: "",
        url: Ee(l.textContent)
      };
      if (E === Xt.ON_AD_PROGRESS && v) {
        const M = Ot(v);
        y.offset = typeof M == "number" ? M.toString() : v;
      }
      i[E] = i[E] || [], i[E].push(y);
    }
    return i;
  }
}
class Uo extends c {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    const e = " > Creatives > Creative";
    let i = [];
    const r = Q(this.adXML, "Ad > Wrapper");
    let s = [];
    for (const h of r) {
      let E = Q(h, "Wrapper" + e);
      if (E.length > 0)
        for (const v of E)
          s.push(v);
      else
        i.push(h);
    }
    if (s.length > 0)
      for (const h of s)
        i.push(h);
    let l = Q(this.adXML, "InLine" + e);
    for (const h of l)
      i.push(h);
    return i;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = Q(this.adXML, "Creative");
      for (let h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    for (const l of r) {
      const h = l.getAttributeNames().find((E) => E.toLowerCase() === "adid");
      s.push(l.getAttribute(h) || null);
    }
    return s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (ct(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = H(this.adXML, "InLine", "Advertiser");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = Q(this.adXML, "AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", h = H(s, "JavaScriptResource"), E = this.getNodeContentsAsText(
        H(s, "VerificationParameters") || document.createElement("div")
      ), v = this.getTrackerNodesAsURLArray(
        H(s, "TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && h) {
        const y = {
          javascriptResource: {
            url: Ee(this.getNodeContentsAsText(h)),
            apiFramework: h.getAttribute("apiFramework") || "",
            browserOptional: h.getAttribute("browserOptional") === "true" || !1
          },
          tracking: v,
          vendor: l,
          verificationParameters: E
        };
        i.push(y);
      }
    }
    return i.length > 0 ? vo(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new ko(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = H(this.adXML, "InLine", "Description");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = ct(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    if (this.wrappers.length > 0) {
      let s = Q(this.adXML, "Ad > Wrapper");
      for (const l of s) {
        const h = l.parentElement.getAttribute("id");
        e.push(h);
      }
    }
    let i = null, r = ct(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = Q(this.adXML, "Creative");
      for (const h of l)
        e.push(h);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    let r = [];
    const s = this.getElementsSortedByDepth(i);
    for (const l of s)
      r.push(l.getAttribute("id") || null);
    return r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = H(this.adXML, "InLine", "AdServingId");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = H(this.adXML, "InLine", "Pricing") || ct(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = H(this.adXML, "InLine", "Survey");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = H(this.adXML, "InLine", "AdSystem");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = H(this.adXML, "InLine", "AdTitle");
    return Ee((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML.hasAttribute && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(ge(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(ge(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: ge(this.rawXML, "_loadEnd") - ge(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = Q(this.adXML, "VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(ge(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(ge(i[r], "_loadEnd")).toISOString(),
        loadTime: ge(i[r], "_loadEnd") - ge(i[r], "_loadStart"),
        url: Ee(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = Q(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = Q(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = Q(this.adXML, "Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || Ee(e.getAttribute("idValue") || "unknown")
    };
  }
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML);
      for (const r of i) {
        const s = r.nodeName === r.nodeName.toUpperCase() ? r.nodeName.toLowerCase() : r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      }
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} - Tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    if (!e)
      return i;
    for (const r of Q(e, "Tracking")) {
      const s = this.getNodeContentsAsText(r);
      if (s.length === 0)
        continue;
      const l = r.getAttribute("event");
      l && (i[l] || (i[l] = []), i[l].push(
        { url: s }
      ));
    }
    return i;
  }
}
class Pt extends Uo {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = Q(this.adXML, "Creative", "Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      ct(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return pe.SPONSORED;
      default:
        return pe.COMMERCIAL;
    }
  }
  parseSkipOffsetToNumber() {
    var i;
    const e = Ot(
      ((i = H(this.adXML, "InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  getVariant(e) {
    if (e === null)
      return pe.COMMERCIAL;
    let i = pe.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  getDuration() {
    var i, r;
    const e = ((r = (i = ct(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || Pt.FALLBACK_LINEAR_DURATION;
    return Ot(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  getError() {
    function e(r) {
      if (r.parentNode)
        return H(r.parentNode, ":scope > parsererror");
    }
    const i = H(this.adXML, "parsererror") || e(this.adXML);
    return i ? {
      code: ge(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  flagCappedAds() {
    return H(this.adXML, "InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: x.WRAPPER.NO_RESPONSE.code,
      message: x.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = ct(this.adXML, e);
    return Ee((i == null ? void 0 : i.textContent) || "");
  }
}
Pt.FALLBACK_LINEAR_DURATION = "00:00:20";
class Fo {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  handleXMLDoc(e) {
    let i = H(e, "parsererror"), r = Q(e, ":root > *"), s;
    if (!(H(e, "html") && i)) {
      if (H(e, "html")) {
        s = document.createElement("VAST");
        const l = new Pt(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new Pt(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const h = new Pt(r[l], e);
        this.adList.push(h);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function jo(p, e) {
  const i = Object.values(fi);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let h = i;
  return e && e.length > 0 && (r = e, h = e), h.filter((v) => !("canPlayType" in s) || v === "application/javascript" || s.canPlayType(v) !== "" || l.canPlayType(v) !== "" ? r.push(v) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = h), p.filter((v) => r.find((y) => v.mimeType === y));
}
class Wi {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === le.NON_LINEAR ? $o.select(r, i) : Bo.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class Bo {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((E) => {
        var v;
        !s.selectedCreativeFile && E.apiFramework && (E.isSIMID = (E.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = E.isSIMID ? E : null), (v = s.selectedCreativeFile) != null && v.isSIMID && (E.isSIMID = !0), E.isVPAID = (E.apiFramework + "").toUpperCase() === "VPAID";
      }), l = Wi.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let h = jo(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        h,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  static selectMediaFile(e, i, r) {
    let s = e.filter((E) => E.isSIMID), l = e.filter((E) => E.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let h = [];
    for (let E = 0; E < r.length; ) {
      if (E > 0 && h.length > 0) {
        e = h;
        break;
      }
      e.filter((v) => {
        v.mimeType === r[E] && h.push(v);
      }), E++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, h) => h.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class $o {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((h) => {
        h.selectedResource = null, (h.apiFramework + "").toUpperCase() === "VPAID" && (h.isVPAID = !0, h.resources = h.resources.filter((E) => Wi.isFriendlyVendorHost(
          E.resource,
          i.desiredVPAIDVendors
        )));
      });
      for (const h of l)
        h.resources.length <= 0 ? h.hasCreative = !1 : h.selectedResource = h.resources[0];
      s.variations = l.filter((h) => !!h.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
function kr(p) {
  let e = 0, i = 0, r = 0;
  const s = p.length;
  for (let l = 0; l < p.length; l++) {
    let h = p[l];
    h.variant === pe.COMMERCIAL ? (h.currentCommercial = i += 1, (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (e += 1), h.currentPodSequencing = i - e) : (h.fallbackOnNoAd || !h.fallbackOnNoAd) && h.hasError && (r += 1), h.variant !== pe.COMMERCIAL && (h.currentCommercial = -1), h.sequence = l + 1, h.currentClip = l + 1;
  }
  return {
    totalClips: s,
    totalPlayableClips: s - e - r,
    totalCommercials: i,
    totalPlayableCommercials: i - e
  };
}
const Qn = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function Ho(p, e, i, r) {
  let s = p;
  const l = i, h = r, E = e, v = {
    DIVIDER: pe.DIVIDER,
    CLOSER: pe.CLOSER,
    OPENER: pe.OPENER
  };
  function y(J) {
    let Se = [], G = {
      adParameters: null,
      creativeTrackers: {},
      duration: Pt.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: le.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let Y in J)
      if (Object.prototype.hasOwnProperty.call(J, Y) && Object.prototype.hasOwnProperty.call(Qn, Y.toUpperCase())) {
        let I = J[Y];
        if (typeof I == "string" && I.length > 0) {
          let T = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: I,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Qn[Y.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          G.mediaFiles.push(T);
        }
      }
    return G.supportedMediaFiles = G.mediaFiles, Se.push(G), Se;
  }
  function M() {
    Object.keys(v).forEach((J) => {
      if (l && Object.prototype.hasOwnProperty.call(l, v[J])) {
        const Se = l[v[J]];
        if (!E && !Se.forcePlay)
          return;
        let G = {};
        G.adTrackers = [], G.creatives = y(Se), G.extensions = [], G.id = G.adId = v[J], G.isLinear = !0, G.variant = v[J], G.properCreative = G.creatives[0], G.properCreative.selectedMediaFile = G.properCreative.supportedMediaFiles[0], G.config = h, G.enrichment = new yt(), G.adReinsertion = new de(h.adReinsertion, G.enrichment), G.expectedAdType = l.type, G.isPaused = !0;
        let Y = [];
        switch (v[J]) {
          case v.DIVIDER:
            for (let I = 0; I < s.length; I++)
              I > 0 && s[I].variant !== s[I - 1].variant && Y.push({
                offset: I,
                ad: G
              });
            if (l[v[J]].forcePlay && Y.length === 0) {
              s[0].variant === pe.SPONSORED ? s.unshift(G) : s.push(G);
              break;
            }
            for (let I = 0; I < Y.length; I++) {
              const T = Y[I].offset + I;
              s.splice(T, 0, Y[I].ad);
            }
            break;
          case v.CLOSER:
            s.push(G);
            break;
          case v.OPENER:
            s.unshift(G);
            break;
        }
      }
    });
  }
  M();
  let ie = kr(s);
  return { enrichedManifest: s, sequenceData: ie };
}
function Zn(p) {
  let e = p;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    for (let l of s)
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
  }
  return e;
}
class Wo {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), Zn(this.adSlotModelList), this.adSlotBuffetList = Zn(this.adSlotBuffetList), c.debug.info(this.NAME + "adPod", this.adSlotModelList), c.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  decorateAdList() {
    for (let e = 0; e < this.adList.length; e++) {
      let i = this.adList[e];
      if (i.adBreakPosition = this.adBreak.adBreakPosition, i.config = this.config, i.enrichment = new yt(), i.enrichment.setFromObject(i.publisherMacros), i.expectedAdType = this.adBreak.type, i.publisherMacros = this.environmentVars.vastMacros, i.adReinsertion = new de(i.config.adReinsertion, i.enrichment), i.isPaused = !0, !i.hasError) {
        if (i.creatives.length < 1) {
          i.error = {}, i.error = x.WRAPPER.NO_RESPONSE;
          continue;
        }
        if (i.expectedAdType === le.LINEAR && i.creativeClass.linearAsArray[0].mediaFiles.length === 0 || i.expectedAdType === le.NON_LINEAR && i.creativeClass.nonLinear.length === 0) {
          i.error = {}, i.error = x.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          continue;
        }
        i.expectedAdType === le.LINEAR ? (i.properCreative = Wi.getProperCreative(
          i.creativeClass.linearAsArray,
          this.environmentVars
        ), i.properCreative && (i.closedCaptions = i.properCreative.captions, i.icons = i.properCreative.icons)) : i.properCreative = Wi.getProperCreative(
          i.creativeClass.nonLinear,
          this.environmentVars
        ), i.properCreative || (i.error = {}, i.error = x.VAST.UNSUPPORTED_MIMETYPE);
      }
    }
  }
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.sequenceInfo = kr(this.adSlotModelList), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = [], this.sequenceInfo = kr(this.adSlotModelList));
  }
  extendWithSeparationClips() {
    if (this.adBreak.type !== le.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = Ho(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && H(e.adXML, `ParserError[code="${x.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
var mi = /* @__PURE__ */ ((p) => (p.XHR = "xhr", p.JSONP = "jsonp", p))(mi || {});
const qr = class qr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = Q(this.XMLDoc, "VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((h) => {
          e(h);
        });
      }
    }
  }
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, h) => {
      let E = H(r, "VASTAdTagURI");
      if (E.setAttribute("_loadStart", Date.now().toString()), E.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return Ye(r, x.WRAPPER.CHAIN_TIMEOUT), h(), e;
      if (i >= this.maxWrapperDepth)
        return Ye(
          r,
          x.WRAPPER.LIMIT_REACHED
        ), h(), e;
      if (this.isInsecureURL(e))
        return Ye(r, x.SESSION.MIXED_CONTENT), h(), e;
      if (this.hasSessionTimeoutError)
        return h(), e;
      let v, y;
      this.loadURL(e, !0).then((M) => {
        let ie = H(M, "VASTAdTagURI");
        v = ((ie || {}).textContent || "").trim(), v && (y = ie.parentNode), this.addContentToWrapperNode(r, M), E.setAttribute("_loadEnd", Date.now().toString()), l([v, y]);
      });
    }).then((l) => {
      let [h, E] = l;
      return h ? this.walkDownAdWrappers(h, i + 1, E, s) : e;
    });
  }
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, this.urlHandlerOptions.adRequestMethod === mi.JSONP && c.debug.warn(
      `Request method ${mi.JSONP} is deprecated since v7.6.2 and will be removed in v8.`
    ), new Promise((r) => {
      new $r().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let h = l || document.createDocumentFragment(), E = H(h, "Ad") || h.documentElement || h;
          this.hasSessionTimeoutError = !0, Ye(E, x.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: de.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && H(l, "parsererror")) {
          let h = document.createDocumentFragment();
          Ye(h, x.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: de.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const h = H(l, "VAST");
          if (h && Q(h, ":scope > *").length === 0) {
            let E = document.createDocumentFragment();
            Ye(E, x.WRAPPER.NO_RESPONSE), r(E);
          }
        }
        if (s && !l) {
          let h = document.createDocumentFragment();
          c.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), Ye(h, s), r(h);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  isInsecureURL(e) {
    return this.blockInsecureURL && !ns(e);
  }
  /* c8 ignore stop */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = H(r, "VAST");
      s && s.setAttribute(e, i);
    }
  }
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
qr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Ur = qr;
class Xo {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(h, E) {
      const v = e[h];
      return !v || v.length <= 0 ? (c.debug.info(E), []) : v;
    }
    const r = (h, E) => {
      const v = e.creatives;
      if (v && v.length !== 0) {
        const y = v.find(
          (M) => M.type === h
        );
        if (y && y.variations && y.variations.length > 0)
          return y.variations;
      }
      return c.debug.info(E), [];
    };
    function s(h) {
      return h.charAt(0).toUpperCase() + h.slice(1);
    }
    const l = (h) => {
      var v, y;
      if (e.isLinear) {
        const M = e.properCreative && e.properCreative.selectedMediaFile;
        return M ? M[h] : -1;
      }
      const E = (y = (v = e.creativesArray) == null ? void 0 : v.nonLinearCreative[0]) == null ? void 0 : y.variations[0];
      if (E && e.isExpanded) {
        const M = `expanded${s(h)}`;
        return E[M] === -1 ? E[h] : E[M];
      }
      return E ? E[h] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(Ai.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function h(v, y) {
          return y === 0 || !v.parentElement ? v : h(v.parentElement, y - 1);
        }
        function E(v) {
          const y = h(v, 3), M = y.getAttributeNames().find((ie) => ie.toLowerCase() === "adid");
          return {
            adId: y.getAttribute(M) || null,
            id: y.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let v = null;
          if (e.isSIMID ? v = "InteractiveCreativeFile" : e.isVPAID ? v = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (v = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), v) {
            const y = H(e.adXML, v);
            return E(y);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const v = e.properCreative.variations[0].selectedResource.type, y = e.properCreative.variations[0].selectedResource.creativeType, M = v !== Hi.IFRAME ? H(e.adXML, `${v}[creativeType="${y}"]`) : H(e.adXML, v);
          return E(M);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (c.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== Hi.IFRAME;
        } catch (h) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (c.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const h = e.properCreative;
        return h && h.length !== 0 ? h : (c.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(Ai.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(h) {
        e.volume = h;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class qo {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class ls {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", c.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, c.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class Yo extends ls {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Go extends ls {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class Ko {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      c.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new Go(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new Yo(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : c.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    c.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Wr(p) {
  if (typeof p != "object" || p === null)
    return p;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(p)) {
    const r = p[i];
    ss(r) || (e[i] = Wr(p[i]));
  }
  return e;
}
function zo(p) {
  const e = document.implementation.createDocument(null, "VAST", null);
  e.documentElement.setAttribute("version", "3.0");
  for (const i of p) {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }
  return e;
}
function Jo(p) {
  let e = p;
  if (e.originConfig = Wr(p), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = zo(e.urls)), e.requested = !1, e;
}
const es = "AdBreakValidation";
function Qo(p) {
  var s, l;
  if (!p || typeof p != "object" || Array.isArray(p) || Object.keys(p).length === 0)
    return c.debug.warn(es + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof p.tag == "string" || Array.isArray(p.tag)) && p.tag.length > 0, i = ((l = (s = p.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = p[pe.CLOSER] || p[pe.DIVIDER] || p[pe.OPENER];
  return !e && !i && !r ? (c.debug.warn(es + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function Zo(p, e, i, r, s) {
  var l = l || {};
  (function(h) {
    var E = {
      globalConfig: p,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function v(I) {
        I = [typeof globalThis == "object" && globalThis, I, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
        for (var T = 0; T < I.length; ++T) {
          var V = I[T];
          if (V && V.Math == Math) return V;
        }
        throw Error("Cannot find global object");
      }
      var y = v(this);
      function M(I) {
        var T = 0;
        return function() {
          return T < I.length ? { done: !1, value: I[T++] } : { done: !0 };
        };
      }
      var ie = typeof Object.defineProperties == "function" ? Object.defineProperty : function(I, T, V) {
        return I == Array.prototype || I == Object.prototype || (I[T] = V.value), I;
      };
      function J(I, T) {
        if (T) e: {
          var V = y;
          I = I.split(".");
          for (var W = 0; W < I.length - 1; W++) {
            var $ = I[W];
            if (!($ in V)) break e;
            V = V[$];
          }
          I = I[I.length - 1], W = V[I], T = T(W), T != W && T != null && ie(V, I, { configurable: !0, writable: !0, value: T });
        }
      }
      J("Symbol", function(I) {
        function T($) {
          if (this instanceof T) throw new TypeError("Symbol is not a constructor");
          return new V("jscomp_symbol_" + ($ || "") + "_" + W++, $);
        }
        function V($, K) {
          this.j = $, ie(this, "description", { configurable: !0, writable: !0, value: K });
        }
        if (I) return I;
        V.prototype.toString = function() {
          return this.j;
        };
        var W = 0;
        return T;
      }), J("Symbol.iterator", function(I) {
        if (I) return I;
        I = Symbol("Symbol.iterator");
        for (var T = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), V = 0; V < T.length; V++) {
          var W = y[T[V]];
          typeof W == "function" && typeof W.prototype[I] != "function" && ie(W.prototype, I, { configurable: !0, writable: !0, value: function() {
            return Se(M(this));
          } });
        }
        return I;
      });
      function Se(I) {
        return I = { next: I }, I[Symbol.iterator] = function() {
          return this;
        }, I;
      }
      function G(I) {
        var T = typeof Symbol != "undefined" && Symbol.iterator && I[Symbol.iterator];
        return T ? T.call(I) : { next: M(I) };
      }
      function Y(I, T) {
        return Object.prototype.hasOwnProperty.call(I, T);
      }
      J("WeakMap", function(I) {
        function T(D) {
          if (this.h = (_ += Math.random() + 1).toString(), D) {
            D = G(D);
            for (var C; !(C = D.next()).done; ) C = C.value, this.set(C[0], C[1]);
          }
        }
        function V() {
        }
        function W(D) {
          var C = typeof D;
          return C === "object" && D !== null || C === "function";
        }
        function $(D) {
          if (!Y(D, F)) {
            var C = new V();
            ie(D, F, { value: C });
          }
        }
        function K(D) {
          var C = Object[D];
          C && (Object[D] = function(B) {
            return B instanceof V ? B : (Object.isExtensible(B) && $(B), C(B));
          });
        }
        if (function() {
          if (!I || !Object.seal) return !1;
          try {
            var D = Object.seal({}), C = Object.seal({}), B = new I([[D, 2], [C, 3]]);
            return B.get(D) != 2 || B.get(C) != 3 ? !1 : (B.delete(D), B.set(C, 4), !B.has(D) && B.get(C) == 4);
          } catch (z) {
            return !1;
          }
        }()) return I;
        var F = "$jscomp_hidden_" + Math.random();
        K("freeze"), K("preventExtensions"), K("seal");
        var _ = 0;
        return T.prototype.set = function(D, C) {
          if (!W(D)) throw Error("Invalid WeakMap key");
          if ($(D), !Y(D, F)) throw Error("WeakMap key fail: " + D);
          return D[F][this.h] = C, this;
        }, T.prototype.get = function(D) {
          return W(D) && Y(D, F) ? D[F][this.h] : void 0;
        }, T.prototype.has = function(D) {
          return W(D) && Y(
            D,
            F
          ) && Y(D[F], this.h);
        }, T.prototype.delete = function(D) {
          return W(D) && Y(D, F) && Y(D[F], this.h) ? delete D[F][this.h] : !1;
        }, T;
      }), J("Map", function(I) {
        function T() {
          var _ = {};
          return _.c = _.next = _.head = _;
        }
        function V(_, D) {
          var C = _.b;
          return Se(function() {
            if (C) {
              for (; C.head != _.b; ) C = C.c;
              for (; C.next != C.head; ) return C = C.next, { done: !1, value: D(C) };
              C = null;
            }
            return { done: !0, value: void 0 };
          });
        }
        function W(_, D) {
          var C = D && typeof D;
          C == "object" || C == "function" ? K.has(D) ? C = K.get(D) : (C = "" + ++F, K.set(D, C)) : C = "p_" + D;
          var B = _.g[C];
          if (B && Y(_.g, C)) for (_ = 0; _ < B.length; _++) {
            var z = B[_];
            if (D !== D && z.key !== z.key || D === z.key) return { id: C, list: B, index: _, a: z };
          }
          return {
            id: C,
            list: B,
            index: -1,
            a: void 0
          };
        }
        function $(_) {
          if (this.g = {}, this.b = T(), this.size = 0, _) {
            _ = G(_);
            for (var D; !(D = _.next()).done; ) D = D.value, this.set(D[0], D[1]);
          }
        }
        if (function() {
          if (!I || typeof I != "function" || !I.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var _ = Object.seal({ x: 4 }), D = new I(G([[_, "s"]]));
            if (D.get(_) != "s" || D.size != 1 || D.get({ x: 4 }) || D.set({ x: 4 }, "t") != D || D.size != 2) return !1;
            var C = D.entries(), B = C.next();
            return B.done || B.value[0] != _ || B.value[1] != "s" ? !1 : (B = C.next(), !(B.done || B.value[0].x != 4 || B.value[1] != "t" || !C.next().done));
          } catch (z) {
            return !1;
          }
        }()) return I;
        var K = /* @__PURE__ */ new WeakMap();
        $.prototype.set = function(_, D) {
          _ = _ === 0 ? 0 : _;
          var C = W(this, _);
          return C.list || (C.list = this.g[C.id] = []), C.a ? C.a.value = D : (C.a = { next: this.b, c: this.b.c, head: this.b, key: _, value: D }, C.list.push(C.a), this.b.c.next = C.a, this.b.c = C.a, this.size++), this;
        }, $.prototype.delete = function(_) {
          return _ = W(this, _), _.a && _.list ? (_.list.splice(_.index, 1), _.list.length || delete this.g[_.id], _.a.c.next = _.a.next, _.a.next.c = _.a.c, _.a.head = null, this.size--, !0) : !1;
        }, $.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = T(), this.size = 0;
        }, $.prototype.has = function(_) {
          return !!W(this, _).a;
        }, $.prototype.get = function(_) {
          return (_ = W(this, _).a) && _.value;
        }, $.prototype.entries = function() {
          return V(this, function(_) {
            return [_.key, _.value];
          });
        }, $.prototype.keys = function() {
          return V(this, function(_) {
            return _.key;
          });
        }, $.prototype.values = function() {
          return V(this, function(_) {
            return _.value;
          });
        }, $.prototype.forEach = function(_, D) {
          for (var C = this.entries(), B; !(B = C.next()).done; ) B = B.value, _.call(D, B[1], B[0], this);
        }, $.prototype[Symbol.iterator] = $.prototype.entries;
        var F = 0;
        return $;
      }), J("Object.is", function(I) {
        return I || function(T, V) {
          return T === V ? T !== 0 || 1 / T === 1 / V : T !== T && V !== V;
        };
      }), J("Array.prototype.includes", function(I) {
        return I || function(T, V) {
          var W = this;
          W instanceof String && (W = String(W));
          var $ = W.length;
          for (V = V || 0, 0 > V && (V = Math.max(V + $, 0)); V < $; V++) {
            var K = W[V];
            if (K === T || Object.is(K, T)) return !0;
          }
          return !1;
        };
      }), J("String.prototype.includes", function(I) {
        return I || function(T, V) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (T instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(T, V || 0) !== -1;
        };
      }), J("Array.from", function(I) {
        return I || function(T, V, W) {
          V = V != null ? V : function(_) {
            return _;
          };
          var $ = [], K = typeof Symbol != "undefined" && Symbol.iterator && T[Symbol.iterator];
          if (typeof K == "function") {
            T = K.call(T);
            for (var F = 0; !(K = T.next()).done; ) $.push(V.call(W, K.value, F++));
          } else for (K = T.length, F = 0; F < K; F++) $.push(V.call(W, T[F], F));
          return $;
        };
      }), function() {
        function I() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function T() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function V(F) {
          return F == "True" || F == "true" || F == 1 || F == "1" || F == 1;
        }
        function W() {
          var F = function() {
            var B = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), z = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Te = B.slice(0, B.length / 2).split("").reverse().join("");
            return B = B.slice(B.length / 2).split("").reverse().join(""), z + Te + z + B + z;
          }(), _ = function(B) {
            var z = 0, Te;
            if (B.length == 0) return z;
            var Ue = 0;
            for (Te = B.length; Ue < Te; Ue++) z = (z << 5) - z + B.charCodeAt(Ue), z |= 0;
            return Math.abs(z);
          }(F).toString();
          _ = (_ + _.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), F = btoa(F).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var D = "", C = 0; C < _.length; C++) D += F.charAt(_[C]);
          return D || "zork";
        }
        function $(F, _) {
          return F = Math.round(Math.abs(F)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, F);
        }
        I.prototype.getItem = function(F) {
          return this.i[F] || this.client[F] || this.f[F];
        }, I.prototype.l = function(F) {
          this.f = F.embed, this.global = F.global, this.client = F.client, this.i = F.customer;
        };
        var K = null;
        K = new I(), function(F) {
          function _(P, X, ve) {
            var ne = { homad_url_prefix_alias: "", homad_track_key: "*" + encodeURIComponent(P) + "*", homad_track_value: "*" + encodeURIComponent(X.toString()) + "*" }, se = ve ? null : function() {
              _(P, X, !0);
            };
            ve = ve ? D(!0) : C(), et(ve, null, se, ne);
          }
          function D(P) {
            return P = P ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + P.slice(P.length - 2).join(".") + "/[hash]/").replace("[hash]", T($()));
          }
          function C() {
            if (Re && Re.server) {
              var P = Re.server[Math.floor(Math.random() * Re.server.length)] + "";
              return P.replace("[hash]", T($()));
            }
            return D(!1);
          }
          function B() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(X) {
              try {
                X.pause();
              } catch (ve) {
              }
              X.parentNode.removeChild(X);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(X) {
              X.parentNode.removeChild(X);
            }), window.self != window.top) for (var P = window.document; P.hasChildNodes(); ) P.removeChild(P.lastChild);
            Me.get("setTimeout")(B, Math.round(1e3 + 100 * Math.random()));
          }
          function z(P) {
            return Fe && clearTimeout(Fe), _("stats_embed_penalty", P), B(), !1;
          }
          function Te() {
            je && je.enabled === !1 || Re && Re.enabled === !1 || Le && Le.enabled === !1 ? clearTimeout(Fe) : z("load_main");
          }
          function Ue() {
            et(Le.src.toString(), function(P) {
              Le.src.toString() === P.responseURL ? (P = ft(P.responseText), Le.data = P, Le.enabled = V(P.enabled), Te()) : z("redirect_customer");
            }, function() {
              Le.data = {}, Le.enabled = void 0, Te();
            });
          }
          function Ze() {
            var P = Re.src;
            typeof P == "string" ? et(P.toString(), function(X) {
              P.toString() === X.responseURL ? (X = ft(X.responseText), Re.data = X, Re.enabled = V(X.enabled), Le.src = X.config, Ue()) : z("redirect_client");
            }, function() {
              Re.data = {}, Re.enabled = void 0, Ue();
            }) : (Re.data = typeof P == "function" ? P() : P, Ue());
          }
          function zt() {
            et(je.src.toString(), function(P) {
              je.src.toString() === P.responseURL ? (P = ft(P.responseText), je.data = P, je.enabled = V(P.enabled), Ze()) : z("redirect_global");
            }, function() {
              je.data = {}, je.enabled = void 0, Ze();
            });
          }
          function bt(P) {
            clearTimeout(Fe);
            var X = new P();
            X.init(K.f.globalConfig, K.f.clientConfig, !0, function() {
              K.f.utilsReady(X);
            }, function() {
              z("utils_init");
            }, K.f);
          }
          function He(P) {
            var X = Ae.shift();
            X ? !window[W()] || P ? Ge(X) : P || clearTimeout(Fe) : zt();
          }
          function et(P, X, ve, ne) {
            ne = ne === void 0 ? null : ne;
            var se = new XMLHttpRequest();
            if (se.onreadystatechange = function() {
              X && se.readyState == 4 && se.status == 200 && X(se), ve && se.readyState == 4 && se.status != 200 && ve(se);
            }, ne) {
              var Z = "", At;
              for (At in ne) Z += "&" + At + "=" + encodeURIComponent(ne[At]);
              Z = Z.substr(1), se.open("POST", P, !0), se.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), se.send(Z);
            } else se.open("GET", P, !0), se.send();
          }
          function Ge(P) {
            var X = document.createElement.toString().includes("native code") ? document.createElement("script") : Me.get("createElement")("script"), ve;
            if (X.setAttribute("data-info", it), X.src = P, X.onload = function(se) {
              se.currentTarget.getAttribute("id") === W() ? tt() ? (se = ve[it.split("").reverse().join("")], bt(se)) : clearTimeout(Fe) : Ae.length ? He(!0) : z("main_redirect");
            }, X.onerror = function() {
              He(!0);
            }, window[W()] || (window[W()] = $(5 + Math.round(5 * Math.random()))), tt()) {
              var ne = document.createElement.toString().includes("native code") ? document.createElement("iframe") : Me.get("createElement")("iframe");
              if (!ne || ne.nodeName.toLowerCase() !== "iframe" || !ne.nodeType) return z("utils_iframe");
              ne.style.display = "none", ne.onload = function() {
                if (ve = ne.contentWindow, ve[it] = F, ne.contentWindow.document.body.appendChild(X) !== X) return z("utils_script");
              }, document.body.appendChild(ne);
            } else document.head.appendChild(X);
          }
          function ft(P) {
            var X = Me.get("JSON");
            try {
              var ve = X.parse(P);
            } catch (ne) {
              ve = {};
            }
            return ve;
          }
          function tt() {
            return K.f.utilsReady != null;
          }
          var it = $(10 + Math.round(10 * Math.random()));
          window[it] = F, K = new I(), K.l({ embed: F }), K.f.version = "20230601_1407";
          var Fe = 0, wt = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], xt = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], Ae = tt() ? xt : wt, je = { src: F.globalConfig, enabled: void 0, data: null }, Re = { src: F.clientConfig, enabled: void 0, data: null }, Le = { src: null, enabled: void 0, data: null }, Me = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var P = document.createElement("iframe");
              P.style.display = "none", document.body.appendChild(P);
              var X = P.contentWindow;
            } else document.head ? (P = document.createElement("iframe"), P.style.display = "none", document.head.appendChild(P), X = P.contentWindow) : X = window;
            Me.set("JSON", X.JSON), Me.set("createElement", X.document.createElement.bind(document)), Me.set("setTimeout", X.setTimeout.bind(window)), P && P.parentNode && P.parentNode.removeChild(P);
          })(), function() {
            Fe = Me.get("setTimeout")(function() {
              z("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), He();
        }(E);
      }();
    })();
  }).bind(l)(l);
}
let De = null, xe = null;
const ae = class ae extends It {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: le.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = De = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : pt, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(A.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = de.EventDispatcher.addEventListener(
      A.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = De.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  initializeHOMAD(e) {
    const i = new yt();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(fi)), xe = new de(this.config.adReinsertion, i);
    let r = (l) => {
      c.debug.info(ae.NAME + "initializeHOMAD - Utils ready.", l), c.debug.info(ae.NAME + "initializeHOMAD - Set vendor API.", l), xe.setVendorAPI(l), xe.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), xe.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      c.debug.warn(ae.NAME + "initializeHOMAD Penalty"), r = () => {
      }, xe.vendorAPI ? (c.debug.warn("initializeHOMAD - Penalty during ad playback."), at.call(this, x.SESSION.AD_REINSERTION_PENALTY)) : (c.debug.warn("initializeHOMAD - Error.", l), at.call(this, x.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(A.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      Zo(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (h) => {
          r(h);
        },
        (h) => {
          s(h);
        }
      );
    }
  }
  forceHOMADActivation() {
    this.error && this.error.code === x.SETUP.AD_REINSERTION_PENALTY.code || (xe.setReinsertionReason({
      reason: de.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), xe.enable(
      () => {
        c.debug.info(
          ae.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(A.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        c.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (at.call(this, x.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Qo(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = Gt(De.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, c.debug.info(ae.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = le.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === le.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === le.NON_LINEAR && !this.environmentVars.adContainer && c.debug.warn(ae.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(A.ON_AD_MANIFEST_LOAD_ERROR, () => (c.debug.info(ae.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(A.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const h = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        c.debug.info(
          ae.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), at.call(this, x.SESSION.TIMEOUT), this.dispatchEvent(A.ON_AD_MANIFEST_LOAD_ERROR);
      }, h * 1e3), this.parse(this.adBreak);
    })) : (at.call(this, x.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, h) => {
      if (!De.adReinsertion.homad.utils)
        throw c.debug.info(r + s), new Error(r + s);
      De.adReinsertion.homad.utils.corroborate(i).then(() => {
        c.debug.info(r + "resolved."), l();
      }).catch((E) => {
        c.debug.info(r + "rejected.", E), h(E);
      });
    });
  }
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!De.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = De.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, h = setTimeout(() => (l = !0, i()), de.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), E = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(h), c.debug.info(E + "approved."), !l)
            return i();
        }, (v) => {
          if (clearTimeout(h), c.debug.warn(E + "declined.", typeof v), v && v.stack && v.message)
            return xe.disable(), i();
          if (!l)
            return xe.disable(), r();
        });
      } catch (v) {
        return clearTimeout(h), c.debug.warn(E + "failed. Error in activationCallback:", v), l = !0, xe.disable(), i();
      }
    });
  }
  setupEnrichmentAndTCF() {
    const e = new yt();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(fi)), this.environmentVars.vastMacros.GDPRCONSENT || new Ko(e), e;
  }
  restartAdSlot() {
    c.debug.info(ae.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), De.urlhandler = $i, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : c.debug.warn(ae.NAME + "What to do next?");
    }).catch((e) => {
      c.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  parse(e) {
    const i = Jo(e);
    c.debug.info(ae.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    xe = new de(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(De.timeouts));
    const l = {
      adReinsertion: xe,
      blockInsecureURL: De.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: De.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: De.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: Gt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let h = null, E = this.adBreak;
    if (typeof i == "object" && (E = i), E.urls.length === 1 && (h = E.urls[0], l.response = null), h || l.response) {
      let v = new Ur(l);
      h ? v.requestURL(E.urls[0], this.onXMLLoadDone.bind(this, l)) : v.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      c.debug.warn(
        ae.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new Fo(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let E = pi;
      r.adReinsertion = new de(E.adReinsertion, new yt()), r.timeouts = E.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new Wo(
      e,
      De,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, h = () => {
      if (!s.hasValidAds || l) {
        at.call(this, l ? x.SESSION.TIMEOUT : x.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(A.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new br(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(A.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      c.debug.info(
        ae.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (E) => {
          c.debug.info(
            ae.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            E
          ), h();
        }
      );
      return;
    }
    h();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      c.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      c.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      c.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === le.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(A.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(A.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = Vr;
      this.slot = new i(this.currentAd, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(A.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      for (const s of Object.values(A))
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      this.slot.deliverNextAd();
    };
    this.adBreak.type === le.LINEAR ? (c.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      c.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      c.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  resetErrorWarning() {
    const e = [
      x.WARNING.TRACKER_LOAD_FAILED.code,
      x.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === le.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(ae.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(A.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        c.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  resetContent() {
    c.debug.info(ae.NAME + "Reset content.");
    let e = {
      code: x.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, c.debug.error(ae.NAME + "resetContent - timeout"), at.call(this, e), this.dispatchEvent(A.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), c.debug.info(ae.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (h) => {
      i || (clearTimeout(l), c.debug.error(
        ae.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        h
      ), e.message = "SessionError: Reset content failed.", at.call(this, e), this.dispatchEvent(A.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  closeAdSlot() {
    xe && De.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (xe.disable(), De.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(ae.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string|void} The landing page URL.
   */
  clickThrough(e = !1) {
    if (!this.slot)
      return;
    if (this.ad.hasClickThrough)
      return this.slot.adSlotController.onClickThrough(e);
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(A.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {string} reason The reason code corresponding to the cause of the failure.
   */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(A.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (c.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(A.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (c.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const h = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, h);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot && this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot && this.slot.play();
  }
  dispatchEvent(e) {
    return c.debug.info(ae.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI|null} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Xo(this.adSlotController.currentAd) : (c.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot|null} Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new qo(this.adSlotController, this.sequenceData) : (c.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return os.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
ae.NAME = "AdSAPI::", ae.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Fr = ae;
const Yt = class Yt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (c.debug.info(Yt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Fr(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (c.debug.info(Yt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (c.debug.info(Yt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new Dr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Yt.NAME = "MainCtlr::";
let jr = Yt;
function ea() {
  var p = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? { done: !1, value: t[n++] } : { done: !0 };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return { next: r(t) };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var h = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, E = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function v(t) {
      t = [typeof globalThis == "object" && globalThis, t, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var y = v(this);
    function M(t, n) {
      if (n) e: {
        var o = y;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var f = t[d];
          if (!(f in o)) break e;
          o = o[f];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && E(o, t, { configurable: !0, writable: !0, value: n });
      }
    }
    var ie;
    if (typeof Object.setPrototypeOf == "function") ie = Object.setPrototypeOf;
    else {
      var J;
      e: {
        var Se = { a: !0 }, G = {};
        try {
          G.__proto__ = Se, J = G.a;
          break e;
        } catch (t) {
        }
        J = !1;
      }
      ie = J ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var Y = ie;
    function I(t, n) {
      if (t.prototype = h(n.prototype), t.prototype.constructor = t, Y) Y(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.xa = n.prototype;
    }
    function T() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function V(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var W = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var f in d) V(d, f) && (t[f] = d[f]);
      }
      return t;
    };
    M("Object.assign", function(t) {
      return t || W;
    }), M("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), M("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var f = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + f, 0)); o < f; o++) {
          var g = d[o];
          if (g === n || Object.is(g, n)) return !0;
        }
        return !1;
      };
    });
    function $(t, n, o) {
      if (t == null) throw new TypeError("The 'this' value for String.prototype." + o + " must not be null or undefined");
      if (n instanceof RegExp) throw new TypeError("First argument to String.prototype." + o + " must not be a regular expression");
      return t + "";
    }
    M("String.prototype.includes", function(t) {
      return t || function(n, o) {
        return $(this, n, "includes").indexOf(n, o || 0) !== -1;
      };
    }), M("Symbol", function(t) {
      function n(g) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (g || "") + "_" + f++, g);
      }
      function o(g, R) {
        this.g = g, E(this, "description", { configurable: !0, writable: !0, value: R });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", f = 0;
      return n;
    }), M("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = y[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && E(d.prototype, t, { configurable: !0, writable: !0, value: function() {
          return K(r(this));
        } });
      }
      return t;
    });
    function K(t) {
      return t = { next: t }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    M("WeakMap", function(t) {
      function n(N) {
        if (this.g = (O += Math.random() + 1).toString(), N) {
          N = s(N);
          for (var b; !(b = N.next()).done; ) b = b.value, this.set(b[0], b[1]);
        }
      }
      function o() {
      }
      function d(N) {
        var b = typeof N;
        return b === "object" && N !== null || b === "function";
      }
      function f(N) {
        if (!V(N, R)) {
          var b = new o();
          E(N, R, { value: b });
        }
      }
      function g(N) {
        var b = Object[N];
        b && (Object[N] = function(j) {
          return j instanceof o ? j : (Object.isExtensible(j) && f(j), b(j));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var N = Object.seal({}), b = Object.seal({}), j = new t([[N, 2], [b, 3]]);
          return j.get(N) != 2 || j.get(b) != 3 ? !1 : (j.delete(N), j.set(b, 4), !j.has(N) && j.get(b) == 4);
        } catch (ue) {
          return !1;
        }
      }()) return t;
      var R = "$jscomp_hidden_" + Math.random();
      g("freeze"), g("preventExtensions"), g("seal");
      var O = 0;
      return n.prototype.set = function(N, b) {
        if (!d(N)) throw Error("Invalid WeakMap key");
        if (f(N), !V(N, R)) throw Error("WeakMap key fail: " + N);
        return N[R][this.g] = b, this;
      }, n.prototype.get = function(N) {
        return d(N) && V(N, R) ? N[R][this.g] : void 0;
      }, n.prototype.has = function(N) {
        return d(N) && V(
          N,
          R
        ) && V(N[R], this.g);
      }, n.prototype.delete = function(N) {
        return d(N) && V(N, R) && V(N[R], this.g) ? delete N[R][this.g] : !1;
      }, n;
    }), M("Map", function(t) {
      function n() {
        var O = {};
        return O.L = O.next = O.head = O;
      }
      function o(O, N) {
        var b = O.g;
        return K(function() {
          if (b) {
            for (; b.head != O.g; ) b = b.L;
            for (; b.next != b.head; ) return b = b.next, { done: !1, value: N(b) };
            b = null;
          }
          return { done: !0, value: void 0 };
        });
      }
      function d(O, N) {
        var b = N && typeof N;
        b == "object" || b == "function" ? g.has(N) ? b = g.get(N) : (b = "" + ++R, g.set(N, b)) : b = "p_" + N;
        var j = O.h[b];
        if (j && V(O.h, b)) for (O = 0; O < j.length; O++) {
          var ue = j[O];
          if (N !== N && ue.key !== ue.key || N === ue.key) return { id: b, list: j, index: O, A: ue };
        }
        return {
          id: b,
          list: j,
          index: -1,
          A: void 0
        };
      }
      function f(O) {
        if (this.h = {}, this.g = n(), this.size = 0, O) {
          O = s(O);
          for (var N; !(N = O.next()).done; ) N = N.value, this.set(N[0], N[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var O = Object.seal({ x: 4 }), N = new t(s([[O, "s"]]));
          if (N.get(O) != "s" || N.size != 1 || N.get({ x: 4 }) || N.set({ x: 4 }, "t") != N || N.size != 2) return !1;
          var b = N.entries(), j = b.next();
          return j.done || j.value[0] != O || j.value[1] != "s" ? !1 : (j = b.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !b.next().done));
        } catch (ue) {
          return !1;
        }
      }()) return t;
      var g = /* @__PURE__ */ new WeakMap();
      f.prototype.set = function(O, N) {
        O = O === 0 ? 0 : O;
        var b = d(this, O);
        return b.list || (b.list = this.h[b.id] = []), b.A ? b.A.value = N : (b.A = { next: this.g, L: this.g.L, head: this.g, key: O, value: N }, b.list.push(b.A), this.g.L.next = b.A, this.g.L = b.A, this.size++), this;
      }, f.prototype.delete = function(O) {
        return O = d(this, O), O.A && O.list ? (O.list.splice(O.index, 1), O.list.length || delete this.h[O.id], O.A.L.next = O.A.next, O.A.next.L = O.A.L, O.A.head = null, this.size--, !0) : !1;
      }, f.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, f.prototype.has = function(O) {
        return !!d(this, O).A;
      }, f.prototype.get = function(O) {
        return (O = d(this, O).A) && O.value;
      }, f.prototype.entries = function() {
        return o(this, function(O) {
          return [O.key, O.value];
        });
      }, f.prototype.keys = function() {
        return o(this, function(O) {
          return O.key;
        });
      }, f.prototype.values = function() {
        return o(this, function(O) {
          return O.value;
        });
      }, f.prototype.forEach = function(O, N) {
        for (var b = this.entries(), j; !(j = b.next()).done; ) j = j.value, O.call(N, j[1], j[0], this);
      }, f.prototype[Symbol.iterator] = f.prototype.entries;
      var R = 0;
      return f;
    }), M("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({ x: 4 }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({ x: 4 }) != d || d.size != 2) return !1;
          var f = d.entries(), g = f.next();
          return g.done || g.value[0] != o || g.value[1] != o ? !1 : (g = f.next(), g.done || g.value[0] == o || g.value[0].x != 4 || g.value[1] != g.value[0] ? !1 : f.next().done);
        } catch (R) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var f = this;
        this.g.forEach(function(g) {
          return o.call(d, g, g, f);
        });
      }, n);
    }), M("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) V(n, d) && o.push(n[d]);
        return o;
      };
    });
    function F(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, f = { next: function() {
        if (!d && o < t.length) {
          var g = o++;
          return { value: n(g, t[g]), done: !1 };
        }
        return d = !0, { done: !0, value: void 0 };
      } };
      return f[Symbol.iterator] = function() {
        return f;
      }, f;
    }
    M("Array.prototype.keys", function(t) {
      return t || function() {
        return F(this, function(n) {
          return n;
        });
      };
    }), M("String.prototype.repeat", function(t) {
      return t || function(n) {
        var o = $(this, null, "repeat");
        if (0 > n || 1342177279 < n) throw new RangeError("Invalid count value");
        n |= 0;
        for (var d = ""; n; ) n & 1 && (d += o), (n >>>= 1) && (o += o);
        return d;
      };
    }), M("String.prototype.padStart", function(t) {
      return t || function(n, o) {
        var d = $(this, null, "padStart");
        return n -= d.length, o = o !== void 0 ? String(o) : " ", (0 < n && o ? o.repeat(Math.ceil(n / o.length)).substring(0, n) : "") + d;
      };
    }), M("Array.prototype.values", function(t) {
      return t || function() {
        return F(this, function(n, o) {
          return o;
        });
      };
    });
    var _ = { oa: "loaded", ua: "start", la: "firstQuartile", pa: "midpoint", va: "thirdQuartile", ja: "complete", qa: "pause", sa: "resume", ia: "bufferStart", ha: "bufferFinish", ta: "skipped", wa: "volumeChange", ra: "playerStateChange", ga: "adUserInteraction" }, D = { ma: "full", ka: "domain", na: "limited" };
    function C(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.D = t.D || void 0, this.X = t.X || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.R = t.R !== void 0 ? t.R === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.F = t.F || void 0, this.ba = t.ba || void 0, this.Y = t.Y === "true" || t.Y === !0 || !1, this.O = t.O || [], this.S = t.S || !1, this.g = n;
    }
    function B(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function z(t) {
      var n = {};
      return Object.assign({}, B(t), (n.x = t.x, n.y = t.y, n));
    }
    function Te(t) {
      var n = z(t), o = {};
      return Object.assign({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    C.prototype.T = function(t) {
      if (t == null) return !1;
      t = z(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function Ue(t) {
      return t.width * t.height;
    }
    function Ze(t) {
      return t.width === 0 || t.height === 0;
    }
    function zt(t, n) {
      t = z(t);
      for (var o = [], d = [], f = 0; f < n.length; f++) {
        var g = z(n[f]);
        g = bt(t, g), He(o, g.x), He(o, g.J), He(d, g.y), He(d, g.K);
      }
      return o = o.sort(function(R, O) {
        return R - O;
      }), d = d.sort(function(R, O) {
        return R - O;
      }), { ea: o, fa: d };
    }
    function bt(t, n) {
      return { x: Math.max(t.x, n.x), y: Math.max(t.y, n.y), J: Math.min(t.x + t.width, n.x + n.width), K: Math.min(t.y + t.height, n.y + n.height) };
    }
    function He(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function et() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    et.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(Ge(this)) === JSON.stringify(Ge(t));
    };
    function Ge(t) {
      var n = [], o = [], d = { viewport: t.l, adView: { percentageInView: t.u, pixelsInView: t.B, reasons: t.m }, declaredFriendlyObstructions: t.o.length };
      if (t.g !== void 0) {
        d.adView.geometry = z(t.g), d.adView.geometry.pixels = Ue(t.g), d.adView.onScreenGeometry = z(t.h), d.adView.onScreenGeometry.pixels = je(t);
        for (var f = 0; f < t.j.length; f++) n.push(z(t.j[f]));
        for (f = 0; f < t.v.length; f++) {
          var g = t.v[f], R = g, O = {};
          R.h && (O.obstructionClass = R.h), R.i && (O.obstructionPurpose = R.i), R.j && (O.obstructionReason = R.j), g = bt(t.g, g), o.push(Object.assign(
            {},
            { x: g.x, y: g.y, width: g.J - g.x, height: g.K - g.y },
            O
          ));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function ft(t, n) {
      n = B(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function tt() {
      return { x: 0, y: 0, endX: 0, endY: 0, width: 0, height: 0 };
    }
    function it(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function Fe(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function wt(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = Ue(t.g);
        if (n !== 0) {
          var o = je(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function xt(t, n) {
      if (Ze(n) || !t.h) n = !1;
      else {
        var o = Te(t.h), d = o.y, f = o.endX;
        t = o.endY;
        var g = n.J;
        o = o.x, (g = g < o || 0.01 > Math.abs(g - o)) || (g = n.x, g = g > f || 0.01 > Math.abs(g - f)), (f = g) || (f = n.K, f = f < d || 0.01 > Math.abs(f - d)), (d = f) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function Ae(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function je(t) {
      var n = Math, o = n.max, d = Ue(t.h), f = t.j, g = 0;
      if (0 < f.length) {
        var R = zt(t.h, f);
        t = R.ea, R = R.fa;
        for (var O = 0; O < t.length - 1; O++) for (var N = (t[O] + (t[O] + 1)) / 2, b = t[O + 1] - t[O], j = 0; j < R.length - 1; j++) {
          for (var ue = (R[j] + (R[j] + 1)) / 2, nt = R[j + 1] - R[j], ht = !1, Ke = 0; Ke < f.length; Ke++) {
            var We = z(f[Ke]);
            if (We.x < N && We.x + We.width > N && We.y < ue && We.y + We.height > ue) {
              ht = !0;
              break;
            }
          }
          ht && (g += Math.round(b) * Math.round(nt));
        }
      }
      return o.call(n, 0, d - g);
    }
    function Re() {
    }
    function Le() {
    }
    function Me(t, n, o, d) {
      var f = n.S ? !0 : n.D === d;
      if (f) {
        o.g = n;
        var g = Te(o.g);
        t = it(o.i, g);
        var R = o.g;
        R.F === "notAttached" || R.F === "noWindowFocus" || R.F === "noAdView" ? (Ae(o, "notFound"), o.h = new C(tt(), !1)) : (R = o.g, R.F === "viewInvisible" || R.F === "viewGone" || R.F === "viewNotVisible" || R.F === "viewAlphaZero" || R.F === "viewHidden" || o.g.F !== void 0 || Ze(o.g) ? (Ae(o, "hidden"), o.h = new C(tt(), !1)) : (o.g.Y && Ae(o, "pictureInPicture"), o.g.m || (Ae(o, "backgrounded"), Ae(o, "noWindowFocus")), Fe(t, g) && Ae(o, "clipped"), o.h = new C(t, !1)));
      } else if (g = !0, n.g && (g = n.X.indexOf(d) !== -1 ? !1 : n.R === !1), g) {
        R = n.O;
        for (var O = 0; O < R.length; O++) g = o.g !== void 0, Me(t, new C(R[O], g), o, d);
      }
      f || o.g === void 0 || (n.g ? n.X.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (f = Te(n), d = Te(o.h), z(o.h), !Ze(o.h) && n.R && (n = it(d, f), Fe(n, d) && (Ae(o, "clipped"), o.h = new C(n, !1)))));
    }
    function P() {
      var t = T.apply(0, arguments);
      ve(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function X() {
      var t = T.apply(0, arguments);
      ve(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function ve(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function ne(t) {
      return t && t.omidNative && typeof t.omidNative.attest == "function";
    }
    function se() {
      var t = ye;
      if (!t || !t.navigator) return !1;
      t = t.navigator.userAgent;
      var n = /Safari\/[\d.]*$/.test(t) && !/Chrome|Firefox|Edg|OPR/.test(t), o = /(iPhone|iPad|iPod)/.test(t), d = /(Macintosh)/.test(t);
      try {
        if (o) {
          var f = /(iPhone OS|iPad OS|CPU OS) (\d+[_.]\d+)/.exec(t);
          return f ? 16 <= parseInt(f[2], 10) : !1;
        }
        if (n && d) {
          var g = /OS X (\d+(?:[_.]\d+)+)/.exec(t);
          if (!g) return !0;
          e: {
            if (g && g[1]) {
              var R = g[0].includes(".") ? "." : "_", O = g[1].split(R);
              if (O.length === 3) {
                var N = parseInt(O[1], 10);
                break e;
              }
              if (O.length === 2) {
                N = parseInt(
                  O[0],
                  10
                );
                break e;
              }
            }
            N = null;
          }
          return (f = N) ? 13 <= f : void 0;
        }
      } catch (b) {
        P("Error analyzing the user agent. Contact OM SDK with the user agent.");
      }
      return !1;
    }
    function Z() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    Z.prototype.setInterval = function(t, n) {
      return Tt(this, "setInterval")(t, n);
    }, Z.prototype.clearInterval = function(t) {
      Tt(this, "clearInterval")(t);
    };
    function At(t, n) {
      Tt(t, "clearTimeout")(n);
    }
    function Tt(t, n) {
      return t.g && t.g[n] ? t.g[n] : Jt(t, n);
    }
    function qi(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var f = t.g.document.createElement("img");
        f.width = 1, f.height = 1, f.style.display = "none", f.src = n, o && f.addEventListener("load", function() {
          return o();
        }), d && f.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(f);
      } else Jt(t, "sendUrl")(n, o, d);
    }
    function Yi(t, n, o) {
      if (n) try {
        if (ne(t.g)) t.g.omidNative.attest(n, o);
        else if (t.g.document && t.g.document.body) {
          var d = t.g.document.createElement("img");
          d.width = 1, d.height = 1, d.style.display = "none", d.src = n, o && d.addEventListener("load", function() {
            return o();
          }), t.g.document.body.appendChild(d);
        }
      } catch (f) {
      }
    }
    function Jt(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    var ye = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function Gi() {
      this.h = /* @__PURE__ */ new Map(), this.i = null, this.g = [], ne(ye) ? this.g.push({ mechanism: "ApplePAT", version: "default", executionEnvironment: "native" }) : se() && this.g.push({ mechanism: "ApplePAT", version: "default", executionEnvironment: "web" });
    }
    function te() {
      return Vt || (Vt = new Gi()), Vt;
    }
    var Vt = null;
    function Qt() {
      this.h = /* @__PURE__ */ new Set(), this.g = 0;
    }
    function Oe(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function Ki() {
      this.D = null, this.i = { apiVersion: "1.0", accessMode: "limited", environment: "web", omidJsInfo: { omidImplementer: "omsdk", serviceVersion: "1.6.3-iab357" }, adSessionType: "html", supports: ["clid", "vlid"] }, this.H = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.M = this.h = this.g = this.N = this.C = null, this.u = /* @__PURE__ */ new Map(), this.v = new Qt();
    }
    function zi(t) {
      if (t === ye) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function Pe() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return zi(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function Zt(t, n) {
      this.g = t, this.h = n;
    }
    y.Object.defineProperties(Zt.prototype, { event: { configurable: !0, enumerable: !0, get: function() {
      return this.g;
    } }, origin: { configurable: !0, enumerable: !0, get: function() {
      return this.h;
    } } });
    function Ei(t) {
      return { supportedAttestationMechanisms: t.map(function(n) {
        return { mechanism: n.mechanism, version: n.version };
      }) };
    }
    function a(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function u(t, n) {
      if (t.g !== void 0 && t.g.D && L(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function m(t, n) {
      t.m.push(n), u(t, n);
    }
    function S(t, n, o) {
      t.g !== void 0 && t.g.D && t.m.filter(function(d) {
        return d.event.type === n && L(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function L(t, n) {
      var o = n.event.type, d = Object.values(_).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function fe(t, n, o) {
      Object.keys(_).forEach(function(d) {
        d = _[d];
        var f = { type: d, W: o, I: n };
        t.j.push(f), S(t, d, f);
      });
    }
    function me(t, n, o, d) {
      var f = { ca: o, W: d, I: n };
      t.l.push(f), t.i.forEach(function(g) {
        var R = Kr(g);
        g.event.type === "sessionStart" && w(t, R, f), t.h(f.I, R);
      });
    }
    function Rt(t, n, o) {
      var d = mt(t, "sessionError", "native", { errorType: n, message: o });
      t.i.push(d), t.l.forEach(function(f) {
        t.h(f.I, d.event);
      });
    }
    function k(t, n) {
      if (t.o = Object.assign(t.o, n), n = t.g.i, n !== void 0) {
        n = Object.assign({}, ds(gi(t, vi(t, { context: n }), !0)), { supportsLoadedEvent: !!t.g.h || t.g.g == "video" }), Object.assign(n, { pageUrl: Pe(), contentUrl: t.g.H }), us(n);
        var o = mt(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var f = Kr(o);
          w(t, f, d), t.h(d.I, f);
        }, t), ee(t);
      }
    }
    function w(t, n, o) {
      o.ca && (n.data.verificationParameters = t.o[o.ca]), o.W && (o = t.g.u.get(o.W)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function U(t) {
      var n = mt(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    a.prototype.h = function(t) {
      var n = T.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        X(o);
      }
    };
    function ee(t) {
      var n = t.m.filter(function(g) {
        return !!(Object.values(_).includes(g.event.type) && t.g.g == "video" && g.origin === t.g.j || g.event.type == "loaded" && t.g.g == "display" && g.origin === t.g.s);
      }).map(function(g) {
        return g.event;
      }), o = t.g.D || "", d = {};
      n = s(n);
      for (var f = n.next(); !f.done; d = { G: d.G }, f = n.next()) {
        if (d.G = f.value, d.G.adSessionId || (d.G.adSessionId = o), d.G.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.G.data = gi(t, vi(t, d.G.data));
        }
        t.j.filter(/* @__PURE__ */ function(g) {
          return function(R) {
            return R.type === g.G.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(g) {
          return function(R) {
            return R.I(g.G);
          };
        }(d));
      }
    }
    function ut(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? (P("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function Gr(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? (P("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function Ji(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? (P("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function gi(t, n, o) {
      return o = o === void 0 ? !1 : o, n = Object.assign({}, n), t.g.g && Object.assign(n, { mediaType: t.g.g }), t.g.h && (o || t.g.h !== "definedByJavaScript") && Object.assign(n, { creativeType: t.g.h }), n;
    }
    function ds(t) {
      var n = te().i;
      return n ? Object.assign({}, t, { lastActivity: n }) : t;
    }
    function vi(t, n) {
      return t.g.M ? Object.assign({}, n, { impressionType: t.g.M }) : n;
    }
    function us(t) {
      var n = te().g;
      Object.assign(t, Ei(n));
    }
    function mt(t, n, o, d) {
      return new Zt({ adSessionId: t.g.D || "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: n, data: d }, o);
    }
    function Kr(t) {
      t = t.event;
      var n = t.data ? Object.assign({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = Object.assign({}, n.context)), { adSessionId: t.adSessionId, timestamp: t.timestamp, type: t.type, data: n };
    }
    function zr(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.C);
    }
    function Jr(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (Object.assign(o, { mediaPlayerVolume: n }), t.g.N = n) : d != null && (Object.assign(o, { videoPlayerVolume: d }), t.g.N = d);
      }
    }
    function hs(t, n) {
      this.h = t, this.g = n;
    }
    function Qr(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function rt(t, n, o, d, f) {
      this.j = t, this.da = n, this.U = o, this.i = d, this.aa = f, this.h = null, this.g = this.m = this.M = void 0, this.$ = !0, this.o = void 0, Si(this);
    }
    function Si(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.$ && (Rt(t.U, "generic", "More than one element with 'omid-element' class name."), t.$ = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        yi(t);
      }
    }
    function yi(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, Qr(t.h) ? t.i.o && t.s() : t.s());
    }
    function ei(t) {
      t.g && (Qr(t.h) ? t.i.o && (t.P(), Zr(t)) : (t.P(), Zr(t)));
    }
    rt.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, rt.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", ei(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function Zr(t) {
      if (t.M) {
        t.i.U = t.M, t = t.da;
        var n = t.g.U, o = t.g.P;
        if (n && !n.T(o)) {
          o = Ge(n);
          var d = t.h;
          d.g.h != "audio" && m(d, mt(d, "geometryChange", "native", o)), t.g.P = n;
        }
      }
    }
    function en(t) {
      if (t.g && t.i.o) {
        var n = new C(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.R = !0, n;
      }
    }
    function kt(t, n, o, d, f, g) {
      rt.call(this, t, o, d, f, g), this.u = n, this.l = void 0;
    }
    I(kt, rt), kt.prototype.v = function() {
      this.l !== void 0 && (this.aa.clearInterval(this.l), this.l = void 0), rt.prototype.v.call(this);
    }, kt.prototype.s = function() {
      var t = this;
      rt.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.aa.setInterval(function() {
        return tn(t);
      }, 200), tn(this));
    }, kt.prototype.P = function() {
      if (this.m) {
        var t = en(this);
        if (t) {
          this.g.S = !1, t.S = !0;
          for (var n = !1, o = 0; o < this.g.O.length; o++) if (this.g.O[o].S) {
            this.g.O[o] = t, n = !0;
            break;
          }
          n || this.g.O.push(t);
        } else this.g.S = !0;
        n = this.u, o = this.i.B;
        var d = this.i.D, f = this.N();
        t = new et();
        var g = new C(this.m, !1);
        if (ft(t, g), Me(n, g, t, d), f) if (g.ba) Ae(t, "backgrounded"), Ae(t, "noOutputDevice");
        else if (o === "backgrounded") Ae(t, "backgrounded");
        else if (t.g !== void 0) {
          for (n = 0; n < t.o.length; n++) xt(t, t.o[n]) && t.v.push(t.o[n]);
          for (n = 0; n < t.s.length; n++) {
            if (o = xt(t, t.s[n])) {
              e: {
                for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                  o = !0;
                  break e;
                }
                o = !1;
              }
              o = !o;
            }
            o && (Ae(t, "obstructed"), t.j.push(t.s[n]));
          }
          wt(t);
        } else Ae(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new C((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = tt();
        this.M = t;
      }
    }, kt.prototype.N = function() {
      return rn(this);
    };
    function tn(t) {
      if (t.l !== void 0) {
        if (rn(t)) {
          var n = t.j.top;
          n = new C(new Oe(n.innerWidth, n.innerHeight), !1);
        } else n = new C(new Oe(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new C(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.R = !0, t.m = n, t.m.O.push(t.g), ei(t));
      }
    }
    function rn(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function Ut(t, n, o, d, f, g) {
      rt.call(this, t, o, d, f, g), this.C = this.u = this.B = this.l = void 0, this.Z = !1, this.H = void 0;
    }
    I(Ut, rt), Ut.prototype.v = function() {
      this.l && this.l.disconnect(), nn(this), rt.prototype.v.call(this);
    }, Ut.prototype.s = function() {
      if (rt.prototype.s.call(this), this.h && (this.l || (this.l = cs(this)), sn(this), on(this.h) && ps(this), this.i.B === "backgrounded")) {
        var t = Oi(new Oe(0, 0));
        this.H = this.g = this.m = t, ei(this);
      }
    }, Ut.prototype.P = function() {
      if (this.g && this.H) {
        var t = en(this);
        if (t) {
          var n = t, o = this.H, d = Math.max(t.x, o.x), f = Math.max(t.y, o.y), g = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), g <= d || t <= f ? d = null : (o = {}, d = new C((o.x = d, o.y = f, o.width = Math.abs(g - d), o.height = Math.abs(t - f), o), !1)), d || (d = new C({ x: 0, y: 0, width: 0, height: 0 }, !1));
        } else n = this.g, d = this.H;
        f = new et(), this.m && ft(f, this.m), (g = this.i.B == "backgrounded") && Ae(f, "backgrounded"), f.g = n, f.h = d, wt(f), this.Z ? !g && Ze(f.g) ? Ae(f, "hidden") : g || f.u === 100 || Ae(f, "clipped") : Ae(
          f,
          "viewport"
        ), this.M = f;
      }
    }, Ut.prototype.N = function() {
      return !0;
    };
    function nn(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function sn(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function on(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function cs(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], f = 1; f < n.length; f++) n[f].time > d.time && (d = n[f]);
            o = d, t.m = Oi(o.rootBounds), t.g = Oi(o.boundingClientRect), t.H = Oi(o.intersectionRect), t.Z = !!o.isIntersecting, ei(t);
          }
        } catch (g) {
          t.v(), Rt(t.U, "generic", "Problem handling IntersectionObserver callback: " + g.message);
        }
      }, { root: null, rootMargin: "0px", threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1] });
    }
    function ps(t) {
      t.j.ResizeObserver ? t.B || (t.B = fs(t, function() {
        return Qi(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return Qi(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return Qi(t);
      }), t.u.observe(t.h, { childList: !1, attributes: !0, subtree: !1 })));
    }
    function Qi(t) {
      t.h && !on(t.h) && (sn(t), nn(t));
    }
    function fs(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function Oi(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new C(t, !1);
    }
    function Zi(t) {
      if (typeof t == "object" && typeof t.webOSSystem == "object") return t.webOSSystem;
    }
    function Ii(t) {
      return typeof Zi(t) == "object";
    }
    function Ft(t) {
      if (typeof t == "object" && typeof t.tizen == "object") return t.tizen;
    }
    function Nt(t) {
      return typeof Ft(t) == "object";
    }
    function As(t, n) {
      this.h = t, this.g = n;
    }
    function er() {
      return typeof crypto != "undefined" && typeof crypto.getRandomValues == "function";
    }
    function tr() {
      var t = new Uint8Array(16);
      crypto.getRandomValues(t), t[6] = t[6] & 15 | 64, t[8] = t[8] & 63 | 128;
      for (var n = [], o = 0; 16 > o; o++) n.push(t[o].toString(16).padStart(2, "0"));
      return n[0] + n[1] + n[2] + n[3] + "-" + n[4] + n[5] + "-" + n[6] + n[7] + "-" + n[8] + n[9] + "-" + n[10] + n[11] + n[12] + n[13] + n[14] + n[15];
    }
    function ir() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function ms(t, n) {
      var o = o === void 0 ? ye : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function an(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, f = typeof d == "string" && Object.values(D).indexOf(d) !== -1 ? o.accessMode : null, g = f ? f == "domain" ? "limited" : f : "limited";
          o.accessMode = g;
          e: {
            var R = o.resourceUrl, O = t.g.location.origin;
            try {
              var N = new URL(R, O);
              break e;
            } catch (nt) {
            }
            try {
              N = new URL(R);
              break e;
            } catch (nt) {
            }
            N = null;
          }
          if (d = N) {
            var b = er() ? tr() : ir();
            Es(t, b, d, g);
            var j = o.vendorKey, ue = o.verificationParameters;
            j = j === void 0 ? "" : j, ue = ue === void 0 ? "" : ue, j && typeof j == "string" && j !== "" && ue && typeof ue == "string" && ue !== "" && (t.i.o[j] = ue), t.j.u.set(b, o);
          }
        } catch (nt) {
          X("OMID verification script " + o.resourceUrl + " failed to load: " + nt);
        }
      });
    }
    function Es(t, n, o, d) {
      var f = t.g.document, g = f.createElement("iframe");
      if (g.id = "omid-verification-script-frame-" + n, g.style.display = "none", d == "full") {
        var R = function() {
          var O = g.contentWindow;
          O.omidVerificationProperties = { serviceWindow: t.g, injectionSource: "web", injectionId: n }, O = O.document;
          var N = O.createElement("script");
          N.src = o.href, O.head.appendChild(N), g.removeEventListener("load", R);
        };
        g.addEventListener("load", R);
      } else d == "limited" && (g.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, g.sandbox = "allow-scripts");
      f.body.appendChild(g), te().h.set(n, g);
    }
    function rr(t, n) {
      var o = window, d = this;
      if (Ii(o)) if (o) if (o.WebOSServiceBridge) {
        this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(f) {
          try {
            var g = JSON.parse(f);
            if (g && g.errorCode) d.error(f);
            else if (!g) d.error("No object recieved from webOS bridge");
            else if (!Ti(d, f, g, "volumeStatus", "object")) {
              var R = g.volumeStatus;
              Ti(d, f, R, "muteStatus", "boolean") || Ti(d, f, R, "volume", "number") || Ti(d, f, R, "maxVolume", "number") || (0 >= R.maxVolume ? d.error("Invalid max volume status.") : d.i(R.muteStatus ? 0 : R.volume / R.maxVolume));
            }
          } catch (O) {
            d.error(O);
          }
        };
        try {
          this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
        } catch (f) {
          this.error(f);
        }
      } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    rr.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, rr.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Ti(t, n, o, d, f) {
      return typeof o[d] === f ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + f + '" but was of type "' + typeof o[d] + '".'), !0);
    }
    function ln(t) {
      return Nt(t) ? typeof Ft(t).tvinputdevice == "object" : !1;
    }
    function Ri(t, n) {
      var o = window, d = this;
      if (o) if (this.validate(o)) {
        this.h = n;
        var f = Ft(o).tvaudiocontrol;
        this.g = void 0, n = function() {
          var g = f.isMute() ? 0 : f.getVolume() / 100;
          (d.g === void 0 || d.g != g) && (d.g = g, t(d.g));
        }, n(), this.i = o.setInterval(n, 200), this.j = o;
      } else n("Invalid Tizen window context");
      else n("No window context");
    }
    Ri.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, Ri.prototype.validate = function(t) {
      return Nt(t) && ln(t) && typeof Ft(t).tvaudiocontrol == "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, Ri.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function dn(t, n, o, d, f) {
      var g = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = f, this.m = !1, nr(this, function(R) {
        if (R.type === "sessionStart") {
          g.m = !0;
          try {
            an(g.l);
          } catch (O) {
            P(O.message);
          }
        }
        R.type === "sessionFinish" && (g.m = !1);
      });
    }
    function nr(t, n, o, d) {
      me(t.i, n, o, d);
    }
    i = dn.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && yi(this.h)) : P("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && yi(this.h), this.h && ei(this.h);
    }, i.error = function(t, n) {
      Rt(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        an(this.l);
      } catch (o) {
        P(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.M = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = Object.assign({}, d.omidJsInfo, { sessionClientVersion: t, partnerName: n, partnerVersion: o }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function gs(t) {
      if (Nt(window) || Ii(window)) {
        var n = function(d) {
          if (t.g.C !== d && t.i.g.j !== "none" && typeof d == "number" && !isNaN(d)) {
            t.g.C = d;
            var f = t.o, g = f.g.N;
            g != null && (d = f.h, f = { mediaPlayerVolume: g, deviceVolume: f.g.C }, zr(d, "volumeChange", f), Jr(d, "volumeChange", f), m(d, mt(d, "volumeChange", "native", f)));
          }
        }, o = function(d) {
          P(d);
        };
        Ii(window) ? t.j = new rr(n, o) : Nt(window) && (t.j = new Ri(n, o));
      }
    }
    function sr(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function be(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function or(t) {
      var n = new Ki(), o = new a(n), d = new Re(), f = new Le(), g = new hs(o, n);
      t = t.i;
      var R = e;
      return d = R ? R.IntersectionObserver && (R.MutationObserver || R.ResizeObserver) ? new Ut(R, d, g, o, n, t) : new kt(R, f, g, o, n, t) : null, new dn(n, o, d, new ms(o, n), new As(o, n));
    }
    function jt(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function un(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function hn(t) {
      return new jt(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function cn(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function pn(t) {
      this.i = t;
    }
    function Bt(t) {
      this.i = t, this.handleExportedMessage = Bt.prototype.j.bind(this);
    }
    I(Bt, pn), Bt.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(cn(t), this);
    }, Bt.prototype.j = function(t, n) {
      un(t) && this.g && this.g(hn(t), n);
    };
    function Ni(t) {
      return ar(t, "SessionService.");
    }
    function ar(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function lr(t, n) {
      this.h = t, this.i = n;
    }
    lr.prototype.g = function(t) {
      var n = T.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, lr.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function re(t, n) {
      return t.g.bind(t, n);
    }
    function vs(t, n) {
      n = n === void 0 ? ye : n, n.omidSessionInterface == null && (t = { setSessionClientWindow: t.i, setClientInfo: re(t, "setClientInfo"), registerSessionObserver: re(t, "registerSessionObserver"), startAdSession: re(t, "startSession"), finishAdSession: re(t, "finishSession"), reportError: re(t, "sessionError"), registerAdEvents: re(t, "registerAdEvents"), registerMediaEvents: re(t, "registerMediaEvents"), injectVerificationScriptResources: re(t, "injectVerificationScriptResources"), setSlotElement: re(t, "setSlotElement"), setVideoElement: re(
        t,
        "setVideoElement"
      ), setElementBounds: re(t, "setElementBounds"), setCreativeType: re(t, "setCreativeType"), setImpressionType: re(t, "setImpressionType"), setContentUrl: re(t, "setContentUrl"), adEvents: { impressionOccurred: re(t, "impressionOccurred"), loaded: re(t, "loaded") }, mediaEvents: {
        start: re(t, "start"),
        firstQuartile: re(t, "firstQuartile"),
        midpoint: re(t, "midpoint"),
        thirdQuartile: re(t, "thirdQuartile"),
        complete: re(t, "complete"),
        pause: re(t, "pause"),
        resume: re(t, "resume"),
        bufferStart: re(t, "bufferStart"),
        bufferFinish: re(t, "bufferFinish"),
        skipped: re(t, "skipped"),
        volumeChange: re(t, "volumeChange"),
        playerStateChange: re(t, "playerStateChange"),
        adUserInteraction: re(t, "adUserInteraction")
      } }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", { value: t, writable: !1 }));
    }
    function Ci(t, n) {
      this.i = n = n === void 0 ? ye : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (typeof d.data == "object") {
          var f = d.data;
          un(f) && d.source && o.g && o.g(hn(f), d.source);
        }
      });
    }
    I(Ci, pn), Ci.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(cn(t), "*");
    };
    function Ss(t) {
      if (ye.document) {
        var n = ye.document.createElement("iframe");
        n.style.display = "none", n.src = t, t = function() {
          var o = ye.document.body || ye.document.documentElement;
          o && (o.appendChild(n), setTimeout(function() {
            n.parentNode && n.parentNode.removeChild(n);
          }, 100));
        }, ye.document.readyState === "loading" ? ye.document.addEventListener("DOMContentLoaded", t) : t();
      }
    }
    function fn() {
      this.g = Nn;
    }
    i = fn.prototype, i.registerSessionObserver = function(t, n) {
      nr(be(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      be(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      be(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      be(this.g, t).error(n, o);
    };
    function Ne(t, n, o, d) {
      t = be(t.g, n), o == "impression" ? Gr(t.i) && (o = t.i, d = (d = o.g.P) ? Ge(d) : null, d = gi(o, vi(o, d)), m(o, mt(o, "impression", "javascript", d)), t.h && Si(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, Ji(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = mt(d, "loaded", "javascript", gi(d, vi(d, n === void 0 ? null : n))), m(d, n))) : Ji(t.i) && (n = t.i, zr(n, o, d), Jr(n, o, d), m(n, mt(n, o, "javascript", d))), ["loaded", "start"].includes(o) && t.h && Si(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      be(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, be(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      be(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var f = this.g;
      if (t == null) t = f.g;
      else {
        var g = [].concat(l(f.h.values())).includes(f.g) ? or(f) : f.g;
        f.h.set(t, g), t = g;
      }
      return t.setClientInfo(n, o, d);
    };
    function An(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), f = parseInt(n[o], 10);
        if (d > f) break;
        if (d < f) return !1;
      }
      return !0;
    }
    function mn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && An(t) ? n : JSON.stringify(n);
    }
    function En(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && An(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function dr() {
      var t = Cs, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new Bt(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new Ci(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new lr(function(d, f, g) {
        try {
          vn(n, d, f, g);
        } catch (R) {
          P(Sn(R));
        }
      }, function(d) {
        n.m = d;
        var f = er() ? tr() : ir();
        n.i.h(new jt(f, "identifyServiceWindow", "1.6.3-iab357"), d);
      }), vs(this.s, this.h);
    }
    dr.prototype.l = function(t, n) {
      Ni(t.method) != null && gn(this, t, n, this.j);
    }, dr.prototype.o = function(t, n) {
      if (Ni(t.method) != null) {
        if (!this.m || n !== this.m) return P("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        gn(this, t, n, this.i);
      }
    };
    function gn(t, n, o, d) {
      function f() {
        var N = new jt(g, "response", O, mn(O, T.apply(0, arguments)));
        d.h(N, o);
      }
      var g = n.h, R = n.method, O = n.version;
      n = En(O, n.g);
      try {
        vn(t, R, f, n);
      } catch (N) {
        d.h(new jt(g, "error", O, Sn(N)), o);
      }
    }
    function vn(t, n, o, d) {
      if (Ni(n) != null) switch (Ni(n)) {
        case "registerAdEvents":
          var f = s(d).next().value, g = be(t.g.g, f).i;
          ut(g, ["impression"]) && Gr(g) && (g.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var R = s(d).next().value, O = be(t.g.g, R).i;
          ut(O, Object.values(_)) && Ji(O) && (O.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var N = s(d).next().value;
          t.g.registerSessionObserver(N, o);
          break;
        case "setSlotElement":
          var b = s(d), j = b.next().value, ue = b.next().value;
          t.g.setSlotElement(ue, j);
          break;
        case "setVideoElement":
          var nt = s(d), ht = nt.next().value, Ke = nt.next().value, We = be(t.g.g, Ke);
          ht && ht.tagName && ht.tagName.toLowerCase() === "video" ? (We.g.l = ht, We.h && yi(We.h)) : P("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Di = s(d), cr = Di.next().value, pr = Di.next().value;
          t.g.setElementBounds(pr, cr);
          break;
        case "startSession":
          var Li = s(d), ze = Li.next().value, ti = Li.next().value, Je = t.h;
          if (ze != null && typeof ze == "object") {
            var ii = ze.customReferenceData, ri = ze.underEvaluation, ni = ze.universalAdId;
            typeof ii == "string" || (ii = void 0), typeof ri == "boolean" || (ri = !1);
            var st = { customReferenceData: ii, underEvaluation: ri };
            if (typeof ni == "string" && (st.universalAdId = ni), Ii(Je)) {
              var Mi = Zi(Je), $t;
              typeof Mi == "object" && ($t = Mi.identifier), st.app = { appId: $t && typeof $t == "string" ? $t : void 0 };
              e: {
                var Pi = Zi(Je);
                if (typeof Pi == "object") {
                  try {
                    var we = JSON.parse(Pi.deviceInfo);
                  } catch (Ao) {
                    var fr = void 0;
                    break e;
                  }
                  fr = { deviceType: we.modelName || "Unknown", osVersion: we.platformVersion || "Unknown", os: "webOS" };
                } else fr = void 0;
              }
              st.deviceInfo = fr, st.deviceCategory = "ctv";
            } else if (Nt(Je)) {
              e: {
                if (Nt(Je)) {
                  try {
                    var Cn = Ft(Je).application.getCurrentApplication().appInfo.id;
                  } catch (Ao) {
                    var Ar = void 0;
                    break e;
                  }
                  if (typeof Cn == "string") {
                    Ar = Cn;
                    break e;
                  }
                }
                Ar = void 0;
              }
              if (st.app = { appId: Ar }, Nt(Je)) {
                var bi = Ft(Je).systeminfo;
                if (typeof bi == "object" && typeof bi.getCapability == "function")
                  var _s = bi.getCapability("http://tizen.org/system/model_name"), Ds = bi.getCapability("http://tizen.org/feature/platform.version");
                var _n = { deviceType: _s || "Unknown", osVersion: Ds || "Unknown", os: "tizen" };
              } else _n = void 0;
              st.deviceInfo = _n, ln(Je) && (st.deviceCategory = "ctv");
            }
            ze = st;
          } else ze = null;
          if (ze == null) break;
          var Ct = ze, mr = mr === void 0 ? null : mr, Et = be(t.g.g, ti), Dn = Et.g.i;
          Dn.sessionOwner || (Dn.sessionOwner = "javascript");
          var Ls = ti || (er() ? tr() : ir());
          Et.g.D = Ls, Ct.canMeasureVisibility = Et.h.N();
          var Er = Et.g;
          Ct.contentUrl !== void 0 && (Er.H = Ct.contentUrl, Ct.contentUrl = void 0);
          var Ln = Er.i || {};
          Ct.omidJsInfo = Object.assign({}, Ln.omidJsInfo || {}, Ct.omidJsInfo || {});
          var Ms = Object.assign({}, Ln, Ct);
          Er.i = Ms, k(Et.i, mr), Et.h && Si(Et.h), gs(Et);
          break;
        case "finishSession":
          var Ps = s(d).next().value, Mn = t.g, si = be(Mn.g, Ps), Pn = Mn.g;
          Pn.g = or(Pn), U(si.i), si.h.v(), si.j && (si.j.stop(), si.j = null);
          break;
        case "impressionOccurred":
          var bs = s(d).next().value;
          Ne(t.g, bs, "impression");
          break;
        case "loaded":
          var bn = s(d), Ht = bn.next().value, wn = bn.next().value;
          if (Ht) {
            var xn = { skippable: Ht.isSkippable, autoPlay: Ht.isAutoPlay, position: Ht.position };
            Ht.isSkippable && (xn.skipOffset = Ht.skipOffset), Ne(t.g, wn, "loaded", xn);
          } else Ne(t.g, wn, "loaded");
          break;
        case "start":
          var gr = s(d), ws = gr.next().value, xs = gr.next().value, Vs = gr.next().value;
          Ne(t.g, Vs, "start", { duration: ws, mediaPlayerVolume: xs });
          break;
        case "firstQuartile":
          var ks = s(d).next().value;
          Ne(t.g, ks, "firstQuartile");
          break;
        case "midpoint":
          var Us = s(d).next().value;
          Ne(t.g, Us, "midpoint");
          break;
        case "thirdQuartile":
          var Fs = s(d).next().value;
          Ne(t.g, Fs, "thirdQuartile");
          break;
        case "complete":
          var js = s(d).next().value;
          Ne(t.g, js, "complete");
          break;
        case "pause":
          var Bs = s(d).next().value;
          Ne(t.g, Bs, "pause");
          break;
        case "resume":
          var $s = s(d).next().value;
          Ne(t.g, $s, "resume");
          break;
        case "bufferStart":
          var Hs = s(d).next().value;
          Ne(t.g, Hs, "bufferStart");
          break;
        case "bufferFinish":
          var Ws = s(d).next().value;
          Ne(t.g, Ws, "bufferFinish");
          break;
        case "skipped":
          var Xs = s(d).next().value;
          Ne(t.g, Xs, "skipped");
          break;
        case "volumeChange":
          var Vn = s(d), qs = Vn.next().value, Ys = Vn.next().value;
          Ne(t.g, Ys, "volumeChange", { mediaPlayerVolume: qs });
          break;
        case "playerStateChange":
          var kn = s(d), Gs = kn.next().value, Ks = kn.next().value;
          Ne(t.g, Ks, "playerStateChange", { state: Gs });
          break;
        case "adUserInteraction":
          var Un = s(d), zs = Un.next().value, Js = Un.next().value;
          Ne(t.g, Js, "adUserInteraction", { interactionType: zs });
          break;
        case "setClientInfo":
          var wi = s(d), Qs = wi.next().value, Zs = wi.next().value, eo = wi.next().value, to = wi.next().value, io = t.g.setClientInfo(to, Qs, Zs, eo);
          o(io);
          break;
        case "injectVerificationScriptResources":
          var Fn = s(d), ro = Fn.next().value, no = Fn.next().value;
          t.g.injectVerificationScriptResources(no, ro);
          break;
        case "setCreativeType":
          var jn = s(d), so = jn.next().value, oo = jn.next().value;
          t.g.setCreativeType(oo, so);
          break;
        case "setImpressionType":
          var Bn = s(d), ao = Bn.next().value, lo = Bn.next().value;
          t.g.setImpressionType(lo, ao);
          break;
        case "setContentUrl":
          var $n = s(d), uo = $n.next().value, ho = $n.next().value;
          be(t.g.g, ho).g.H = uo;
          break;
        case "sessionError":
          var vr = s(d), co = vr.next().value, po = vr.next().value, fo = vr.next().value;
          t.g.error(fo, co, po);
      }
    }
    function Sn(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function ur() {
      var t = Nn, n = Rn, o = this, d = d === void 0 ? ye : d;
      this.i = t, this.g = n, this.l = {}, this.m = {}, this.j = new Bt(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.j, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new Ci(d)), this.j.g = function(f, g) {
        On(o, f, g, o.j);
      }, this.h && (this.h.g = function(f, g) {
        o.h && On(o, f, g, o.h);
      });
    }
    function yn(t) {
      t({ adSessionId: "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: "sessionError", data: { errorType: "generic", message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected." } });
    }
    function ys(t, n, o, d) {
      t = sr(t.i, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? fe(t, o, d) : (o = { type: n, W: d, I: o }, t.j.push(o), S(t, n, o))) : yn(o);
    }
    function Os(t, n, o, d) {
      t = sr(t.i, d), d !== void 0 && t.g.u.has(d) ? nr(t, n, o, d) : yn(n);
    }
    function Is(t, n, o, d, f, g, R) {
      R = sr(t.i, R);
      var O = 2 <= R.g.v.g ? { V: !1, reason: "SESSION_ATTESTATION_LIMIT_EXCEEDED" } : R.g.v.h.has(g) ? { V: !1, reason: "TOO_MANY_REQUESTS" } : 0.5 <= Math.random() ? { V: !1, reason: "SAMPLING_REJECTED" } : { V: !0, reason: null };
      if (R.g.v.h.add(g), O.V) if (R.g.v.g++, g = R.g.D, n === "ApplePAT") Yi(t.g, d.ya, f);
      else try {
        t = {};
        for (var N in d) d.hasOwnProperty(N) && (t[N.toLowerCase()] = d[N]);
        var b = ye.webkit ? ye.webkit.messageHandlers.omidJsAttestationListener : ye.omidJsAttestationListener;
        if (b) b.postMessage(JSON.stringify({
          method: "attest",
          data: { adSessionId: g, mechanism: n, version: o, attestationArgs: t }
        }));
        else {
          d = "";
          for (var j in t) t.hasOwnProperty(j) && (d += "&" + j + "=" + t[j]);
          Ss("omid-native://?method=attest&adSessionId=" + g + "&mechanism=" + n + "&version=" + o + d);
        }
        f(!0, "SUCCESS");
      } catch (ue) {
        P("Failed to trigger native-layer attestation method: " + ue.message), f(!1, "FAILED_TO_TRIGGER_ATTESTATION");
      }
      else f(!1, O.reason);
    }
    function Ts(t, n, o, d) {
      qi(t.g, n, o, d);
    }
    ur.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, ur.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function Rs(t, n, o, d) {
      Jt(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function On(t, n, o, d) {
      function f() {
        var we = new jt(g, "response", O, mn(O, T.apply(0, arguments)));
        d.h(we, o);
      }
      var g = n.h, R = n.method, O = n.version;
      if (n = En(O, n.g), ar(R, "VerificationService.") != null) {
        R = ar(R, "VerificationService.");
        try {
          switch (R) {
            case "addEventListener":
              var N = s(n), b = N.next().value, j = N.next().value || hr(o);
              ys(t, b, f, j);
              break;
            case "addSessionListener":
              var ue = s(n), nt = ue.next().value, ht = ue.next().value || hr(o);
              Os(t, f, nt, ht);
              break;
            case "attest":
              var Ke = s(n), We = Ke.next().value, Di = Ke.next().value, cr = Ke.next().value, pr = Ke.next().value, Li = Ke.next().value || hr(o);
              Is(t, We, Di, cr, f, pr, Li);
              break;
            case "sendUrl":
              var ze = s(n).next().value;
              Ts(t, ze, function() {
                return f(!0);
              }, function() {
                return f(!1);
              });
              break;
            case "setTimeout":
              var ti = s(n), Je = ti.next().value, ii = ti.next().value;
              t.l[Je] = Tt(t.g, "setTimeout")(f, ii);
              break;
            case "clearTimeout":
              var ri = s(n).next().value;
              At(t.g, t.l[ri]);
              break;
            case "setInterval":
              var ni = s(n), st = ni.next().value, Mi = ni.next().value;
              t.m[st] = t.setInterval(f, Mi);
              break;
            case "clearInterval":
              var $t = s(n).next().value;
              t.clearInterval(t.m[$t]);
              break;
            case "injectJavaScriptResource":
              var Pi = s(n).next().value;
              Rs(t, Pi, function(we) {
                return f(!0, we);
              }, function() {
                return f(!1);
              });
              break;
            case "getVersion":
              f("1.6.3-iab357");
          }
        } catch (we) {
          d.h(new jt(g, "error", O, `
              name: ` + we.name + `
              message: ` + we.message + `
              filename: ` + we.filename + `
              lineNumber: ` + we.lineNumber + `
              columnNumber: ` + we.columnNumber + `
              stack: ` + we.stack + `
              toString(): ` + we.toString() + `
          `), o);
        }
      }
    }
    function hr(t) {
      for (var n = te().h, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var f = n.get(d);
        if (f) {
          if (f.contentWindow === t) return d;
          try {
            if (f.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (g) {
          }
        }
      }
    }
    function In(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function Tn(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function _i(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function Ns(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(f) {
          f.addedNodes[0].nodeName === "BODY" && (f = In(n), _i(t, "omid_v1_present"), _i(t, f), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, { childList: !0 });
    }
    var Rn = new Z(), Nn = new function() {
      this.i = Rn, this.h = /* @__PURE__ */ new Map(), this.g = or(this);
    }(), Cs = new fn();
    new ur(), new dr(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? Ns(t, n) : (n = In(n), t.document.body ? (_i(t, "omid_v1_present"), _i(t, n)) : (Tn(t, "omid_v1_present"), Tn(t, n))));
    }(ye, "web");
  }).call(p, p);
}
const ts = "4.0", is = ["4.0"], Yr = class Yr {
  constructor() {
    this.OmidServiceClient = ea();
  }
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      c.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (c.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  hasValidHandshake(e, i = ts, r = is) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  hasValidFacadeImplementation(e, i = go) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  validate(e) {
    if (!e) {
      this.error = x.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = x.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = x.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = Gt(pi, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function h(E) {
        c.debug.critical("init - error", E), l(E);
      }
      Object.keys(this.initError).length > 0 ? h(this.initError) : s(new jr(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return c.debug.warn(
      `Request method ${mi.JSONP} is deprecated since v7.6.2 and will be removed in v8.`
    ), mi;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return le;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return pe;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Wr(pi);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return fi;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return A;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(A);
  }
  get LOGLEVEL() {
    return dt;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    c.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return c.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return c.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return ts;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return is;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.6.2";
  }
};
Yr.NAME = "Core::";
let Xi = Yr;
const ta = new Xi();
typeof window != "undefined" && (window.smartclientcore = ta);
typeof exports == "object" && (exports = {
  smartclientcore: Xi
});
export {
  go as FacadeBase,
  ta as default
};
