[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [constants/interfaces](constants/interfaces/README.md) / Rect

# Interface: Rect

Represents a rectangle with position and size properties.
This interface is used to describe the size and position of an element,
similar to the DOMRect interface in the Web API.

 Rect

## See

[https://developer.mozilla.org/en-US/docs/Web/API/DOMRect](https://developer.mozilla.org/en-US/docs/Web/API/DOMRect)

## Properties

<a id="bottom" name="bottom"></a>

### bottom?

> `optional` **bottom**: `number`

The y-coordinate of the bottom of the rectangle.
 It has the same value as `y + height`, or `y` if `height` is negative.

***

<a id="height" name="height"></a>

### height

> **height**: `number`

The height of the rectangle. This is a required property.

***

<a id="left" name="left"></a>

### left?

> `optional` **left**: `number`

The x-coordinate of the left side of the rectangle.
 It has the same value as `x`, or `x + width` if `width` is negative.

***

<a id="right" name="right"></a>

### right?

> `optional` **right**: `number`

The x-coordinate of the right side of the rectangle.
 It has the same value as `x + width`, or `x` if `width` is negative.

***

<a id="top" name="top"></a>

### top?

> `optional` **top**: `number`

The y-coordinate of the top of the rectangle.
 It has the same value as `y`, or `y + height` if `height` is negative.

***

<a id="width" name="width"></a>

### width

> **width**: `number`

The width of the rectangle. This is a required property.

***

<a id="x" name="x"></a>

### x

> **x**: `number`

The x-coordinate of the origin of the rectangle. This is a required property.

***

<a id="y" name="y"></a>

### y

> **y**: `number`

The y-coordinate of the origin of the rectangle. This is a required property.
