var rt = /* @__PURE__ */ ((p) => (p[p.SILENT = 0] = "SILENT", p[p.ERROR = 1] = "ERROR", p[p.NORMAL = 2] = "NORMAL", p[p.VERBOSE = 3] = "VERBOSE", p))(rt || {}), Re = /* @__PURE__ */ ((p) => (p[p.CRITICAL = 0] = "CRITICAL", p[p.ERROR = 1] = "ERROR", p[p.INFO = 2] = "INFO", p[p.TABLE = 3] = "TABLE", p[p.WARN = 4] = "WARN", p))(Re || {});
let _t = rt.SILENT;
const Li = "[OIS_DEBUG]", no = {
  [rt.ERROR]: [Re.CRITICAL, Re.ERROR],
  [rt.NORMAL]: [Re.INFO, Re.TABLE, Re.WARN],
  [rt.SILENT]: [],
  [rt.VERBOSE]: [Re.CRITICAL, Re.ERROR, Re.INFO, Re.TABLE, Re.WARN]
};
function ei() {
}
class c {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    _t = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return _t;
  }
  static shouldLog(e, i) {
    return i !== rt.SILENT && no[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(Re.CRITICAL, _t) ? console.error : ei).bind(console, Li),
      info: (this.shouldLog(Re.INFO, _t) ? console.info : ei).bind(console, Li),
      error: (this.shouldLog(Re.ERROR, _t) ? console.error : ei).bind(console, Li),
      table: (this.shouldLog(Re.TABLE, _t) ? console.table : ei).bind(console),
      warn: (this.shouldLog(Re.WARN, _t) ? console.warn : ei).bind(console, Li)
    };
  }
}
const so = "4.0";
class oo {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return so;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var ae = /* @__PURE__ */ ((p) => (p.LINEAR = "linear", p.NON_LINEAR = "nonlinear", p))(ae || {});
function Pn(p, e = "") {
  return (Array.isArray(p) ? p : [p]).map((r) => e ? `${r} ${e}` : r).join(",");
}
class Yt {
  static cTSTS(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  static gMNE(e, i) {
    let r = -1, s = null;
    for (const l of J(e, i)) {
      let u = 0, m = l;
      for (; m.parentNode !== e; )
        u++, m = m.parentNode;
      u > r && (r = u, s = l);
    }
    return s;
  }
  static gU(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, u) => !r.includes(l[i], u + 1));
  }
  static t(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
  static f(e, i, r = "") {
    return e.querySelector(Pn(i, r));
  }
  static fA(e, i, r = "") {
    return e.querySelectorAll(Pn(i, r));
  }
}
const yt = Yt.cTSTS, $ = Yt.f, J = Yt.fA, ao = Yt.gU, lt = Yt.gMNE, me = Yt.t;
class lo {
  constructor(e) {
    this.adSourceXML = e, this.adSource = $(this.adSourceXML, "AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? me(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : me(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const Lt = class Lt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return ae.NON_LINEAR;
      default:
        return ae.LINEAR;
    }
  }
  queryElements(e) {
    return J(this.adBreakXML, e);
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = $(this.adBreakXML, ":scope > AdSource");
    return e ? new lo(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] && this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = yt(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  getBreakPosition() {
    return this.type === ae.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || yt(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  getExtensions() {
    const e = this.queryElements(":scope > Extensions > Extension"), i = [];
    for (const r of e)
      i.push({
        extensionXML: r,
        type: r.getAttribute("type") || ""
      });
    return i;
  }
  getTrackers() {
    const e = this.queryElements(":scope > TrackingEvents > Tracking");
    let i = {};
    for (const r of e) {
      const s = r.getAttribute("event"), l = r.textContent.trim();
      l && (i[s] = i[s] || [], i[s].push({ url: l }));
    }
    return i;
  }
  getSeparationClips() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = $(this.adBreakXML, "ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
Lt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let oi = Lt;
class uo {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let r = e.documentElement || e, s = J(r, ":scope > *");
    const l = [];
    for (const G of s)
      l.push(new oi(G, i));
    this.adSlotList = l;
    let u = {}, m = [];
    const g = "Ad", S = "AdTagURI", L = "adtaguri", ie = "allowMultipleAds", Q = "sequence", Se = "type", K = "VAST";
    for (let G = 0; G < s.length; G++) {
      let O = l[G];
      O.breakPosition === 2 && O.timeOffset !== null && (u[O.timeOffset] = (u[O.timeOffset] || 0) + 1, u[O.timeOffset] > 1 && (O.multiMidroll = !0, m.length === 0 && (this.adSlotList[G - 1].multiMidroll = !0, this.adSlotList[G - 1].adBreakXML.setAttribute(
        Se,
        this.adSlotList[G - 1].adSource.type
      ), this.adSlotList[G - 1].adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[G].adSource.allowMultipleAds.toString()
      ), m.push(this.adSlotList[G - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[G].multiMidroll = !0, O.adBreakXML.setAttribute(Se, this.adSlotList[G].adSource.type), O.adBreakXML.setAttributeNS(
        null,
        ie,
        this.adSlotList[G].adSource.allowMultipleAds.toString()
      ), m.push(O.adBreakXML.cloneNode(!0))));
    }
    if (this.midrollHasSameTimeOffset) {
      let G = [];
      for (let I = 0; I < m.length; I++)
        if (m[I].getAttribute(Se).includes(L)) {
          let w = document.createElementNS(null, g);
          w.setAttribute(Q, (I + 1).toString());
          let W = document.createElementNS(null, "Wrapper");
          W.setAttributeNS(
            null,
            "fallbackOnNoAd",
            m[I].getAttribute(ie)
          );
          let X = document.createElementNS(null, K + S);
          X.textContent = $(m[I], S).textContent.trim(), W.appendChild(X), w.appendChild(W), G.push(w);
        } else
          $(m[I], g).setAttribute(Q, (I + 1).toString()), G.push($(m[I], g));
      let O = null;
      for (let I = 0; I < this.adSlotList.length; I++) {
        if (!this.adSlotList[I].multiMidroll)
          continue;
        if (this.adSlotList[I].adBreakXML.hasAttribute(Se) && this.adSlotList[I].adBreakXML.getAttribute(Se).includes(L) && (O = document.createElementNS(null, K + "AdData")), $(this.adSlotList[I].adBreakXML, "Ad") || O) {
          if (O) {
            $(this.adSlotList[I].adBreakXML, "AdTagURI").remove();
            let W = $(this.adSlotList[I].adBreakXML, "AdSource");
            const X = document.createElementNS(null, "VAST");
            for (const z of G)
              X.appendChild(z);
            O.appendChild(X), W.appendChild(O);
          } else {
            $(this.adSlotList[I].adBreakXML, "Ad").remove();
            const W = $(this.adSlotList[I].adBreakXML, "VAST");
            for (const X of G)
              W.appendChild(X);
          }
          this.adSlotList[I].multiMidroll = !1, this.adSlotList[I] = new oi(this.adSlotList[I].adBreakXML, this.adSlotList[I].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((I) => {
        if (!I.multiMidroll)
          return I;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class Ot {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const P = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let ar = null, lr = null, Ht = 0, wn = null, dr = null;
const Xe = class Xe {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (wn = e), this.enrichment.set("BLOCKED", Ht, "blocked");
  }
  get isActive() {
    return Ht === 1;
  }
  get vendorAPI() {
    return dr;
  }
  setVendorAPI(e) {
    !dr && e && (dr = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    lr = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    ar = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (c.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !wn.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      c.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = P.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!lr) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    lr(r, s).then(() => {
      Ht !== Xe.STATUS.IS_BLOCKED ? ar ? ar(r).then((l) => {
        c.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          Xe.STATUS.IS_BLOCKED,
          "blocked"
        ), Ht = Xe.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        c.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (c.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        Xe.STATUS.IS_BLOCKED,
        "blocked"
      ), Ht = Xe.STATUS.IS_BLOCKED, e()) : (c.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    Ht = 0, this.enrichment.set("BLOCKED", Xe.STATUS.IS_OPEN, "blocked");
  }
};
Xe.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, Xe.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, Xe.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, Xe.EventDispatcher = new Ot();
let le = Xe;
class we {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: we.screenHeight(),
      width: we.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return we.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !we.isIF() || we.isFIF();
  }
}
function ho() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function bi(p) {
  return encodeURIComponent(p).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function co() {
  const p = /* @__PURE__ */ new Date(), e = p.toISOString();
  let i = p.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function po(p, e, i) {
  if (p.indexOf(e) === -1)
    return p;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(p) ? parseInt(p.match(/\|(\d+)]/)[1], 10) : 0;
    return p.replace(
      r,
      s === 0 ? bi(i) : bi(i).substring(0, s)
    );
  }
}
function Pi(p) {
  let e = !Number.isFinite(p) || p < 0 ? 0 : p;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function Yn() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (p) => {
    let e = Math.random() * 16 | 0;
    return (p === "x" ? e : e & 3 | 8).toString(16);
  });
}
class St {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], we.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], ho), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Pi), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", we.userAgent(), "deviceua"), this.set("DOMAIN", we.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", we.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Pi), this.set("OS", we.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.6.1", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      we.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", we.screenHeight(), "screenheight"), this.set("SCREENWIDTH", we.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", co), this.set("TRANSACTIONID", Yn(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  getMacros(e = !1) {
    let i = {};
    if (e)
      for (const [r] of this.macroMap)
        i[`[${r}]`] = this.get(r, !0);
    else
      for (const [r] of this.macroMap)
        i[r] = this.get(r, !0);
    return i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, u = r || l.macroList;
    return l.value = i, u ? Array.isArray(u) ? l.macroList = u : l.macroList = [u] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => bi(String(l))).join(",") : bi(String(s)) : s;
  }
  setFromObject(e) {
    if (e)
      for (const i in e) {
        if (!Object.prototype.hasOwnProperty.call(e, i))
          continue;
        const r = e[i], s = typeof r == "string" && r.length === 0 || Array.isArray(r) && r.length === 0 ? "-1" : r;
        this.set(i.toUpperCase(), s, "");
      }
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    let i = e === null ? "" : String(e);
    for (const [r, s] of this.macroMap) {
      const l = String(this.get(r, !0));
      for (const u of s.macroList)
        i = this.replaceMacroWithValue(i, u, l);
    }
    return i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return po(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class wi {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new wi().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class fo {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, u = setTimeout(() => {
      s = !0;
      let L = new Error("ImageURLHandler: Tracking request timeout.");
      L.code = P.WARNING.TRACKER_TIMEOUT.code, L.description = P.WARNING.TRACKER_TIMEOUT.message, L.type = "AdWarning", r(L);
    }, l);
    let m = new Image();
    m.src = "";
    const g = () => {
      clearTimeout(u), !s && r(null);
    }, S = (L) => {
      g();
    };
    return m.onerror = S, m.onload = g, m.src = e, m;
  }
}
function _r(p) {
  if (typeof p != "string")
    return p;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(p, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(p), e = i;
  }
  return e;
}
const ur = " Response contains neither 'responseXML' nor 'responseText'", Te = class Te {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Te().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, m = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        c.debug.info(Te.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let g = new Error(Te.NAME + ": Request timeout");
      g.code = P.WRAPPER.TIMEOUT.code;
      let S = r.timeouts ? r.timeouts.errorMessage : null;
      g.message = S || P.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? le.REASON.WRAPPER_CHAIN_TIMEOUT : le.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: g
      }), i(g, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(m), s.status === 200) {
            let g = s.responseXML;
            if (!g && s.responseText && (g = _r(s.responseText)), !g) {
              c.debug.info(Te.NAME + ur);
              let S = new Error(Te.NAME + ur);
              S.code = r.isWrapper ? P.WRAPPER.NO_RESPONSE.code : P.XML.INVALID_XML.code, S.message = "XHR Response Error:" + ur, r.adReinsertion.setReinsertionReason({
                reason: le.REASON.XHR_ERROR,
                xhr: s,
                xhrError: S
              }), i(S, null);
              return;
            }
            i(null, g);
          } else {
            s.onreadystatechange = s.onerror = () => {
              c.debug.info(Te.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let g = new Error(Te.NAME + s.statusText);
            g.code = r.isWrapper ? P.WRAPPER.TIMEOUT.code : P.XML.INVALID_XML.code, g.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: le.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: g
            }), i(g, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(m), c.debug.info(Te.NAME + ": XHR Error.", s.readyState, s.status, e);
        let g = new Error(Te.NAME + s.statusText);
        g.code = P.WRAPPER.TIMEOUT.code, g.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: le.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: g
        }), i(g, null);
      };
    } catch (g) {
      clearTimeout(m);
      let S = new Error(`${Te.NAME}: Request error.`);
      S.code = P.WRAPPER.TIMEOUT.code, S.message = `XHR Request Error: ${g}`, r.adReinsertion.setReinsertionReason({
        reason: le.REASON.XHR_ERROR,
        xhr: null,
        xhrError: S
      }), i(S, null);
    }
  }
  get(e, i, r) {
    c.debug.info(`${Te.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Te.ISSUER.TRACKING ? fo.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Te.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Te.NAME = "XHRURLHandler";
let dt = Te;
dt.DEFAULT_TIMEOUT = 4;
function Vi(p, e) {
  if (p.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + p;
  }
  return p.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + p : p;
}
const ai = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class Dr {
  constructor() {
    this.issuer = dt.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = ai, s.enrichment = new St()), s.issuer = this.issuer, s.enrichment = s.enrichment || new St(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = Vi(l, ""));
    let u = s.urlhandler;
    if (s.response) {
      let m = s.response;
      i(null, _r(m));
    } else return u && u.supported() ? new u().get(l, i, s) : dt.supported() ? new dt().get(l, i, s) : wi.supported() ? new wi().get(l, i, s) : i();
    return null;
  }
}
const ri = class ri extends Dr {
  constructor() {
    super(), this.issuer = dt.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : c.debug.info(ri.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    for (const s of e)
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && c.debug.warn(ri.NAME + "onResponse failed:", i.name, i, e);
  }
};
ri.NAME = "TrackingUrlHandler::";
let xi = ri;
const f = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup",
  // HOMAD
  ON_HOMAD_PENALTY: "HOMADPenalty"
}, $t = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, Mt = class Mt {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, Mt.ERROR_CODE_MAP[P.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, Mt.ERROR_CODE_MAP[P.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, c.debug.info(
      ye.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new St(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new le(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, u) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        c.debug.info(
          ye.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((m) => {
        c.debug.warn(ye.NAME + "initAdSlot - Could not init ad slot", m), u(m);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    c.debug.info(
      ye.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_START, () => {
        this.trackEvent($t.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent($t.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Mt.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent($t.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(f.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent($t.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), c.debug.info(
      ye.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      ye.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(
        ye.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new xi().track(e, (r, s) => {
      s && c.debug.warn(ye.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
Mt.ERROR_CODE_MAP = {}, Mt.NAME = "AdBreakCtrl::";
let fr = Mt;
const Fe = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, hr = "Content - Scan for AdBreaks to play", de = class de extends Ot {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(f.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(f.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, c.debug.info(
      de.NAME + "before" + hr + "."
    ), super.dispatchEvent(f.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      c.debug.info(
        de.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), c.debug.info(
      de.NAME + "start" + hr + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, c.debug.info(
      de.NAME + "after" + hr + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset) {
      this.isSeeking = !1, this.postroll = null;
      for (const s of this.adPlaylist)
        s.timeOffset !== "end" && (s.requested = !0);
      this.requestAdBreak(e);
    }
    if (this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    for (const s of i)
      s.requested = !0;
    return r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new fr(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((u) => {
        c.debug.info(
          de.NAME + "requestAdBreak - Initialized AdBreak",
          u.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(u), s();
      }).catch((u) => {
        c.debug.warn(
          de.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          u
        ), l(u);
      })) : l(
        de.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      de.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), c.debug.info(de.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = de.PROCESS.REQUEST) {
    function s(u, m) {
      var S;
      const g = u - m;
      return (S = e.publisherSpecs) != null && S.strictOffsets ? g >= 0 && g <= de.STRICT_OFFSET_THRESHOLD : g >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const u = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, u);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === de.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === de.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = yt(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", Pi(r)), this.adPlaylist.push(new oi(s, e.publisherSpecs)), c.debug.info(
      de.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener(Fe.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, u = (Date.now() - e) / 1e3;
      l > u + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= de.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        de.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(Fe.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), c.debug.info(
      de.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      de.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    );
    for (const e of this.eventHandlers)
      e();
    this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
de.NAME = "AdPlaylistCtrl::", de.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, de.STRICT_OFFSET_THRESHOLD = 2, de.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let ye = de;
const Ao = "HomadXHRUrlHandler", Vn = ": Response contains neither 'responseXML' nor 'responseText'", Wt = class Wt {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Wt().xhrRequest();
  }
  getAsXHR(e, i, r) {
    function s(g) {
      i(g, null);
    }
    function l(g) {
      if (r.issuer && r.issuer === dt.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let S = g.responseXML;
      if (!S && g.responseText && (S = _r(g.responseText)), !S) {
        let L = new Error(Ao + Vn);
        L.code = P.XML.INVALID_XML.code, L.description = "HOMAD Response Error" + Vn, i(L, null);
        return;
      }
      i(null, S);
    }
    if (!r.adReinsertion) {
      let g = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      g.code = P.WRAPPER.TIMEOUT.code, g.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(g);
      return;
    }
    const u = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let m = r.adReinsertion.vendorAPI.getUrlRequest(u);
    m.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), c.debug.info(
      Wt.NAME + "getAsXHR - Provide VAST Macro List" + m.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(m, (g) => {
      l(g);
    }, (g) => {
      let S, L = "HOMADUtils XHR";
      g.timedOut ? (S = new Error("HomadUtilsURLHandler: Request timeout."), S.code = P.WRAPPER.TIMEOUT.code, S.description = `${L} Timeout Error ${r.timeouts.errorMessage || P.WRAPPER.TIMEOUT.message}`) : (S = new Error("HomadUtilsURLHandler: " + g.statusText), S.code = P.XML.INVALID_XML.code, S.description = `${L} Status Error (${g.status}): ${g.statusText}`), s(S);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = ai.timeouts), c.debug.info(`${Wt.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
Wt.NAME = "HomadUrlHandler::";
let ki = Wt;
function Gn(p) {
  return window.location.protocol === "https:" && !p.startsWith("http://") || window.location.protocol !== "https:";
}
function qe(p, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), p.appendChild(i);
}
const ni = class ni {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (c.debug.info(ni.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return qe(r, P.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    J(e, "VMAP").length > 0 && J(e, "AdBreak").length === 0 && (qe(r, P.VMAP.NO_ADBREAKS), i = r), J(e, "VMAP").length === 0 && J(e, "ParserError").length === 0 && (qe(r, P.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new Dr().get(e, (r, s) => {
        if (!r && s && $(s, "parsererror")) {
          let l = document.createDocumentFragment();
          qe(l, P.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          c.debug.warn(ni.NAME + "loadURL - XHR Request Error", r), qe(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  isInsecureURL(e) {
    return this.blockInsecureURL && !Gn(e);
  }
};
ni.NAME = "VMAPReqService::";
let Ar = ni;
function Kn(p) {
  if (!p || typeof p != "object")
    return !1;
  try {
    return p.self === p;
  } catch (e) {
    return !0;
  }
}
function qt(p, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (Kn(i[r]) ? p[r] = i[r] : typeof p[r] == "object" && typeof i[r] == "object" ? p[r] = qt(p[r], i[r]) : p[r] = i[r]);
  return p;
}
function zn() {
  return this.error || null;
}
function tt(p) {
  this.error = {
    code: p.code,
    message: p.message,
    timestamp: Date.now()
  };
}
let xn = null;
const br = class br extends Ot {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, c.debug.info(ye.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), c.debug.info(ye.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = qt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    xn = new le(this.config.adReinsertion, s);
    const l = {
      adReinsertion: xn,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: qt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((u, m) => {
      r = this.addEventListener(f.ON_AD_PLAYLIST_LOAD_ERROR, () => m(this.errorAPI)), this.addEventListener(f.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new ye(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), u("ok")));
      let g = new Ar(
        l
      );
      e.tag ? g.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : g.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new uo(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    c.debug.info(ye.NAME + "onXMLLoadDone and vmap parsed.", i), c.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = $(i, "ParserError"), u = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = P.VMAP.NO_ADBREAKS;
        tt.call(this, u), super.dispatchEvent(f.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(f.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      c.debug.info(
        ye.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), c.debug.info(
            ye.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = ki, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          c.debug.info(ye.NAME + "enable - AdReinsertion remains disabled.", l), tt.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    super.dispatchEvent(f.ON_AD_PLAYLIST_START);
    for (const e of Object.values(f))
      this.adPlaylistController.addEventListener(e, (i) => {
        super.dispatchEvent(i.type);
      });
    return new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return zn.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
br.NAME = "AdPlaylAPI::";
let mr = br;
var ue = /* @__PURE__ */ ((p) => (p.CLOSER = "closer", p.DIVIDER = "divider", p.OPENER = "opener", p.COMMERCIAL = "commercial", p.SPONSORED = "sponsored", p))(ue || {});
class mo {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== ue.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const se = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, et = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, it = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, We = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, si = class si extends c {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.resolutionListeners = {}, this.eventsThatRequireResponse = [
      se.CLICK_THRU,
      se.GET_MEDIA_STATE,
      se.READY,
      se.REPORT_TRACKING,
      se.REQUEST_CHANGE_AD_DURATION,
      se.REQUEST_FULL_SCREEN,
      se.REQUEST_PAUSE,
      se.REQUEST_PLAY,
      se.REQUEST_RESIZE,
      se.REQUEST_SKIP,
      se.REQUEST_STOP,
      se.REQUEST_VIDEO_LOCATION,
      se.REQUEST_VOLUME,
      it.AD_SKIPPED,
      it.AD_STOPPED,
      it.FATAL_ERROR,
      it.INIT,
      it.START_CREATIVE,
      We.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === We.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((u, m) => {
      this.addResolveRejectListener(r, u, m), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((u) => {
      this.target.postMessage(JSON.stringify(l), "*"), u();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  isResolve(e) {
    return e.type === We.RESOLVE;
  }
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      this.isResolve(l) ? i(l.args.value) : r(l.args.value);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  parseData(e) {
    try {
      return JSON.parse(e);
    } catch (i) {
      return null;
    }
  }
  callListeners(e, i) {
    const r = this.listeners[e];
    if (r)
      for (let s = 0; s < r.length; s++)
        r[s](i);
  }
  // eslint-disable-next-line complexity
  isValidSession(e) {
    const i = e.sessionId, r = e.type, s = this.sessionId === "" && r === We.CREATE_SESSION, l = this.sessionId === i;
    if (!(!(s || l) || r === null)) {
      if (Object.values(We).includes(r))
        this.handleProtocolMessage(e);
      else if (r.startsWith("SIMID:")) {
        const m = r.substring(6);
        this.callListeners(m, e);
      }
    }
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i = this.parseData(e.data);
    i && this.isValidSession(i);
  }
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case We.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {}), this.callListeners(i, e);
        break;
      case We.RESOLVE:
      // intentional fallthrough
      case We.REJECT:
        const s = e.args.messageId, l = this.resolutionListeners[s];
        l && (l(e), delete this.resolutionListeners[s]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: We.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: We.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      c.debug.info(si.NAME + "createSession resolve");
    }, i = () => {
      c.debug.info(si.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(We.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
si.NAME = "SIMIDPtl::";
let Er = si;
function vt(p, e) {
  let i = document.createElement(p);
  if (e)
    for (const r in e)
      Object.prototype.hasOwnProperty.call(e, r) && i.setAttribute(r, e[r]);
  return i;
}
const Mi = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, kn = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Dt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, ti = 0, cr = -2, Eo = !0, Pe = class Pe {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new Er(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = ti, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = ti, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      c.debug.info(
        Pe.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = vt("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    if (c.debug.info(Pe.NAME + "createSimidIframe with", this.creativeAsset), e.style.display = "none", this.container.appendChild(e), this.creativeAsset.resource) {
      const i = new Blob([this.creativeAsset.resource], { type: "text/html" });
      e.src = URL.createObjectURL(i);
    } else
      e.src = this.creativeAsset.fileURL;
    return this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  addListeners() {
    this.simidProtocol.addListener(We.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(se.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(se.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(se.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(se.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(se.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(se.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(se.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      se.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(se.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(se.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(se.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(se.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(se.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = e.y + e.height <= i.height, s = e.x + e.width <= i.width;
    return r && s;
  }
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      c.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  setIFrameDimensions(e) {
    c.debug.info(Pe.NAME + "resize", e), this.IFrame.style.height = e.height.toString(), this.IFrame.style.width = e.width.toString(), this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: Mi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), c.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), c.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: Mi.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), c.debug.error(Pe.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: Mi.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.error(Pe.NAME + i, r.message);
    }
  }
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(it.INIT, l).then(() => {
      this.resolveInitializationPromise(), c.debug.info(Pe.NAME + "session created");
    }).catch((m) => {
      this.rejectInitializationPromise(m);
    });
  }
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(f.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), c.debug.info(Pe.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(it.START_CREATIVE);
  }
  onAdInitializedFailed(e) {
    this.setError(P.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(f.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), c.debug.error(Pe.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  setCreativeControlsState(e) {
    let i = J(document, ".ad_request");
    if (i)
      for (let r of i)
        r.disabled = e;
  }
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        et.ERROR,
        {
          error: P.SIMID.GENERAL_ERROR.code,
          message: P.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = P.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(et.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(et.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(et.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(et.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(et.SEEKING);
    }), this.videoTrackingEvents.set(Fe.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        et.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        et.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Dt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        et.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Dt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(it.AD_STOPPED).then(() => {
      c.debug.info(Pe.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(it.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(f.ON_AD_SKIPPED), this.loadedSource = null;
  }
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(Eo), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    c.debug.info(Pe.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.requestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: kn.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: Mi.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    c.debug.info(Pe.NAME + "onReportTracking -  Creative has asked the player to send a ping."), c.debug.table(i);
  }
  videoComplete() {
    if (this.simidProtocol.sendMessage(et.ENDED), this.requestedDuration === ti && this.stopAd(Dt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== ti && this.requestedDuration !== cr) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Dt.CREATIVE_INITIATED);
      }, e);
    }
  }
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== cr && i < 0) {
      const r = {
        errorCode: kn.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  compareAdAndReqDurations() {
    this.requestedDuration === ti || this.requestedDuration === cr || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (c.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Dt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(it.LOG, i);
  }
};
Pe.NAME = "SIMIDPly::";
let gr = Pe;
function Un(p) {
  return p.height >= 0 ? p.y + p.height : p.y;
}
function Fn(p) {
  return p.width >= 0 ? p.x : p.x + p.width;
}
function jn(p) {
  return p.width >= 0 ? p.x + p.width : p.x;
}
function Bn(p) {
  return p.height >= 0 ? p.y : p.y + p.height;
}
function go(p, e) {
  let i = 0, r = {
    bottom: Math.min(Un(p), Un(e)),
    height: 0,
    left: Math.max(Fn(p), Fn(e)),
    right: Math.min(jn(p), jn(e)),
    top: Math.max(Bn(p), Bn(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = p.width * p.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class vo {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   */
  constructor(e) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(f)) {
      let i = this.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case f.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case f.ON_AD_PLAYBACK_START:
      case f.ON_AD_PLAYING:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(f.ON_AD_NOT_VIEWABLE)), this.removeEventListeners(), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.adSlotController.player.getPlayerSize(), i = this.adSlotController.player.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = go(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (c.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function So(p, e, i) {
  return new Promise((r) => {
    let s = vt("iframe", {
      id: p,
      style: e
    });
    s.onload = () => {
      let l = vt("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let u = vt("style", {});
      u.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(u), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const Y = class Y extends Ot {
  // ms
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = c.logLevel === rt.NORMAL || c.logLevel === rt.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = vt("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.timeoutAdLoadedTimer = null, this.timeoutScriptLoadTimer = null, this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), So(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = vt("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = vt("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = vt("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      c.debug.warn(Y.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = P.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest);
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), c.debug.info(
      Y.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (c.debug.info(Y.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return c.debug.info(
        Y.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), c.debug.info(
        Y.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), c.debug.info(
      Y.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), c.debug.info(
      Y.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    c.debug.info(Y.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = P.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest);
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    c.debug.info(Y.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = P.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness);
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, c.debug.info(Y.NAME + "cleanup"), this.dispatchEvent(f.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    c.debug.info(Y.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(f.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    c.debug.info(Y.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    c.debug.info(Y.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    c.debug.info(Y.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    c.debug.info(Y.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    c.debug.info(Y.NAME + "onStartAd"), this.dispatchEvent(f.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression() {
    c.debug.info(Y.NAME + "onAdImpression"), this.dispatchEvent(f.ON_AD_IMPRESSION);
  }
  onAdVideoStart() {
    c.debug.info(Y.NAME + "onAdVideoStart"), this.dispatchEvent(f.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), Y.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (c.debug.warn(Y.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, Y.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile() {
    c.debug.info(Y.NAME + "onAdVideoFirstQuartile"), this.dispatchEvent(f.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint() {
    c.debug.info(Y.NAME + "onAdVideoMidpoint"), this.dispatchEvent(f.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile() {
    c.debug.info(Y.NAME + "onAdVideoThirdQuartile"), this.dispatchEvent(f.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete() {
    c.debug.info(Y.NAME + "onAdVideoComplete"), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.dispatchEvent(f.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange() {
    c.debug.info(Y.NAME + "onAdDurationChange"), this.getAllProperties();
  }
  onStopAd() {
    c.debug.info(Y.NAME + "onStopAd"), this.dispatchEvent(f.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i) {
    c.debug.info(Y.NAME + "onAdError", e, i), this.currentAd.error = this.currentAd.error === null ? P.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd() {
    this.dispatchEvent(f.ON_AD_SKIPPED), c.debug.info(Y.NAME + "onSkipAd"), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(f.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && c.debug.info(
      Y.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange() {
    c.debug.info(Y.NAME + "onAdExpandedChange");
  }
  onAdSkippableStateChange() {
    c.debug.info(Y.NAME + "onAdSkippableStateChange"), this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(f.ON_AD_PROGRESS);
  }
  onAdVolumeChange() {
    c.debug.info(Y.NAME + "onAdVolumeChange");
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    c.debug.info(Y.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (c.debug.info(Y.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(f.ON_AD_CLICKED);
  }
  onAdInteraction(e) {
    c.debug.info(Y.NAME + "onAdInteraction", e);
  }
  onAdUserAcceptInvitation() {
    c.debug.info(Y.NAME + "onAdUserAcceptInvitation");
  }
  onAdUserMinimize() {
    c.debug.info(Y.NAME + "onAdUserMinimize");
  }
  onAdUserClose() {
    c.debug.info(Y.NAME + "onAdUserClose");
  }
  onAdPaused() {
    c.debug.info(Y.NAME + "onAdPaused");
  }
  onAdPlaying() {
    c.debug.info(Y.NAME + "onAdPlaying"), this.dispatchEvent(f.ON_AD_PLAYING);
  }
  onAdLog(e) {
    c.debug.info(Y.NAME + "onAdLog", e);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && c.debug.info(
        Y.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), c.debug.table(this.debugTiming));
  }
  //Debug -- End
};
Y.NAME = "VPAIDBridge::", Y.TIMEUPDATE_INTERVAL = 250;
let vr = Y;
const li = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  //  and it's used in canPlayType, text/html can't be played it's only used for interactive actions.
  VPAID: "application/javascript",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, Ue = class Ue extends Ot {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot.
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads.
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {FacadePlayer} player - Facade interface for the player.
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = Ue.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(f), this.eventTypes = Object.values(f), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  hasOffsetReached(e, i, r) {
    let s = r.offset;
    return typeof s == "string" && s.indexOf("%") > -1 && (s = parseInt(s, 10) / 100 * i), e >= parseInt(s, 10) && !r.requested;
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new mo(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(li)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [ue.COMMERCIAL, ue.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new vo(this));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    for (const i of this.eventCallbacks)
      i();
    this.eventCallbacks = [];
    for (const i of Object.values(f)) {
      const r = this.addEventListener(i, (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }
    if (this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const u = this.currentAd.config.adSourceSelector(
          l
        ).then((m) => m === null || Object.keys(m).length === 0 ? null : m);
        Promise.race([r, u]).then((m) => {
          m === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = m : this.currentAd.properCreative.selectedResource = m, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(f.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, c.debug.info(Ue.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === ue.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), c.debug.info(
          Ue.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), c.debug.info(Ue.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(Ue.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new xi().track(e, (s, l) => {
      l && (c.debug.warn(Ue.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : P.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(f.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === ae.NON_LINEAR) {
      this.currentAd.error = P.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(f.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = P.VAST.UNSUPPORTED_MIMETYPE), c.debug.info(Ue.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(f.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = Vi(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(f.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((u) => u.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === ue.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      c.debug.info(Ue.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === Ue.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(f.ON_ENTER_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_EXPAND)) : (this.dispatchEvent(f.ON_EXIT_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(f.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === ue.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(f.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Pi(e)), this.currentAd.variant === ue.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [ue.COMMERCIAL, ue.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          this.hasOffsetReached(e, this.adDuration, s) && this.dispatchEvent(f.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(f.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(f.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(f.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(f.ON_AD_FIRST_QUARTILE), e && i.push(f.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((u) => u === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = $t[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let u = this.currentAd.trackingEvents[r];
      e === f.ON_AD_PROGRESS && (u = u.filter((m) => this.hasOffsetReached(s, l, m))), this.callTrackers(u);
    }
  }
  loadAdSIMID() {
    this.currentAd.properCreative.selectedCreativeFile.fileURL === "" && this.currentAd.properCreative.selectedCreativeFile.resource === null ? (this.currentAd.error = P.SIMID.GENERAL_ERROR, this.cancelAdWithError()) : (this.simidPlayer = new gr(this), this.simidPlayer.initializeAd());
  }
  loadAdVPAID() {
    this.vpaidPlayer = new vr(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      f.ON_AD_CLICKED,
      f.ON_AD_LOADED,
      f.ON_AD_STARTED,
      f.ON_AD_IMPRESSION,
      f.ON_AD_PLAYING,
      f.ON_AD_PLAYBACK_START,
      f.ON_AD_FIRST_QUARTILE,
      f.ON_AD_MID_POINT,
      f.ON_AD_THIRD_QUARTILE,
      f.ON_AD_PLAYBACK_FINISHED,
      f.ON_AD_STOPPED,
      f.ON_AD_SKIPPED,
      f.ON_AD_ERROR,
      f.ON_AD_PROGRESS,
      f.ON_AD_SIZE_CHANGED,
      f.ON_AD_SKIPPABLE_STATE_CHANGE,
      f.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      f.ON_AD_LINEARITY_CHANGE,
      f.ON_AD_SKIPPED,
      f.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case f.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (c.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case f.ON_AD_SKIPPED:
        case f.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case f.ON_AD_LOADED:
      //onStartAd
      case f.ON_AD_STARTED:
      //onStartAd
      case f.ON_AD_IMPRESSION:
      case f.ON_AD_PLAYING:
      //onAdPlaying()
      case f.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case f.ON_AD_FIRST_QUARTILE:
      case f.ON_AD_MID_POINT:
      case f.ON_AD_THIRD_QUARTILE:
      case f.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case f.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case f.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case f.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case f.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    c.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
Ue.NAME = "AdSloCtrl::", Ue.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let Sr = Ue;
var ii = /* @__PURE__ */ ((p) => (p[p.ERROR_RESOURCE_REJECTED = 1] = "ERROR_RESOURCE_REJECTED", p[p.ERROR_VERIFICATION_NOT_SUPPORTED = 2] = "ERROR_VERIFICATION_NOT_SUPPORTED", p[p.ERROR_ON_RESOURCE_LOAD = 3] = "ERROR_ON_RESOURCE_LOAD", p))(ii || {}), Et = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function yo(p) {
  return p && p.__esModule && Object.prototype.hasOwnProperty.call(p, "default") ? p.default : p;
}
var Qn = {};
(function(p) {
  (function(e, i, r) {
    if (typeof r == "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      let g = function(S) {
        for (var L in S)
          S.hasOwnProperty(L) && (S[L] = g(S[L]));
        return Object.freeze(S);
      };
      var r = {}, s = ["1.5.6-iab144"], l = "default";
      l && s.push(l), i(e, r);
      for (var u in r)
        r.hasOwnProperty(u) && (Object.getOwnPropertyDescriptor(e, u) == null && Object.defineProperty(e, u, {
          value: {}
        }), s.forEach(function(S) {
          if (Object.getOwnPropertyDescriptor(e[u], S) == null) {
            var L = g(r[u]);
            Object.defineProperty(e[u], S, {
              get: function() {
                return L;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(Et, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, h) {
      return a.raw = h, a;
    }, r.arrayIteratorImpl = function(a) {
      var h = 0;
      return function() {
        return h < a.length ? { done: !1, value: a[h++] } : { done: !0 };
      };
    }, r.arrayIterator = function(a) {
      return { next: r.arrayIteratorImpl(a) };
    }, r.makeIterator = function(a) {
      var h = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (h)
        return h.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var h, E = []; !(h = a.next()).done; )
        E.push(h.value);
      return E;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var h = function() {
      };
      return h.prototype = a, new h();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, h, E) {
      return a == Array.prototype || a == Object.prototype || (a[h] = E.value), a;
    }, r.getGlobal = function(a) {
      a = [typeof globalThis == "object" && globalThis, a, typeof window == "object" && window, typeof self == "object" && self, typeof Et == "object" && Et];
      for (var h = 0; h < a.length; ++h) {
        var E = a[h];
        if (E && E.Math == Math)
          return E;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && typeof Symbol("x") == "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, h, E, y) {
      h && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, h, E, y) : r.polyfillUnisolated(a, h, E, y));
    }, r.polyfillUnisolated = function(a, h, E, y) {
      for (E = r.global, a = a.split("."), y = 0; y < a.length - 1; y++) {
        var _ = a[y];
        if (!(_ in E))
          return;
        E = E[_];
      }
      a = a[a.length - 1], y = E[a], h = h(y), h != y && h != null && r.defineProperty(E, a, { configurable: !0, writable: !0, value: h });
    }, r.polyfillIsolated = function(a, h, E, y) {
      var _ = a.split(".");
      a = _.length === 1, y = _[0], y = !a && y in r.polyfills ? r.polyfills : r.global;
      for (var ce = 0; ce < _.length - 1; ce++) {
        var pe = _[ce];
        if (!(pe in y))
          return;
        y = y[pe];
      }
      _ = _[_.length - 1], E = r.IS_SYMBOL_NATIVE && E === "es6" ? y[_] : null, h = h(E), h != null && (a ? r.defineProperty(r.polyfills, _, { configurable: !0, writable: !0, value: h }) : h !== E && (r.propertyToPolyfillSymbol[_] === void 0 && (E = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[_] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(_) : r.POLYFILL_PREFIX + E + "$" + _), r.defineProperty(y, r.propertyToPolyfillSymbol[_], { configurable: !0, writable: !0, value: h })));
    }, r.getConstructImplementation = function() {
      function a() {
        function E() {
        }
        return Reflect.construct(E, [], function() {
        }), new E() instanceof E;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var h = Reflect.construct;
        return function(E, y, _) {
          return E = h(E, y), _ && Reflect.setPrototypeOf(E, _.prototype), E;
        };
      }
      return function(E, y, _) {
        return _ === void 0 && (_ = E), _ = r.objectCreate(_.prototype || Object.prototype), Function.prototype.apply.call(E, _, y) || _;
      };
    }, r.construct = { valueOf: r.getConstructImplementation }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = { a: !0 }, h = {};
      try {
        return h.__proto__ = a, h.a;
      } catch (E) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, h) {
      if (a.__proto__ = h, a.__proto__ !== h)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, h) {
      if (a.prototype = r.objectCreate(h.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var E = r.setPrototypeOf;
        E(a, h);
      } else
        for (E in h)
          if (E != "prototype")
            if (Object.defineProperties) {
              var y = Object.getOwnPropertyDescriptor(h, E);
              y && Object.defineProperty(a, E, y);
            } else
              a[E] = h[E];
      a.superClass_ = h.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), h = [], E = a; E < arguments.length; E++)
        h[E - a] = arguments[E];
      return h;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var h = r.setPrototypeOf;
        return function(E, y) {
          try {
            return h(E, y), !0;
          } catch (_) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var h = function(ce, pe) {
        this.$jscomp$symbol$id_ = ce, r.defineProperty(this, "description", { configurable: !0, writable: !0, value: pe });
      };
      h.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var E = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", y = 0, _ = function(ce) {
        if (this instanceof _)
          throw new TypeError("Symbol is not a constructor");
        return new h(E + (ce || "") + "_" + y++, ce);
      };
      return _;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var h = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), E = 0; E < h.length; E++) {
        var y = r.global[h[E]];
        typeof y == "function" && typeof y.prototype[a] != "function" && r.defineProperty(y.prototype, a, { configurable: !0, writable: !0, value: function() {
          return r.iteratorPrototype(r.arrayIteratorImpl(this));
        } });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = { next: a }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, h) {
      a instanceof String && (a += "");
      var E = 0, y = !1, _ = { next: function() {
        if (!y && E < a.length) {
          var ce = E++;
          return { value: h(ce, a[ce]), done: !1 };
        }
        return y = !0, { done: !0, value: void 0 };
      } };
      return _[Symbol.iterator] = function() {
        return _;
      }, _;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(h) {
          return h;
        });
      };
    }, "es6", "es3"), r.owns = function(a, h) {
      return Object.prototype.hasOwnProperty.call(a, h);
    }, r.polyfill("Object.values", function(a) {
      return a || function(h) {
        var E = [], y;
        for (y in h)
          r.owns(h, y) && E.push(h[y]);
        return E;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, h = Object.create(new r.global.Proxy(a, { get: function(E, y, _) {
          return E == a && y == "q" && _ == h;
        } }));
        return h.q === !0;
      } catch (E) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function h() {
        if (!a || !Object.seal)
          return !1;
        try {
          var M = Object.seal({}), k = Object.seal({}), Z = new a([[M, 2], [k, 3]]);
          return Z.get(M) != 2 || Z.get(k) != 3 ? !1 : (Z.delete(M), Z.set(k, 4), !Z.has(M) && Z.get(k) == 4);
        } catch (ot) {
          return !1;
        }
      }
      function E() {
      }
      function y(M) {
        var k = typeof M;
        return k === "object" && M !== null || k === "function";
      }
      function _(M) {
        if (!r.owns(M, pe)) {
          var k = new E();
          r.defineProperty(M, pe, { value: k });
        }
      }
      function ce(M) {
        if (!r.ISOLATE_POLYFILLS) {
          var k = Object[M];
          k && (Object[M] = function(Z) {
            return Z instanceof E ? Z : (Object.isExtensible(Z) && _(Z), k(Z));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (h())
        return a;
      var pe = "$jscomp_hidden_" + Math.random();
      ce("freeze"), ce("preventExtensions"), ce("seal");
      var ft = 0, U = function(M) {
        if (this.id_ = (ft += Math.random() + 1).toString(), M) {
          M = r.makeIterator(M);
          for (var k; !(k = M.next()).done; )
            k = k.value, this.set(k[0], k[1]);
        }
      };
      return U.prototype.set = function(M, k) {
        if (!y(M))
          throw Error("Invalid WeakMap key");
        if (_(M), !r.owns(M, pe))
          throw Error("WeakMap key fail: " + M);
        return M[pe][this.id_] = k, this;
      }, U.prototype.get = function(M) {
        return y(M) && r.owns(M, pe) ? M[pe][this.id_] : void 0;
      }, U.prototype.has = function(M) {
        return y(M) && r.owns(M, pe) && r.owns(M[pe], this.id_);
      }, U.prototype.delete = function(M) {
        return y(M) && r.owns(M, pe) && r.owns(M[pe], this.id_) ? delete M[pe][this.id_] : !1;
      }, U;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function h() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var U = Object.seal({ x: 4 }), M = new a(r.makeIterator([[U, "s"]]));
          if (M.get(U) != "s" || M.size != 1 || M.get({ x: 4 }) || M.set({ x: 4 }, "t") != M || M.size != 2)
            return !1;
          var k = M.entries(), Z = k.next();
          return Z.done || Z.value[0] != U || Z.value[1] != "s" ? !1 : (Z = k.next(), !(Z.done || Z.value[0].x != 4 || Z.value[1] != "t" || !k.next().done));
        } catch (ot) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (h())
        return a;
      var E = /* @__PURE__ */ new WeakMap(), y = function(U) {
        if (this.data_ = {}, this.head_ = pe(), this.size = 0, U) {
          U = r.makeIterator(U);
          for (var M; !(M = U.next()).done; )
            M = M.value, this.set(M[0], M[1]);
        }
      };
      y.prototype.set = function(U, M) {
        U = U === 0 ? 0 : U;
        var k = _(this, U);
        return k.list || (k.list = this.data_[k.id] = []), k.entry ? k.entry.value = M : (k.entry = { next: this.head_, previous: this.head_.previous, head: this.head_, key: U, value: M }, k.list.push(k.entry), this.head_.previous.next = k.entry, this.head_.previous = k.entry, this.size++), this;
      }, y.prototype.delete = function(U) {
        return U = _(this, U), U.entry && U.list ? (U.list.splice(U.index, 1), U.list.length || delete this.data_[U.id], U.entry.previous.next = U.entry.next, U.entry.next.previous = U.entry.previous, U.entry.head = null, this.size--, !0) : !1;
      }, y.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = pe(), this.size = 0;
      }, y.prototype.has = function(U) {
        return !!_(this, U).entry;
      }, y.prototype.get = function(U) {
        return (U = _(this, U).entry) && U.value;
      }, y.prototype.entries = function() {
        return ce(this, function(U) {
          return [U.key, U.value];
        });
      }, y.prototype.keys = function() {
        return ce(this, function(U) {
          return U.key;
        });
      }, y.prototype.values = function() {
        return ce(this, function(U) {
          return U.value;
        });
      }, y.prototype.forEach = function(U, M) {
        for (var k = this.entries(), Z; !(Z = k.next()).done; )
          Z = Z.value, U.call(M, Z[1], Z[0], this);
      }, y.prototype[Symbol.iterator] = y.prototype.entries;
      var _ = function(U, M) {
        var k = M && typeof M;
        k == "object" || k == "function" ? E.has(M) ? k = E.get(M) : (k = "" + ++ft, E.set(M, k)) : k = "p_" + M;
        var Z = U.data_[k];
        if (Z && r.owns(U.data_, k))
          for (U = 0; U < Z.length; U++) {
            var ot = Z[U];
            if (M !== M && ot.key !== ot.key || M === ot.key)
              return { id: k, list: Z, index: U, entry: ot };
          }
        return { id: k, list: Z, index: -1, entry: void 0 };
      }, ce = function(U, M) {
        var k = U.head_;
        return r.iteratorPrototype(function() {
          if (k) {
            for (; k.head != U.head_; )
              k = k.previous;
            for (; k.next != k.head; )
              return k = k.next, { done: !1, value: M(k) };
            k = null;
          }
          return { done: !0, value: void 0 };
        });
      }, pe = function() {
        var U = {};
        return U.previous = U.next = U.head = U;
      }, ft = 0;
      return y;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", u = "omid_message_version", m = "omid_message_args", g = function(a, h, E, y) {
      this.guid = a, this.method = h, this.version = E, this.args = y;
    };
    g.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[u] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[u] == "string" && (a[m] === void 0 || a[m] !== void 0);
    }, g.deserialize = function(a) {
      return new g(a[s], a[l], a[u], a[m]);
    }, g.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[u] = this.version, a), this.args !== void 0 && (a[m] = this.args), a;
    };
    var S = { AdEventType: { SESSION_START: "sessionStart", SESSION_FINISH: "sessionFinish" }, MediaEventType: { LOADED: "loaded", START: "start", FIRST_QUARTILE: "firstQuartile", MIDPOINT: "midpoint", THIRD_QUARTILE: "thirdQuartile", COMPLETE: "complete", PAUSE: "pause", RESUME: "resume", BUFFER_START: "bufferStart", BUFFER_FINISH: "bufferFinish", SKIPPED: "skipped", VOLUME_CHANGE: "volumeChange", PLAYER_STATE_CHANGE: "playerStateChange", AD_USER_INTERACTION: "adUserInteraction" }, ImpressionType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, ErrorType: { GENERIC: "generic" }, AccessMode: { FULL: "full" }, Environment: { APP: "app", WEB: "web" }, CreativeType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, CommunicationType: { NONE: "NONE", DIRECT: "DIRECT", POST_MESSAGE: "POST_MESSAGE" }, MessageMethod: { IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow" } }, L = function(a) {
      this.to = a, this.communicationType_ = S.CommunicationType.NONE;
    };
    L.prototype.sendMessage = function(a, h) {
    }, L.prototype.handleMessage = function(a, h) {
      this.onMessage && this.onMessage(a, h);
    }, L.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, L.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, L.prototype.isDirectCommunication = function() {
      return this.communicationType_ === S.CommunicationType.DIRECT;
    }, L.prototype.isCrossOrigin = function() {
    };
    function ie(a, h) {
      if (!h)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof h != "string" && !(h instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (h.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function Q(a, h) {
      if (h == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function Se(a, h) {
      if (h == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof h != "number" || isNaN(h))
        throw Error("Value for " + a + " is not a number");
    }
    function K(a, h, E, y) {
      if (Se(a, h), h < E || h > y)
        throw Error("Value for " + a + " is outside the range [" + E + "," + y + "]");
    }
    function G() {
      return typeof i == "undefined" ? null : i;
    }
    function O(a, h) {
      return a && (a[h] || (a[h] = {}));
    }
    function I(a, h, E) {
      (E = E === void 0 ? G() : E) && (a = a.split("."), a.slice(0, a.length - 1).reduce(O, E)[a[a.length - 1]] = h);
    }
    var w = function(a, h) {
      ie("Partner.name", a), ie("Partner.version", h), this.name = a, this.version = h;
    };
    I("OmidSessionClient.Partner", w);
    var W = function(a, h, E, y) {
      y = y === void 0 ? S.AccessMode.FULL : y, ie("VerificationScriptResource.resourceUrl", a), this.resourceUrl = a, this.vendorKey = h, this.verificationParameters = E, this.accessMode = y;
    };
    W.prototype.toJSON = function() {
      return { accessMode: this.accessMode, resourceUrl: this.resourceUrl, vendorKey: this.vendorKey, verificationParameters: this.verificationParameters };
    }, I("OmidSessionClient.VerificationScriptResource", W);
    var X = function(a, h) {
      ie("UniversalAdId.value", a), ie("UniversalAdId.idRegistry", h), this.value = a, this.idRegistry = h;
    };
    X.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, I("OmidSessionClient.UniversalAdId", X);
    var z = function(a, h, E, y, _) {
      E = E === void 0 ? null : E, y = y === void 0 ? null : y, _ = _ === void 0 ? null : _, Q("Context.partner", a), this.partner = a, this.verificationScriptResources = h, this.videoElement = this.slotElement = null, this.contentUrl = E, this.customReferenceData = y, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = _;
    };
    z.prototype.setVideoElement = function(a) {
      Q("Context.videoElement", a), this.videoElement = a;
    }, z.prototype.setSlotElement = function(a) {
      Q("Context.slotElement", a), this.slotElement = a;
    }, z.prototype.setServiceWindow = function(a) {
      Q("Context.serviceWindow", a), this.serviceWindow = a;
    }, I("OmidSessionClient.Context", z);
    var F = {};
    function D() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof Et != "undefined" && Et)
        return Et;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    F.omidGlobal = D();
    var R = { ROOT: "omidSessionInterface", AD_EVENTS: "adEvents", MEDIA_EVENTS: "mediaEvents" }, b = { sessionError: "reportError" }, j = Object.keys(S.MediaEventType).map(function(a) {
      return S.MediaEventType[a];
    }), ee = ["impressionOccurred"], Ne = function(a) {
      a = a === void 0 ? F.omidGlobal : a, this.interfaceRoot_ = a[R.ROOT];
    };
    Ne.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, Ne.prototype.sendMessage = function(a, h, E) {
      if (a == "registerSessionObserver" && (E = [h]), b[a] && (a = b[a]), h = this.interfaceRoot_, 0 <= ee.indexOf(a) && (h = h[R.AD_EVENTS]), 0 <= j.indexOf(a) && (h = h[R.MEDIA_EVENTS]), h = h[a], !h)
        throw Error("Unrecognized method name: " + a + ".");
      h.apply(null, r.arrayFromIterable(E));
    };
    function Ce() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var h = 16 * Math.random() | 0;
        return a = a === "y" ? (h & 3 | 8).toString(16) : h.toString(16), a;
      });
    }
    function ut() {
      var a = r.getRestArguments.apply(0, arguments);
      Pt(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function Pt(a, h) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && h();
    }
    var Ye = { Version: "1.5.6-iab144" }, nt = 3;
    function je(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function It(a, h) {
      a = a.split("-")[0].split("."), h = h.split("-")[0].split(".");
      for (var E = 0; E < nt; E++) {
        var y = parseInt(a[E], 10), _ = parseInt(h[E], 10);
        if (y > _)
          break;
        if (y < _)
          return !1;
      }
      return !0;
    }
    var Qe = "1.0.3";
    function ht(a, h) {
      return je(a) && It(a, Qe) ? h : JSON.stringify(h);
    }
    function st(a, h) {
      return je(a) && It(a, Qe) ? h || [] : h && typeof h == "string" ? JSON.parse(h) : [];
    }
    var Be = { SESSION_SERVICE: "SessionService." };
    function wt(a) {
      return ge(a, Be.SESSION_SERVICE);
    }
    function ge(a, h) {
      return h + a;
    }
    function ct(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function Ve(a) {
      if (a === F.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        Oe(a);
      } catch (h) {
        return !0;
      }
      return !1;
    }
    function Oe(a) {
      return a.x === "" || a.x !== "";
    }
    function _e(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), ct(a) ? a : F.omidGlobal;
    }
    function He(a) {
      return ct(a) ? a.top : F.omidGlobal;
    }
    var V = function(a) {
      L.call(this, a), this.communicationType_ = S.CommunicationType.DIRECT, this.handleExportedMessage = V.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(V, L), V.prototype.sendMessage = function(a, h) {
      if (h = h === void 0 ? this.to : h, !h)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      h.handleExportedMessage(a.serialize(), this);
    }, V.prototype.handleExportedMessage = function(a, h) {
      g.isValidSerializedMessage(a) && this.handleMessage(g.deserialize(a), h);
    }, V.prototype.isCrossOrigin = function() {
      return !1;
    };
    var B = function(a, h) {
      h = h === void 0 ? F.omidGlobal : h, L.call(this, h);
      var E = this;
      this.communicationType_ = S.CommunicationType.POST_MESSAGE, a.addEventListener("message", function(y) {
        if (typeof y.data == "object") {
          var _ = y.data;
          g.isValidSerializedMessage(_) && (_ = g.deserialize(_), y.source && E.handleMessage(_, y.source));
        }
      });
    };
    r.inherits(B, L), B.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, B.prototype.sendMessage = function(a, h) {
      if (h = h === void 0 ? this.to : h, !h)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      h.postMessage(a.serialize(), "*");
    }, B.prototype.isCrossOrigin = function() {
      return this.to ? Ve(this.to) : !0;
    };
    var q = { OMID_PRESENT_FRAME_NAME: "omid_v1_present", OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web", OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app", getEnvironmentIframeName: function(a) {
      var h = {};
      return (h[S.Environment.APP] = q.OMID_PRESENT_FRAME_NAME_APP, h[S.Environment.WEB] = q.OMID_PRESENT_FRAME_NAME_WEB, h)[a];
    } };
    function he(a, h) {
      try {
        return a.frames && !!a.frames[h];
      } catch (E) {
        return !1;
      }
    }
    q.isOmidPresent = function(a) {
      return [q.OMID_PRESENT_FRAME_NAME, q.OMID_PRESENT_FRAME_NAME_WEB, q.OMID_PRESENT_FRAME_NAME_APP].some(function(h) {
        return he(a, h);
      });
    }, q.getOmidEnvironment = function(a) {
      for (var h = r.makeIterator(Object.values(S.Environment)), E = h.next(); !E.done; E = h.next()) {
        E = E.value;
        var y = q.getEnvironmentIframeName(E);
        if (he(a, y))
          return E;
      }
      return null;
    };
    function ne(a, h) {
      a.document.write('<iframe style="display:none" id="' + (h + '" name="' + h + '" sandbox></iframe>'));
    }
    q.declareOmidPresence = function(a, h) {
      a.frames && a.document && ![q.OMID_PRESENT_FRAME_NAME, q.OMID_PRESENT_FRAME_NAME_WEB, q.OMID_PRESENT_FRAME_NAME_APP].some(function(E) {
        return !!a.frames[E];
      }) && (a.document.body == null && q.isMutationObserverAvailable_(a) ? q.registerMutationObserver_(a, h) : (h = q.getEnvironmentIframeName(h), a.document.body ? (q.appendPresenceIframe_(a, q.OMID_PRESENT_FRAME_NAME), q.appendPresenceIframe_(a, h)) : (ne(
        a,
        q.OMID_PRESENT_FRAME_NAME
      ), ne(a, h))));
    }, q.appendPresenceIframe_ = function(a, h) {
      var E = a.document.createElement("iframe");
      E.id = h, E.name = h, E.style.display = "none", E.sandbox = "", a.document.body.appendChild(E);
    }, q.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, q.registerMutationObserver_ = function(a, h) {
      var E = new MutationObserver(function(y) {
        y.forEach(function(_) {
          _.addedNodes[0].nodeName === "BODY" && (_ = q.getEnvironmentIframeName(h), q.appendPresenceIframe_(a, q.OMID_PRESENT_FRAME_NAME), q.appendPresenceIframe_(a, _), E.disconnect());
        });
      });
      E.observe(a.document.documentElement, { childList: !0 });
    };
    var pt = ["omid", "v1_SessionServiceCommunication"];
    function Tt(a, h) {
      return h.reduce(function(E, y) {
        return E && E[y];
      }, a);
    }
    function ui(a, h, E, y) {
      if (!Ve(h))
        try {
          var _ = Tt(h, E);
          if (_)
            return new V(_);
        } catch (ce) {
        }
      return y(h) ? new B(a, h) : null;
    }
    function $e(a, h, E, y) {
      h = r.makeIterator(h);
      for (var _ = h.next(); !_.done; _ = h.next())
        if (_ = ui(a, _.value, E, y))
          return _;
      return null;
    }
    function hi(a, h, E) {
      E = E === void 0 ? q.isOmidPresent : E;
      var y = [a, He(a)];
      return h && y.unshift(h), $e(a, y, pt, E);
    }
    var te = function(a, h, E) {
      Q("AdSession.context", a), this.adSessionId_ = Ce(), this.context_ = a, this.impressionOccurred_ = !1;
      var y = this.context_.serviceWindow || void 0;
      this.communication_ = h || hi(_e(), y), this.sessionInterface_ = E || new Ne(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(a.verificationScriptResources), this.sendSlotElement_(a.slotElement), this.sendVideoElement_(a.videoElement), this.sendContentUrl_(a.contentUrl), this.watchSessionEvents_();
    };
    te.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, te.prototype.setCreativeType = function(a) {
      if (a === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + S.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, te.prototype.setImpressionType = function(a) {
      if (a === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + S.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, te.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, te.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, te.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, te.prototype.start = function() {
      var a = { customReferenceData: this.context_.customReferenceData, underEvaluation: this.context_.underEvaluation };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, te.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, te.prototype.error = function(a, h) {
      this.sendOneWayMessage("sessionError", a, h, this.adSessionId_);
    }, te.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, te.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, te.prototype.sendOneWayMessage = function(a) {
      var h = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(h)));
    }, te.prototype.sendMessage = function(a, h) {
      var E = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, h, E) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, h, E);
    }, te.prototype.sendInternalMessage_ = function(a, h, E) {
      var y = Ce();
      h && (this.callbackMap_[y] = h), a = new g(y, wt(a), Ye.Version, ht(Ye.Version, E)), this.communication_.sendMessage(a);
    }, te.prototype.handleInternalMessage_ = function(a, h) {
      h = a.method;
      var E = a.guid;
      if (a = a.args, h === "response" && this.callbackMap_[E]) {
        var y = st(Ye.Version, a);
        this.callbackMap_[E].apply(this, y);
      }
      h === "error" && window.console && ut(a);
    }, te.prototype.sendInterfaceMessage_ = function(a, h, E) {
      try {
        this.sessionInterface_.sendMessage(a, h, E);
      } catch (y) {
        ut("Failed to communicate with SessionInterface with error:"), ut(y);
      }
    }, te.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, te.prototype.impressionOccurred = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, te.prototype.creativeLoaded = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, te.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", Ye.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, te.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(h) {
        return h.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, te.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, te.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, te.prototype.sendElement_ = function(a, h) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(h, a, this.adSessionId_) : this.error(S.ErrorType.GENERIC, "Session Client " + h + " called when communication is cross-origin"));
    }, te.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, te.prototype.setElementBounds = function(a) {
      Q("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, te.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(h) {
        h.type === S.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = h.data.creativeType, a.impressionType_ = h.data.impressionType), h.type === S.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, I("OmidSessionClient.AdSession", te);
    var Gt = function(a, h, E, y) {
      this.isSkippable = a, this.skipOffset = h, this.isAutoPlay = E, this.position = y;
    };
    Gt.prototype.toJSON = function() {
      return { isSkippable: this.isSkippable, skipOffset: this.skipOffset, isAutoPlay: this.isAutoPlay, position: this.position };
    };
    var Kt = function(a) {
      Q("AdEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerAdEvents(), this.adSession = a;
      } catch (h) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    Kt.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, Kt.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, I("OmidSessionClient.AdEvents", Kt);
    var ve = function(a) {
      Q("MediaEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerMediaEvents(), this.adSession = a;
      } catch (h) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    ve.prototype.start = function(a, h) {
      Se("MediaEvents.start.duration", a), K("MediaEvents.start.mediaPlayerVolume", h, 0, 1), this.adSession.sendOneWayMessage("start", a, h, this.adSessionId_);
    }, ve.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, ve.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, ve.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, ve.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, ve.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, ve.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, ve.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, ve.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, ve.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, ve.prototype.volumeChange = function(a) {
      K("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, ve.prototype.playerStateChange = function(a) {
      Q("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, ve.prototype.adUserInteraction = function(a) {
      Q("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, I("OmidSessionClient.MediaEvents", ve);
    var ci = function(a, h) {
      ie("OmidVersion.semanticVersion", a), ie("OmidVersion.apiLevel", h);
    };
    I("OmidSessionClient.OmidVersion", ci);
    function pi(a) {
      var h = _e();
      new B(h).onMessage = function(E, y) {
        E.method === S.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(y);
      };
    }
    I("OmidSessionClient.listenForServiceWindow", pi), I("OmidSessionClient.VastProperties", Gt);
    var xe = { VerificationVendorId: { OTHER: 1, MOAT: 2, DOUBLEVERIFY: 3, INTEGRAL_AD_SCIENCE: 4, PIXELATE: 5, NIELSEN: 6, COMSCORE: 7, MEETRICS: 8, GOOGLE: 9, HUMAN: 10 } };
    function fi(a) {
      for (var h = r.makeIterator(Vt.keys()), E = h.next(); !E.done; E = h.next()) {
        E = E.value;
        for (var y = r.makeIterator(Vt.get(E)), _ = y.next(); !_.done; _ = y.next())
          if (_.value.test(a))
            return E;
      }
      return xe.VerificationVendorId.OTHER;
    }
    var Vt = /* @__PURE__ */ new Map([[xe.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [xe.VerificationVendorId.INTEGRAL_AD_SCIENCE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/
    ]], [xe.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [xe.VerificationVendorId.NIELSEN, []], [xe.VerificationVendorId.COMSCORE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/
    ]], [xe.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [xe.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [
      xe.VerificationVendorId.HUMAN,
      [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]
    ]]);
    I("OmidSessionClient.verificationVendorIdForScriptUrl", fi), I("OmidSessionClient.VerificationVendorId", xe.VerificationVendorId), xe.verificationVendorIdForScriptUrl = fi;
  }, p);
})(Qn);
const Oo = /* @__PURE__ */ yo(Qn), fe = class fe {
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = Oo.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      c.debug.warn(fe.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      c.debug.info(
        fe.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (c.debug.info(
      fe.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), c.debug.table(this.verifications), e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      c.debug.info(
        fe.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      fe.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, ii.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        ii.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  initOMIDJS() {
    if (this.adSession = this.createAdSession(), this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? fe.IMPRESSION_TYPE.RENDER : fe.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), c.debug.info(fe.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return c.debug.error(fe.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          ii.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const e = () => {
      const i = this.createVastProperties();
      this.adEvents.loaded(i), this.video.removeEventListener("canplaythrough", e);
    };
    return this.video.addEventListener("canplaythrough", e), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  createAdSession() {
    let e = new this.sessionClient.Partner(fe.PARTNER_NAME, fe.PARTNER_VERSION), i = this.verifications.map((s) => (c.debug.info(
      fe.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      Vi(s.javascriptResource.url, s.javascriptResource.url),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      Vi(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners();
    for (const e of Object.values(f)) {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        e,
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    }
  }
  removeEventListeners() {
    for (const e of this.removeEventHandlers)
      e();
    this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case f.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), c.debug.info(fe.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          c.debug.info(fe.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (c.debug.info(fe.NAME + i, e), !this.adEvents) {
      c.debug.warn(fe.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case f.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case f.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case f.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case f.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case f.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case f.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case f.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case f.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case f.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case f.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case f.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case f.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case f.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  trackError(e, i) {
    this.ad.enrichment.set("REASON", i, "reason"), this.adSlotDelivery.adSlotController.callTrackers(e);
  }
};
fe.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, fe.PARTNER_NAME = "Smartcliptv", fe.PARTNER_VERSION = "7.6.1", fe.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], fe.NAME = "OMID::";
let yr = fe;
const pr = "Resource", Ui = {
  STATIC: `Static${pr}`,
  HTML: `HTML${pr}`,
  IFRAME: `IFrame${pr}`
}, gt = class gt extends Ot {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case Ui.STATIC:
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    c.debug.info(gt.NAME + "pause");
    for (const e of this.cleanupTimer)
      clearTimeout(e);
    this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    c.debug.info(gt.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    c.debug.info(gt.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    c.debug.info(gt.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    c.debug.info(gt.NAME + "onStopAd"), this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
gt.NAME = "NonLinear::";
let Or = gt;
const ze = class ze extends Ot {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i) {
    super(), this.adSlotController = i, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i.player;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        c.debug.info(
          ze.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (S(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, u = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_STARTED,
          s
        ), m = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_ERROR,
          l
        ), g = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_VPAID_CLEANUP,
          r
        ), S = () => {
          u(), m(), g();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      f.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(Fe.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(Fe.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(f.ON_AD_PAUSED);
    }), this.addPlayerEventListener(Fe.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(f.ON_AD_PLAYING);
    }), this.addPlayerEventListener(Fe.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(f.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(f.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(f.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(f.ON_AD_START, this.saveStartVolume), super.addEventListener(f.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(Fe.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED), c.debug.info(ze.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(Fe.ON_ERROR, () => {
      c.debug.info(
        ze.NAME + "on - Player sent error event"
      );
    });
  }
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => {
      if (!this.adSlotHasStarted)
        return e();
      this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(f.ON_AD_SLOT_STOPPED));
      for (const i of this.eventCallbacks)
        i();
      return this.eventCallbacks = [], e();
    });
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), c.debug.info(ze.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(f.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart;
        e.removeImpressionOnStartHandler = (s ? e.adSlotController : e).addEventListener(
          // To bridge the gap between impression (ad loaded) and start (first timeupdate),
          //  a publisher may want the impression to be tracked with the start trackers first.
          s ? f.ON_AD_PLAYBACK_START : f.ON_AD_STARTED,
          () => {
            e.adSlotController.dispatchEvent(f.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
          }
        );
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(f.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    if (e && e.length > 0 && this.dispatchEvent(f.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(f.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(f.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(f.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0) {
      if (!this.currentAd.config.adVerification.disabled)
        this.currentAd.config.adVerification.playerHandles || new yr(this.currentAd, this);
      else {
        c.debug.warn(
          ze.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
        );
        for (const i of this.currentAd.adVerifications)
          this.currentAd.enrichment.set("REASON", ii.ERROR_RESOURCE_REJECTED, "reason"), this.adSlotController.callTrackers(i.tracking.verificationNotExecuted);
      }
      this.dispatchEvent(f.ON_VERIFICATION_DETECTED);
    }
  }
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR)), le.EventDispatcher.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (u) => {
        s = !0, c.debug.error("VideoProxy load timeout.", u), this.currentAd.error = P.VAST.TIMEOUT, this.deliverOrHOMAD(le.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), c.debug.info(ze.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (c.debug.info(ze.NAME + i + "success."), this.adSlotController.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED));
      }, (u) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        c.debug.error(ze.NAME + i + "failed", u);
        const m = {
          [P.VAST.GENERAL_ERROR.code]: P.VAST.GENERAL_ERROR,
          [P.VAST.FILE_NOT_FOUND.code]: P.VAST.FILE_NOT_FOUND,
          [P.VAST.UNSUPPORTED_MIMETYPE.code]: P.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = m[u] || P.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(le.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(Fe.ON_LOADED_DATA, () => {
          this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(Fe.ON_ENDED, () => {
          this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, c.debug.error(s + " timeout.", l), this.currentAd.error = P.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(le.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (c.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (c.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Or(this, i), [
        f.ON_AD_STARTED,
        f.ON_AD_IMPRESSION,
        f.ON_AD_CREATIVE_VIEW,
        f.ON_AD_NONLINEAR_STOPPED,
        f.ON_AD_STOPPED
      ].map((l) => {
        const u = this.adSlotController.nonLinearView.addEventListener(
          l,
          (m) => {
            this.dispatchEvent(m.type), m.type === f.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(u);
      }), this.addPlayerEventListener(Fe.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(Fe.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && c.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (c.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = P.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(le.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
ze.NAME = "AdSloDel::";
let Ir = ze;
class Lr {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, u;
    this.adParameters = ((s = (r = $(i, "AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((u = (l = $(i, e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : u.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [];
    const r = Object.values(Ui).join(", ");
    let s = J(e, r);
    for (let l = 0; l < s.length; l++)
      i.push({
        creativeType: s[l].getAttribute("creativeType"),
        resource: me(s[l].textContent || ""),
        type: s[l].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    const s = J(i, e + "ClickTracking");
    for (const l of s)
      r.push({
        url: me(l.textContent),
        id: l.getAttribute("id")
      });
    return r;
  }
}
class Io extends Lr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = me(((s = $(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || Yn(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function Ee(p, e) {
  const i = (p == null ? void 0 : p.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class To extends Lr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = me(((s = $(r, "AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = Ee(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = me(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = yt(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = Ee(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class Ro extends Lr {
  constructor(e, i, r) {
    const s = Ee(r, "expandedHeight"), l = Ee(r, "expandedWidth"), u = Ee(r, "height"), m = r.getAttribute("id"), g = r.getAttribute("maintainAspectRatio") !== "false", S = yt(
      r.getAttribute("minSuggestedDuration")
    ), L = r.getAttribute("scalable") !== "false", ie = Ee(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = u, this.id = m, this.maintainAspectRatio = g, this.minSuggestedDuration = S != null ? S : -1, this.scalable = L, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = ie;
  }
}
var di = ((p) => (p.COMPANION = "companion", p[p.LINEAR = ae.LINEAR] = "LINEAR", p[p.NON_LINEAR = ae.NON_LINEAR] = "NON_LINEAR", p))(di || {});
class No {
  constructor(e) {
    this.adXML = e, this.VASTVersion = this.adXML.parentElement && typeof this.adXML.parentElement.getAttribute == "function" ? parseInt(this.adXML.parentElement.getAttribute("version"), 10) : null, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, u = e.mediaFiles.vpaid, m = [];
    return m = m.concat(
      ...u,
      ...l,
      ...r,
      ...s,
      ...i
    ), m;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  getLinear() {
    let e = $(this.adXML, "InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = $(e, "MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getBaseForVersion(e, i) {
    if (i === null)
      return e;
    const s = {
      2: 3,
      3: 1,
      4: 0
    }[i];
    let l = e;
    for (let u = 0; u < s && l.parentElement; u++)
      l = l.parentElement;
    return l;
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  extractInteractiveCreativeUrl(e) {
    for (const i of e.childNodes)
      if (i.wholeText)
        return i.wholeText.trim();
    return "";
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = J(e, 'MediaFile[apiFramework="VPAID"]'), s = $(e, "AdParameters");
    for (let u = 0; u < r.length; u++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: Ee(r[u], "bitrate"),
        fileURL: me(r[u].textContent),
        height: Ee(r[u], "height"),
        linearity: ae.LINEAR,
        mimeType: r[u].getAttribute("type"),
        width: Ee(r[u], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = J(e, 'MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: Ee(r[s], "bitrate"),
        fileURL: me(r[s].textContent),
        height: Ee(r[s], "height"),
        linearity: ae.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: Ee(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var m;
    const i = [], r = this.getBaseForVersion(e, this.VASTVersion), s = J(r, "InteractiveCreativeFile"), l = $(r, "AdParameters"), u = $(r, "HTMLResource");
    for (let g = 0; g < s.length; g++) {
      let S = "", L = null;
      this.VASTVersion && this.VASTVersion < 4 ? (S = this.extractInteractiveCreativeUrl(s[g]), L = S === "" && u ? u.textContent.trim() : null) : S = s[g].textContent.trim(), i.push({
        adParameters: ((m = l == null ? void 0 : l.textContent) == null ? void 0 : m.trim()) || null,
        apiFramework: s[g].getAttribute("apiFramework"),
        delivery: s[g].getAttribute("delivery"),
        fileURL: S,
        linearity: ae.LINEAR,
        mimeType: s[g].getAttribute("type"),
        resource: L,
        variableDuration: s[g].getAttribute("variableDuration") === "true"
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = $(e, "ClosedCaptionFiles");
    if (r) {
      let s = J(r, "ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: ae.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [], s = J(e, i);
    for (const l of s)
      r.push({
        url: me(l.textContent) || ""
      });
    return r;
  }
  getIndustryIcons() {
    const e = {};
    let i = J(this.adXML, "Creatives > Creative > Linear", "Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), u = new To("Icon", l, i[r]);
      e[s] = u;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  getNonLinear() {
    let e = J(this.adXML, "InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    c.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = J(e, "NonLinear"), r = [{
      type: di.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new Ro(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = J(this.adXML, "Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: di.COMPANION,
        variations: []
      };
      const s = J(e[r], "Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const u = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let m = new Io(
            "Companion",
            u,
            s[l]
          );
          i[r].hasCompanionResources = m.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(m);
        }
    }
    return i.reverse();
  }
  getTrackers(e) {
    const i = {}, r = Array.from(J(this.adXML, "ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], u = l.nodeName === l.nodeName.toUpperCase() ? l.nodeName.toLowerCase() : l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), m = l.getAttribute("event") || u, g = l.getAttribute("offset"), S = {
        offset: "",
        url: me(l.textContent)
      };
      if (m === $t.ON_AD_PROGRESS && g) {
        const L = yt(g);
        S.offset = typeof L == "number" ? L.toString() : g;
      }
      i[m] = i[m] || [], i[m].push(S);
    }
    return i;
  }
}
class Co extends c {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    const e = " > Creatives > Creative";
    let i = [];
    const r = J(this.adXML, "Ad > Wrapper");
    let s = [];
    for (const u of r) {
      let m = J(u, "Wrapper" + e);
      if (m.length > 0)
        for (const g of m)
          s.push(g);
      else
        i.push(u);
    }
    if (s.length > 0)
      for (const u of s)
        i.push(u);
    let l = J(this.adXML, "InLine" + e);
    for (const u of l)
      i.push(u);
    return i;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = J(this.adXML, "Creative");
      for (let u of l)
        e.push(u);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    for (const l of r) {
      const u = l.getAttributeNames().find((m) => m.toLowerCase() === "adid");
      s.push(l.getAttribute(u) || null);
    }
    return s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (lt(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = $(this.adXML, "InLine", "Advertiser");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = J(this.adXML, "AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", u = $(s, "JavaScriptResource"), m = this.getNodeContentsAsText(
        $(s, "VerificationParameters") || document.createElement("div")
      ), g = this.getTrackerNodesAsURLArray(
        $(s, "TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && u) {
        const S = {
          javascriptResource: {
            url: me(this.getNodeContentsAsText(u)),
            apiFramework: u.getAttribute("apiFramework") || "",
            browserOptional: u.getAttribute("browserOptional") === "true" || !1
          },
          tracking: g,
          vendor: l,
          verificationParameters: m
        };
        i.push(S);
      }
    }
    return i.length > 0 ? ao(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = lt(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new No(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = $(this.adXML, "InLine", "Description");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = lt(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = lt(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    if (this.wrappers.length > 0) {
      let s = J(this.adXML, "Ad > Wrapper");
      for (const l of s) {
        const u = l.parentElement.getAttribute("id");
        e.push(u);
      }
    }
    let i = null, r = lt(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    if (this.wrappers.length > 0)
      e = this.getWrapperAndInLineCreative();
    else {
      let l = J(this.adXML, "Creative");
      for (const u of l)
        e.push(u);
    }
    let i = [];
    for (const l of e)
      i.push(this.getNodeDepth(l));
    let r = [];
    const s = this.getElementsSortedByDepth(i);
    for (const l of s)
      r.push(l.getAttribute("id") || null);
    return r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = $(this.adXML, "InLine", "AdServingId");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = $(this.adXML, "InLine", "Pricing") || lt(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = $(this.adXML, "InLine", "Survey");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = $(this.adXML, "InLine", "AdSystem");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = $(this.adXML, "InLine", "AdTitle");
    return me((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML.hasAttribute && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(Ee(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(Ee(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: Ee(this.rawXML, "_loadEnd") - Ee(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = J(this.adXML, "VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(Ee(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(Ee(i[r], "_loadEnd")).toISOString(),
        loadTime: Ee(i[r], "_loadEnd") - Ee(i[r], "_loadStart"),
        url: me(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = J(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = J(this.adXML, ["Creative", "CreativeExtension", "Extension"], "UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = J(this.adXML, "Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || me(e.getAttribute("idValue") || "unknown")
    };
  }
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML);
      for (const r of i) {
        const s = r.nodeName === r.nodeName.toUpperCase() ? r.nodeName.toLowerCase() : r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      }
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} - Tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    if (!e)
      return i;
    for (const r of J(e, "Tracking")) {
      const s = this.getNodeContentsAsText(r);
      if (s.length === 0)
        continue;
      const l = r.getAttribute("event");
      l && (i[l] || (i[l] = []), i[l].push(
        { url: s }
      ));
    }
    return i;
  }
}
class bt extends Co {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = J(this.adXML, "Creative", "Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      lt(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return ue.SPONSORED;
      default:
        return ue.COMMERCIAL;
    }
  }
  parseSkipOffsetToNumber() {
    var i;
    const e = yt(
      ((i = $(this.adXML, "InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  getVariant(e) {
    if (e === null)
      return ue.COMMERCIAL;
    let i = ue.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  getDuration() {
    var i, r;
    const e = ((r = (i = lt(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || bt.FALLBACK_LINEAR_DURATION;
    return yt(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  getError() {
    function e(r) {
      if (r.parentNode)
        return $(r.parentNode, ":scope > parsererror");
    }
    const i = $(this.adXML, "parsererror") || e(this.adXML);
    return i ? {
      code: Ee(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  flagCappedAds() {
    return $(this.adXML, "InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: P.WRAPPER.NO_RESPONSE.code,
      message: P.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = lt(this.adXML, e);
    return me((i == null ? void 0 : i.textContent) || "");
  }
}
bt.FALLBACK_LINEAR_DURATION = "00:00:20";
class _o {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  handleXMLDoc(e) {
    let i = $(e, "parsererror"), r = J(e, ":root > *"), s;
    if (!($(e, "html") && i)) {
      if ($(e, "html")) {
        s = document.createElement("VAST");
        const l = new bt(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new bt(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const u = new bt(r[l], e);
        this.adList.push(u);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function Do(p, e) {
  const i = Object.values(li);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let u = i;
  return e && e.length > 0 && (r = e, u = e), u.filter((g) => !("canPlayType" in s) || g === "application/javascript" || s.canPlayType(g) !== "" || l.canPlayType(g) !== "" ? r.push(g) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = u), p.filter((g) => r.find((S) => g.mimeType === S));
}
class Fi {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === ae.NON_LINEAR ? Mo.select(r, i) : Lo.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class Lo {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((m) => {
        var g;
        !s.selectedCreativeFile && m.apiFramework && (m.isSIMID = (m.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = m.isSIMID ? m : null), (g = s.selectedCreativeFile) != null && g.isSIMID && (m.isSIMID = !0), m.isVPAID = (m.apiFramework + "").toUpperCase() === "VPAID";
      }), l = Fi.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let u = Do(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        u,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  static selectMediaFile(e, i, r) {
    let s = e.filter((m) => m.isSIMID), l = e.filter((m) => m.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let u = [];
    for (let m = 0; m < r.length; ) {
      if (m > 0 && u.length > 0) {
        e = u;
        break;
      }
      e.filter((g) => {
        g.mimeType === r[m] && u.push(g);
      }), m++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, u) => u.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class Mo {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((u) => {
        u.selectedResource = null, (u.apiFramework + "").toUpperCase() === "VPAID" && (u.isVPAID = !0, u.resources = u.resources.filter((m) => Fi.isFriendlyVendorHost(
          m.resource,
          i.desiredVPAIDVendors
        )));
      });
      for (const u of l)
        u.resources.length <= 0 ? u.hasCreative = !1 : u.selectedResource = u.resources[0];
      s.variations = l.filter((u) => !!u.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
function Tr(p) {
  let e = 0, i = 0, r = 0;
  const s = p.length;
  for (let l = 0; l < p.length; l++) {
    let u = p[l];
    u.variant === ue.COMMERCIAL ? (u.currentCommercial = i += 1, (u.fallbackOnNoAd || !u.fallbackOnNoAd) && u.hasError && (e += 1), u.currentPodSequencing = i - e) : (u.fallbackOnNoAd || !u.fallbackOnNoAd) && u.hasError && (r += 1), u.variant !== ue.COMMERCIAL && (u.currentCommercial = -1), u.sequence = l + 1, u.currentClip = l + 1;
  }
  return {
    totalClips: s,
    totalPlayableClips: s - e - r,
    totalCommercials: i,
    totalPlayableCommercials: i - e
  };
}
const Hn = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function bo(p, e, i, r) {
  let s = p;
  const l = i, u = r, m = e, g = {
    DIVIDER: ue.DIVIDER,
    CLOSER: ue.CLOSER,
    OPENER: ue.OPENER
  };
  function S(Q) {
    let Se = [], K = {
      adParameters: null,
      creativeTrackers: {},
      duration: bt.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: ae.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let G in Q)
      if (Object.prototype.hasOwnProperty.call(Q, G) && Object.prototype.hasOwnProperty.call(Hn, G.toUpperCase())) {
        let O = Q[G];
        if (typeof O == "string" && O.length > 0) {
          let I = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: O,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Hn[G.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          K.mediaFiles.push(I);
        }
      }
    return K.supportedMediaFiles = K.mediaFiles, Se.push(K), Se;
  }
  function L() {
    Object.keys(g).forEach((Q) => {
      if (l && Object.prototype.hasOwnProperty.call(l, g[Q])) {
        const Se = l[g[Q]];
        if (!m && !Se.forcePlay)
          return;
        let K = {};
        K.adTrackers = [], K.creatives = S(Se), K.extensions = [], K.id = K.adId = g[Q], K.isLinear = !0, K.variant = g[Q], K.properCreative = K.creatives[0], K.properCreative.selectedMediaFile = K.properCreative.supportedMediaFiles[0], K.config = u, K.enrichment = new St(), K.adReinsertion = new le(u.adReinsertion, K.enrichment), K.expectedAdType = l.type, K.isPaused = !0;
        let G = [];
        switch (g[Q]) {
          case g.DIVIDER:
            for (let O = 0; O < s.length; O++)
              O > 0 && s[O].variant !== s[O - 1].variant && G.push({
                offset: O,
                ad: K
              });
            if (l[g[Q]].forcePlay && G.length === 0) {
              s[0].variant === ue.SPONSORED ? s.unshift(K) : s.push(K);
              break;
            }
            for (let O = 0; O < G.length; O++) {
              const I = G[O].offset + O;
              s.splice(I, 0, G[O].ad);
            }
            break;
          case g.CLOSER:
            s.push(K);
            break;
          case g.OPENER:
            s.unshift(K);
            break;
        }
      }
    });
  }
  L();
  let ie = Tr(s);
  return { enrichedManifest: s, sequenceData: ie };
}
function $n(p) {
  let e = p;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    for (let l of s)
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
  }
  return e;
}
class Po {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), $n(this.adSlotModelList), this.adSlotBuffetList = $n(this.adSlotBuffetList), c.debug.info(this.NAME + "adPod", this.adSlotModelList), c.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  decorateAdList() {
    for (let e = 0; e < this.adList.length; e++) {
      let i = this.adList[e];
      if (i.adBreakPosition = this.adBreak.adBreakPosition, i.config = this.config, i.enrichment = new St(), i.enrichment.setFromObject(i.publisherMacros), i.expectedAdType = this.adBreak.type, i.publisherMacros = this.environmentVars.vastMacros, i.adReinsertion = new le(i.config.adReinsertion, i.enrichment), i.isPaused = !0, !i.hasError) {
        if (i.creatives.length < 1) {
          i.error = {}, i.error = P.WRAPPER.NO_RESPONSE;
          continue;
        }
        if (i.expectedAdType === ae.LINEAR && i.creativeClass.linearAsArray[0].mediaFiles.length === 0 || i.expectedAdType === ae.NON_LINEAR && i.creativeClass.nonLinear.length === 0) {
          i.error = {}, i.error = P.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          continue;
        }
        i.expectedAdType === ae.LINEAR ? (i.properCreative = Fi.getProperCreative(
          i.creativeClass.linearAsArray,
          this.environmentVars
        ), i.properCreative && (i.closedCaptions = i.properCreative.captions, i.icons = i.properCreative.icons)) : i.properCreative = Fi.getProperCreative(
          i.creativeClass.nonLinear,
          this.environmentVars
        ), i.properCreative || (i.error = {}, i.error = P.VAST.UNSUPPORTED_MIMETYPE);
      }
    }
  }
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.sequenceInfo = Tr(this.adSlotModelList), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = [], this.sequenceInfo = Tr(this.adSlotModelList));
  }
  extendWithSeparationClips() {
    if (this.adBreak.type !== ae.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = bo(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && $(e.adXML, `ParserError[code="${P.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
const Pr = class Pr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = J(this.XMLDoc, "VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((u) => {
          e(u);
        });
      }
    }
  }
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, u) => {
      let m = $(r, "VASTAdTagURI");
      if (m.setAttribute("_loadStart", Date.now().toString()), m.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return qe(r, P.WRAPPER.CHAIN_TIMEOUT), u(), e;
      if (i >= this.maxWrapperDepth)
        return qe(
          r,
          P.WRAPPER.LIMIT_REACHED
        ), u(), e;
      if (this.isInsecureURL(e))
        return qe(r, P.SESSION.MIXED_CONTENT), u(), e;
      if (this.hasSessionTimeoutError)
        return u(), e;
      let g, S;
      this.loadURL(e, !0).then((L) => {
        let ie = $(L, "VASTAdTagURI");
        g = ((ie || {}).textContent || "").trim(), g && (S = ie.parentNode), this.addContentToWrapperNode(r, L), m.setAttribute("_loadEnd", Date.now().toString()), l([g, S]);
      });
    }).then((l) => {
      let [u, m] = l;
      return u ? this.walkDownAdWrappers(u, i + 1, m, s) : e;
    });
  }
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, new Promise((r) => {
      new Dr().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let u = l || document.createDocumentFragment(), m = $(u, "Ad") || u.documentElement || u;
          this.hasSessionTimeoutError = !0, qe(m, P.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: le.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(u);
        }
        if (!s && l && $(l, "parsererror")) {
          let u = document.createDocumentFragment();
          qe(u, P.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: le.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(u);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const u = $(l, "VAST");
          if (u && J(u, ":scope > *").length === 0) {
            let m = document.createDocumentFragment();
            qe(m, P.WRAPPER.NO_RESPONSE), r(m);
          }
        }
        if (s && !l) {
          let u = document.createDocumentFragment();
          c.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), qe(u, s), r(u);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  isInsecureURL(e) {
    return this.blockInsecureURL && !Gn(e);
  }
  /* c8 ignore stop */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = $(r, "VAST");
      s && s.setAttribute(e, i);
    }
  }
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
Pr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Rr = Pr;
class wo {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(u, m) {
      const g = e[u];
      return !g || g.length <= 0 ? (c.debug.info(m), []) : g;
    }
    const r = (u, m) => {
      const g = e.creatives;
      if (g && g.length !== 0) {
        const S = g.find(
          (L) => L.type === u
        );
        if (S && S.variations && S.variations.length > 0)
          return S.variations;
      }
      return c.debug.info(m), [];
    };
    function s(u) {
      return u.charAt(0).toUpperCase() + u.slice(1);
    }
    const l = (u) => {
      var g, S;
      if (e.isLinear) {
        const L = e.properCreative && e.properCreative.selectedMediaFile;
        return L ? L[u] : -1;
      }
      const m = (S = (g = e.creativesArray) == null ? void 0 : g.nonLinearCreative[0]) == null ? void 0 : S.variations[0];
      if (m && e.isExpanded) {
        const L = `expanded${s(u)}`;
        return m[L] === -1 ? m[u] : m[L];
      }
      return m ? m[u] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(di.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function u(g, S) {
          return S === 0 || !g.parentElement ? g : u(g.parentElement, S - 1);
        }
        function m(g) {
          const S = u(g, 3), L = S.getAttributeNames().find((ie) => ie.toLowerCase() === "adid");
          return {
            adId: S.getAttribute(L) || null,
            id: S.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let g = null;
          if (e.isSIMID ? g = "InteractiveCreativeFile" : e.isVPAID ? g = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (g = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), g) {
            const S = $(e.adXML, g);
            return m(S);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const g = e.properCreative.variations[0].selectedResource.type, S = e.properCreative.variations[0].selectedResource.creativeType, L = g !== Ui.IFRAME ? $(e.adXML, `${g}[creativeType="${S}"]`) : $(e.adXML, g);
          return m(L);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var u;
        return !e.isLinear && ((u = e.creativesArray) != null && u.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (c.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== Ui.IFRAME;
        } catch (u) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (c.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const u = e.properCreative;
        return u && u.length !== 0 ? u : (c.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(di.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var u;
        return !e.isLinear && ((u = e.creativesArray) != null && u.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(u) {
        e.volume = u;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Vo {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class Jn {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", c.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, c.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class xo extends Jn {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class ko extends Jn {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class Uo {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      c.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new ko(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new xo(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : c.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    c.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Mr(p) {
  if (typeof p != "object" || p === null)
    return p;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(p)) {
    const r = p[i];
    Kn(r) || (e[i] = Mr(p[i]));
  }
  return e;
}
function Fo(p) {
  const e = document.implementation.createDocument(null, "VAST", null);
  e.documentElement.setAttribute("version", "3.0");
  for (const i of p) {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }
  return e;
}
function jo(p) {
  let e = p;
  if (e.originConfig = Mr(p), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = Fo(e.urls)), e.requested = !1, e;
}
const Wn = "AdBreakValidation";
function Bo(p) {
  var s, l;
  if (!p || typeof p != "object" || Array.isArray(p) || Object.keys(p).length === 0)
    return c.debug.warn(Wn + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof p.tag == "string" || Array.isArray(p.tag)) && p.tag.length > 0, i = ((l = (s = p.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = p[ue.CLOSER] || p[ue.DIVIDER] || p[ue.OPENER];
  return !e && !i && !r ? (c.debug.warn(Wn + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function Ho(p, e, i, r, s) {
  var l = l || {};
  (function(u) {
    var m = {
      globalConfig: p,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function g(O) {
        O = [typeof globalThis == "object" && globalThis, O, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
        for (var I = 0; I < O.length; ++I) {
          var w = O[I];
          if (w && w.Math == Math) return w;
        }
        throw Error("Cannot find global object");
      }
      var S = g(this);
      function L(O) {
        var I = 0;
        return function() {
          return I < O.length ? { done: !1, value: O[I++] } : { done: !0 };
        };
      }
      var ie = typeof Object.defineProperties == "function" ? Object.defineProperty : function(O, I, w) {
        return O == Array.prototype || O == Object.prototype || (O[I] = w.value), O;
      };
      function Q(O, I) {
        if (I) e: {
          var w = S;
          O = O.split(".");
          for (var W = 0; W < O.length - 1; W++) {
            var X = O[W];
            if (!(X in w)) break e;
            w = w[X];
          }
          O = O[O.length - 1], W = w[O], I = I(W), I != W && I != null && ie(w, O, { configurable: !0, writable: !0, value: I });
        }
      }
      Q("Symbol", function(O) {
        function I(X) {
          if (this instanceof I) throw new TypeError("Symbol is not a constructor");
          return new w("jscomp_symbol_" + (X || "") + "_" + W++, X);
        }
        function w(X, z) {
          this.j = X, ie(this, "description", { configurable: !0, writable: !0, value: z });
        }
        if (O) return O;
        w.prototype.toString = function() {
          return this.j;
        };
        var W = 0;
        return I;
      }), Q("Symbol.iterator", function(O) {
        if (O) return O;
        O = Symbol("Symbol.iterator");
        for (var I = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), w = 0; w < I.length; w++) {
          var W = S[I[w]];
          typeof W == "function" && typeof W.prototype[O] != "function" && ie(W.prototype, O, { configurable: !0, writable: !0, value: function() {
            return Se(L(this));
          } });
        }
        return O;
      });
      function Se(O) {
        return O = { next: O }, O[Symbol.iterator] = function() {
          return this;
        }, O;
      }
      function K(O) {
        var I = typeof Symbol != "undefined" && Symbol.iterator && O[Symbol.iterator];
        return I ? I.call(O) : { next: L(O) };
      }
      function G(O, I) {
        return Object.prototype.hasOwnProperty.call(O, I);
      }
      Q("WeakMap", function(O) {
        function I(R) {
          if (this.h = (D += Math.random() + 1).toString(), R) {
            R = K(R);
            for (var b; !(b = R.next()).done; ) b = b.value, this.set(b[0], b[1]);
          }
        }
        function w() {
        }
        function W(R) {
          var b = typeof R;
          return b === "object" && R !== null || b === "function";
        }
        function X(R) {
          if (!G(R, F)) {
            var b = new w();
            ie(R, F, { value: b });
          }
        }
        function z(R) {
          var b = Object[R];
          b && (Object[R] = function(j) {
            return j instanceof w ? j : (Object.isExtensible(j) && X(j), b(j));
          });
        }
        if (function() {
          if (!O || !Object.seal) return !1;
          try {
            var R = Object.seal({}), b = Object.seal({}), j = new O([[R, 2], [b, 3]]);
            return j.get(R) != 2 || j.get(b) != 3 ? !1 : (j.delete(R), j.set(b, 4), !j.has(R) && j.get(b) == 4);
          } catch (ee) {
            return !1;
          }
        }()) return O;
        var F = "$jscomp_hidden_" + Math.random();
        z("freeze"), z("preventExtensions"), z("seal");
        var D = 0;
        return I.prototype.set = function(R, b) {
          if (!W(R)) throw Error("Invalid WeakMap key");
          if (X(R), !G(R, F)) throw Error("WeakMap key fail: " + R);
          return R[F][this.h] = b, this;
        }, I.prototype.get = function(R) {
          return W(R) && G(R, F) ? R[F][this.h] : void 0;
        }, I.prototype.has = function(R) {
          return W(R) && G(
            R,
            F
          ) && G(R[F], this.h);
        }, I.prototype.delete = function(R) {
          return W(R) && G(R, F) && G(R[F], this.h) ? delete R[F][this.h] : !1;
        }, I;
      }), Q("Map", function(O) {
        function I() {
          var D = {};
          return D.c = D.next = D.head = D;
        }
        function w(D, R) {
          var b = D.b;
          return Se(function() {
            if (b) {
              for (; b.head != D.b; ) b = b.c;
              for (; b.next != b.head; ) return b = b.next, { done: !1, value: R(b) };
              b = null;
            }
            return { done: !0, value: void 0 };
          });
        }
        function W(D, R) {
          var b = R && typeof R;
          b == "object" || b == "function" ? z.has(R) ? b = z.get(R) : (b = "" + ++F, z.set(R, b)) : b = "p_" + R;
          var j = D.g[b];
          if (j && G(D.g, b)) for (D = 0; D < j.length; D++) {
            var ee = j[D];
            if (R !== R && ee.key !== ee.key || R === ee.key) return { id: b, list: j, index: D, a: ee };
          }
          return {
            id: b,
            list: j,
            index: -1,
            a: void 0
          };
        }
        function X(D) {
          if (this.g = {}, this.b = I(), this.size = 0, D) {
            D = K(D);
            for (var R; !(R = D.next()).done; ) R = R.value, this.set(R[0], R[1]);
          }
        }
        if (function() {
          if (!O || typeof O != "function" || !O.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var D = Object.seal({ x: 4 }), R = new O(K([[D, "s"]]));
            if (R.get(D) != "s" || R.size != 1 || R.get({ x: 4 }) || R.set({ x: 4 }, "t") != R || R.size != 2) return !1;
            var b = R.entries(), j = b.next();
            return j.done || j.value[0] != D || j.value[1] != "s" ? !1 : (j = b.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !b.next().done));
          } catch (ee) {
            return !1;
          }
        }()) return O;
        var z = /* @__PURE__ */ new WeakMap();
        X.prototype.set = function(D, R) {
          D = D === 0 ? 0 : D;
          var b = W(this, D);
          return b.list || (b.list = this.g[b.id] = []), b.a ? b.a.value = R : (b.a = { next: this.b, c: this.b.c, head: this.b, key: D, value: R }, b.list.push(b.a), this.b.c.next = b.a, this.b.c = b.a, this.size++), this;
        }, X.prototype.delete = function(D) {
          return D = W(this, D), D.a && D.list ? (D.list.splice(D.index, 1), D.list.length || delete this.g[D.id], D.a.c.next = D.a.next, D.a.next.c = D.a.c, D.a.head = null, this.size--, !0) : !1;
        }, X.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = I(), this.size = 0;
        }, X.prototype.has = function(D) {
          return !!W(this, D).a;
        }, X.prototype.get = function(D) {
          return (D = W(this, D).a) && D.value;
        }, X.prototype.entries = function() {
          return w(this, function(D) {
            return [D.key, D.value];
          });
        }, X.prototype.keys = function() {
          return w(this, function(D) {
            return D.key;
          });
        }, X.prototype.values = function() {
          return w(this, function(D) {
            return D.value;
          });
        }, X.prototype.forEach = function(D, R) {
          for (var b = this.entries(), j; !(j = b.next()).done; ) j = j.value, D.call(R, j[1], j[0], this);
        }, X.prototype[Symbol.iterator] = X.prototype.entries;
        var F = 0;
        return X;
      }), Q("Object.is", function(O) {
        return O || function(I, w) {
          return I === w ? I !== 0 || 1 / I === 1 / w : I !== I && w !== w;
        };
      }), Q("Array.prototype.includes", function(O) {
        return O || function(I, w) {
          var W = this;
          W instanceof String && (W = String(W));
          var X = W.length;
          for (w = w || 0, 0 > w && (w = Math.max(w + X, 0)); w < X; w++) {
            var z = W[w];
            if (z === I || Object.is(z, I)) return !0;
          }
          return !1;
        };
      }), Q("String.prototype.includes", function(O) {
        return O || function(I, w) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (I instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(I, w || 0) !== -1;
        };
      }), Q("Array.from", function(O) {
        return O || function(I, w, W) {
          w = w != null ? w : function(D) {
            return D;
          };
          var X = [], z = typeof Symbol != "undefined" && Symbol.iterator && I[Symbol.iterator];
          if (typeof z == "function") {
            I = z.call(I);
            for (var F = 0; !(z = I.next()).done; ) X.push(w.call(W, z.value, F++));
          } else for (z = I.length, F = 0; F < z; F++) X.push(w.call(W, I[F], F));
          return X;
        };
      }), function() {
        function O() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function I() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function w(F) {
          return F == "True" || F == "true" || F == 1 || F == "1" || F == 1;
        }
        function W() {
          var F = function() {
            var j = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), ee = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Ne = j.slice(0, j.length / 2).split("").reverse().join("");
            return j = j.slice(j.length / 2).split("").reverse().join(""), ee + Ne + ee + j + ee;
          }(), D = function(j) {
            var ee = 0, Ne;
            if (j.length == 0) return ee;
            var Ce = 0;
            for (Ne = j.length; Ce < Ne; Ce++) ee = (ee << 5) - ee + j.charCodeAt(Ce), ee |= 0;
            return Math.abs(ee);
          }(F).toString();
          D = (D + D.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), F = btoa(F).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var R = "", b = 0; b < D.length; b++) R += F.charAt(D[b]);
          return R || "zork";
        }
        function X(F, D) {
          return F = Math.round(Math.abs(F)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, F);
        }
        O.prototype.getItem = function(F) {
          return this.i[F] || this.client[F] || this.f[F];
        }, O.prototype.l = function(F) {
          this.f = F.embed, this.global = F.global, this.client = F.client, this.i = F.customer;
        };
        var z = null;
        z = new O(), function(F) {
          function D(V, B, q) {
            var he = { homad_url_prefix_alias: "", homad_track_key: "*" + encodeURIComponent(V) + "*", homad_track_value: "*" + encodeURIComponent(B.toString()) + "*" }, ne = q ? null : function() {
              D(V, B, !0);
            };
            q = q ? R(!0) : b(), je(q, null, ne, he);
          }
          function R(V) {
            return V = V ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + V.slice(V.length - 2).join(".") + "/[hash]/").replace("[hash]", I(X()));
          }
          function b() {
            if (Oe && Oe.server) {
              var V = Oe.server[Math.floor(Math.random() * Oe.server.length)] + "";
              return V.replace("[hash]", I(X()));
            }
            return R(!1);
          }
          function j() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(B) {
              try {
                B.pause();
              } catch (q) {
              }
              B.parentNode.removeChild(B);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(B) {
              B.parentNode.removeChild(B);
            }), window.self != window.top) for (var V = window.document; V.hasChildNodes(); ) V.removeChild(V.lastChild);
            He.get("setTimeout")(j, Math.round(1e3 + 100 * Math.random()));
          }
          function ee(V) {
            return Be && clearTimeout(Be), D("stats_embed_penalty", V), j(), !1;
          }
          function Ne() {
            Ve && Ve.enabled === !1 || Oe && Oe.enabled === !1 || _e && _e.enabled === !1 ? clearTimeout(Be) : ee("load_main");
          }
          function Ce() {
            je(_e.src.toString(), function(V) {
              _e.src.toString() === V.responseURL ? (V = Qe(V.responseText), _e.data = V, _e.enabled = w(V.enabled), Ne()) : ee("redirect_customer");
            }, function() {
              _e.data = {}, _e.enabled = void 0, Ne();
            });
          }
          function ut() {
            var V = Oe.src;
            typeof V == "string" ? je(V.toString(), function(B) {
              V.toString() === B.responseURL ? (B = Qe(B.responseText), Oe.data = B, Oe.enabled = w(B.enabled), _e.src = B.config, Ce()) : ee("redirect_client");
            }, function() {
              Oe.data = {}, Oe.enabled = void 0, Ce();
            }) : (Oe.data = typeof V == "function" ? V() : V, Ce());
          }
          function Pt() {
            je(Ve.src.toString(), function(V) {
              Ve.src.toString() === V.responseURL ? (V = Qe(V.responseText), Ve.data = V, Ve.enabled = w(V.enabled), ut()) : ee("redirect_global");
            }, function() {
              Ve.data = {}, Ve.enabled = void 0, ut();
            });
          }
          function Ye(V) {
            clearTimeout(Be);
            var B = new V();
            B.init(z.f.globalConfig, z.f.clientConfig, !0, function() {
              z.f.utilsReady(B);
            }, function() {
              ee("utils_init");
            }, z.f);
          }
          function nt(V) {
            var B = ct.shift();
            B ? !window[W()] || V ? It(B) : V || clearTimeout(Be) : Pt();
          }
          function je(V, B, q, he) {
            he = he === void 0 ? null : he;
            var ne = new XMLHttpRequest();
            if (ne.onreadystatechange = function() {
              B && ne.readyState == 4 && ne.status == 200 && B(ne), q && ne.readyState == 4 && ne.status != 200 && q(ne);
            }, he) {
              var pt = "", Tt;
              for (Tt in he) pt += "&" + Tt + "=" + encodeURIComponent(he[Tt]);
              pt = pt.substr(1), ne.open("POST", V, !0), ne.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), ne.send(pt);
            } else ne.open("GET", V, !0), ne.send();
          }
          function It(V) {
            var B = document.createElement.toString().includes("native code") ? document.createElement("script") : He.get("createElement")("script"), q;
            if (B.setAttribute("data-info", st), B.src = V, B.onload = function(ne) {
              ne.currentTarget.getAttribute("id") === W() ? ht() ? (ne = q[st.split("").reverse().join("")], Ye(ne)) : clearTimeout(Be) : ct.length ? nt(!0) : ee("main_redirect");
            }, B.onerror = function() {
              nt(!0);
            }, window[W()] || (window[W()] = X(5 + Math.round(5 * Math.random()))), ht()) {
              var he = document.createElement.toString().includes("native code") ? document.createElement("iframe") : He.get("createElement")("iframe");
              if (!he || he.nodeName.toLowerCase() !== "iframe" || !he.nodeType) return ee("utils_iframe");
              he.style.display = "none", he.onload = function() {
                if (q = he.contentWindow, q[st] = F, he.contentWindow.document.body.appendChild(B) !== B) return ee("utils_script");
              }, document.body.appendChild(he);
            } else document.head.appendChild(B);
          }
          function Qe(V) {
            var B = He.get("JSON");
            try {
              var q = B.parse(V);
            } catch (he) {
              q = {};
            }
            return q;
          }
          function ht() {
            return z.f.utilsReady != null;
          }
          var st = X(10 + Math.round(10 * Math.random()));
          window[st] = F, z = new O(), z.l({ embed: F }), z.f.version = "20230601_1407";
          var Be = 0, wt = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], ge = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], ct = ht() ? ge : wt, Ve = { src: F.globalConfig, enabled: void 0, data: null }, Oe = { src: F.clientConfig, enabled: void 0, data: null }, _e = { src: null, enabled: void 0, data: null }, He = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var V = document.createElement("iframe");
              V.style.display = "none", document.body.appendChild(V);
              var B = V.contentWindow;
            } else document.head ? (V = document.createElement("iframe"), V.style.display = "none", document.head.appendChild(V), B = V.contentWindow) : B = window;
            He.set("JSON", B.JSON), He.set("createElement", B.document.createElement.bind(document)), He.set("setTimeout", B.setTimeout.bind(window)), V && V.parentNode && V.parentNode.removeChild(V);
          })(), function() {
            Be = He.get("setTimeout")(function() {
              ee("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), nt();
        }(m);
      }();
    })();
  }).bind(l)(l);
}
let Le = null, be = null;
const oe = class oe extends Ot {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: ae.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = Le = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : dt, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = le.EventDispatcher.addEventListener(
      f.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = Le.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  initializeHOMAD(e) {
    const i = new St();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(li)), be = new le(this.config.adReinsertion, i);
    let r = (l) => {
      c.debug.info(oe.NAME + "initializeHOMAD - Utils ready.", l), c.debug.info(oe.NAME + "initializeHOMAD - Set vendor API.", l), be.setVendorAPI(l), be.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), be.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      c.debug.warn(oe.NAME + "initializeHOMAD Penalty"), r = () => {
      }, be.vendorAPI ? (c.debug.warn("initializeHOMAD - Penalty during ad playback."), tt.call(this, P.SESSION.AD_REINSERTION_PENALTY)) : (c.debug.warn("initializeHOMAD - Error.", l), tt.call(this, P.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(f.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      Ho(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (u) => {
          r(u);
        },
        (u) => {
          s(u);
        }
      );
    }
  }
  forceHOMADActivation() {
    this.error && this.error.code === P.SETUP.AD_REINSERTION_PENALTY.code || (be.setReinsertionReason({
      reason: le.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), be.enable(
      () => {
        c.debug.info(
          oe.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        c.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (tt.call(this, P.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Bo(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = qt(Le.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, c.debug.info(oe.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = ae.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === ae.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === ae.NON_LINEAR && !this.environmentVars.adContainer && c.debug.warn(oe.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => (c.debug.info(oe.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(f.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const u = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        c.debug.info(
          oe.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), tt.call(this, P.SESSION.TIMEOUT), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
      }, u * 1e3), this.parse(this.adBreak);
    })) : (tt.call(this, P.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, u) => {
      if (!Le.adReinsertion.homad.utils)
        throw c.debug.info(r + s), new Error(r + s);
      Le.adReinsertion.homad.utils.corroborate(i).then(() => {
        c.debug.info(r + "resolved."), l();
      }).catch((m) => {
        c.debug.info(r + "rejected.", m), u(m);
      });
    });
  }
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!Le.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = Le.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, u = setTimeout(() => (l = !0, i()), le.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), m = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(u), c.debug.info(m + "approved."), !l)
            return i();
        }, (g) => {
          if (clearTimeout(u), c.debug.warn(m + "declined.", typeof g), g && g.stack && g.message)
            return be.disable(), i();
          if (!l)
            return be.disable(), r();
        });
      } catch (g) {
        return clearTimeout(u), c.debug.warn(m + "failed. Error in activationCallback:", g), l = !0, be.disable(), i();
      }
    });
  }
  setupEnrichmentAndTCF() {
    const e = new St();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(li)), this.environmentVars.vastMacros.GDPRCONSENT || new Uo(e), e;
  }
  restartAdSlot() {
    c.debug.info(oe.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), Le.urlhandler = ki, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : c.debug.warn(oe.NAME + "What to do next?");
    }).catch((e) => {
      c.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  parse(e) {
    const i = jo(e);
    c.debug.info(oe.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    be = new le(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(Le.timeouts));
    const l = {
      adReinsertion: be,
      blockInsecureURL: Le.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: Le.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: Le.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: qt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let u = null, m = this.adBreak;
    if (typeof i == "object" && (m = i), m.urls.length === 1 && (u = m.urls[0], l.response = null), u || l.response) {
      let g = new Rr(l);
      u ? g.requestURL(m.urls[0], this.onXMLLoadDone.bind(this, l)) : g.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      c.debug.warn(
        oe.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new _o(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let m = ai;
      r.adReinsertion = new le(m.adReinsertion, new St()), r.timeouts = m.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new Po(
      e,
      Le,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, u = () => {
      if (!s.hasValidAds || l) {
        tt.call(this, l ? P.SESSION.TIMEOUT : P.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new Sr(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(f.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      c.debug.info(
        oe.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (m) => {
          c.debug.info(
            oe.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            m
          ), u();
        }
      );
      return;
    }
    u();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      c.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      c.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      c.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === ae.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(f.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(f.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = Ir;
      this.slot = new i(this.currentAd, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(f.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      for (const s of Object.values(f))
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      this.slot.deliverNextAd();
    };
    this.adBreak.type === ae.LINEAR ? (c.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      c.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      c.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  resetErrorWarning() {
    const e = [
      P.WARNING.TRACKER_LOAD_FAILED.code,
      P.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === ae.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(oe.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(f.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        c.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  resetContent() {
    c.debug.info(oe.NAME + "Reset content.");
    let e = {
      code: P.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, c.debug.error(oe.NAME + "resetContent - timeout"), tt.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), c.debug.info(oe.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (u) => {
      i || (clearTimeout(l), c.debug.error(
        oe.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        u
      ), e.message = "SessionError: Reset content failed.", tt.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  closeAdSlot() {
    be && Le.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (be.disable(), Le.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(oe.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string|void} The landing page URL.
   */
  clickThrough(e = !1) {
    if (!this.slot)
      return;
    if (this.ad.hasClickThrough)
      return this.slot.adSlotController.onClickThrough(e);
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(f.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {string} reason The reason code corresponding to the cause of the failure.
   */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(f.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (c.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(f.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (c.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const u = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, u);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot && this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot && this.slot.play();
  }
  dispatchEvent(e) {
    return c.debug.info(oe.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI|null} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new wo(this.adSlotController.currentAd) : (c.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot|null} Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Vo(this.adSlotController, this.sequenceData) : (c.debug.warn("There is no loaded ad."), null);
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return zn.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
oe.NAME = "AdSAPI::", oe.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Nr = oe;
const Xt = class Xt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (c.debug.info(Xt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Nr(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (c.debug.info(Xt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (c.debug.info(Xt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new mr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Xt.NAME = "MainCtlr::";
let Cr = Xt;
var Zn = /* @__PURE__ */ ((p) => (p.XHR = "xhr", p.JSONP = "jsonp", p))(Zn || {});
function $o() {
  var p = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? { done: !1, value: t[n++] } : { done: !0 };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return { next: r(t) };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var u = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, m = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function g(t) {
      t = [typeof globalThis == "object" && globalThis, t, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var S = g(this);
    function L(t, n) {
      if (n) e: {
        var o = S;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var A = t[d];
          if (!(A in o)) break e;
          o = o[A];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && m(o, t, { configurable: !0, writable: !0, value: n });
      }
    }
    var ie;
    if (typeof Object.setPrototypeOf == "function") ie = Object.setPrototypeOf;
    else {
      var Q;
      e: {
        var Se = { a: !0 }, K = {};
        try {
          K.__proto__ = Se, Q = K.a;
          break e;
        } catch (t) {
        }
        Q = !1;
      }
      ie = Q ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var G = ie;
    function O(t, n) {
      if (t.prototype = u(n.prototype), t.prototype.constructor = t, G) G(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.wa = n.prototype;
    }
    function I() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function w(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var W = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var A in d) w(d, A) && (t[A] = d[A]);
      }
      return t;
    };
    L("Object.assign", function(t) {
      return t || W;
    }), L("Symbol", function(t) {
      function n(v) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (v || "") + "_" + A++, v);
      }
      function o(v, N) {
        this.g = v, m(this, "description", { configurable: !0, writable: !0, value: N });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", A = 0;
      return n;
    }), L("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = S[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && m(d.prototype, t, { configurable: !0, writable: !0, value: function() {
          return X(r(this));
        } });
      }
      return t;
    });
    function X(t) {
      return t = { next: t }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    L("WeakMap", function(t) {
      function n(C) {
        if (this.g = (T += Math.random() + 1).toString(), C) {
          C = s(C);
          for (var x; !(x = C.next()).done; ) x = x.value, this.set(x[0], x[1]);
        }
      }
      function o() {
      }
      function d(C) {
        var x = typeof C;
        return x === "object" && C !== null || x === "function";
      }
      function A(C) {
        if (!w(C, N)) {
          var x = new o();
          m(C, N, { value: x });
        }
      }
      function v(C) {
        var x = Object[C];
        x && (Object[C] = function(H) {
          return H instanceof o ? H : (Object.isExtensible(H) && A(H), x(H));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var C = Object.seal({}), x = Object.seal({}), H = new t([[C, 2], [x, 3]]);
          return H.get(C) != 2 || H.get(x) != 3 ? !1 : (H.delete(C), H.set(x, 4), !H.has(C) && H.get(x) == 4);
        } catch (Ae) {
          return !1;
        }
      }()) return t;
      var N = "$jscomp_hidden_" + Math.random();
      v("freeze"), v("preventExtensions"), v("seal");
      var T = 0;
      return n.prototype.set = function(C, x) {
        if (!d(C)) throw Error("Invalid WeakMap key");
        if (A(C), !w(C, N)) throw Error("WeakMap key fail: " + C);
        return C[N][this.g] = x, this;
      }, n.prototype.get = function(C) {
        return d(C) && w(C, N) ? C[N][this.g] : void 0;
      }, n.prototype.has = function(C) {
        return d(C) && w(
          C,
          N
        ) && w(C[N], this.g);
      }, n.prototype.delete = function(C) {
        return d(C) && w(C, N) && w(C[N], this.g) ? delete C[N][this.g] : !1;
      }, n;
    }), L("Map", function(t) {
      function n() {
        var T = {};
        return T.L = T.next = T.head = T;
      }
      function o(T, C) {
        var x = T.g;
        return X(function() {
          if (x) {
            for (; x.head != T.g; ) x = x.L;
            for (; x.next != x.head; ) return x = x.next, { done: !1, value: C(x) };
            x = null;
          }
          return { done: !0, value: void 0 };
        });
      }
      function d(T, C) {
        var x = C && typeof C;
        x == "object" || x == "function" ? v.has(C) ? x = v.get(C) : (x = "" + ++N, v.set(C, x)) : x = "p_" + C;
        var H = T.h[x];
        if (H && w(T.h, x)) for (T = 0; T < H.length; T++) {
          var Ae = H[T];
          if (C !== C && Ae.key !== Ae.key || C === Ae.key) return { id: x, list: H, index: T, A: Ae };
        }
        return {
          id: x,
          list: H,
          index: -1,
          A: void 0
        };
      }
      function A(T) {
        if (this.h = {}, this.g = n(), this.size = 0, T) {
          T = s(T);
          for (var C; !(C = T.next()).done; ) C = C.value, this.set(C[0], C[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var T = Object.seal({ x: 4 }), C = new t(s([[T, "s"]]));
          if (C.get(T) != "s" || C.size != 1 || C.get({ x: 4 }) || C.set({ x: 4 }, "t") != C || C.size != 2) return !1;
          var x = C.entries(), H = x.next();
          return H.done || H.value[0] != T || H.value[1] != "s" ? !1 : (H = x.next(), !(H.done || H.value[0].x != 4 || H.value[1] != "t" || !x.next().done));
        } catch (Ae) {
          return !1;
        }
      }()) return t;
      var v = /* @__PURE__ */ new WeakMap();
      A.prototype.set = function(T, C) {
        T = T === 0 ? 0 : T;
        var x = d(this, T);
        return x.list || (x.list = this.h[x.id] = []), x.A ? x.A.value = C : (x.A = { next: this.g, L: this.g.L, head: this.g, key: T, value: C }, x.list.push(x.A), this.g.L.next = x.A, this.g.L = x.A, this.size++), this;
      }, A.prototype.delete = function(T) {
        return T = d(this, T), T.A && T.list ? (T.list.splice(T.index, 1), T.list.length || delete this.h[T.id], T.A.L.next = T.A.next, T.A.next.L = T.A.L, T.A.head = null, this.size--, !0) : !1;
      }, A.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, A.prototype.has = function(T) {
        return !!d(this, T).A;
      }, A.prototype.get = function(T) {
        return (T = d(this, T).A) && T.value;
      }, A.prototype.entries = function() {
        return o(this, function(T) {
          return [T.key, T.value];
        });
      }, A.prototype.keys = function() {
        return o(this, function(T) {
          return T.key;
        });
      }, A.prototype.values = function() {
        return o(this, function(T) {
          return T.value;
        });
      }, A.prototype.forEach = function(T, C) {
        for (var x = this.entries(), H; !(H = x.next()).done; ) H = H.value, T.call(C, H[1], H[0], this);
      }, A.prototype[Symbol.iterator] = A.prototype.entries;
      var N = 0;
      return A;
    }), L("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) w(n, d) && o.push(n[d]);
        return o;
      };
    });
    function z(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, A = { next: function() {
        if (!d && o < t.length) {
          var v = o++;
          return { value: n(v, t[v]), done: !1 };
        }
        return d = !0, { done: !0, value: void 0 };
      } };
      return A[Symbol.iterator] = function() {
        return A;
      }, A;
    }
    L("Array.prototype.keys", function(t) {
      return t || function() {
        return z(this, function(n) {
          return n;
        });
      };
    }), L("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({ x: 4 }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({ x: 4 }) != d || d.size != 2) return !1;
          var A = d.entries(), v = A.next();
          return v.done || v.value[0] != o || v.value[1] != o ? !1 : (v = A.next(), v.done || v.value[0] == o || v.value[0].x != 4 || v.value[1] != v.value[0] ? !1 : A.next().done);
        } catch (N) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var A = this;
        this.g.forEach(function(v) {
          return o.call(d, v, v, A);
        });
      }, n);
    }), L("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), L("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var A = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + A, 0)); o < A; o++) {
          var v = d[o];
          if (v === n || Object.is(v, n)) return !0;
        }
        return !1;
      };
    }), L("String.prototype.includes", function(t) {
      return t || function(n, o) {
        if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
        if (n instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
        return this.indexOf(n, o || 0) !== -1;
      };
    }), L("Array.prototype.values", function(t) {
      return t || function() {
        return z(this, function(n, o) {
          return o;
        });
      };
    });
    var F = { na: "loaded", ta: "start", ka: "firstQuartile", oa: "midpoint", ua: "thirdQuartile", ia: "complete", pa: "pause", ra: "resume", ha: "bufferStart", ga: "bufferFinish", sa: "skipped", va: "volumeChange", qa: "playerStateChange", fa: "adUserInteraction" }, D = { la: "full", ja: "domain", ma: "limited" };
    function R(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.H = t.H || void 0, this.V = t.V || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.P = t.P !== void 0 ? t.P === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.D = t.D || void 0, this.aa = t.aa || void 0, this.W = t.W === "true" || t.W === !0 || !1, this.N = t.N || [], this.R = t.R || !1, this.g = n;
    }
    function b(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function j(t) {
      var n = {};
      return Object.assign({}, b(t), (n.x = t.x, n.y = t.y, n));
    }
    function ee(t) {
      var n = j(t), o = {};
      return Object.assign({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    R.prototype.T = function(t) {
      if (t == null) return !1;
      t = j(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function Ne(t) {
      return t.width * t.height;
    }
    function Ce(t) {
      return t.width === 0 || t.height === 0;
    }
    function ut(t, n) {
      t = j(t);
      for (var o = [], d = [], A = 0; A < n.length; A++) {
        var v = j(n[A]);
        v = Pt(t, v), Ye(o, v.x), Ye(o, v.J), Ye(d, v.y), Ye(d, v.K);
      }
      return o = o.sort(function(N, T) {
        return N - T;
      }), d = d.sort(function(N, T) {
        return N - T;
      }), { da: o, ea: d };
    }
    function Pt(t, n) {
      return { x: Math.max(t.x, n.x), y: Math.max(t.y, n.y), J: Math.min(t.x + t.width, n.x + n.width), K: Math.min(t.y + t.height, n.y + n.height) };
    }
    function Ye(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function nt() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    nt.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(je(this)) === JSON.stringify(je(t));
    };
    function je(t) {
      var n = [], o = [], d = { viewport: t.l, adView: { percentageInView: t.u, pixelsInView: t.B, reasons: t.m }, declaredFriendlyObstructions: t.o.length };
      if (t.g !== void 0) {
        d.adView.geometry = j(t.g), d.adView.geometry.pixels = Ne(t.g), d.adView.onScreenGeometry = j(t.h), d.adView.onScreenGeometry.pixels = ct(t);
        for (var A = 0; A < t.j.length; A++) n.push(j(t.j[A]));
        for (A = 0; A < t.v.length; A++) {
          var v = t.v[A], N = v, T = {};
          N.h && (T.obstructionClass = N.h), N.i && (T.obstructionPurpose = N.i), N.j && (T.obstructionReason = N.j), v = Pt(t.g, v), o.push(Object.assign(
            {},
            { x: v.x, y: v.y, width: v.J - v.x, height: v.K - v.y },
            T
          ));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function It(t, n) {
      n = b(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function Qe() {
      return { x: 0, y: 0, endX: 0, endY: 0, width: 0, height: 0 };
    }
    function ht(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function st(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function Be(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = Ne(t.g);
        if (n !== 0) {
          var o = ct(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function wt(t, n) {
      if (Ce(n) || !t.h) n = !1;
      else {
        var o = ee(t.h), d = o.y, A = o.endX;
        t = o.endY;
        var v = n.J;
        o = o.x, (v = v < o || 0.01 > Math.abs(v - o)) || (v = n.x, v = v > A || 0.01 > Math.abs(v - A)), (A = v) || (A = n.K, A = A < d || 0.01 > Math.abs(A - d)), (d = A) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function ge(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function ct(t) {
      var n = Math, o = n.max, d = Ne(t.h), A = t.j, v = 0;
      if (0 < A.length) {
        var N = ut(t.h, A);
        t = N.da, N = N.ea;
        for (var T = 0; T < t.length - 1; T++) for (var C = (t[T] + (t[T] + 1)) / 2, x = t[T + 1] - t[T], H = 0; H < N.length - 1; H++) {
          for (var Ae = (N[H] + (N[H] + 1)) / 2, Ze = N[H + 1] - N[H], at = !1, Nt = 0; Nt < A.length; Nt++) {
            var ke = j(A[Nt]);
            if (ke.x < C && ke.x + ke.width > C && ke.y < Ae && ke.y + ke.height > Ae) {
              at = !0;
              break;
            }
          }
          at && (v += Math.round(x) * Math.round(Ze));
        }
      }
      return o.call(n, 0, d - v);
    }
    function Ve() {
    }
    function Oe() {
    }
    function _e(t, n, o, d) {
      var A = n.R ? !0 : n.H === d;
      if (A) {
        o.g = n;
        var v = ee(o.g);
        t = ht(o.i, v);
        var N = o.g;
        N.D === "notAttached" || N.D === "noWindowFocus" || N.D === "noAdView" ? (ge(o, "notFound"), o.h = new R(Qe(), !1)) : (N = o.g, N.D === "viewInvisible" || N.D === "viewGone" || N.D === "viewNotVisible" || N.D === "viewAlphaZero" || N.D === "viewHidden" || o.g.D !== void 0 || Ce(o.g) ? (ge(o, "hidden"), o.h = new R(Qe(), !1)) : (o.g.W && ge(o, "pictureInPicture"), o.g.m || (ge(o, "backgrounded"), ge(o, "noWindowFocus")), st(t, v) && ge(o, "clipped"), o.h = new R(t, !1)));
      } else if (v = !0, n.g && (v = n.V.indexOf(d) !== -1 ? !1 : n.P === !1), v) {
        N = n.N;
        for (var T = 0; T < N.length; T++) v = o.g !== void 0, _e(t, new R(N[T], v), o, d);
      }
      A || o.g === void 0 || (n.g ? n.V.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (A = ee(n), d = ee(o.h), j(o.h), !Ce(o.h) && n.P && (n = ht(d, A), st(n, d) && (ge(o, "clipped"), o.h = new R(n, !1)))));
    }
    function He() {
      this.g = /* @__PURE__ */ new Map(), this.h = null;
    }
    function V() {
      return B || (B = new He()), B;
    }
    var B = null;
    function q(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function he() {
      this.H = null, this.i = { apiVersion: "1.0", accessMode: "limited", environment: "web", omidJsInfo: { omidImplementer: "omsdk", serviceVersion: "1.5.6-iab144" }, adSessionType: "html", supports: ["clid", "vlid"] }, this.C = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.G = this.h = this.g = this.M = this.v = null, this.u = /* @__PURE__ */ new Map();
    }
    var ne = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function pt(t) {
      if (t === ne) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function Tt() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return pt(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function ui(t, n) {
      this.g = t, this.h = n;
    }
    S.Object.defineProperties(ui.prototype, { event: { configurable: !0, enumerable: !0, get: function() {
      return this.g;
    } }, origin: { configurable: !0, enumerable: !0, get: function() {
      return this.h;
    } } });
    function $e() {
      var t = I.apply(0, arguments);
      te(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function hi() {
      var t = I.apply(0, arguments);
      te(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function te(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function Gt(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function Kt(t, n) {
      if (t.g !== void 0 && t.g.H && pi(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function ve(t, n) {
      t.m.push(n), Kt(t, n);
    }
    function ci(t, n, o) {
      t.g !== void 0 && t.g.H && t.m.filter(function(d) {
        return d.event.type === n && pi(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function pi(t, n) {
      var o = n.event.type, d = Object.values(F).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function xe(t, n, o) {
      Object.keys(F).forEach(function(d) {
        d = F[d];
        var A = { type: d, U: o, I: n };
        t.j.push(A), ci(t, d, A);
      });
    }
    function fi(t, n, o, d) {
      var A = { ba: o, U: d, I: n };
      t.l.push(A), t.i.forEach(function(v) {
        var N = Z(v);
        v.event.type === "sessionStart" && h(t, N, A), t.h(A.I, N);
      });
    }
    function Vt(t, n, o) {
      var d = k(t, "sessionError", "native", { errorType: n, message: o });
      t.i.push(d), t.l.forEach(function(A) {
        t.h(A.I, d.event);
      });
    }
    function a(t, n) {
      if (t.o = Object.assign(t.o, n), n = t.g.i, n !== void 0) {
        n = Object.assign({}, U(ft(t, M(t, { context: n }), !0)), { supportsLoadedEvent: !!t.g.h || t.g.g == "video" }), Object.assign(n, { pageUrl: Tt(), contentUrl: t.g.C });
        var o = k(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var A = Z(o);
          h(t, A, d), t.h(d.I, A);
        }, t), y(t);
      }
    }
    function h(t, n, o) {
      o.ba && (n.data.verificationParameters = t.o[o.ba]), o.U && (o = t.g.u.get(o.U)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function E(t) {
      var n = k(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    Gt.prototype.h = function(t) {
      var n = I.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        hi(o);
      }
    };
    function y(t) {
      var n = t.m.filter(function(v) {
        return !!(Object.values(F).includes(v.event.type) && t.g.g == "video" && v.origin === t.g.j || v.event.type == "loaded" && t.g.g == "display" && v.origin === t.g.s);
      }).map(function(v) {
        return v.event;
      }), o = t.g.H || "", d = {};
      n = s(n);
      for (var A = n.next(); !A.done; d = { F: d.F }, A = n.next()) {
        if (d.F = A.value, d.F.adSessionId || (d.F.adSessionId = o), d.F.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.F.data = ft(t, M(t, d.F.data));
        }
        t.j.filter(/* @__PURE__ */ function(v) {
          return function(N) {
            return N.type === v.F.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(v) {
          return function(N) {
            return N.I(v.F);
          };
        }(d));
      }
    }
    function _(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? ($e("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function ce(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? ($e("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function pe(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? ($e("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function ft(t, n, o) {
      return o = o === void 0 ? !1 : o, n = Object.assign({}, n), t.g.g && Object.assign(n, { mediaType: t.g.g }), t.g.h && (o || t.g.h !== "definedByJavaScript") && Object.assign(n, { creativeType: t.g.h }), n;
    }
    function U(t) {
      var n = V().h;
      return n ? Object.assign({}, t, { lastActivity: n }) : t;
    }
    function M(t, n) {
      return t.g.G ? Object.assign({}, n, { impressionType: t.g.G }) : n;
    }
    function k(t, n, o, d) {
      return new ui({ adSessionId: t.g.H || "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: n, data: d }, o);
    }
    function Z(t) {
      t = t.event;
      var n = t.data ? Object.assign({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = Object.assign({}, n.context)), { adSessionId: t.adSessionId, timestamp: t.timestamp, type: t.type, data: n };
    }
    function ot(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.v);
    }
    function Vr(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (Object.assign(o, { mediaPlayerVolume: n }), t.g.M = n) : d != null && (Object.assign(o, { videoPlayerVolume: d }), t.g.M = d);
      }
    }
    function es(t, n) {
      this.h = t, this.g = n;
    }
    function Bi() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    Bi.prototype.setInterval = function(t, n) {
      return Ai(this, "setInterval")(t, n);
    }, Bi.prototype.clearInterval = function(t) {
      Ai(this, "clearInterval")(t);
    };
    function ts(t, n) {
      Ai(t, "clearTimeout")(n);
    }
    function Ai(t, n) {
      return t.g && t.g[n] ? t.g[n] : Hi(t, n);
    }
    function is(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var A = t.g.document.createElement("img");
        A.width = 1, A.height = 1, A.style.display = "none", A.src = n, o && A.addEventListener("load", function() {
          return o();
        }), d && A.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(A);
      } else Hi(t, "sendUrl")(n, o, d);
    }
    function Hi(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    function xr(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function Je(t, n, o, d, A) {
      this.j = t, this.ca = n, this.X = o, this.i = d, this.$ = A, this.h = null, this.g = this.m = this.M = void 0, this.Z = !0, this.o = void 0, mi(this);
    }
    function mi(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.Z && (Vt(t.X, "generic", "More than one element with 'omid-element' class name."), t.Z = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        Ei(t);
      }
    }
    function Ei(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, xr(t.h) ? t.i.o && t.s() : t.s());
    }
    function zt(t) {
      t.g && (xr(t.h) ? t.i.o && (t.S(), kr(t)) : (t.S(), kr(t)));
    }
    Je.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, Je.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", zt(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function kr(t) {
      if (t.M) {
        t.i.S = t.M, t = t.ca;
        var n = t.g.S, o = t.g.O;
        if (n && !n.T(o)) {
          o = je(n);
          var d = t.h;
          d.g.h != "audio" && ve(d, k(d, "geometryChange", "native", o)), t.g.O = n;
        }
      }
    }
    function Ur(t) {
      if (t.g && t.i.o) {
        var n = new R(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.P = !0, n;
      }
    }
    function xt(t, n, o, d, A, v) {
      Je.call(this, t, o, d, A, v), this.u = n, this.l = void 0;
    }
    O(xt, Je), xt.prototype.v = function() {
      this.l !== void 0 && (this.$.clearInterval(this.l), this.l = void 0), Je.prototype.v.call(this);
    }, xt.prototype.s = function() {
      var t = this;
      Je.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.$.setInterval(function() {
        return Fr(t);
      }, 200), Fr(this));
    }, xt.prototype.S = function() {
      if (this.m) {
        var t = Ur(this);
        if (t) {
          this.g.R = !1, t.R = !0;
          for (var n = !1, o = 0; o < this.g.N.length; o++) if (this.g.N[o].R) {
            this.g.N[o] = t, n = !0;
            break;
          }
          n || this.g.N.push(t);
        } else this.g.R = !0;
        n = this.u, o = this.i.B;
        var d = this.i.H, A = this.O();
        t = new nt();
        var v = new R(this.m, !1);
        if (It(t, v), _e(n, v, t, d), A) if (v.aa) ge(t, "backgrounded"), ge(t, "noOutputDevice");
        else if (o === "backgrounded") ge(t, "backgrounded");
        else if (t.g !== void 0) {
          for (n = 0; n < t.o.length; n++) wt(t, t.o[n]) && t.v.push(t.o[n]);
          for (n = 0; n < t.s.length; n++) {
            if (o = wt(t, t.s[n])) {
              e: {
                for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                  o = !0;
                  break e;
                }
                o = !1;
              }
              o = !o;
            }
            o && (ge(t, "obstructed"), t.j.push(t.s[n]));
          }
          Be(t);
        } else ge(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new R((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = Qe();
        this.M = t;
      }
    }, xt.prototype.O = function() {
      return jr(this);
    };
    function Fr(t) {
      if (t.l !== void 0) {
        if (jr(t)) {
          var n = t.j.top;
          n = new R(new q(n.innerWidth, n.innerHeight), !1);
        } else n = new R(new q(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new R(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.P = !0, t.m = n, t.m.N.push(t.g), zt(t));
      }
    }
    function jr(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function kt(t, n, o, d, A, v) {
      Je.call(this, t, o, d, A, v), this.C = this.u = this.B = this.l = void 0, this.Y = !1, this.G = void 0;
    }
    O(kt, Je), kt.prototype.v = function() {
      this.l && this.l.disconnect(), Br(this), Je.prototype.v.call(this);
    }, kt.prototype.s = function() {
      if (Je.prototype.s.call(this), this.h && (this.l || (this.l = rs(this)), Hr(this), $r(this.h) && ns(this), this.i.B === "backgrounded")) {
        var t = gi(new q(0, 0));
        this.G = this.g = this.m = t, zt(this);
      }
    }, kt.prototype.S = function() {
      if (this.g && this.G) {
        var t = Ur(this);
        if (t) {
          var n = t, o = this.G, d = Math.max(t.x, o.x), A = Math.max(t.y, o.y), v = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), v <= d || t <= A ? d = null : (o = {}, d = new R((o.x = d, o.y = A, o.width = Math.abs(v - d), o.height = Math.abs(t - A), o), !1)), d || (d = new R({ x: 0, y: 0, width: 0, height: 0 }, !1));
        } else n = this.g, d = this.G;
        A = new nt(), this.m && It(A, this.m), (v = this.i.B == "backgrounded") && ge(A, "backgrounded"), A.g = n, A.h = d, Be(A), this.Y ? !v && Ce(A.g) ? ge(A, "hidden") : v || A.u === 100 || ge(A, "clipped") : ge(
          A,
          "viewport"
        ), this.M = A;
      }
    }, kt.prototype.O = function() {
      return !0;
    };
    function Br(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function Hr(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function $r(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function rs(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], A = 1; A < n.length; A++) n[A].time > d.time && (d = n[A]);
            o = d, t.m = gi(o.rootBounds), t.g = gi(o.boundingClientRect), t.G = gi(o.intersectionRect), t.Y = !!o.isIntersecting, zt(t);
          }
        } catch (v) {
          t.v(), Vt(t.X, "generic", "Problem handling IntersectionObserver callback: " + v.message);
        }
      }, { root: null, rootMargin: "0px", threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1] });
    }
    function ns(t) {
      t.j.ResizeObserver ? t.B || (t.B = ss(t, function() {
        return $i(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return $i(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return $i(t);
      }), t.u.observe(t.h, { childList: !1, attributes: !0, subtree: !1 })));
    }
    function $i(t) {
      t.h && !$r(t.h) && (Hr(t), Br(t));
    }
    function ss(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function gi(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new R(t, !1);
    }
    function Wi(t) {
      if (typeof t == "object" && typeof t.webOSSystem == "object") return t.webOSSystem;
    }
    function vi(t) {
      return typeof Wi(t) == "object";
    }
    function Ut(t) {
      if (typeof t == "object" && typeof t.tizen == "object") return t.tizen;
    }
    function Rt(t) {
      return typeof Ut(t) == "object";
    }
    function os(t, n) {
      this.h = t, this.g = n;
    }
    function Xi() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function as(t, n) {
      var o = o === void 0 ? ne : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function Wr(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, A = typeof d == "string" && Object.values(D).indexOf(d) !== -1 ? o.accessMode : null, v = A ? A == "domain" ? "limited" : A : "limited";
          o.accessMode = v;
          e: {
            var N = o.resourceUrl, T = t.g.location.origin;
            try {
              var C = new URL(N, T);
              break e;
            } catch (Ze) {
            }
            try {
              C = new URL(N);
              break e;
            } catch (Ze) {
            }
            C = null;
          }
          if (d = C) {
            var x = Xi();
            ls(t, x, d, v);
            var H = o.vendorKey, Ae = o.verificationParameters;
            H = H === void 0 ? "" : H, Ae = Ae === void 0 ? "" : Ae, H && typeof H == "string" && H !== "" && Ae && typeof Ae == "string" && Ae !== "" && (t.i.o[H] = Ae), t.j.u.set(x, o);
          }
        } catch (Ze) {
          hi("OMID verification script " + o.resourceUrl + " failed to load: " + Ze);
        }
      });
    }
    function ls(t, n, o, d) {
      var A = t.g.document, v = A.createElement("iframe");
      if (v.id = "omid-verification-script-frame-" + n, v.style.display = "none", d == "full") {
        var N = function() {
          var T = v.contentWindow;
          T.omidVerificationProperties = { serviceWindow: t.g, injectionSource: "web", injectionId: n }, T = T.document;
          var C = T.createElement("script");
          C.src = o.href, T.head.appendChild(C), v.removeEventListener("load", N);
        };
        v.addEventListener("load", N);
      } else d == "limited" && (v.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, v.sandbox = "allow-scripts");
      A.body.appendChild(v), V().g.set(n, v);
    }
    function qi(t, n) {
      var o = window, d = this;
      if (vi(o)) if (o) if (o.WebOSServiceBridge) {
        this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(A) {
          try {
            var v = JSON.parse(A);
            if (v && v.errorCode) d.error(A);
            else if (!v) d.error("No object recieved from webOS bridge");
            else if (!Si(d, A, v, "volumeStatus", "object")) {
              var N = v.volumeStatus;
              Si(d, A, N, "muteStatus", "boolean") || Si(d, A, N, "volume", "number") || Si(d, A, N, "maxVolume", "number") || (0 >= N.maxVolume ? d.error("Invalid max volume status.") : d.i(N.muteStatus ? 0 : N.volume / N.maxVolume));
            }
          } catch (T) {
            d.error(T);
          }
        };
        try {
          this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
        } catch (A) {
          this.error(A);
        }
      } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    qi.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, qi.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Si(t, n, o, d, A) {
      return typeof o[d] === A ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + A + '" but was of type "' + typeof o[d] + '".'), !0);
    }
    function Xr(t) {
      return Rt(t) ? typeof Ut(t).tvinputdevice == "object" : !1;
    }
    function yi(t, n) {
      var o = window, d = this;
      if (o) if (this.validate(o)) {
        this.h = n;
        var A = Ut(o).tvaudiocontrol;
        this.g = void 0, n = function() {
          var v = A.isMute() ? 0 : A.getVolume() / 100;
          (d.g === void 0 || d.g != v) && (d.g = v, t(d.g));
        }, n(), this.i = o.setInterval(n, 200), this.j = o;
      } else n("Invalid Tizen window context");
      else n("No window context");
    }
    yi.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, yi.prototype.validate = function(t) {
      return Rt(t) && Xr(t) && typeof Ut(t).tvaudiocontrol == "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, yi.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function qr(t, n, o, d, A) {
      var v = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = A, this.m = !1, Yi(this, function(N) {
        if (N.type === "sessionStart") {
          v.m = !0;
          try {
            Wr(v.l);
          } catch (T) {
            $e(T.message);
          }
        }
        N.type === "sessionFinish" && (v.m = !1);
      });
    }
    function Yi(t, n, o, d) {
      fi(t.i, n, o, d);
    }
    i = qr.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && Ei(this.h)) : $e("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && Ei(this.h), this.h && zt(this.h);
    }, i.error = function(t, n) {
      Vt(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        Wr(this.l);
      } catch (o) {
        $e(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.G = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = Object.assign({}, d.omidJsInfo, { sessionClientVersion: t, partnerName: n, partnerVersion: o }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function ds(t) {
      if (Rt(window) || vi(window)) {
        var n = function(d) {
          if (t.g.v !== d && t.i.g.j !== "none" && typeof d == "number" && !isNaN(d)) {
            t.g.v = d;
            var A = t.o, v = A.g.M;
            v != null && (d = A.h, A = { mediaPlayerVolume: v, deviceVolume: A.g.v }, ot(d, "volumeChange", A), Vr(d, "volumeChange", A), ve(d, k(d, "volumeChange", "native", A)));
          }
        }, o = function(d) {
          $e(d);
        };
        vi(window) ? t.j = new qi(n, o) : Rt(window) && (t.j = new yi(n, o));
      }
    }
    function Yr(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function Me(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function Gi(t) {
      var n = new he(), o = new Gt(n), d = new Ve(), A = new Oe(), v = new es(o, n);
      t = t.i;
      var N = e;
      return d = N ? N.IntersectionObserver && (N.MutationObserver || N.ResizeObserver) ? new kt(N, d, v, o, n, t) : new xt(N, A, v, o, n, t) : null, new qr(n, o, d, new as(o, n), new os(o, n));
    }
    function Ft(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function Gr(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function Kr(t) {
      return new Ft(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function zr(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function Qr(t) {
      this.i = t;
    }
    function jt(t) {
      this.i = t, this.handleExportedMessage = jt.prototype.j.bind(this);
    }
    O(jt, Qr), jt.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(zr(t), this);
    }, jt.prototype.j = function(t, n) {
      Gr(t) && this.g && this.g(Kr(t), n);
    };
    function Oi(t) {
      return Ki(t, "SessionService.");
    }
    function Ki(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function zi(t, n) {
      this.h = t, this.i = n;
    }
    zi.prototype.g = function(t) {
      var n = I.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, zi.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function re(t, n) {
      return t.g.bind(t, n);
    }
    function us(t, n) {
      n = n === void 0 ? ne : n, n.omidSessionInterface == null && (t = { setSessionClientWindow: t.i, setClientInfo: re(t, "setClientInfo"), registerSessionObserver: re(t, "registerSessionObserver"), startAdSession: re(t, "startSession"), finishAdSession: re(t, "finishSession"), reportError: re(t, "sessionError"), registerAdEvents: re(t, "registerAdEvents"), registerMediaEvents: re(t, "registerMediaEvents"), injectVerificationScriptResources: re(t, "injectVerificationScriptResources"), setSlotElement: re(t, "setSlotElement"), setVideoElement: re(
        t,
        "setVideoElement"
      ), setElementBounds: re(t, "setElementBounds"), setCreativeType: re(t, "setCreativeType"), setImpressionType: re(t, "setImpressionType"), setContentUrl: re(t, "setContentUrl"), adEvents: { impressionOccurred: re(t, "impressionOccurred"), loaded: re(t, "loaded") }, mediaEvents: {
        start: re(t, "start"),
        firstQuartile: re(t, "firstQuartile"),
        midpoint: re(t, "midpoint"),
        thirdQuartile: re(t, "thirdQuartile"),
        complete: re(t, "complete"),
        pause: re(t, "pause"),
        resume: re(t, "resume"),
        bufferStart: re(t, "bufferStart"),
        bufferFinish: re(t, "bufferFinish"),
        skipped: re(t, "skipped"),
        volumeChange: re(t, "volumeChange"),
        playerStateChange: re(t, "playerStateChange"),
        adUserInteraction: re(t, "adUserInteraction")
      } }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", { value: t, writable: !1 }));
    }
    function Ii(t, n) {
      this.i = n = n === void 0 ? ne : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (typeof d.data == "object") {
          var A = d.data;
          Gr(A) && d.source && o.g && o.g(Kr(A), d.source);
        }
      });
    }
    O(Ii, Qr), Ii.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(zr(t), "*");
    };
    function Jr() {
      this.g = cn;
    }
    i = Jr.prototype, i.registerSessionObserver = function(t, n) {
      Yi(Me(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      Me(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      Me(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      Me(this.g, t).error(n, o);
    };
    function Ie(t, n, o, d) {
      t = Me(t.g, n), o == "impression" ? ce(t.i) && (o = t.i, d = (d = o.g.O) ? je(d) : null, d = ft(o, M(o, d)), ve(o, k(o, "impression", "javascript", d)), t.h && mi(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, pe(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = k(d, "loaded", "javascript", ft(d, M(d, n === void 0 ? null : n))), ve(d, n))) : pe(t.i) && (n = t.i, ot(n, o, d), Vr(n, o, d), ve(n, k(n, o, "javascript", d))), ["loaded", "start"].includes(o) && t.h && mi(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      Me(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, Me(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      Me(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var A = this.g;
      if (t == null) t = A.g;
      else {
        var v = [].concat(l(A.h.values())).includes(A.g) ? Gi(A) : A.g;
        A.h.set(t, v), t = v;
      }
      return t.setClientInfo(n, o, d);
    };
    function Zr(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), A = parseInt(n[o], 10);
        if (d > A) break;
        if (d < A) return !1;
      }
      return !0;
    }
    function en(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Zr(t) ? n : JSON.stringify(n);
    }
    function tn(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Zr(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function Qi() {
      var t = ms, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new jt(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new Ii(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new zi(function(d, A, v) {
        try {
          nn(n, d, A, v);
        } catch (N) {
          $e(sn(N));
        }
      }, function(d) {
        n.m = d;
        var A = Xi();
        n.i.h(new Ft(A, "identifyServiceWindow", "1.5.6-iab144"), d);
      }), us(this.s, this.h);
    }
    Qi.prototype.l = function(t, n) {
      Oi(t.method) != null && rn(this, t, n, this.j);
    }, Qi.prototype.o = function(t, n) {
      if (Oi(t.method) != null) {
        if (!this.m || n !== this.m) return $e("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        rn(this, t, n, this.i);
      }
    };
    function rn(t, n, o, d) {
      function A() {
        var C = new Ft(v, "response", T, en(T, I.apply(0, arguments)));
        d.h(C, o);
      }
      var v = n.h, N = n.method, T = n.version;
      n = tn(T, n.g);
      try {
        nn(t, N, A, n);
      } catch (C) {
        d.h(new Ft(v, "error", T, sn(C)), o);
      }
    }
    function nn(t, n, o, d) {
      if (Oi(n) != null) switch (Oi(n)) {
        case "registerAdEvents":
          var A = s(d).next().value, v = Me(t.g.g, A).i;
          _(v, ["impression"]) && ce(v) && (v.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var N = s(d).next().value, T = Me(t.g.g, N).i;
          _(T, Object.values(F)) && pe(T) && (T.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var C = s(d).next().value;
          t.g.registerSessionObserver(C, o);
          break;
        case "setSlotElement":
          var x = s(d), H = x.next().value, Ae = x.next().value;
          t.g.setSlotElement(Ae, H);
          break;
        case "setVideoElement":
          var Ze = s(d), at = Ze.next().value, Nt = Ze.next().value, ke = Me(t.g.g, Nt);
          at && at.tagName && at.tagName.toLowerCase() === "video" ? (ke.g.l = at, ke.h && Ei(ke.h)) : $e("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Ri = s(d), Zi = Ri.next().value, er = Ri.next().value;
          t.g.setElementBounds(er, Zi);
          break;
        case "startSession":
          var Qt = s(d), Ge = Qt.next().value, Ni = Qt.next().value, Ke = t.h;
          if (Ge != null && typeof Ge == "object") {
            var Jt = Ge.customReferenceData, De = Ge.underEvaluation, pn = Ge.universalAdId;
            typeof Jt == "string" || (Jt = void 0), typeof De == "boolean" || (De = !1);
            var At = { customReferenceData: Jt, underEvaluation: De };
            if (typeof pn == "string" && (At.universalAdId = pn), vi(Ke)) {
              var fn = Wi(Ke), Ci;
              typeof fn == "object" && (Ci = fn.identifier), At.app = { appId: Ci && typeof Ci == "string" ? Ci : void 0 };
              e: {
                var An = Wi(Ke);
                if (typeof An == "object") {
                  try {
                    var mn = JSON.parse(An.deviceInfo);
                  } catch (ro) {
                    var tr = void 0;
                    break e;
                  }
                  tr = { deviceType: mn.modelName || "Unknown", osVersion: mn.platformVersion || "Unknown", os: "webOS" };
                } else tr = void 0;
              }
              At.deviceInfo = tr, At.deviceCategory = "ctv";
            } else if (Rt(Ke)) {
              e: {
                if (Rt(Ke)) {
                  try {
                    var En = Ut(Ke).application.getCurrentApplication().appInfo.id;
                  } catch (ro) {
                    var ir = void 0;
                    break e;
                  }
                  if (typeof En == "string") {
                    ir = En;
                    break e;
                  }
                }
                ir = void 0;
              }
              if (At.app = { appId: ir }, Rt(Ke)) {
                var _i = Ut(Ke).systeminfo;
                if (typeof _i == "object" && typeof _i.getCapability == "function")
                  var Es = _i.getCapability("http://tizen.org/system/model_name"), gs = _i.getCapability("http://tizen.org/feature/platform.version");
                var gn = { deviceType: Es || "Unknown", osVersion: gs || "Unknown", os: "tizen" };
              } else gn = void 0;
              At.deviceInfo = gn, Xr(Ke) && (At.deviceCategory = "ctv");
            }
            Ge = At;
          } else Ge = null;
          if (Ge == null) break;
          var Ct = Ge, rr = rr === void 0 ? null : rr, mt = Me(t.g.g, Ni), vn = mt.g.i;
          vn.sessionOwner || (vn.sessionOwner = "javascript");
          var vs = Ni || Xi();
          mt.g.H = vs, Ct.canMeasureVisibility = mt.h.O();
          var nr = mt.g;
          Ct.contentUrl !== void 0 && (nr.C = Ct.contentUrl, Ct.contentUrl = void 0);
          var Sn = nr.i || {};
          Ct.omidJsInfo = Object.assign({}, Sn.omidJsInfo || {}, Ct.omidJsInfo || {});
          var Ss = Object.assign({}, Sn, Ct);
          nr.i = Ss, a(mt.i, rr), mt.h && mi(mt.h), ds(mt);
          break;
        case "finishSession":
          var ys = s(d).next().value, yn = t.g, Zt = Me(yn.g, ys), On = yn.g;
          On.g = Gi(On), E(Zt.i), Zt.h.v(), Zt.j && (Zt.j.stop(), Zt.j = null);
          break;
        case "impressionOccurred":
          var Os = s(d).next().value;
          Ie(t.g, Os, "impression");
          break;
        case "loaded":
          var In = s(d), Bt = In.next().value, Tn = In.next().value;
          if (Bt) {
            var Rn = { skippable: Bt.isSkippable, autoPlay: Bt.isAutoPlay, position: Bt.position };
            Bt.isSkippable && (Rn.skipOffset = Bt.skipOffset), Ie(t.g, Tn, "loaded", Rn);
          } else Ie(t.g, Tn, "loaded");
          break;
        case "start":
          var sr = s(d), Is = sr.next().value, Ts = sr.next().value, Rs = sr.next().value;
          Ie(t.g, Rs, "start", { duration: Is, mediaPlayerVolume: Ts });
          break;
        case "firstQuartile":
          var Ns = s(d).next().value;
          Ie(t.g, Ns, "firstQuartile");
          break;
        case "midpoint":
          var Cs = s(d).next().value;
          Ie(t.g, Cs, "midpoint");
          break;
        case "thirdQuartile":
          var _s = s(d).next().value;
          Ie(t.g, _s, "thirdQuartile");
          break;
        case "complete":
          var Ds = s(d).next().value;
          Ie(t.g, Ds, "complete");
          break;
        case "pause":
          var Ls = s(d).next().value;
          Ie(t.g, Ls, "pause");
          break;
        case "resume":
          var Ms = s(d).next().value;
          Ie(t.g, Ms, "resume");
          break;
        case "bufferStart":
          var bs = s(d).next().value;
          Ie(t.g, bs, "bufferStart");
          break;
        case "bufferFinish":
          var Ps = s(d).next().value;
          Ie(t.g, Ps, "bufferFinish");
          break;
        case "skipped":
          var ws = s(d).next().value;
          Ie(t.g, ws, "skipped");
          break;
        case "volumeChange":
          var Nn = s(d), Vs = Nn.next().value, xs = Nn.next().value;
          Ie(t.g, xs, "volumeChange", { mediaPlayerVolume: Vs });
          break;
        case "playerStateChange":
          var Cn = s(d), ks = Cn.next().value, Us = Cn.next().value;
          Ie(t.g, Us, "playerStateChange", { state: ks });
          break;
        case "adUserInteraction":
          var _n = s(d), Fs = _n.next().value, js = _n.next().value;
          Ie(t.g, js, "adUserInteraction", { interactionType: Fs });
          break;
        case "setClientInfo":
          var Di = s(d), Bs = Di.next().value, Hs = Di.next().value, $s = Di.next().value, Ws = Di.next().value, Xs = t.g.setClientInfo(Ws, Bs, Hs, $s);
          o(Xs);
          break;
        case "injectVerificationScriptResources":
          var Dn = s(d), qs = Dn.next().value, Ys = Dn.next().value;
          t.g.injectVerificationScriptResources(Ys, qs);
          break;
        case "setCreativeType":
          var Ln = s(d), Gs = Ln.next().value, Ks = Ln.next().value;
          t.g.setCreativeType(Ks, Gs);
          break;
        case "setImpressionType":
          var Mn = s(d), zs = Mn.next().value, Qs = Mn.next().value;
          t.g.setImpressionType(Qs, zs);
          break;
        case "setContentUrl":
          var bn = s(d), Js = bn.next().value, Zs = bn.next().value;
          Me(t.g.g, Zs).g.C = Js;
          break;
        case "sessionError":
          var or = s(d), eo = or.next().value, to = or.next().value, io = or.next().value;
          t.g.error(io, eo, to);
      }
    }
    function sn(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function Ji() {
      var t = cn, n = hn, o = this, d = d === void 0 ? ne : d;
      this.j = t, this.g = n, this.l = {}, this.m = {}, this.i = new jt(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.i, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new Ii(d)), this.i.g = function(A, v) {
        an(o, A, v, o.i);
      }, this.h && (this.h.g = function(A, v) {
        o.h && an(o, A, v, o.h);
      });
    }
    function on(t) {
      t({ adSessionId: "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: "sessionError", data: { errorType: "generic", message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected." } });
    }
    function hs(t, n, o, d) {
      t = Yr(t.j, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? xe(t, o, d) : (o = { type: n, U: d, I: o }, t.j.push(o), ci(t, n, o))) : on(o);
    }
    function cs(t, n, o, d) {
      t = Yr(t.j, d), d !== void 0 && t.g.u.has(d) ? Yi(t, n, o, d) : on(n);
    }
    function ps(t, n, o, d) {
      is(t.g, n, o, d);
    }
    Ji.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, Ji.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function fs(t, n, o, d) {
      Hi(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function an(t, n, o, d) {
      function A() {
        var De = new Ft(v, "response", T, en(T, I.apply(0, arguments)));
        d.h(De, o);
      }
      var v = n.h, N = n.method, T = n.version;
      if (n = tn(T, n.g), Ki(N, "VerificationService.") != null) {
        N = Ki(N, "VerificationService.");
        try {
          switch (N) {
            case "addEventListener":
              var C = s(n), x = C.next().value, H = C.next().value || ln(o);
              hs(t, x, A, H);
              break;
            case "addSessionListener":
              var Ae = s(n), Ze = Ae.next().value, at = Ae.next().value || ln(o);
              cs(t, A, Ze, at);
              break;
            case "sendUrl":
              var Nt = s(n).next().value;
              ps(t, Nt, function() {
                return A(!0);
              }, function() {
                return A(!1);
              });
              break;
            case "setTimeout":
              var ke = s(n), Ri = ke.next().value, Zi = ke.next().value;
              t.l[Ri] = Ai(t.g, "setTimeout")(A, Zi);
              break;
            case "clearTimeout":
              var er = s(n).next().value;
              ts(t.g, t.l[er]);
              break;
            case "setInterval":
              var Qt = s(n), Ge = Qt.next().value, Ni = Qt.next().value;
              t.m[Ge] = t.setInterval(A, Ni);
              break;
            case "clearInterval":
              var Ke = s(n).next().value;
              t.clearInterval(t.m[Ke]);
              break;
            case "injectJavaScriptResource":
              var Jt = s(n).next().value;
              fs(t, Jt, function(De) {
                return A(!0, De);
              }, function() {
                return A(!1);
              });
              break;
            case "getVersion":
              A("1.5.6-iab144");
          }
        } catch (De) {
          d.h(new Ft(
            v,
            "error",
            T,
            `
              name: ` + De.name + `
              message: ` + De.message + `
              filename: ` + De.filename + `
              lineNumber: ` + De.lineNumber + `
              columnNumber: ` + De.columnNumber + `
              stack: ` + De.stack + `
              toString(): ` + De.toString() + `
          `
          ), o);
        }
      }
    }
    function ln(t) {
      for (var n = V().g, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var A = n.get(d);
        if (A) {
          if (A.contentWindow === t) return d;
          try {
            if (A.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (v) {
          }
        }
      }
    }
    function dn(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function un(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function Ti(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function As(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(A) {
          A.addedNodes[0].nodeName === "BODY" && (A = dn(n), Ti(t, "omid_v1_present"), Ti(t, A), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, { childList: !0 });
    }
    var hn = new Bi(), cn = new function() {
      this.i = hn, this.h = /* @__PURE__ */ new Map(), this.g = Gi(this);
    }(), ms = new Jr();
    new Ji(), new Qi(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? As(t, n) : (n = dn(n), t.document.body ? (Ti(t, "omid_v1_present"), Ti(t, n)) : (un(t, "omid_v1_present"), un(t, n))));
    }(ne, "web");
  }).call(p, p);
}
const Xn = "4.0", qn = ["4.0"], wr = class wr {
  constructor() {
    this.OmidServiceClient = $o();
  }
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      c.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (c.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  hasValidHandshake(e, i = Xn, r = qn) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  hasValidFacadeImplementation(e, i = oo) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  validate(e) {
    if (!e) {
      this.error = P.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = P.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = P.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = qt(ai, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function u(m) {
        c.debug.critical("init - error", m), l(m);
      }
      Object.keys(this.initError).length > 0 ? u(this.initError) : s(new Cr(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return Zn;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return ae;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return ue;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Mr(ai);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return li;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return f;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(f);
  }
  get LOGLEVEL() {
    return rt;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    c.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return c.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return c.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return Xn;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return qn;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.6.1";
  }
};
wr.NAME = "Core::";
let ji = wr;
const Wo = new ji();
typeof window != "undefined" && (window.smartclientcore = Wo);
typeof exports == "object" && (exports = {
  smartclientcore: ji
});
export {
  oo as FacadeBase,
  Wo as default
};
