[> Documentation-Index](index.md)

# smartclientcore - Error Codes

If an error occurs while trying to load and serve an ad, the smartclientcore will replace the `[ERRORCODE]` macro within
VAST `<Error>` URLs.


## Table of contents
- [Ad Error Codes](#ad-error-codes)
- [Ad Warning Codes](#ad-warning-codes)
- [Setup Error Codes](#setup-error-codes)
- [Ad-Slot Error Codes](#adslot-error-codes)
- [AdReinsertion Activation Reason Codes](#adreinsertion-activation-codes)

<a name="ad-error-codes"></a>

## Ad Error - Codes Table

List of error codes used by the smartclientcore. 

All error codes are equal with the **[IAB VAST 4.2](https://wiki.iabtechlab.com/index.php?title=VAST_Error_Code_Troubleshooting_Matrix) Error Codes and Meanings**.
The code with a leading asterisk (*) were introduced with https://interactiveadvertisingbureau.github.io/SIMID/#errors.

| Code | Description                                                                                                                                                                                                                                                       |
|------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| 
| 100  | XML parsing error.                                                                                                                                                                                                                                                |
| 101  | VAST schema validation error.                                                                                                                                                                                                                                     |
| 200  | Trafficking error. Video player received an ad type that it was not expecting and/or cannot display.                                                                                                                                                              |
| 201  | Video player expecting different linearity.                                                                                                                                                                                                                       |
| 301  | Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI. |
| 302  | Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response.                                                                                                                                     |
| 303  | No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback.                                                                                                                                                      |
| 400  | General linear error. Video player is unable to display the linear ad.                                                                                                                                                                                            |
| 401  | File not found. Unable to find Linear/MediaFile from URI.                                                                                                                                                                                                         |
| 402  | Timeout of MediaFile URI.                                                                                                                                                                                                                                         |
| 403  | Could not find MediaFile that is supported by this video player, based on the attributes of the MediaFile element.                                                                                                                                                |
| 405  | Problem displaying MediaFile.                                                                                                                                                                                                                                     |
| 500  | General NonLinearAds error.                                                                                                                                                                                                                                       |
| 501  | Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large).                                                                                                                          |
| 502  | Unable to fetch NonLinearAds/NonLinear resource.                                                                                                                                                                                                                  |
| 503  | Could not find NonLinearresource with supported type.                                                                                                                                                                                                             |
| 901  | General VPAID error.                                                                                                                                                                                                                                              |
| *902 | General SIMID error.                                                                                                                                                                                                                                              |


<a name="ad-warning-codes"></a>

## Ad Warning - Codes Table

During ad playback the smartclientcore may respond with one of the following error codes
to warn about non-critical issues that do not interrupt the delivery.

| Code   | Description                     |
|--------|---------------------------------|
| 200400 | Unknown tracker loading error   |
| 200401 | Timeout of tracker request URIs |


<a name="setup-error-codes"></a>

## Init Error - Codes Table

The smartclientcore responds with one of the following error codes if the initial setup fails. 
See [Static API Methods](plugin-static-api.md#methods) for more Details.

| Code   | Description                                                                                                                                                      |
|--------|------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 200100 | No facade was handed over                                                                                                                                        |
| 200101 | Facade implementation is incorrect                                                                                                                               |
| 200102 | Handshake validation failed                                                                                                                                      |
| 200103 | AdReinsertion initialisation failed                                                                                                                              |
| 200104 | Ad Reinsertion Penalty - AdReinsertion initialization failed, either due to a invalid configuration or issues that muste be answered by the AdReinsertion vendor |

<a name="adslot-error-codes"></a>

## Ad-Slot Error - Codes Table

The smartclientcore responds with one of the following error codes if the initialization 
or termination of an ad slot fails. 

| Code   | Description                                                                                                                    |
|--------|--------------------------------------------------------------------------------------------------------------------------------|
| 200200 | Ad Reinsertion usage declined by the vendor.                                                                                   |
| 200201 | Invalid AdBreak definition.                                                                                                    |
| 200202 | An ad-slot has already been started. Shut down the current ad-slot by calling `stopAdSlot`.                                    |
| 200203 | Unknown Manifest Loading Error.                                                                                                |
| 200204 | The manifest couldn't be loaded in time.                                                                                       |
| 200205 | Mixed Content: The ad request has been blocked and must be served over HTTPS.                                                  |
| 200206 | Restoring the content failed. **The smartclientcore indicates the error by sending a `GeneralError` event.**                       |
| 200207 | Ad Reinsertion Initialization Timeout - AdReinsertion initialization took too long, either caused by the AdReinsertion vendor. |
| 200208 | AdReinsertion failed at runtime.                                                                                               |


<a name="adreinsertion-activation-codes"></a>

## AdReinsertion Activation Reason - Codes Table
| Code   | Description                               |
|--------|-------------------------------------------|
| 201000 | Timeout of ad-request URIs                |
| 201001 | XHR request status is not 200 (ok)        |
| 201002 | XHR request error                         |
| 201003 | XML parsing error                         |
| 201004 | Timeout of wrapper request chain          |
| 201005 | Requesting the entire AdSlot timed out    |
| 201006 | XHR promise error                         |
| 201010 | Timeout of media file request URIs        |
| 201013 | General load error of media file URIs     |
| 201020 | General ad-reinsertion activation request |


[IAB VAST 4.2]: https://iabtechlab.com/standards/vast/
